/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.dbsession.DbSessionBase;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.oresident.JavaStoredProcExceptionHandler;
import chemaxon.jchem.cartridge.oresident.longop.LongOp;
import chemaxon.jchem.cartridge.oresident.longop.LongOpOracleParams;
import chemaxon.jchem.cartridge.oresident.longop.LongOpStatus;
import chemaxon.jchem.cartridge.oresident.util.CxOptions;
import chemaxon.jchem.cartridge.rmi.Admin;
import chemaxon.jchem.cartridge.rmi.Index;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.structs.JCartDefaultProperties;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.structs.JChemProperties;
import chemaxon.jchem.cartridge.tunnel.FetchIndexStats;
import chemaxon.jchem.cartridge.tunnel.JcTableInfo;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import chemaxon.jchem.cartridge.tunnel.UserInfo;
import chemaxon.jchem.cartridge.tunnel.index.AlterIndexInfo;
import chemaxon.jchem.cartridge.tunnel.index.CreateMolDescInfo;
import chemaxon.jchem.cartridge.tunnel.index.IndexCreateInfo;
import chemaxon.jchem.cartridge.tunnel.index.IndexRebuildInfo;
import chemaxon.jchem.cartridge.tunnel.index.IndexingInfo;
import chemaxon.jchem.cartridge.tunnel.index.MdManagementInfo;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.jdbc.OracleResultSet;

public class Indexing
extends JFunctions {
    private static final JCartLogger logger = JCartLogger.getLogger(Indexing.class);
    public static final String IDXSEQ = "JCHEMIDX_SEQ";
    public static final String IDX_PARAM_STD_CONF = "STD_CONFIG";
    public static final String IDX_PARAM_STD_CONF_SQL = "STD_CONF:SQL";
    public static final String IDX_PARAM_DUPFILTER = "duplicateFiltering";
    public static final String IDX_PARAM_DUPFILTER_EXCLUSIVE = "exclusiveDuplicateFiltering";
    public static final String IDX_PARAM_DUPFILTER_TAUTOMER = "tautomerDuplicateFiltering";
    public static final String IDX_PARAM_GENTAUT_PROTCHIR = "genericTautomerProtectsChirality";
    public static final String IDX_PARAM_SWITCH_OFF_ALL_PROTECTIONS_TDF = "swOffAllProtTdf";
    public static final int IDX_SUBTYPE_STRUCTURE = 0;
    public static final int IDX_SUBTYPE_FINGERPRINT = 1;
    public static final String IDX_SUBTYPE_PROPKEY = "idxSubType";
    public static final String IDX_SUBTYPE_OPTVALUE_FINGERPRINT = "fp";
    public static final String OPTNAME_INSERT_SESSION_COUNT = "insSessCnt";
    public static final String OPTNAME_ADDMD = "addMd";
    private static final String OPTNAME_DELMD = "delMd";
    public static final String OPTNAME_ADDMDCONF = "addMdConf";
    public static final String OPTNAME_DELMDCONF = "delMdConf";
    public static final String OPTNAME_ADD_DFLT_MDCONF = "addDfltMdConf";
    public static final String REFRESHPERIOD = "refreshPeriod";
    private static JcMetaDataFunctions metaData;

    private static JcMetaDataFunctions getMetaData() {
        if (metaData == null) {
            metaData = new JcMetaDataFunctions(JavaStoredProcSession.instance());
        }
        return metaData;
    }

    public static String indexCreate(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String tblPartition, String colName, String param) throws Exception {
        try {
            Long taskId = Indexing.indexCreate(idxSchema, idxName, idxPartition, tblSchema, tblName, tblPartition, colName, param, false);
            if (taskId != null && Indexing.isIndexingAsynch()) {
                LongOpOracleParams oracleParams = new LongOpOracleParams();
                LongOp indexLongOp = Indexing.getIndexLongOp(taskId, oracleParams);
                while (!LongOpStatus.updateStatus(indexLongOp, oracleParams)) {
                }
            }
            return null;
        }
        catch (Exception e) {
            return JavaStoredProcExceptionHandler.handleTopLevelError(e);
        }
    }

    private static LongOp getIndexLongOp(final long taskId, LongOpOracleParams oracleParams) {
        LongOp indexLongOp = new LongOp(){

            @Override
            public boolean waitForRefresh() throws Exception {
                return Indexing.getIndexServer().waitForRefresh(taskId);
            }

            @Override
            public int getTotalWork() throws Exception {
                return Indexing.getIndexServer().getLongopStatusTotalWork(taskId);
            }

            @Override
            public int getSofar() throws Exception {
                return Indexing.getIndexServer().getLongopStatusSofar(taskId);
            }

            @Override
            public String getTarget() throws Exception {
                return "INDEX";
            }

            @Override
            public String getOpName() throws Exception {
                return Indexing.getIndexServer().getLongopStatusOpName(taskId);
            }

            @Override
            public long getId() throws Exception {
                return taskId;
            }

            @Override
            public Connection getConnection() throws Exception {
                return JavaStoredProcSession.instance().getConnection();
            }

            @Override
            public void dispose() throws Exception {
                Indexing.getIndexServer().disposeLongop(taskId);
            }
        };
        return indexLongOp;
    }

    private static Long indexCreate(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String tblPartition, String colName, String param, boolean rebuild) throws Exception {
        boolean tautomerDuplicateFiltering;
        int dotPos;
        JavaStoredProcSession dbSession = JavaStoredProcSession.instance();
        String[] allowedOptions = new String[]{"JCHEMPROPERTIESTABLE", "TABLESPACE", "STORAGE", "DEBUGLEVEL", "ABSOLUTESTEREO", "FP_SIZE", "FP_BIT", "PAT_LENGTH", IDX_PARAM_STD_CONF, IDX_PARAM_STD_CONF_SQL, "REGENERATETABLE", "BUILDTYPE", "PASSWORD", "STRUCTURALFP_CONFIG", "HALTONBADFORMAT", "haltOnError", "TABLETYPE", "STRUCTURETYPE", "AUTOCALCCT", "AUTOCALCCTWCN", "DUPLICATEFILTERING", "TDF", IDX_PARAM_SWITCH_OFF_ALL_PROTECTIONS_TDF, "EXCLUSIVEDF", "IDXSUBTYPE", "threadCnt", OPTNAME_INSERT_SESSION_COUNT, REFRESHPERIOD};
        String[] repeatableOptions = new String[]{"AUTOCALCCT", "AUTOCALCCTWCN"};
        if (idxName.length() > 22) {
            throw new Exception("Please, use an index name less than 23 characters long. The maximum length of JChem Cartridge index names is currently 22 characters.");
        }
        String jcptName = idxSchema + ".JChemProperties";
        CxOptions jcOptions = new CxOptions(allowedOptions, repeatableOptions, param, ",", '=');
        String s = jcOptions.getStringValue("JCHEMPROPERTIESTABLE");
        if (s != null && (dotPos = (jcptName = s).indexOf(46)) == -1) {
            jcptName = JavaStoredProcSession.instance().getRealUser() + "." + jcptName;
        }
        boolean isJChemTable = JcMetaDataFunctions.getJspInstance().isJChemTable(jcptName, tblSchema + "." + tblName);
        int idxSubType = 0;
        String idxSubTypeString = jcOptions.getStringValue(IDX_SUBTYPE_PROPKEY);
        if (idxSubTypeString != null) {
            if (isJChemTable) {
                throw new IllegalArgumentException("idxSubTypeis not supported with JChem structure tables");
            }
            if (idxSubTypeString.toLowerCase().equals(IDX_SUBTYPE_OPTVALUE_FINGERPRINT)) {
                idxSubType = 1;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("idxSubType=" + idxSubType);
        }
        boolean absoluteStereo = jcOptions.getBoolValue("absoluteStereo", JChemProperties.ABSOLUTE_STEREO_DEFAULT);
        boolean swoffAllTatuomerProtections = jcOptions.containsOptionName(IDX_PARAM_SWITCH_OFF_ALL_PROTECTIONS_TDF) ? jcOptions.getBoolValue(IDX_PARAM_SWITCH_OFF_ALL_PROTECTIONS_TDF, JChemProperties.SWITCH_OFF_ALL_TAUTOMER_PROTECTIONS_DEFAULT) : JCartDefaultProperties.getInstance(JavaStoredProcSession.instance()).isSwitchOffAllProtectionsTdf();
        String tablespaceName = null;
        String storageClose = null;
        s = jcOptions.getStringValue("TABLESPACE");
        if (s != null) {
            if (isJChemTable) {
                throw new IllegalArgumentException("The TABLESPACE parameter can not be  specified with JChem tables");
            }
            tablespaceName = s;
        }
        if ((s = jcOptions.getStringValue("STORAGE")) != null) {
            if (isJChemTable) {
                throw new IllegalArgumentException("The STORAGE parameter can not be  specified with JChem tables");
            }
            storageClose = s;
        }
        if ((s = jcOptions.getStringValue("ABSOLUTESTEREO")) != null) {
            if (isJChemTable) {
                throw new IllegalArgumentException("The absoluteStereo parameter can not be  specified with JChem tables");
            }
            absoluteStereo = jcOptions.getBoolValue("ABSOLUTESTEREO", absoluteStereo);
        }
        int fp_size = -1;
        int fp_bit = -1;
        int pat_length = -1;
        String structFpConfig = null;
        int debug = 0;
        String sFpSize = jcOptions.getStringValue("FP_SIZE");
        String sFpBit = jcOptions.getStringValue("FP_BIT");
        String sPatLength = jcOptions.getStringValue("PAT_LENGTH");
        if (sFpBit != null && (sFpSize == null || sPatLength == null) || sPatLength != null && (sFpSize == null || sFpBit == null)) {
            throw new Exception("If FP_BIT or PAT_LENGTH are specified, all three fingerprint properties should be specified.");
        }
        if (sFpSize != null) {
            if (isJChemTable) {
                throw new Exception("Index is being creating on a JChem structure table. Fingerprint properties cannot be defined in the parameters string.");
            }
            fp_size = Integer.parseInt(sFpSize);
            if (sFpBit != null) {
                fp_bit = Integer.parseInt(sFpBit);
            }
            if (sPatLength != null) {
                pat_length = Integer.parseInt(sPatLength);
            }
        }
        String stdConfig = Indexing.getStandardizerConfiguration(jcOptions, isJChemTable);
        s = jcOptions.getStringValue("REGENERATETABLE");
        if (s != null && s.equalsIgnoreCase("true")) {
            if (!isJChemTable) {
                throw new IllegalArgumentException("The option REGENERATETABLE can be specified only with a JChem generated tabel.");
            }
            try {
                JFunctions.checkTableVersion(JavaStoredProcSession.instance(), jcptName, tblSchema + "." + tblName);
            }
            catch (Exception e) {
                if (e.getMessage().indexOf("regenerate") != -1) {
                    JcTableInfo jcTableInfo = new JcTableInfo();
                    jcTableInfo.tableName = tblSchema + "." + tblName;
                    jcTableInfo.jcPropTableName = jcptName;
                    jcTableInfo.sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
                    jcTableInfo.operation = 2;
                    Indexing.getRmiTunnel().process(jcTableInfo);
                }
                throw e;
            }
        }
        if ((s = jcOptions.getStringValue("STRUCTURALFP_CONFIG")) != null) {
            if (isJChemTable) {
                throw new Exception("Index is being creating on a JChem structure table. Configuration for structural keys cannot be defined as an index parameter.");
            }
            structFpConfig = s;
        }
        String[] ctArray = null;
        ArrayList ctlist = jcOptions.getValueList("AUTOCALCCT");
        if (ctlist != null) {
            if (isJChemTable) {
                Indexing.failUnsupportedJcbTableParam("AUTOCALCCT");
            }
            ctArray = new String[ctlist.size()];
            ctlist.toArray(ctArray);
        }
        String[] ctWcnArray = null;
        ArrayList ctWcnList = jcOptions.getValueList("AUTOCALCCTWCN");
        if (ctWcnList != null) {
            if (isJChemTable) {
                Indexing.failUnsupportedJcbTableParam("AUTOCALCCTWCN");
            }
            ctWcnArray = new String[ctWcnList.size()];
            ctWcnList.toArray(ctWcnArray);
        }
        int duplicateFilteringFlags = 0;
        boolean duplicateFiltering = jcOptions.getBoolValue("DUPLICATEFILTERING", false);
        if (duplicateFiltering) {
            if (isJChemTable) {
                Indexing.failUnsupportedJcbTableParam("DUPLICATEFILTERING");
            }
            duplicateFilteringFlags |= 1;
        }
        if (tautomerDuplicateFiltering = jcOptions.getBoolValue("TDF", false)) {
            if (isJChemTable) {
                Indexing.failUnsupportedJcbTableParam("TDF");
            }
            duplicateFilteringFlags |= 4;
        }
        boolean uniqueLikeDuplicateFiltering = jcOptions.getBoolValue("EXCLUSIVEDF", false);
        if (duplicateFiltering && isJChemTable) {
            Indexing.failUnsupportedJcbTableParam("EXCLUSIVEDF");
        }
        if (duplicateFiltering && uniqueLikeDuplicateFiltering) {
            duplicateFilteringFlags |= 2;
        }
        String haltOnError = "true";
        haltOnError = jcOptions.getStringValue("haltOnBadFormat", haltOnError);
        haltOnError = jcOptions.getStringValue("haltOnError", haltOnError);
        String tableTypeString = jcOptions.getStringValue("tableType");
        if (tableTypeString != null && isJChemTable && isJChemTable) {
            throw new Exception("In the case of JChem structure tables, table type should be specified during table creation.");
        }
        if (tableTypeString == null && (tableTypeString = jcOptions.getStringValue("structureType")) != null && isJChemTable && isJChemTable) {
            throw new Exception("In the case of JChem structure tables, structure type should be specified during table creation.");
        }
        if (isJChemTable) {
            Indexing.checkTableVersion(JavaStoredProcSession.instance(), jcptName, tblSchema + "." + tblName);
        }
        if (isJChemTable) {
            Indexing.getMetaData().initMetadataMaybe(idxSchema);
            Indexing.registerCacheIds(JavaStoredProcSession.instance().getUserInfo(), JavaStoredProcSession.instance().getJccOwner(), jcptName);
            String idxQName = JcMetaDataFunctions.getJspInstance().getIdxQName(idxSchema, idxName, idxPartition);
            Indexing.getMetaData().setMasterProperty(idxSchema, idxQName + ".JChemProperties", jcptName);
            Indexing.getMetaData().setMasterProperty(idxSchema, idxQName + ".debuglevel", "" + debug);
            try {
                Indexing.getMetaData().getJChemPropertyForIndex(jcptName, tblSchema + "." + tblName, true, "fingerprint.numberOfBits");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String msg = tblName + " is not a valid JChem table, it is not registered in " + jcptName + ". [" + ex.getMessage() + "]";
                System.err.println(msg);
                throw new RuntimeException(msg);
            }
        } else {
            int[] fp_props = new int[]{fp_size * 32, fp_bit, pat_length};
            if (fp_size == -1) {
                fp_props = null;
            }
            Indexing.indexDrop(idxSchema, idxName, idxPartition, tblSchema, tblName);
            Indexing.getMetaData().initMetadataMaybe(idxSchema);
            if (logger.isDebugEnabled()) {
                logger.debug("Meta data intialized");
            }
            JavaStoredProcSession.instance().getConnection().commit();
            if (idxSubType == 1 && tableTypeString != null) {
                throw new IllegalArgumentException("idxSubType cannot be specified with neither the tableType nor the structureType option.");
            }
            SessionInfo sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
            int threadCount = jcOptions.getIntValue("threadCnt", 0);
            int insertSessionCount = jcOptions.getIntValue(OPTNAME_INSERT_SESSION_COUNT, 0);
            int refreshPeriod = jcOptions.getIntValue(REFRESHPERIOD, 1000);
            IndexCreateInfo info = new IndexCreateInfo(tblSchema, tblName, idxSchema, idxName, idxPartition, null, idxSubType, jcptName, sessionInfo, Indexing.getUserAssignedOpId(jcOptions), threadCount, colName, duplicateFilteringFlags, swoffAllTatuomerProtections, insertSessionCount, tablespaceName, stdConfig, fp_props, tblPartition, structFpConfig, absoluteStereo, storageClose, haltOnError, tableTypeString, ctArray, ctWcnArray, refreshPeriod);
            if (logger.isDebugEnabled()) {
                logger.debug("About to call getIndexServer().createIndex(info) with " + info);
            }
            Long taskId = Indexing.getIndexServer().createIndex(info);
            if (logger.isDebugEnabled()) {
                logger.debug("Call getIndexServer().createIndex(info) returned");
            }
            return taskId;
        }
        return null;
    }

    private static void failUnsupportedJcbTableParam(String param) {
        throw new IllegalArgumentException(param + " not supported for JCB tables");
    }

    private static void registerCacheIds(UserInfo userInfo, String jccOwner, String jchemPropertiesTableName) throws Exception {
        Admin admin = (Admin)RmiDirectory.instance().getServer("AdminServer");
        admin.registerCacheIds(userInfo, jccOwner, jchemPropertiesTableName);
    }

    private static void cleanUpMetadata(String idxSchema) throws Exception {
        String stmt = "DROP TABLE " + Indexing.getMetaData().getMasterIdxTableName(idxSchema);
        try {
            Indexing.getMetaData().execDDLStatement(stmt);
        }
        catch (SQLException sqlE) {
            if (sqlE.getErrorCode() == 942) {
                return;
            }
            throw sqlE;
        }
        try {
            stmt = "DROP SEQUENCE " + idxSchema + "." + IDXSEQ;
            Indexing.getMetaData().execDDLStatement(stmt);
        }
        catch (SQLException sqlE) {
            if (sqlE.getErrorCode() == 2289) {
                return;
            }
            throw sqlE;
        }
        try {
            stmt = "drop table " + idxSchema + ".jc_idx_udop";
            Indexing.getMetaData().execDDLStatement(stmt);
        }
        catch (SQLException sqlE) {
            if (sqlE.getErrorCode() == 942) {
                return;
            }
            throw sqlE;
        }
    }

    public static void dropUpdateLogTable(String logTableName) throws Exception {
        Indexing.dropUpdateLogTable(Indexing.getMetaData(), logTableName);
    }

    public static void dropUpdateLogTable(JcMetaDataFunctions metaData, String logTableName) throws Exception {
        block2: {
            String sql = "DROP TABLE " + logTableName;
            try {
                metaData.execDDLStatement(sql);
            }
            catch (SQLException sqle) {
                if (sqle.getErrorCode() == 942) break block2;
                throw sqle;
            }
        }
    }

    public static String generateUpdateLogTableName(String idxTableQName) {
        return idxTableQName + "_UL";
    }

    public static void createUpdateLogSequence(String idxTableQName) throws Exception {
        Indexing.createUpdateLogSequence(Indexing.getMetaData(), idxTableQName);
    }

    public static void createUpdateLogSequence(JcMetaDataFunctions metaData, String idxTableQName) throws Exception {
        String sql = "CREATE SEQUENCE " + Indexing.generateUpdateLogSeqName(idxTableQName) + " INCREMENT BY 1 START WITH 1";
        metaData.execDDLStatement(sql);
    }

    static void dropUpdateLogSequence(String logTableSeqName) throws Exception {
        block2: {
            String sql = "DROP SEQUENCE " + logTableSeqName;
            try {
                Indexing.getMetaData().execDDLStatement(sql);
            }
            catch (SQLException sqle) {
                if (sqle.getErrorCode() == 2289) break block2;
                throw sqle;
            }
        }
    }

    public static String generateUpdateLogSeqName(String idxTableQName) {
        return idxTableQName + "_USQ";
    }

    public static void completeIndexTable(JcMetaDataFunctions metaData, IndexCreateInfo ii) throws Exception {
        Indexing.createCdHashIndex(metaData, ii.getIndexTableQName(), ii.getTablespaceName());
    }

    public static void createCdHashIndex(JcMetaDataFunctions metaData, String indexTableQName, String tablespaceName) throws Exception {
        String stmt = "CREATE INDEX " + indexTableQName + "hx ON " + indexTableQName + "(cd_hash)";
        if (tablespaceName != null) {
            stmt = stmt + " tablespace " + tablespaceName;
        }
        metaData.execDDLStatement(stmt);
    }

    public static void removeCdHashIndex(JcMetaDataFunctions metaData, String idxTblQName) throws Exception {
        String stmt = "DROP INDEX " + idxTblQName + "hx";
        metaData.execDDLStatement(stmt);
    }

    public static int exchangePartitions(String localIdxSchema, String localIdxName, String localIdxPartition, String globalIdxSchema, String globalIdxName) throws Exception {
        throw new UnsupportedOperationException("ALTER TABLE EXCHANGE PARTITION is not supported with the INCLUDING INDEXES CLAUSE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int indexDrop(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        String stmt;
        if (logger.isDebugEnabled()) {
            logger.debug("Dropping index: idxSchema=" + idxSchema + ", idxName=" + idxName + ", idxPartition=" + idxPartition + ", tblSchema=" + tblSchema + ", tblName=" + tblName);
        }
        PreparedStatement ps = null;
        OracleResultSet rset = null;
        String masterTable = Indexing.getMetaData().getMasterIdxTableName(idxSchema);
        if (!Indexing.getMetaData().tableExists(masterTable)) {
            if (logger.isDebugEnabled()) {
                logger.debug("indexDrop: no indexes yet");
            }
            return 0;
        }
        String idxTableQName = JcMetaDataFunctions.getJspInstance().getIdxTableQName(idxSchema, idxName, idxPartition);
        boolean isJChemTable = false;
        if (idxTableQName == null) {
            isJChemTable = true;
            idxTableQName = tblSchema + "." + tblName;
        }
        String jcptName = null;
        try {
            jcptName = Indexing.getMetaData().getPropertyTableName(idxSchema, idxName, idxPartition);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("indexDrop: jcptName=" + jcptName);
        }
        JCartIndexDescriptor idxDesc = null;
        if (jcptName != null) {
            idxDesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, null);
            SessionInfo uInfo = JavaStoredProcSession.instance().getSessionInfo();
            MdManagementInfo info = new MdManagementInfo(idxDesc, uInfo, null, 0, null);
            Indexing.getIndexServer().deleteAllMolDesc(info);
        }
        if (!isJChemTable) {
            block30: {
                block29: {
                    try {
                        Indexing.getMetaData().execDDLStatement("DROP TABLE " + idxTableQName + " CASCADE CONSTRAINTS");
                        logger.warning("Index table " + idxTableQName + " has been dropped.");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getErrorCode() == 942) break block29;
                        throw sqle;
                    }
                }
                try {
                    Indexing.getMetaData().execDDLStatement("DROP SEQUENCE " + idxTableQName + "_SQ");
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == 2289) break block30;
                    throw sqle;
                }
            }
            if (idxDesc == null) {
                Indexing.dropUpdateLogTable(Indexing.generateUpdateLogTableName(idxTableQName));
                Indexing.dropUpdateLogSequence(Indexing.generateUpdateLogSeqName(idxTableQName));
            } else {
                Indexing.dropUpdateLogTable(idxDesc.getUpdateLogTableName());
                Indexing.dropUpdateLogSequence(idxDesc.getUpdateLogSeqName());
            }
        }
        if (jcptName != null && !isJChemTable) {
            stmt = "DELETE " + jcptName + " WHERE prop_name LIKE ? OR prop_name LIKE ?";
            ps = JavaStoredProcSession.instance().prepareStatement(stmt);
            try {
                ps.setString(1, "%idxtable." + idxTableQName.toUpperCase() + ".%");
                ps.setString(2, "update." + idxTableQName.toUpperCase() + ".%");
                ps.execute();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                JavaStoredProcSession.instance().close(null, ps);
                ps = null;
            }
        }
        stmt = "DELETE " + masterTable + " WHERE prop_name LIKE ?";
        String propNameLike = (idxSchema + "." + idxName).toUpperCase() + ".%";
        try {
            ps = JavaStoredProcSession.instance().prepareStatement(stmt);
            ps.setString(1, propNameLike);
            ps.execute();
        }
        finally {
            JavaStoredProcSession.instance().close(null, ps);
            ps = null;
        }
        stmt = "SELECT count(*) FROM " + masterTable;
        try {
            ps = JavaStoredProcSession.instance().prepareStatement(stmt);
            rset = (OracleResultSet)ps.executeQuery();
            rset.next();
            if (rset.getInt(1) == 0) {
                Indexing.cleanUpMetadata(idxSchema);
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                System.err.println("Error while dropping index");
                throw ex;
            }
            catch (Throwable throwable) {
                JavaStoredProcSession.instance().close((ResultSet)rset, ps);
                ps = null;
                throw throwable;
            }
        }
        JavaStoredProcSession.instance().close((ResultSet)rset, ps);
        ps = null;
        return 0;
    }

    public static int indexTruncate(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        DbSession dbSession = DbSessionBase.getCurrent();
        JCartIndexDescriptor idxDesc = JCartIndexDescriptor.get(dbSession, idxSchema, idxName, idxPartition, tblSchema, tblName, null);
        if (idxDesc.isJChemTable()) {
            return 0;
        }
        IndexingInfo ii = new IndexingInfo(idxDesc, dbSession.getSessionInfo(), null, 1, null, null, 1);
        Indexing.getIndexServer().truncateIndex(ii);
        return 0;
    }

    private static Index getIndexServer() throws Exception {
        return (Index)RmiDirectory.instance().getServer("IndexServer");
    }

    public static int indexAlter(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String tblPartition, String colName, String params, int alterOption) throws Exception {
        return Indexing.indexAlterUc(idxSchema, idxName, idxPartition, tblSchema, tblName, tblPartition, colName, params, alterOption);
    }

    private static int indexAlterUc(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String tblPartition, String colName, String params, int alterOption) throws Exception {
        switch (alterOption) {
            case 0: {
                ArrayList delCtWcnList;
                ArrayList addCtWcnList;
                ArrayList delCtList;
                String[] allowedOptions = new String[]{"resumeIndexUpdate", "addAutoCalcCt", "delAutoCalcCt", "addAutoCalcCtWcn", "delAutoCalcCtWcn", OPTNAME_ADDMD, OPTNAME_DELMD, OPTNAME_ADDMDCONF, OPTNAME_DELMDCONF, OPTNAME_ADD_DFLT_MDCONF, REFRESHPERIOD};
                String[] repeatableOptions = new String[]{"addAutoCalcCt", "delAutoCalcCt", "addAutoCalcCtWcn", "delAutoCalcCtWcn"};
                CxOptions jcOptions = new CxOptions(allowedOptions, repeatableOptions, params, ",", '=');
                JCartIndexDescriptor idesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, colName);
                boolean isJChemTable = idesc.isJChemTable();
                SessionInfo sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
                int threadCount = jcOptions.getIntValue("threadCnt", 0);
                int insertSessionCount = jcOptions.getIntValue(OPTNAME_INSERT_SESSION_COUNT, 0);
                String[] addCts = null;
                String[] delCts = null;
                String[] addCtsWcn = null;
                String[] delCtsWcn = null;
                ArrayList addCtList = jcOptions.getValueList("addAutoCalcCt");
                if (addCtList != null) {
                    if (isJChemTable) {
                        Indexing.failUnsupportedJcbTableParam("addAutoCalcCt");
                    }
                    if (addCtList.size() > 0) {
                        addCts = new String[addCtList.size()];
                        addCtList.toArray(addCts);
                    }
                }
                if ((delCtList = jcOptions.getValueList("delAutoCalcCt")) != null) {
                    if (isJChemTable) {
                        Indexing.failUnsupportedJcbTableParam("delAutoCalcCt");
                    }
                    if (delCtList.size() > 0) {
                        delCts = new String[delCtList.size()];
                        delCtList.toArray(delCts);
                    }
                }
                if ((addCtWcnList = jcOptions.getValueList("addAutoCalcCtWcn")) != null) {
                    if (isJChemTable) {
                        Indexing.failUnsupportedJcbTableParam("addAutoCalcCtWcn");
                    }
                    if (addCtWcnList.size() > 0) {
                        addCtsWcn = new String[addCtWcnList.size()];
                        addCtWcnList.toArray(addCtsWcn);
                    }
                }
                if ((delCtWcnList = jcOptions.getValueList("delAutoCalcCtWcn")) != null) {
                    if (isJChemTable) {
                        Indexing.failUnsupportedJcbTableParam("delAutoCalcCtWcn");
                    }
                    if (delCtWcnList.size() > 0) {
                        delCtsWcn = new String[delCtWcnList.size()];
                        delCtWcnList.toArray(delCtsWcn);
                    }
                }
                AlterIndexInfo aii = new AlterIndexInfo(idesc, sessionInfo, Indexing.getUserAssignedOpId(jcOptions), threadCount, "true", null, insertSessionCount, delCts, addCts, delCtsWcn, addCtsWcn);
                Indexing.getIndexServer().alterIndex(aii);
                Indexing.truncateUpdateLogTable(aii);
                Indexing.incrementUpdateCounter(idesc.getIdxTableQName(), idesc.getJcptName(), false);
                Indexing.indexAlterMD(idesc, params, alterOption, idesc.getJcptName(), idesc.isJChemTable(), jcOptions);
                return 0;
            }
            case 1: {
                break;
            }
            case 2: {
                return Indexing.indexRebuild(idxSchema, idxName, idxPartition, tblSchema, tblName, colName, params);
            }
            case 5: {
                throw new IllegalArgumentException("Illegal option for ALTER INDEX: AlterIndexUpdBlockRefs");
            }
            default: {
                throw new IllegalArgumentException("Illegal option for ALTER INDEX: " + alterOption);
            }
        }
        return -1;
    }

    private static void truncateUpdateLogTable(IndexingInfo ii) throws Exception {
        Index index = (Index)RmiDirectory.instance().getServer("IndexServer");
        index.truncateUpdateLogTable(ii);
    }

    private static int indexAlterMD(JCartIndexDescriptor idxDesc, String params, int alterOption, String jc_name, boolean isJChemTable, CxOptions jcOptions) throws Exception {
        int threadCount;
        SessionInfo sessionInfo;
        if (isJChemTable) {
            throw new UnsupportedOperationException("Molecular Descriptor administriation is currently not supported through this interface.");
        }
        String s = jcOptions.getStringValue(OPTNAME_ADD_DFLT_MDCONF.toUpperCase());
        if (s != null) {
            sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
            threadCount = jcOptions.getIntValue("threadCnt", 0);
            int insertSessionCount = jcOptions.getIntValue(OPTNAME_INSERT_SESSION_COUNT, 0);
            CreateMolDescInfo info = new CreateMolDescInfo(idxDesc, sessionInfo, Indexing.getUserAssignedOpId(jcOptions), threadCount, insertSessionCount, s);
            Indexing.getIndexServer().createMdWithDefaultSettings(info);
        }
        if ((s = jcOptions.getStringValue(OPTNAME_ADDMD.toUpperCase())) != null) {
            Indexing.addMd(idxDesc, jcOptions, s);
        }
        if ((s = jcOptions.getStringValue(OPTNAME_DELMD.toUpperCase())) != null) {
            sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
            threadCount = jcOptions.getIntValue("threadCnt", 0);
            MdManagementInfo info = new MdManagementInfo(idxDesc, sessionInfo, Indexing.getUserAssignedOpId(jcOptions), threadCount, s);
            Indexing.getIndexServer().deleteMolDesc(info);
        }
        if ((s = jcOptions.getStringValue(OPTNAME_ADDMDCONF.toUpperCase())) != null) {
            sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
            threadCount = jcOptions.getIntValue("threadCnt", 0);
            MdManagementInfo info = new MdManagementInfo(idxDesc, sessionInfo, Indexing.getUserAssignedOpId(jcOptions), threadCount, s);
            Indexing.getIndexServer().addMolDescConf(info);
        }
        if ((s = jcOptions.getStringValue(OPTNAME_DELMDCONF.toUpperCase())) != null) {
            sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
            threadCount = jcOptions.getIntValue("threadCnt", 0);
            MdManagementInfo info = new MdManagementInfo(idxDesc, sessionInfo, Indexing.getUserAssignedOpId(jcOptions), threadCount, s);
            Indexing.getIndexServer().delMolDescConf(info);
        }
        return 0;
    }

    private static void addMd(JCartIndexDescriptor idxDesc, CxOptions jcOptions, String mdSettingsLocator) throws RemoteException, Exception {
        SessionInfo sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
        int threadCount = jcOptions.getIntValue("threadCnt", 0);
        int insertSessionCount = jcOptions.getIntValue(OPTNAME_INSERT_SESSION_COUNT, 0);
        CreateMolDescInfo info = new CreateMolDescInfo(idxDesc, sessionInfo, Indexing.getUserAssignedOpId(jcOptions), threadCount, insertSessionCount, mdSettingsLocator);
        Indexing.getIndexServer().createMolDesc(info);
    }

    private static int indexRebuild(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, String param) throws Exception {
        JCartIndexDescriptor idxDescriptor;
        if (logger.isDebugEnabled()) {
            logger.debug("User name: " + JavaStoredProcSession.instance().getConnection().getMetaData().getUserName() + ", real user: " + JavaStoredProcSession.instance().getRealUser());
        }
        if ((idxDescriptor = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, colName)).isJChemTable()) {
            throw new IllegalArgumentException("ALTER INDEX REBUILD is not supported for JChem structure tables.");
        }
        Indexing.registerCacheIds(JavaStoredProcSession.instance().getUserInfo(), JavaStoredProcSession.instance().getJccOwner(), idxDescriptor.getJcptName());
        boolean upgradeOnly = false;
        boolean skipAutoCalcCt = false;
        boolean skipRecalc = false;
        String tablespaceName = null;
        String storageClose = null;
        String[] allowedOptions = new String[]{"UPGRADEONLY", "SKIPAUTOCALCCT", "SKIPRECALC", "TABLESPACE", "STORAGE", "ABSOLUTESTEREO", IDX_PARAM_STD_CONF, IDX_PARAM_STD_CONF_SQL, "threadCnt", OPTNAME_INSERT_SESSION_COUNT, "haltOnError", "usrOpId", REFRESHPERIOD};
        CxOptions jcOptions = new CxOptions(allowedOptions, param, ",", '=');
        String s = jcOptions.getStringValue("UPGRADEONLY");
        if (s != null) {
            upgradeOnly = s.toLowerCase().equals("y");
        }
        if ((s = jcOptions.getStringValue("SKIPAUTOCALCCT")) != null) {
            skipAutoCalcCt = s.toLowerCase().equals("y");
        }
        if ((s = jcOptions.getStringValue("SKIPRECALC")) != null) {
            skipRecalc = s.toLowerCase().equals("y");
        }
        String stdConfig = Indexing.getStandardizerConfiguration(jcOptions, idxDescriptor.isJChemTable());
        if (upgradeOnly) {
            if (idxDescriptor.getIdxSubType() == 1) {
                String skipMessage = "Index " + idxDescriptor.getIndexSchemaName().toUpperCase() + "." + idxDescriptor.getIndexName().toUpperCase() + " is of fingerprint subtype is not going to be rebuilt";
                JFunctions.trace(skipMessage);
                return 0;
            }
            if (idxDescriptor.getIdxCompatibility() >= 0) {
                String skipMessage = "Index " + idxDescriptor.getIndexSchemaName().toUpperCase() + "." + idxDescriptor.getIndexName().toUpperCase() + " is not going to be recalculated " + "as the parameter 'upgradeOnly=y' has been specified " + "and this index is not older than the current version.";
                JFunctions.trace(skipMessage);
                if (idxDescriptor.getIdxCompatibility() == 0) {
                    skipRecalc = true;
                }
            }
        }
        if (skipRecalc && idxDescriptor.getIdxCompatibility() != 0) {
            throw new IllegalArgumentException("Cannot skip index data recalculation due to differing table versions");
        }
        s = jcOptions.getStringValue("TABLESPACE");
        if (s != null) {
            tablespaceName = s;
        }
        if ((s = jcOptions.getStringValue("STORAGE")) != null) {
            storageClose = s;
        }
        SessionInfo sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
        int threadCount = jcOptions.getIntValue("threadCnt", 0);
        int insertSessionCount = jcOptions.getIntValue(OPTNAME_INSERT_SESSION_COUNT, 0);
        int tableType = Indexing.getMetaData().getTableType(idxDescriptor.getJcptName(), idxDescriptor.getIdxTableQName(), false);
        String haltOnError = "true";
        haltOnError = jcOptions.getStringValue("haltOnBadFormat", haltOnError);
        haltOnError = jcOptions.getStringValue("haltOnError", haltOnError);
        IndexRebuildInfo indexRebuildInfo = new IndexRebuildInfo(idxDescriptor, sessionInfo, Indexing.getUserAssignedOpId(jcOptions), threadCount, haltOnError, String.valueOf(tableType), insertSessionCount, tablespaceName, storageClose, stdConfig, skipRecalc, skipAutoCalcCt);
        Long taskId = Indexing.getIndexServer().rebuildIndex(indexRebuildInfo);
        if (Indexing.isIndexingAsynch()) {
            LongOpOracleParams oracleParams = new LongOpOracleParams();
            LongOp indexLongOp = Indexing.getIndexLongOp(taskId, oracleParams);
            while (!LongOpStatus.updateStatus(indexLongOp, oracleParams)) {
            }
        }
        if ((s = jcOptions.getStringValue("ABSOLUTESTEREO")) != null) {
            boolean absoluteStereo = jcOptions.getBoolValue("ABSOLUTESTEREO", false);
            Indexing.getMetaData().setJChemPropertyForIndex(idxDescriptor.getJcptName(), idxDescriptor.getIdxTableQName(), false, "absoluteStereo", String.valueOf(absoluteStereo));
        }
        IndexingInfo ii = new IndexingInfo(idxDescriptor, JavaStoredProcSession.instance().getSessionInfo(), Indexing.getUserAssignedOpId(jcOptions), 1, null, null, 1);
        Indexing.truncateUpdateLogTable(ii);
        Indexing.incrementUpdateCounter(idxDescriptor.getIdxTableQName(), idxDescriptor.getJcptName(), false);
        return 0;
    }

    public static boolean isIndexingAsynch() throws Exception {
        Admin admin = (Admin)RmiDirectory.instance().getServer("AdminServer");
        boolean b = new Boolean(admin.getProperty("chemaxon.jchem.cartridge.indexingIsAynch"));
        if (logger.isDebugEnabled()) {
            logger.debug("isIndexingAsynch returning " + b);
        }
        return b;
    }

    private static String getStandardizerConfiguration(CxOptions jcOptions, boolean isJChemTable) throws Exception {
        String stdConfig = JCartDefaultProperties.getInstance(JavaStoredProcSession.instance()).getStandardizerConfig();
        String s = jcOptions.getStringValue(IDX_PARAM_STD_CONF);
        if (s != null) {
            if (isJChemTable) {
                throw new IllegalArgumentException("The parameter STD_CONFIG cannot be used  for tables that have been generated by JChem.");
            }
            stdConfig = s;
        }
        s = jcOptions.getStringValue(IDX_PARAM_STD_CONF_SQL);
        if (logger.isDebugEnabled()) {
            logger.debug("STD_CONF:SQL: " + s);
        }
        if (s != null) {
            if (isJChemTable) {
                throw new IllegalArgumentException("The parameter STD_CONFIG cannot be used  for tables that have been generated by JChem.");
            }
            ResultSet rs = null;
            PreparedStatement pstmt = JavaStoredProcSession.getCurrent().prepareStatement(s);
            try {
                rs = pstmt.executeQuery();
                if (!rs.next()) {
                    throw new IllegalArgumentException("STD_CONF:SQL returned no results");
                }
                stdConfig = JFunctions.readString(rs, 1);
            }
            catch (SQLException sqlException) {
                if (logger.isErrorEnabled()) {
                    logger.error("Failing sql: " + s);
                }
                throw sqlException;
            }
            finally {
                JavaStoredProcSession.getCurrent().close(rs, pstmt);
            }
        }
        return stdConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkCreateSortableFormulaColumn(JCartIndexDescriptor idxDescriptor) throws Exception {
        String sql = "select * from " + idxDescriptor.getIdxTableQName() + " where 1 = 2";
        ResultSet rs = null;
        PreparedStatement pstmt = JavaStoredProcSession.instance().prepareStatement(sql);
        try {
            rs = pstmt.executeQuery();
            ResultSetMetaData rsmeta = rs.getMetaData();
            int colCount = rsmeta.getColumnCount();
            for (int i = 1; i <= colCount; ++i) {
                if (!rsmeta.getColumnName(i).toLowerCase().equals("cd_sortable_formula")) continue;
                return;
            }
        }
        finally {
            JavaStoredProcSession.instance().close(rs, pstmt);
        }
        sql = "alter table " + idxDescriptor.getIdxTableQName() + " add (cd_sortable_formula varchar2(500))";
        Indexing.getMetaData().execDDLStatement(sql);
    }

    public static String getIndexStatistics(String idxSchema, String idxName, String idxPartition) throws Exception {
        return Indexing.getIndexStatistics(idxSchema, idxName, idxPartition, null);
    }

    public static String getIndexStatistics(String idxSchema, String idxName, String idxPartition, String userAssignedId) throws Exception {
        boolean jchemTable = false;
        JCartIndexDescriptor idxDesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition);
        SessionInfo sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
        FetchIndexStats info = new FetchIndexStats(idxDesc, sessionInfo, userAssignedId);
        return Indexing.getIndexServer().fetchIndexStats(info);
    }

    public static String getIndexName(String idxSchema, String idxName, String idxPartition) {
        String name = idxSchema + "." + idxName;
        if (idxPartition != null) {
            name = name + "_" + idxPartition;
        }
        return name;
    }

    public static void completeIndexTable(IndexCreateInfo ii) throws Exception {
        Indexing.completeIndexTable(Indexing.getMetaData(), ii);
    }

    public static int getIdxSubType(CxOptions cxOptions) {
        if (cxOptions == null) {
            return 0;
        }
        String idxSubTypeString = cxOptions.getStringValue(IDX_SUBTYPE_PROPKEY);
        if (idxSubTypeString == null) {
            return 0;
        }
        if (idxSubTypeString.equalsIgnoreCase(IDX_SUBTYPE_OPTVALUE_FINGERPRINT)) {
            return 1;
        }
        return 0;
    }
}

