/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge;

import chemaxon.jchem.cartridge.JCFunctionsBlob;
import chemaxon.jchem.cartridge.JCartDml;
import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.JcSimilarity;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.oresident.JavaStoredProcExceptionHandler;
import chemaxon.jchem.cartridge.oresident.util.HTMLTools;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.sql.ARRAY;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import sqlj.runtime.RuntimeContext;

public class JCFunctionsClob {
    private JCFunctionsClob() {
    }

    public static String execFunction(String sqlOperator, String target, CLOB query, String options, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, int scanId, int scanFlag, String[] result) throws Exception {
        return JFunctions.execFunction(sqlOperator, target, JCFunctionsClob.clobToString(query), options, rid, idxSchema, idxName, idxPartition, tblSchema, tblName, colName, scanId, scanFlag, result);
    }

    public static String execFunction(String sqlOperator, CLOB target, String query, String options, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, int scanId, int scanFlag, String[] result) throws Exception {
        return JFunctions.execFunction(sqlOperator, JCFunctionsClob.clobToString(target), query, options, rid, idxSchema, idxName, idxPartition, tblSchema, tblName, colName, scanId, scanFlag, result);
    }

    public static String execFunction(String sqlOperator, CLOB target, CLOB query, String options, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, int scanId, int scanFlag, String[] result) throws Exception {
        return JFunctions.execFunction(sqlOperator, JCFunctionsClob.clobToString(target), JCFunctionsClob.clobToString(query), options, rid, idxSchema, idxName, idxPartition, tblSchema, tblName, colName, scanId, scanFlag, result);
    }

    public static String execFunction(String sqlOperator, CLOB target, BLOB query, String options, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, int scanId, int scanFlag, String[] result) throws Exception {
        return JFunctions.execFunction(sqlOperator, JCFunctionsClob.clobToString(target), JCFunctionsBlob.blobToString(query), options, rid, idxSchema, idxName, idxPartition, tblSchema, tblName, colName, scanId, scanFlag, result);
    }

    public static String execFunctionC(String sqlOperator, CLOB target, CLOB query, String options, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, int scanId, int scanFlag, CLOB[] result) throws Exception {
        String[] r = new String[1];
        String error = JFunctions.execFunction(sqlOperator, JCFunctionsClob.clobToString(target), JCFunctionsClob.clobToString(query), options, rid, idxSchema, idxName, idxPartition, tblSchema, tblName, colName, scanId, scanFlag, r);
        if (error == null) {
            result[0] = JCFunctionsClob.stringToTmpClob(r[0], null);
        }
        return error;
    }

    public static ARRAY evaluateArr(CLOB target, String options, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        Object[] objArray = (Object[])JFunctions.evaluateToAny("T_EVALUATE", JCFunctionsClob.clobToString(target), options, rid, idxSchema, idxName, idxPartition, tblSchema, tblName, 2005);
        return JFunctions.convertToARRAY(objArray, "CLOB_ARRAY");
    }

    public static ARRAY hitColorAndAlignOptions(String tblSchema, String tblName, String colName, CLOB query, String rowids, String options, String hitColorAlignOptions, long scanId) throws Exception {
        Object[] objArray = JFunctions.hitColorAlignObjecArr(tblSchema, tblName, colName, JCFunctionsClob.clobToString(query), rowids, options, hitColorAlignOptions, 2005, scanId);
        return JFunctions.convertToARRAY(objArray, "CLOB_ARRAY");
    }

    public static String calcValue(CLOB query, String rid, String params, String method, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        return JFunctions.calcValue(JCFunctionsClob.clobToString(query), rid, params, method, idxSchema, idxName, idxPartition, tblSchema, tblName);
    }

    public static String indexScan(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, String optype, String optypeFlavor, String start, String stop, int opFlag, CLOB query, String options, long scanId) throws Exception {
        return JFunctions.indexScan(idxSchema, idxName, idxPartition, tblSchema, tblName, colName, optype, optypeFlavor, start, stop, opFlag, JCFunctionsClob.clobToString(query), options, scanId);
    }

    public static int getHitCount(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, String jpName, String optype, String optypeFlavor, String start, String stop, int opFlag, CLOB query, String options, long scanId) throws Exception {
        return JFunctions.getHitCount(idxSchema, idxName, idxPartition, tblSchema, tblName, colName, jpName, optype, optypeFlavor, start, stop, opFlag, JCFunctionsClob.clobToString(query), options, scanId);
    }

    public static String getSimilarity(CLOB query, String searchType, String start, String stop, int opFlag, String searchOptions, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, long scanId) throws Exception {
        return JcSimilarity.getSimilarity(JCFunctionsClob.clobToString(query), searchType, start, stop, opFlag, searchOptions, idxSchema, idxName, idxPartition, tblSchema, tblName, colName, scanId);
    }

    public static String insertMolIntoIndexTable(CLOB str, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, String rid) throws Exception {
        if (JFunctions.isJChemTable(idxSchema, idxName, idxPartition, tblSchema, tblName, false)) {
            return null;
        }
        try {
            JCartIndexDescriptor idesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, colName);
            JCartDml.insertMolIntoIndexTable(JCFunctionsClob.clobToString(str), idesc, rid);
            return null;
        }
        catch (Exception exception) {
            return JavaStoredProcExceptionHandler.handleTopLevelError(exception);
        }
    }

    public static String updateMolIndexTable(CLOB oldValue, CLOB newValue, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, String rid) throws Exception {
        if (JFunctions.isJChemTable(idxSchema, idxName, idxPartition, tblSchema, tblName, false)) {
            return null;
        }
        String oldv = JCFunctionsClob.clobToString(oldValue);
        String newv = JCFunctionsClob.clobToString(newValue);
        if (oldv == null || newv == null ? oldv == null && newv == null : oldv.equals(newv)) {
            return null;
        }
        try {
            JCartIndexDescriptor idesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, colName);
            JCartDml.updateMolIndexTable(newv, idesc, rid);
            return null;
        }
        catch (Exception exception) {
            return JavaStoredProcExceptionHandler.handleTopLevelError(exception);
        }
    }

    public static ARRAY insertMol(CLOB str, String tblName, String JCPName, String dupChk, String hod, String options) throws Exception {
        return JCartDml.insertMol(JCFunctionsClob.clobToString(str), tblName, JCPName, dupChk, hod, options);
    }

    public static int updateMol(CLOB newStr, String tblName, int id, String JCPName, String options) throws Exception {
        return JCartDml.updateMol(JCFunctionsClob.clobToString(newStr), tblName, id, JCPName, options);
    }

    public static CLOB calcMolProp(CLOB query, String type, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        String prop = JFunctions.calcMolProp(JCFunctionsClob.clobToString(query), type, rid, idxSchema, idxName, idxPartition, tblSchema, tblName);
        return JCFunctionsClob.stringToTmpClob(prop, null);
    }

    public static double calcMolPropNum(CLOB query, String type, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        return JFunctions.calcMolPropNum(JCFunctionsClob.clobToString(query), type, rid, idxSchema, idxName, idxPartition, tblSchema, tblName);
    }

    public static CLOB calcMolPropFromRowid(String rid, String type, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        String prop = JFunctions.calcMolPropFromRowid(rid, type, idxSchema, idxName, idxPartition, tblSchema, tblName);
        return JCFunctionsClob.stringToTmpClob(prop, null);
    }

    public static double calcMolPropNumFromRowid(String rid, String type, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        return JFunctions.calcMolPropNumFromRowid(rid, type, idxSchema, idxName, idxPartition, tblSchema, tblName);
    }

    public static double getMolweight(CLOB query, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        return JFunctions.calcMolPropNum(JCFunctionsClob.clobToString(query), "molweight", rid, idxSchema, idxName, idxPartition, tblSchema, tblName);
    }

    public static String getMolformula(CLOB query, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        return JFunctions.calcMolProp(JCFunctionsClob.clobToString(query), "molformula", rid, idxSchema, idxName, idxPartition, tblSchema, tblName);
    }

    public static String getSqlForFormulaScan(String type, String idxSchema, String idxName, String idxPartition, CLOB query, String predicate) throws Exception {
        return JFunctions.getSqlForFormulaScan(idxSchema, idxName, idxPartition, JCFunctionsClob.clobToString(query), predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLOB molconvertc(CLOB query, String inputFormat, String options, String otherOptions, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, CLOB tmpClob) throws Exception {
        Connection conn = RuntimeContext.getRuntime().getDefaultConnection();
        if (tmpClob == null) {
            tmpClob = CLOB.createTemporary((Connection)conn, (boolean)false, (int)10);
        }
        Writer writer = tmpClob.getCharacterOutputStream(0L);
        try {
            byte[] bytes = JFunctions.molconvertToBytes(JCFunctionsClob.clobToByteArray(query), inputFormat, options, otherOptions);
            writer.write(new String(bytes));
            CLOB cLOB = tmpClob;
            return cLOB;
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BLOB molconvertb(CLOB query, String inputFormat, String options, String otherOptions, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, BLOB tmpBlob) throws Exception {
        Connection conn = RuntimeContext.getRuntime().getDefaultConnection();
        if (tmpBlob == null) {
            tmpBlob = BLOB.createTemporary((Connection)conn, (boolean)false, (int)10);
        }
        OutputStream os = tmpBlob.getBinaryOutputStream();
        try {
            byte[] bytes = JFunctions.molconvertToBytes(JCFunctionsClob.clobToByteArray(query), inputFormat, options, otherOptions);
            os.write(bytes);
            BLOB bLOB = tmpBlob;
            return bLOB;
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLOB molconvertCFromRowid(String rid, String format2, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, CLOB tmp) throws Exception {
        CLOB cLOB;
        Connection conn = RuntimeContext.getRuntime().getDefaultConnection();
        boolean isJChemTable = JFunctions.isJChemTable(idxSchema, idxName, idxPartition, tblSchema, tblName, false);
        if (!isJChemTable) {
            return null;
        }
        String stmt = "SELECT cd_structure FROM " + tblSchema + "." + tblName + " WHERE ROWID = ?";
        PreparedStatement ps = null;
        ResultSet rset = null;
        ps = conn.prepareStatement(stmt);
        try {
            ps.setString(1, rid);
            rset = ps.executeQuery();
            rset.next();
            byte[] ba = JFunctions.readBytes(rset, "cd_structure");
            cLOB = JCFunctionsClob.stringToTmpClob(new String(JFunctions.molconvertToBytes(ba, null, format2, null)), tmp);
        }
        catch (Throwable throwable) {
            JavaStoredProcSession.instance().close(rset, ps);
            throw throwable;
        }
        JavaStoredProcSession.instance().close(rset, ps);
        return cLOB;
    }

    public static CLOB react(CLOB reaction, CLOB reactant1, CLOB reactant2, CLOB reactant3, CLOB reactant4, String options, CLOB tempClob, String oldJcReact) throws Exception {
        String[] products = JFunctions.react(JCFunctionsClob.clobToString(reaction), JCFunctionsClob.clobToString(reactant1), JCFunctionsClob.clobToString(reactant2), JCFunctionsClob.clobToString(reactant3), JCFunctionsClob.clobToString(reactant4), options, oldJcReact, false);
        if (products == null || products.length == 0) {
            return null;
        }
        return JCFunctionsClob.stringToTmpClob(products[0], tempClob);
    }

    public static ARRAY reactArr(CLOB reaction, CLOB reactant1, CLOB reactant2, CLOB reactant3, CLOB reactant4, String options, CLOB tempClob) throws Exception {
        Object[] objArray = JFunctions.reactObjArr(JCFunctionsClob.clobToString(reaction), JCFunctionsClob.clobToString(reactant1), JCFunctionsClob.clobToString(reactant2), JCFunctionsClob.clobToString(reactant3), JCFunctionsClob.clobToString(reactant4), options, "f", true);
        return JFunctions.convertToARRAY(objArray, "CLOB_PRODUCT_ARRAY");
    }

    public static CLOB standardize(CLOB structure, String param, CLOB tempClob) throws Exception {
        String result = JFunctions.standardize(JCFunctionsClob.clobToString(structure), param);
        return JCFunctionsClob.stringToTmpClob(result, tempClob);
    }

    public static CLOB sendUserFunc(String name, String delim, CLOB params) throws Exception {
        return JCFunctionsClob.stringToTmpClob(JFunctions.sendUserFunc(name, delim, JCFunctionsClob.clobToString(params)), null);
    }

    public static CLOB convertForJavaScript(CLOB blob) throws Exception {
        return JCFunctionsClob.convertForJavaScript(blob, null);
    }

    public static CLOB convertForJavaScript(CLOB blob, CLOB tempClob) throws Exception {
        String js = HTMLTools.convertForJavaScript(JCFunctionsClob.clobToString(blob));
        return JCFunctionsClob.stringToTmpClob(js, tempClob);
    }

    public static String convertForJavaScriptToStr(CLOB blob) throws Exception {
        return HTMLTools.convertForJavaScript(JCFunctionsClob.clobToString(blob));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clobToString(CLOB clob) throws Exception {
        if (clob == null) {
            return null;
        }
        StringWriter swriter = new StringWriter();
        int bufferSize = clob.getBufferSize();
        char[] buffer = new char[bufferSize];
        Reader reader = clob.getCharacterStream();
        try {
            int readCount = reader.read(buffer);
            while (readCount != -1) {
                swriter.write(buffer, 0, readCount);
                readCount = reader.read(buffer);
            }
            swriter.flush();
            String string = swriter.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] clobToByteArray(CLOB clob) throws Exception {
        if (clob == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int bufferSize = clob.getBufferSize();
        char[] buffer = new char[bufferSize];
        Reader reader = clob.getCharacterStream();
        try {
            byte[] result;
            int readCount = reader.read(buffer);
            while (readCount != -1) {
                String chunk = new String(buffer, 0, readCount);
                byte[] bytes = chunk.getBytes();
                bout.write(bytes, 0, bytes.length);
                readCount = reader.read(buffer);
            }
            byte[] byArray = result = bout.toByteArray();
            return byArray;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLOB stringToTmpClob(String string, CLOB tempClob) throws Exception {
        if (string == null) {
            return null;
        }
        if (tempClob == null) {
            Connection conn = JavaStoredProcSession.instance().getConnection();
            tempClob = CLOB.createTemporary((Connection)conn, (boolean)true, (int)10);
        }
        Writer writer = tempClob.getCharacterOutputStream();
        try {
            writer.write(string);
            CLOB cLOB = tempClob;
            return cLOB;
        }
        finally {
            writer.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int equals(CLOB b1, CLOB b2) throws Exception {
        if (b1 == null) return 0;
        if (b2 == null) {
            return 0;
        }
        if (b1.equals((Object)b2)) {
            return 1;
        }
        Reader reader1 = b1.getCharacterStream();
        try {
            Reader reader2 = b2.getCharacterStream();
            try {
                int readCount1;
                int bufferSize = Math.max(b1.getBufferSize(), b2.getBufferSize());
                char[] buffer1 = new char[bufferSize];
                char[] buffer2 = new char[bufferSize];
                do {
                    int readCount2;
                    if ((readCount1 = reader1.read(buffer1)) != (readCount2 = reader2.read(buffer2))) {
                        int n = 0;
                        return n;
                    }
                    if (readCount1 != -1) continue;
                    int n = 1;
                    return n;
                } while (JCFunctionsClob.compare(buffer1, buffer2, readCount1));
                int n = 0;
                return n;
            }
            finally {
                reader2.close();
            }
        }
        finally {
            reader1.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String tableName, String columnName, String structure, int id) throws Exception {
        String sql = "select " + columnName + " from " + tableName + " where cd_id = ? for update";
        PreparedStatement psSelect = JavaStoredProcSession.instance().prepareStatement(sql);
        try {
            psSelect.setInt(1, id);
            ResultSet rs = psSelect.executeQuery();
            rs.next();
            JCFunctionsClob.writeStructureToClob(rs, structure);
        }
        finally {
            JavaStoredProcSession.instance().close(null, psSelect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean update(String tableName, String columnName, String newStruct, int id) throws Exception {
        StringBuffer sqlBuffer = new StringBuffer("SELECT " + columnName + " FROM ").append(tableName).append(" WHERE cd_id = ? FOR UPDATE");
        PreparedStatement ps1 = JavaStoredProcSession.instance().prepareStatement(sqlBuffer.toString());
        try {
            ps1.setInt(1, id);
            ResultSet rs = ps1.executeQuery();
            if (!rs.next()) {
                JFunctions.trace("No such cd_id: " + id);
                boolean bl = false;
                return bl;
            }
            JCFunctionsClob.writeStructureToClob(rs, newStruct);
            boolean bl = true;
            return bl;
        }
        finally {
            JavaStoredProcSession.instance().close(null, ps1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeStructureToClob(ResultSet rs, String structure) throws Exception {
        CLOB oraClob = (CLOB)rs.getClob(1);
        Writer writer = oraClob.getCharacterOutputStream();
        try {
            writer.write(structure);
        }
        finally {
            writer.close();
        }
    }

    public static boolean compare(char[] b1, char[] b2, int length) {
        for (int ix = 0; ix < length; ++ix) {
            if (b1[ix] == b2[ix]) continue;
            return false;
        }
        return true;
    }

    public static void freeTemporary(CLOB blob) throws Exception {
        CLOB.freeTemporary((CLOB)blob);
    }

    public static void trace(String msg) throws SQLException {
        JFunctions.trace(msg);
    }

    public static int isInsertable(CLOB structure, String schemaName, String tableName, String columnName) throws Exception {
        return JCartDml.isInsertable(JCFunctionsClob.clobToString(structure), schemaName, tableName, columnName);
    }
}

