/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge;

import chemaxon.jchem.cartridge.Debug;
import chemaxon.jchem.cartridge.JCFunctionsBlob;
import chemaxon.jchem.cartridge.JCFunctionsClob;
import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.dml.UpdateLogProcessor;
import chemaxon.jchem.cartridge.jcservcli.LocalPerfectSearchResult;
import chemaxon.jchem.cartridge.jctable.ColumnTypeHandler;
import chemaxon.jchem.cartridge.oresident.JavaStoredProcExceptionHandler;
import chemaxon.jchem.cartridge.oresident.JccConfigConstants;
import chemaxon.jchem.cartridge.oresident.dml.MarkushIndexTableDml;
import chemaxon.jchem.cartridge.oresident.util.CxOptions;
import chemaxon.jchem.cartridge.rmi.Dml;
import chemaxon.jchem.cartridge.rmi.DuplicateStructureException;
import chemaxon.jchem.cartridge.rmi.StructureFormatException;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.structs.MdMetaDataSupport;
import chemaxon.jchem.cartridge.tunnel.InsertFpReqData;
import chemaxon.jchem.cartridge.tunnel.InsertReqData;
import chemaxon.jchem.cartridge.tunnel.InsertRespData;
import chemaxon.jchem.cartridge.tunnel.MdMetaData;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class JCartDml
implements Debug {
    private static JCartLogger logger = JCartLogger.getLogger(JCartDml.class);
    public static final int DML_TYPE_INSERT = 0;
    public static final int DML_TYPE_UPDATE = 1;
    public static final int DML_TYPE_DELETE = 2;
    private static Hashtable cdStructColTypeCache = new Hashtable();
    private static InsertReqData requestData = new InsertReqData();
    private static InsertFpReqData fpRequestData = new InsertFpReqData();
    static InsertRespData responseData = new InsertRespData();
    private static UpdateLogProcessor updateLogProcessor = new UpdateLogProcessor();

    private JCartDml() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCdStructColType(JCartIndexDescriptor idxDescriptor) throws Exception {
        String idxTableQName = idxDescriptor.getIdxTableQName();
        Integer t = (Integer)cdStructColTypeCache.get(idxTableQName);
        if (t == null) {
            ResultSet rset = null;
            PreparedStatement pstmt = JavaStoredProcSession.instance().prepareStatement("select cd_structure from " + idxTableQName);
            try {
                rset = pstmt.executeQuery();
                t = new Integer(rset.getMetaData().getColumnType(1));
                cdStructColTypeCache.put(idxTableQName, t);
            }
            finally {
                JavaStoredProcSession.instance().close(rset, pstmt);
            }
        }
        return t;
    }

    public static void clearCdStructColTypeCache() {
        cdStructColTypeCache.clear();
    }

    public static void delCdStructColTypeCacheEntry(String tableName) {
        cdStructColTypeCache.remove(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int perfectSearchForDuplicate(JCartIndexDescriptor idxDescriptor, int cdIdToUpdate) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("requestData.structure=" + JCartDml.requestData.structure);
            logger.debug("responseData.structure=" + JCartDml.responseData.structure);
            logger.debug("responseData.smilesOrSmarts=" + JCartDml.responseData.smilesOrSmarts);
        }
        if (!idxDescriptor.isQueryIndex() && (JCartDml.responseData.structure == null || JFunctions.isEmptyMol(JCartDml.responseData.smilesOrSmarts))) {
            return -1;
        }
        LocalPerfectSearchResult perfectScanResult = new LocalPerfectSearchResult(idxDescriptor, JCartDml.responseData.structure, JCartDml.responseData.smilesOrSmarts, 1, JCartDml.responseData.genericTautomer, null, JCartDml.responseData.hashCode);
        try {
            int[] res = perfectScanResult.getNextHits();
            while (res != null) {
                for (int ix = 0; ix < res.length; ++ix) {
                    if (res[ix] == cdIdToUpdate) continue;
                    int n = res[ix];
                    return n;
                }
                res = perfectScanResult.getNextHits();
            }
        }
        finally {
            perfectScanResult.dispose();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String perfectSearchForDuplicate(JCartIndexDescriptor idxDescriptor, String rowidToUpdate) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("requestData.structure=" + JCartDml.requestData.structure);
            logger.debug("responseData.structure=" + JCartDml.responseData.structure);
            logger.debug("responseData.smilesOrSmarts=" + JCartDml.responseData.smilesOrSmarts);
        }
        if (!idxDescriptor.isQueryIndex() && (JCartDml.responseData.structure == null || JFunctions.isEmptyMol(JCartDml.responseData.smilesOrSmarts))) {
            return null;
        }
        LocalPerfectSearchResult perfectScanResult = new LocalPerfectSearchResult(idxDescriptor, JCartDml.responseData.structure, JCartDml.responseData.smilesOrSmarts, 1, JCartDml.responseData.genericTautomer, null, JCartDml.responseData.hashCode);
        try {
            int[] res = perfectScanResult.getNextHits();
            while (res != null) {
                for (int ix = 0; ix < res.length; ++ix) {
                    String duplicateRowid = JCartDml.getRowidForCdId(idxDescriptor, res[ix]);
                    if (rowidToUpdate != null && duplicateRowid.equals(rowidToUpdate)) continue;
                    String string = duplicateRowid;
                    return string;
                }
                res = perfectScanResult.getNextHits();
            }
        }
        finally {
            perfectScanResult.dispose();
        }
        return null;
    }

    private static String getInternalStructPlaceHolder(JCartIndexDescriptor idxDescriptor) throws Exception {
        String internalStructPlaceHolder = "?";
        if (responseData == null) {
            return internalStructPlaceHolder;
        }
        if (idxDescriptor.isQueryIndex()) {
            if (JCartDml.responseData.smilesOrSmarts != null && JCartDml.responseData.smilesOrSmarts.length() > 4000) {
                internalStructPlaceHolder = "empty_blob()";
            }
        } else {
            JCartDml.responseData.smilesOrSmarts = JCartDml.checkSmiles(JCartDml.responseData.smilesOrSmarts, idxDescriptor.getIdxTableQName());
        }
        return internalStructPlaceHolder;
    }

    private static String getInternalStructColName(JCartIndexDescriptor idxDescriptor) throws Exception {
        String internalStructColName = "cd_smiles";
        if (idxDescriptor.isQueryIndex()) {
            internalStructColName = "cd_smarts";
        }
        return internalStructColName;
    }

    private static void setInternalStructValue(JCartIndexDescriptor idxDescriptor, PreparedStatement ps, int paramIdx) throws Exception {
        if (idxDescriptor.isQueryIndex()) {
            ps.setBytes(paramIdx, JFunctions.encodeDbString(JCartDml.responseData.smilesOrSmarts));
        } else {
            ps.setString(paramIdx, JCartDml.responseData.smilesOrSmarts);
        }
    }

    public static String insertMolIntoIndexTable(String str, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, String rid) throws Exception {
        try {
            JCartIndexDescriptor idxDescriptor = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, colName);
            if (idxDescriptor.isJChemTable()) {
                return null;
            }
            JCartDml.insertMolIntoIndexTable(str, idxDescriptor, rid);
            return null;
        }
        catch (Exception exception) {
            return JavaStoredProcExceptionHandler.handleTopLevelError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void insertMolIntoIndexTable(String str, JCartIndexDescriptor idxDescriptor, String rid) throws Exception {
        if (idxDescriptor.isJChemTable()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("insertMolIntoIndexTable: Processing str='" + str + "'");
        }
        responseData.reset();
        if (idxDescriptor.getIdxSubType() == 1) {
            if (str == null) {
                responseData = new InsertRespData();
                int numOfBits = idxDescriptor.getFingerPrintProps()[0];
                JCartDml.responseData.fps = new int[numOfBits / 32];
            } else {
                JCartDml.fpRequestData.fpAsBitString = str;
                responseData = JCartDml.getDml().createInsertData(fpRequestData);
            }
        } else {
            requestData.reset();
            JCartDml.requestData.structure = str;
            JCartDml.requestData.haltOnBadFormat = true;
            JCartDml.fillInCommonRequestData(idxDescriptor, requestData);
            if (JFunctions.mayBeLobSeed(str)) {
                responseData.setFpsEmpty(requestData);
            } else {
                responseData = JCartDml.getMolProps(idxDescriptor, requestData);
            }
            JCartDml.duplicateFilteringMaybe(idxDescriptor, null);
        }
        if (idxDescriptor.isMarkushIndex()) {
            MarkushIndexTableDml dml = new MarkushIndexTableDml(JavaStoredProcSession.instance(), idxDescriptor);
            int cdId = dml.insert(responseData, rid);
            JCartDml.storeUpdate(idxDescriptor, (byte)4, cdId);
            return;
        }
        int cdId = JCartDml.getNextFreeCdId(idxDescriptor);
        String internalStructPlaceHolder = JCartDml.getInternalStructPlaceHolder(idxDescriptor);
        String internalStructColName = JCartDml.getInternalStructColName(idxDescriptor);
        StringBuffer colList = new StringBuffer();
        colList.append("cd_id, rid, ").append(internalStructColName).append(", cd_formula, cd_sortable_formula, cd_molweight, ").append("cd_hash, cd_flags");
        for (int i = 0; i < JCartDml.responseData.fps.length; ++i) {
            colList.append(", cd_fp" + (i + 1));
        }
        JCartDml.addColumnNamesToColumnList(JCartDml.responseData.ctColNamesAndValues, colList);
        StringBuffer stmt_buf = new StringBuffer();
        stmt_buf.append("INSERT INTO ").append(idxDescriptor.getIdxTableQName()).append(" (").append(colList.toString()).append(") VALUES(?,");
        int molPropCount = 7 + JCartDml.responseData.fps.length;
        for (int i = 0; i < molPropCount; ++i) {
            if (i > 0) {
                stmt_buf.append(",");
            }
            if (i == 1) {
                stmt_buf.append(internalStructPlaceHolder);
                continue;
            }
            stmt_buf.append(" ?");
        }
        JCartDml.addPlaceHoldersToValueList(JCartDml.responseData.ctColNamesAndValues, stmt_buf);
        stmt_buf.append(")");
        PreparedStatement ps = JavaStoredProcSession.instance().prepareStatement(stmt_buf.toString());
        try {
            int paramIdx = 1;
            ps.setInt(paramIdx, cdId);
            ps.setString(++paramIdx, rid);
            ++paramIdx;
            if (internalStructPlaceHolder.equals("?")) {
                JCartDml.setInternalStructValue(idxDescriptor, ps, paramIdx);
                ++paramIdx;
            }
            ps.setString(paramIdx, JCartDml.responseData.formula);
            ps.setString(++paramIdx, null);
            ++paramIdx;
            if (JCartDml.responseData.mass == null) {
                ps.setNull(paramIdx, 6);
            } else {
                ps.setFloat(paramIdx, JCartDml.responseData.mass.floatValue());
            }
            ps.setInt(++paramIdx, JCartDml.responseData.hashCode);
            String flags = JCartDml.responseData.flags;
            ps.setString(++paramIdx, flags);
            ++paramIdx;
            for (int ix = 0; ix < JCartDml.responseData.fps.length; ++ix) {
                ps.setInt(paramIdx, JCartDml.responseData.fps[ix]);
                ++paramIdx;
            }
            paramIdx = JCartDml.setColValuesOnPstmt(idxDescriptor, JCartDml.responseData.ctColNamesAndValues, ps, paramIdx);
            ps.executeUpdate();
            if (!internalStructPlaceHolder.equals("?")) {
                JCartDml.updateInternalStructBlob(idxDescriptor, cdId);
            }
        }
        finally {
            JavaStoredProcSession.instance().close(null, ps);
            ps = null;
        }
        JCartDml.insertMds(idxDescriptor, cdId);
        JCartDml.updateMds(idxDescriptor, null, cdId);
        JCartDml.storeUpdate(idxDescriptor, (byte)4, cdId);
    }

    private static void updateInternalStructBlob(JCartIndexDescriptor idxDescriptor, int cdId) throws UnsupportedEncodingException, Exception {
        if (idxDescriptor.isQueryIndex()) {
            JCFunctionsBlob.loadBlobContent(idxDescriptor.getIdxTableQName(), "cd_smarts", JCartDml.responseData.smilesOrSmarts.getBytes("US-ASCII"), cdId);
        }
    }

    private static void updateInternalStructBlob(JCartIndexDescriptor idxDescriptor, String rowid) throws UnsupportedEncodingException, Exception {
        if (idxDescriptor.isQueryIndex()) {
            JCFunctionsBlob.loadBlobContent(idxDescriptor.getIdxTableQName(), "cd_smarts", JCartDml.responseData.smilesOrSmarts.getBytes("US-ASCII"), rowid);
        }
    }

    private static void perfectSearchForIdxTable(JCartIndexDescriptor idxDescriptor, String rowidToUpdate) throws Exception {
        String dupRowid;
        if (logger.isDebugEnabled()) {
            logger.debug("perfectSearchForIdxTable(...): BEGIN");
        }
        if ((dupRowid = JCartDml.perfectSearchForDuplicate(idxDescriptor, rowidToUpdate)) != null) {
            throw JCartDml.createDupStructExceptionRowid(dupRowid);
        }
    }

    public static Exception createDupStructExceptionRowid(String firstRowid) {
        return new DuplicateStructureException(MessageFormat.format("Structure is a duplicate of structure with {0}", "ROWID " + firstRowid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRowidForCdId(JCartIndexDescriptor idxDescriptor, int cdId) throws Exception {
        String string;
        String sql = "select rid from " + idxDescriptor.getIdxTableQName() + " where cd_id = ?";
        ResultSet rs = null;
        PreparedStatement pstmt = JavaStoredProcSession.instance().prepareStatement(sql);
        try {
            pstmt.setInt(1, cdId);
            rs = pstmt.executeQuery();
            rs.next();
            string = rs.getString(1);
        }
        catch (Throwable throwable) {
            JavaStoredProcSession.instance().close(rs, pstmt);
            throw throwable;
        }
        JavaStoredProcSession.instance().close(rs, pstmt);
        return string;
    }

    public static ARRAY insertMol(String str, String tableName, String jcptName, String dupChk, String hod, String options) throws Exception {
        try {
            return JCartDml.insertMolUc(str, tableName, jcptName, dupChk, hod, options);
        }
        catch (Exception e) {
            JavaStoredProcExceptionHandler.handleTopLevelError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ARRAY insertMolUc(String str, String tableName, String jcptName, String dupChk, String hod, String options) throws Exception {
        int[] cdIdArray;
        ArrayDescriptor arraydesc;
        Connection conn;
        JCartIndexDescriptor idxDescriptor;
        block25: {
            boolean duplicateFiltering;
            boolean haltOnBadFormat;
            block24: {
                ResultSet rset;
                PreparedStatement ps;
                block23: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("insertMol: str=" + str + ", tableName=" + tableName + ", jcptName=" + jcptName + ", dupChk=" + dupChk + ", hod=" + hod + ", options=" + options);
                    }
                    idxDescriptor = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), tableName, jcptName);
                    requestData.reset();
                    JCartDml.requestData.structure = str;
                    responseData.reset();
                    if (!JcMetaDataFunctions.getJspInstance().tableExists(idxDescriptor.getIdxTableQName())) {
                        throw new IllegalArgumentException("Table '" + idxDescriptor.getIdxTableQName() + "' does not exists");
                    }
                    JFunctions.checkTableVersion(JavaStoredProcSession.instance(), idxDescriptor.getJcptName(), idxDescriptor.getIdxTableQName());
                    String installSchema = JavaStoredProcSession.instance().getJccOwner();
                    conn = JavaStoredProcSession.instance().getConnection();
                    arraydesc = ArrayDescriptor.createDescriptor((String)(installSchema + ".CD_ID_ARRAY"), (Connection)conn);
                    cdIdArray = null;
                    String[] allowedOptions = new String[]{"flags", "haltOnBadFormat", "userDefColMap"};
                    CxOptions jcOptions = new CxOptions(allowedOptions, options);
                    String flags = jcOptions.getStringValue("flags");
                    haltOnBadFormat = jcOptions.getBoolValue("haltOnBadFormat", true);
                    String userDefColMapString = jcOptions.getStringValue("userDefColMap");
                    JCartDml.fillInCommonRequestData(idxDescriptor, requestData);
                    JCartDml.requestData.structure = str;
                    JCartDml.requestData.haltOnBadFormat = haltOnBadFormat;
                    JCartDml.requestData.userDefinedColMap = userDefColMapString;
                    JCartDml.requestData.flags = flags;
                    boolean bl = duplicateFiltering = dupChk != null && dupChk.equalsIgnoreCase("TRUE") || idxDescriptor.getBooleanJChemProperty("duplicateFiltering");
                    if (logger.isDebugEnabled()) {
                        logger.debug("duplicateFiltering=" + duplicateFiltering);
                    }
                    if (str == null || !str.toUpperCase().startsWith("SELECT")) break block24;
                    int ARRAY_SIZE = 4096;
                    ArrayList<int[]> arrayList = null;
                    int[] intArray = null;
                    int arrayIx = 0;
                    ps = null;
                    rset = null;
                    try {
                        ps = JavaStoredProcSession.instance().prepareStatement(str);
                        if (duplicateFiltering) {
                            rset = ps.executeQuery();
                            try {
                                ResultSetMetaData rsmd = rset.getMetaData();
                                if (rsmd.getColumnCount() > 1) {
                                    throw new RuntimeException("The select statement defined at the first parameter of the insert_mol procedure should contain only the structure column.");
                                }
                                arrayList = new ArrayList<int[]>();
                                intArray = new int[4096];
                                arrayIx = 0;
                                while (rset.next()) {
                                    byte[] bytes = JFunctions.readBytes(rset, 1);
                                    String structure = null;
                                    if (bytes != null) {
                                        structure = new String(bytes, "ASCII");
                                    }
                                    boolean mayBeLobSeed = JFunctions.mayBeLobSeed(structure);
                                    try {
                                        responseData.reset();
                                        if (mayBeLobSeed) {
                                            responseData.setFpsEmpty(requestData);
                                        } else {
                                            JCartDml.requestData.structure = structure;
                                            responseData = JCartDml.getMolProps(idxDescriptor, requestData);
                                        }
                                    }
                                    catch (Exception e) {
                                        if (JavaStoredProcExceptionHandler.getFirstCauseOfType(e, StructureFormatException.class) != null) {
                                            if (!haltOnBadFormat) continue;
                                            throw e;
                                        }
                                        throw e;
                                    }
                                    int cdId = JCartDml.insertSingleMol(idxDescriptor, duplicateFiltering && !mayBeLobSeed, hod);
                                    if (arrayIx == 4096) {
                                        arrayList.add(intArray);
                                        intArray = new int[4096];
                                        arrayIx = 0;
                                    }
                                    intArray[arrayIx++] = cdId;
                                }
                            }
                            finally {
                                JavaStoredProcSession.instance().close(rset, ps);
                                rset = null;
                                ps = null;
                            }
                            int fullArrayCount = arrayList.size();
                            cdIdArray = new int[fullArrayCount * 4096 + arrayIx];
                            for (int ix = 0; ix < fullArrayCount; ++ix) {
                                int[] source = (int[])arrayList.get(ix);
                                System.arraycopy(source, 0, cdIdArray, ix * 4096, 4096);
                            }
                            System.arraycopy(intArray, 0, cdIdArray, fullArrayCount * 4096, arrayIx);
                            break block23;
                        }
                        cdIdArray = JCartDml.insertMolPropsInBatch(idxDescriptor, ps, flags);
                    }
                    catch (Throwable throwable) {
                        JavaStoredProcSession.instance().close(rset, ps);
                        throw throwable;
                    }
                }
                JavaStoredProcSession.instance().close(rset, ps);
                break block25;
            }
            if (!haltOnBadFormat) {
                throw new IllegalArgumentException("Will always abort on badly formatted structures when inserted one-by-one.");
            }
            cdIdArray = JCartDml.insertMolMulti(idxDescriptor, str, idxDescriptor.getJcptName(), duplicateFiltering, hod);
        }
        if (cdIdArray.length == 1) {
            JCartDml.storeUpdate(idxDescriptor, (byte)4, cdIdArray[0]);
        } else {
            JCartDml.storeUpdate(idxDescriptor, (byte)5, 0);
        }
        ARRAY a = new ARRAY(arraydesc, conn, (Object)cdIdArray);
        return a;
    }

    public static int[] insertMolMulti(JCartIndexDescriptor idxDescriptor, String structure, String jcptName, boolean duplicateFiltering, String hod) throws Exception {
        int[] cdIdArray = null;
        responseData.reset();
        boolean mayBeLobSeed = JFunctions.mayBeLobSeed(structure);
        if (mayBeLobSeed) {
            duplicateFiltering = false;
            responseData.setFpsEmpty(requestData);
            return new int[]{JCartDml.insertSingleMol(idxDescriptor, duplicateFiltering, hod)};
        }
        InsertRespData[][] holder = new InsertRespData[1][];
        JCartDml.getMolProps(idxDescriptor, requestData, holder);
        InsertRespData[] resp = holder[0];
        cdIdArray = new int[resp.length];
        for (int i = 0; i < resp.length; ++i) {
            responseData = resp[i];
            cdIdArray[i] = JCartDml.insertSingleMol(idxDescriptor, duplicateFiltering, hod);
        }
        return cdIdArray;
    }

    public static int insertSingleMol(JCartIndexDescriptor idxDescriptor, boolean duplicateFiltering, String hod) throws Exception {
        int dupId;
        if (logger.isDebugEnabled()) {
            logger.debug("insertSingleMol: smiles=" + JCartDml.responseData.smilesOrSmarts + ", duplicateFiltering=" + duplicateFiltering + ", hod=" + hod);
        }
        if (duplicateFiltering && (dupId = JCartDml.perfectSearchForDuplicate(idxDescriptor, -1)) > -1) {
            String message = MessageFormat.format("Structure is a duplicate of structure with {0}", "cd_id " + dupId);
            if (hod != null && hod.compareToIgnoreCase("TRUE") == 0) {
                throw new DuplicateStructureException(message);
            }
            JFunctions.trace(message);
            return -1 * dupId;
        }
        int i = JCartDml.insertMolIntoJCTable(idxDescriptor);
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextFreeCdId(JCartIndexDescriptor idxDescriptor) throws SQLException {
        int cdId = -1;
        StringBuffer buffer = new StringBuffer("SELECT ");
        buffer.append(idxDescriptor.getIdxTableQName()).append("_SQ.nextval FROM dual");
        String sql = buffer.toString();
        PreparedStatement ps = JavaStoredProcSession.instance().prepareStatement(sql);
        ResultSet rset = null;
        try {
            rset = ps.executeQuery();
            rset.next();
            int n = rset.getInt(1);
            return n;
        }
        finally {
            JavaStoredProcSession.instance().close(rset, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCdIdFromRowid(JCartIndexDescriptor idxDescriptor, String rowid) throws SQLException {
        int cdId = -1;
        ResultSet rset = null;
        PreparedStatement ps = JavaStoredProcSession.instance().prepareStatementNoCache("SELECT cd_id FROM " + idxDescriptor.getIdxTableQName() + " WHERE rid = ?");
        try {
            ps.setString(1, rowid);
            rset = ps.executeQuery();
            rset.next();
            int n = rset.getInt(1);
            return n;
        }
        finally {
            ps.close();
        }
    }

    public static int insertMolIntoJCTable(JCartIndexDescriptor idxDescriptor) throws Exception {
        if (idxDescriptor.isMarkushIndex()) {
            MarkushIndexTableDml dml = new MarkushIndexTableDml(JavaStoredProcSession.instance(), idxDescriptor);
            int cdId = dml.insert(responseData, "Unused");
            JCartDml.storeUpdate(idxDescriptor, (byte)4, cdId);
            return 0;
        }
        PreparedStatement ps = null;
        Object rs = null;
        int cdStructColType = JCartDml.getCdStructColType(idxDescriptor);
        if (logger.isDebugEnabled()) {
            StringBuffer logBuffer = new StringBuffer("insertMolIntoJCTable(...): ");
            logBuffer.append("qualifTblName=");
            logBuffer.append(idxDescriptor.getIdxTableQName());
            logBuffer.append(", flags=").append(responseData);
            logger.debug(logBuffer.toString());
        }
        byte[] cdStructureBytes = null;
        if (JCartDml.responseData.structure != null) {
            cdStructureBytes = JCartDml.responseData.structure.getBytes("ASCII");
        }
        int cdId = JCartDml.getNextFreeCdId(idxDescriptor);
        String internalStructPlaceHolder = JCartDml.getInternalStructPlaceHolder(idxDescriptor);
        String internalStructColName = JCartDml.getInternalStructColName(idxDescriptor);
        StringBuffer colList = new StringBuffer();
        colList.append("cd_id, cd_structure, " + internalStructColName + ", ").append("cd_formula, cd_molweight, cd_hash, ").append("cd_flags, cd_timestamp");
        for (int i = 0; i < JCartDml.responseData.fps.length; ++i) {
            colList.append(", cd_fp" + (i + 1));
        }
        JCartDml.addColumnNamesToColumnList(JCartDml.responseData.xColNamesAndValues, colList);
        JCartDml.addColumnNamesToColumnList(JCartDml.responseData.ctColNamesAndValues, colList);
        String qTableName = idxDescriptor.getIdxTableQName();
        StringBuffer sbuf = new StringBuffer("INSERT INTO ");
        sbuf.append(qTableName).append(" (").append(colList.toString()).append(") ");
        if (cdStructColType == 2005 && cdStructureBytes != null) {
            sbuf.append(" VALUES(?, empty_clob(), ");
        } else if (cdStructColType == 2004 && cdStructureBytes != null) {
            sbuf.append(" VALUES(?, empty_blob(), ");
        } else {
            sbuf.append(" VALUES(?, ?, ");
        }
        sbuf.append(internalStructPlaceHolder);
        sbuf.append(", ?, ?, ?, ?, SYSDATE");
        for (int i = 0; i < JCartDml.responseData.fps.length; ++i) {
            sbuf.append(", ?");
        }
        JCartDml.addPlaceHoldersToValueList(JCartDml.responseData.xColNamesAndValues, sbuf);
        JCartDml.addPlaceHoldersToValueList(JCartDml.responseData.ctColNamesAndValues, sbuf);
        sbuf.append(")");
        ps = JavaStoredProcSession.instance().prepareStatement(sbuf.toString());
        try {
            int paramIdx = 1;
            ps.setInt(paramIdx, cdId);
            ++paramIdx;
            if (cdStructureBytes == null) {
                ps.setBytes(paramIdx++, JccConfigConstants.EMPTY_STRUCTURE_AS_BYTES);
            } else {
                switch (cdStructColType) {
                    case 1: 
                    case 12: {
                        ps.setString(paramIdx++, JCartDml.responseData.structure);
                        break;
                    }
                    default: {
                        if (cdStructColType == 2005 || cdStructColType == 2004) break;
                        if (cdStructureBytes.length > 2000) {
                            ByteArrayInputStream bais = new ByteArrayInputStream(cdStructureBytes);
                            ps.setBinaryStream(paramIdx++, (InputStream)bais, cdStructureBytes.length);
                            break;
                        }
                        ps.setBytes(paramIdx++, cdStructureBytes);
                    }
                }
                if (internalStructPlaceHolder.equals("?")) {
                    JCartDml.setInternalStructValue(idxDescriptor, ps, paramIdx);
                    ++paramIdx;
                }
                String cdFormula = JCartDml.responseData.formula;
                ps.setString(paramIdx, cdFormula);
                ++paramIdx;
                if (JCartDml.responseData.mass == null) {
                    ps.setNull(paramIdx, 6);
                } else {
                    ps.setFloat(paramIdx, JCartDml.responseData.mass.floatValue());
                }
                ps.setInt(++paramIdx, JCartDml.responseData.hashCode);
                ps.setString(++paramIdx, JCartDml.responseData.flags);
                ++paramIdx;
                for (int ix = 0; ix < JCartDml.responseData.fps.length; ++ix) {
                    ps.setInt(paramIdx++, JCartDml.responseData.fps[ix]);
                }
                paramIdx = JCartDml.setColValuesOnPstmt(idxDescriptor, JCartDml.responseData.xColNamesAndValues, ps, paramIdx);
                paramIdx = JCartDml.setColValuesOnPstmt(idxDescriptor, JCartDml.responseData.ctColNamesAndValues, ps, paramIdx);
                ps.executeUpdate();
                switch (cdStructColType) {
                    case 2005: {
                        JCFunctionsClob.insert(qTableName, "cd_structure", JCartDml.responseData.structure, cdId);
                        break;
                    }
                    case 2004: {
                        JCFunctionsBlob.loadBlobContent(qTableName, "cd_structure", cdStructureBytes, cdId);
                    }
                }
                if (!internalStructPlaceHolder.equals("?")) {
                    JCartDml.updateInternalStructBlob(idxDescriptor, cdId);
                }
                JCartDml.insertMds(idxDescriptor, cdId);
            }
        }
        catch (Throwable tbl) {
            tbl.printStackTrace();
            if (tbl instanceof SQLException) {
                JavaStoredProcSession.instance().invalidate(sbuf.toString());
            }
            throw new SQLException(tbl.getMessage() + " for " + JCartDml.responseData.structure + " [Failed statement: `" + sbuf.toString() + "`]");
        }
        finally {
            try {
                JavaStoredProcSession.instance().close(null, ps);
            }
            catch (Throwable tbl1) {
                tbl1.printStackTrace();
            }
        }
        return cdId;
    }

    public static int setColValuesOnPstmt(JCartIndexDescriptor idxDescriptor, String[][] colNamesAndValues, PreparedStatement ps, int paramIdx) throws Exception {
        if (colNamesAndValues != null) {
            String[][] xColNamesAndValues = colNamesAndValues;
            for (int ix = 0; ix < xColNamesAndValues.length; ++ix) {
                String colName = xColNamesAndValues[ix][0];
                String stringValue = xColNamesAndValues[ix][1];
                ColumnTypeHandler.setValue(idxDescriptor.getDbSession(), idxDescriptor.getIdxTableQName(), idxDescriptor.getJcptName(), idxDescriptor.isJChemTable(), colName, stringValue, ps, paramIdx++);
            }
        }
        return paramIdx;
    }

    public static void addPlaceHoldersToValueList(String[][] colNamesAndValues, StringBuffer sbuf) {
        if (colNamesAndValues != null) {
            for (int i = 0; i < colNamesAndValues.length; ++i) {
                sbuf.append(", ?");
            }
        }
    }

    public static void addColumnNamesToColumnList(String[][] colNamesAndValues, StringBuffer colList) {
        if (colNamesAndValues != null) {
            for (int ix = 0; ix < colNamesAndValues.length; ++ix) {
                colList.append(", " + colNamesAndValues[ix][0]);
            }
        }
    }

    public static void insertMds(JCartIndexDescriptor idxDescriptor, int cdId) throws Exception {
        MdMetaData[] mdmda;
        if (logger.isDebugEnabled()) {
            logger.debug("insertMds(" + idxDescriptor + ", " + cdId + "): responseData.mdFps=" + JCartDml.responseData.mdFps);
        }
        if ((mdmda = idxDescriptor.getAllMdMetaData()).length == 0) {
            return;
        }
        if (JCartDml.responseData.mdFps == null) {
            JCartDml.responseData.mdFps = new byte[mdmda.length][];
        }
        if (logger.isDebugEnabled()) {
            logger.debug(JCartDml.responseData.mdFps == null ? "responseData.mdFps=null, " : "responseData.mdFps.length=" + JCartDml.responseData.mdFps.length);
        }
        for (int i = 0; i < mdmda.length; ++i) {
            MdMetaData mdMetaData = mdmda[i];
            String mdName = mdMetaData.name;
            byte[] mdData = JCartDml.responseData.mdFps[i];
            String mdTable = MdMetaDataSupport.getMdTableNameByMdName(idxDescriptor.getAllMdMetaData(), mdName);
            if (logger.isDebugEnabled()) {
                logger.debug("insertMds(...): mdData.length=" + (mdData == null ? "[mdData is null]" : String.valueOf(mdData.length)));
            }
            String sql = "INSERT INTO " + mdTable + " ( CD_ID, MD_DATA ) VALUES(?, empty_blob())";
            if (logger.isDebugEnabled()) {
                logger.debug("insertMds: sql=" + sql);
            }
            PreparedStatement ps = JavaStoredProcSession.instance().prepareStatement(sql);
            try {
                ps.setInt(1, cdId);
                ps.execute();
                continue;
            }
            catch (SQLException sqlException) {
                if (logger.isErrorEnabled()) {
                    logger.error("Failing statement: " + sql);
                }
                throw sqlException;
            }
            finally {
                JavaStoredProcSession.instance().close(null, ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMds(JCartIndexDescriptor idxDescriptor, String rid, int cdId) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("updateMds: responseData=" + responseData);
        }
        if (JCartDml.responseData.mdFps == null) {
            return;
        }
        String cdIdSelector = null;
        cdIdSelector = rid == null ? "?" : "(SELECT cd_id FROM " + idxDescriptor.getIdxTableQName() + " WHERE rid = ?)";
        MdMetaData[] mdmda = idxDescriptor.getAllMdMetaData();
        for (int i = 0; i < mdmda.length; ++i) {
            MdMetaData mdMetaData = mdmda[i];
            String mdName = mdMetaData.name;
            byte[] mdData = JCartDml.responseData.mdFps[i];
            if (mdData == null) continue;
            String mdTable = MdMetaDataSupport.getMdTableNameByMdName(idxDescriptor.getAllMdMetaData(), mdName);
            String sql = "SELECT md_data FROM " + mdTable + " WHERE cd_id = " + cdIdSelector + " FOR UPDATE";
            if (logger.isDebugEnabled()) {
                logger.debug("updateMds: sql=" + sql + ", mdData=" + mdData + ", rid=" + rid + ", cdId=" + cdId);
            }
            PreparedStatement ps = JavaStoredProcSession.instance().prepareStatement(sql);
            try {
                if (rid == null) {
                    ps.setInt(1, cdId);
                } else {
                    ps.setString(1, rid);
                }
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) {
                    if (logger.isWarningEnabled()) {
                        logger.warning("SQL return nothing: " + sql);
                    }
                    return;
                }
                JCFunctionsBlob.writeStructureToBlob(rs, mdData);
                continue;
            }
            finally {
                JavaStoredProcSession.instance().close(null, ps);
            }
        }
    }

    public static void fillInCommonRequestData(JCartIndexDescriptor idxDescriptor, InsertReqData requestData) throws Exception {
        requestData.fingerPrintProps = idxDescriptor.getFingerPrintProps();
        requestData.structuralFpColCount = idxDescriptor.getStructuralFpColCount();
    }

    static InsertRespData getMolProps(JCartIndexDescriptor idxDescriptor, InsertReqData reqData) throws Exception {
        return JCartDml.getMolProps(idxDescriptor, reqData, null);
    }

    public static InsertRespData getMolProps(JCartIndexDescriptor idxDescriptor, InsertReqData reqData, InsertRespData[][] multiMolHolder) throws Exception {
        reqData.userInfo = JavaStoredProcSession.instance().getSessionInfo();
        reqData.tableName = idxDescriptor.getIdxTableQName();
        reqData.isJChemTable = idxDescriptor.isJChemTable();
        reqData.propTableName = idxDescriptor.getJcptName();
        reqData.tableTimeStamp = idxDescriptor.getValidityTimestamp();
        reqData.mdMetaData = idxDescriptor.getAllMdMetaData();
        if (multiMolHolder == null) {
            InsertRespData respData = JCartDml.getDml().createInsertData(reqData);
            if (logger.isDebugEnabled()) {
                logger.debug("reqData.structure=" + reqData.structure);
                logger.debug("respData.structure=" + respData.structure);
                logger.debug("respData.smilesOrSmarts=" + respData.smilesOrSmarts);
                logger.debug("respData.mdFps=" + respData.mdFps);
            }
            return respData;
        }
        InsertRespData[] r = JCartDml.getDml().createMultiInsertData(reqData);
        if (logger.isDebugEnabled()) {
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < r.length; ++i) {
                InsertRespData data = r[i];
                b.append("smiles[").append(i).append("]=").append(data.smilesOrSmarts).append(";");
                logger.debug(b.toString());
            }
        }
        multiMolHolder[0] = r;
        return null;
    }

    private static int[] insertMolPropsInBatch(JCartIndexDescriptor idxDescriptor, PreparedStatement pstmt, String flags) throws Exception {
        int count = 0;
        int[] ia = new int[2];
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            responseData.reset();
            String struct = JFunctions.readString(rs, 1);
            if (JFunctions.mayBeLobSeed(struct)) {
                responseData.setFpsEmpty(requestData);
            } else {
                try {
                    JCartDml.requestData.structure = struct;
                    responseData = JCartDml.getMolProps(idxDescriptor, requestData);
                }
                catch (Exception e) {
                    if (JavaStoredProcExceptionHandler.getFirstCauseOfType(e, StructureFormatException.class) != null) {
                        if (!JCartDml.requestData.haltOnBadFormat) continue;
                        throw e;
                    }
                    throw e;
                }
            }
            int i = JCartDml.insertSingleMol(idxDescriptor, false, "false");
            ia = JCartDml.add(ia, count++, i);
        }
        if (ia.length != count) {
            int[] nia = new int[count];
            System.arraycopy(ia, 0, nia, 0, count);
            ia = nia;
        }
        return ia;
    }

    private static int[] add(int[] ia, int count, int i) {
        if (ia.length == count) {
            int[] nia = new int[ia.length + 4096];
            System.arraycopy(ia, 0, nia, 0, count);
            ia = nia;
        }
        ia[count] = i;
        return ia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getSmilesColLength(String qualifTblName) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        StringBuffer buffer = new StringBuffer("SELECT cd_smiles FROM ");
        buffer.append(qualifTblName).append(" WHERE 1 = 2");
        String sql = buffer.toString();
        pstmt = JavaStoredProcSession.instance().prepareStatement(sql);
        try {
            rs = pstmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int n = rsmd.getColumnDisplaySize(1);
            return n;
        }
        catch (SQLException sqlE) {
            if (sqlE.getErrorCode() == 904) {
                int n = 1000;
                return n;
            }
        }
        finally {
            JavaStoredProcSession.instance().close(rs, pstmt);
        }
        return 1000;
    }

    public static String updateMolIndexTable(String oldValue, String newValue, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, String rid) throws Exception {
        if (oldValue == null && newValue == null) {
            return null;
        }
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return null;
        }
        try {
            JCartIndexDescriptor idesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, colName);
            JCartDml.updateMolIndexTable(newValue, idesc, rid);
            return null;
        }
        catch (Exception exception) {
            return JavaStoredProcExceptionHandler.handleTopLevelError(exception);
        }
    }

    public static void updateMolIndexTable(String newValue, JCartIndexDescriptor idxDescriptor, String rid) throws Exception {
        if (idxDescriptor.isJChemTable()) {
            return;
        }
        responseData.reset();
        if (idxDescriptor.getIdxSubType() == 1) {
            JCartDml.fpRequestData.fpAsBitString = newValue;
            responseData = JCartDml.getDml().createInsertData(fpRequestData);
        } else {
            requestData.reset();
            JCartDml.requestData.structure = newValue;
            JCartDml.fillInCommonRequestData(idxDescriptor, requestData);
            if (JFunctions.mayBeLobSeed(newValue)) {
                responseData.setFpsEmpty(requestData);
            } else {
                responseData = JCartDml.getMolProps(idxDescriptor, requestData);
            }
            JCartDml.duplicateFilteringMaybe(idxDescriptor, rid);
        }
        if (idxDescriptor.isMarkushIndex()) {
            MarkushIndexTableDml dml = new MarkushIndexTableDml(JavaStoredProcSession.instance(), idxDescriptor);
            dml.update(responseData, rid);
            JCartDml.storeUpdate(idxDescriptor, (byte)0, JCartDml.getCdIdFromRowid(idxDescriptor, rid));
            return;
        }
        String internalStructPlaceHolder = JCartDml.getInternalStructPlaceHolder(idxDescriptor);
        String internalStructColName = JCartDml.getInternalStructColName(idxDescriptor);
        StringBuffer stmt_buf = new StringBuffer();
        stmt_buf.append("UPDATE " + idxDescriptor.getIdxTableQName() + " SET " + internalStructColName + " = " + internalStructPlaceHolder + ", cd_formula = ?, cd_molweight = ?, ");
        stmt_buf.append("cd_hash = ?, cd_flags = ?");
        for (int i = 0; i < JCartDml.responseData.fps.length; ++i) {
            stmt_buf.append(", cd_fp" + (i + 1) + " = ?");
        }
        JCartDml.addPlaceHoldersToSetList(JCartDml.responseData.ctColNamesAndValues, stmt_buf);
        stmt_buf.append(" WHERE rid = ?");
        PreparedStatement ps = null;
        ps = JavaStoredProcSession.instance().prepareStatement(stmt_buf.toString());
        try {
            int paramIdx = 1;
            if (internalStructPlaceHolder.equals("?")) {
                JCartDml.setInternalStructValue(idxDescriptor, ps, paramIdx);
                ++paramIdx;
            }
            ps.setString(paramIdx, JCartDml.responseData.formula);
            ++paramIdx;
            if (JCartDml.responseData.mass == null) {
                ps.setNull(paramIdx, 6);
            } else {
                ps.setFloat(paramIdx, JCartDml.responseData.mass.floatValue());
            }
            ps.setInt(++paramIdx, JCartDml.responseData.hashCode);
            String flags = JCartDml.responseData.flags;
            ps.setString(++paramIdx, flags);
            ++paramIdx;
            for (int ix = 0; ix < JCartDml.responseData.fps.length; ++ix) {
                ps.setInt(paramIdx++, JCartDml.responseData.fps[ix]);
            }
            paramIdx = JCartDml.setColValuesOnPstmt(idxDescriptor, JCartDml.responseData.ctColNamesAndValues, ps, paramIdx);
            ps.setString(paramIdx++, rid);
            ps.execute();
            if (!internalStructPlaceHolder.equals("?")) {
                JCartDml.updateInternalStructBlob(idxDescriptor, rid);
            }
            JCartDml.updateMds(idxDescriptor, rid, -1);
        }
        catch (Exception exc) {
            JFunctions.trace("Statement " + stmt_buf + " failed.");
            throw exc;
        }
        finally {
            try {
                JavaStoredProcSession.instance().close(null, ps);
            }
            catch (Exception e) {}
        }
        int cdId = JCartDml.getCdIdFromRowid(idxDescriptor, rid);
        JCartDml.storeUpdate(idxDescriptor, (byte)0, cdId);
    }

    private static void duplicateFilteringMaybe(JCartIndexDescriptor idxDescriptor, String rowidToUpdate) throws Exception {
        boolean dupFilt = JcMetaDataFunctions.getJspInstance().getJChemPropertyForIndex(idxDescriptor.getJcptName(), idxDescriptor.getIdxTableQName(), false, "duplicateFiltering").equalsIgnoreCase("true");
        if (dupFilt) {
            boolean exclusiveDupFilter = JcMetaDataFunctions.getJspInstance().getJChemPropertyForIndex(idxDescriptor.getJcptName(), idxDescriptor.getIdxTableQName(), false, "exclusiveDuplicateFiltering").equalsIgnoreCase("true");
            if (exclusiveDupFilter) {
                JCartDml.dupFilterLock(idxDescriptor);
            }
            JCartDml.perfectSearchForIdxTable(idxDescriptor, rowidToUpdate);
        }
    }

    private static void dupFilterLock(JCartIndexDescriptor idxDescriptor) throws Exception {
        String sql = "select prop_value from " + JcMetaDataFunctions.getJspInstance().getMasterIdxTableName(idxDescriptor.getIndexSchemaName()) + " where prop_name = ? for update";
        String param = null;
        ResultSet rset = null;
        PreparedStatement pstmt = JavaStoredProcSession.instance().prepareStatement(sql);
        try {
            param = idxDescriptor.getIndexSchemaName() + "." + idxDescriptor.getIndexName() + ".idxTable";
            pstmt.setString(1, param);
            rset = pstmt.executeQuery();
        }
        catch (SQLException sqlException) {
            try {
                JFunctions.trace("Failing statement: `" + sql + "` ?1 =" + param);
                throw sqlException;
            }
            catch (Throwable throwable) {
                JavaStoredProcSession.instance().close(rset, pstmt);
                throw throwable;
            }
        }
        JavaStoredProcSession.instance().close(rset, pstmt);
    }

    private static void addPlaceHoldersToSetList(String[][] ctColNamesAndValues, StringBuffer stmt_buf) {
        if (ctColNamesAndValues != null) {
            for (int i = 0; i < ctColNamesAndValues.length; ++i) {
                String[] nv = ctColNamesAndValues[i];
                stmt_buf.append(", ").append(nv[0]).append(" = ?");
            }
        }
    }

    public static int updateMol(String newStr, String tblName, int id, String JCPName, String options) throws Exception {
        return JCartDml.updateMol(newStr, tblName, id, JCPName, options, false);
    }

    public static int updateMol(String newStr, String tableName, int id, String jcpName, String options, boolean blob) throws Exception {
        int dupId;
        JCartIndexDescriptor idxDescriptor = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), tableName, jcpName);
        JFunctions.checkTableVersion(JavaStoredProcSession.instance(), idxDescriptor.getJcptName(), idxDescriptor.getIdxTableQName().toUpperCase());
        requestData.reset();
        JCartDml.requestData.structure = newStr;
        JCartDml.fillInCommonRequestData(idxDescriptor, requestData);
        String[] allowedOptions = new String[]{"flags"};
        CxOptions jcOptions = new CxOptions(allowedOptions, options);
        String flags = jcOptions.getStringValue("flags");
        String hod = jcOptions.getStringValue("haltOnDuplicate");
        responseData.reset();
        if (JFunctions.mayBeLobSeed(newStr)) {
            responseData.setFpsEmpty(requestData);
        } else {
            responseData = JCartDml.getMolProps(idxDescriptor, requestData);
        }
        boolean duplicateFiltering = idxDescriptor.getBooleanJChemProperty("duplicateFiltering");
        if (duplicateFiltering && (dupId = JCartDml.perfectSearchForDuplicate(idxDescriptor, id)) > -1) {
            String message = MessageFormat.format("Structure is a duplicate of structure with {0}", "cd_id " + dupId);
            if (hod == null || hod.compareToIgnoreCase("TRUE") == 0) {
                throw new DuplicateStructureException(message);
            }
            JFunctions.trace(message);
            return -1 * dupId;
        }
        if (idxDescriptor.isMarkushIndex()) {
            MarkushIndexTableDml dml = new MarkushIndexTableDml(JavaStoredProcSession.instance(), idxDescriptor);
            dml.update(responseData, id);
            JCartDml.storeUpdate(idxDescriptor, (byte)0, id);
            return 0;
        }
        String internalStructPlaceHolder = JCartDml.getInternalStructPlaceHolder(idxDescriptor);
        String internalStructColName = JCartDml.getInternalStructColName(idxDescriptor);
        StringBuffer sbuf = new StringBuffer("UPDATE ");
        sbuf.append(idxDescriptor.getIdxTableQName()).append(" SET cd_timestamp = SYSDATE, " + internalStructColName + " = " + internalStructPlaceHolder + ", ");
        int cdStructColType = JCartDml.getCdStructColType(idxDescriptor);
        if (cdStructColType == 2005) {
            sbuf.append(" cd_structure = empty_clob(), ");
        } else if (cdStructColType == 2004) {
            sbuf.append(" cd_structure = empty_blob(), ");
        } else {
            sbuf.append(" cd_structure = ?, ");
        }
        sbuf.append("cd_formula = ?, cd_molweight = ?, ");
        sbuf.append("cd_hash = ?, ");
        sbuf.append("cd_flags = ?");
        int fpCount = JCartDml.responseData.fps.length;
        for (int i = 0; i < fpCount; ++i) {
            sbuf.append(", cd_fp" + (i + 1) + " = ?");
        }
        JCartDml.addPlaceHoldersToSetList(JCartDml.responseData.ctColNamesAndValues, sbuf);
        sbuf.append(" WHERE cd_id = ?");
        PreparedStatement ps = null;
        ps = JavaStoredProcSession.instance().prepareStatement(sbuf.toString());
        try {
            String comprStructure;
            int paramIdx = 1;
            if (internalStructPlaceHolder.equals("?")) {
                JCartDml.setInternalStructValue(idxDescriptor, ps, paramIdx);
                ++paramIdx;
            }
            if ((comprStructure = JCartDml.responseData.structure) != null) {
                newStr = comprStructure;
            }
            byte[] newStructBytes = newStr.getBytes("ASCII");
            switch (cdStructColType) {
                case 1: 
                case 12: {
                    ps.setString(paramIdx++, newStr);
                    break;
                }
                default: {
                    if (cdStructColType == 2005 || cdStructColType == 2004) break;
                    if (newStructBytes.length > 2000) {
                        ByteArrayInputStream bais = new ByteArrayInputStream(newStructBytes);
                        ps.setBinaryStream(paramIdx++, (InputStream)bais, newStructBytes.length);
                        break;
                    }
                    ps.setBytes(paramIdx++, newStructBytes);
                }
            }
            ps.setString(paramIdx, JCartDml.responseData.formula);
            ++paramIdx;
            if (JCartDml.responseData.mass == null) {
                ps.setNull(paramIdx, 6);
            } else {
                ps.setFloat(paramIdx, JCartDml.responseData.mass.floatValue());
            }
            ps.setInt(++paramIdx, JCartDml.responseData.hashCode);
            flags = JCartDml.responseData.flags;
            ps.setString(++paramIdx, flags);
            ++paramIdx;
            for (int ix = 0; ix < JCartDml.responseData.fps.length; ++ix) {
                ps.setInt(paramIdx++, JCartDml.responseData.fps[ix]);
            }
            paramIdx = JCartDml.setColValuesOnPstmt(idxDescriptor, JCartDml.responseData.ctColNamesAndValues, ps, paramIdx);
            ps.setInt(paramIdx++, id);
            ps.executeUpdate();
            switch (cdStructColType) {
                case 2005: {
                    if (JCFunctionsClob.update(idxDescriptor.getIdxTableQName(), "cd_structure", newStr, id)) break;
                    int n = 1;
                    return n;
                }
                case 2004: {
                    if (JCFunctionsBlob.loadBlobContent(idxDescriptor.getIdxTableQName(), "cd_structure", newStructBytes, id)) break;
                    int n = 1;
                    return n;
                }
            }
            if (!internalStructPlaceHolder.equals("?")) {
                JCartDml.updateInternalStructBlob(idxDescriptor, id);
            }
        }
        catch (Exception e) {
            JFunctions.trace("Statement " + sbuf + " failed: newStr=" + newStr + ", tblName=" + idxDescriptor.getIdxTableQName() + ", id=" + id + ", JCPName=" + idxDescriptor.getJcptName());
            if (e instanceof SQLException) {
                JavaStoredProcSession.instance().invalidate(sbuf.toString());
            }
            throw e;
        }
        finally {
            JavaStoredProcSession.instance().close(null, ps);
        }
        JCartDml.storeUpdate(idxDescriptor, (byte)0, id);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteMolFromIndexTable(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String rid) throws Exception {
        JCartIndexDescriptor idxDescriptor = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, null);
        if (idxDescriptor.isJChemTable()) {
            return;
        }
        int cdId = -1;
        PreparedStatement ps = null;
        ResultSet rset = null;
        ps = JavaStoredProcSession.instance().prepareStatementNoCache("SELECT cd_id FROM " + idxDescriptor.getIdxTableQName() + " WHERE rid = ?");
        try {
            ps.setString(1, rid);
            rset = ps.executeQuery();
            if (!rset.next()) {
                return;
            }
            cdId = rset.getInt(1);
        }
        finally {
            ps.close();
        }
        ps = JavaStoredProcSession.instance().prepareStatementNoCache("DELETE FROM " + idxDescriptor.getIdxTableQName() + " WHERE rid = ?");
        try {
            ps.setString(1, rid);
            ps.execute();
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception e) {}
        }
        JCartDml.deleteMds(idxDescriptor, rid);
        JCartDml.storeUpdate(idxDescriptor, (byte)2, cdId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteMds(JCartIndexDescriptor idxDescriptor, String rid) throws Exception {
        if (JCartDml.responseData.mdFps == null) {
            return;
        }
        String subSelect = "SELECT cd_id FROM " + idxDescriptor.getIdxTableQName() + " WHERE rid = ?";
        MdMetaData[] mdmda = idxDescriptor.getAllMdMetaData();
        for (int i = 0; i < mdmda.length; ++i) {
            MdMetaData mdMetaData = mdmda[i];
            String mdName = mdMetaData.name;
            byte[] mdData = JCartDml.responseData.mdFps[i];
            String mdTable = MdMetaDataSupport.getMdTableNameByMdName(idxDescriptor.getAllMdMetaData(), mdName);
            String sql = "DELETE FROM " + mdTable + " WHERE cd_id = (" + subSelect + ")";
            PreparedStatement ps = JavaStoredProcSession.instance().prepareStatement(sql);
            try {
                ps.setString(1, rid);
                ps.execute();
                continue;
            }
            finally {
                JavaStoredProcSession.instance().close(null, ps);
            }
        }
    }

    public static int deleteMol(String tblName, String condition, String jcptName) throws Exception {
        JCartIndexDescriptor idxDescriptor = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), tblName, jcptName);
        JFunctions.checkTableVersion(JavaStoredProcSession.instance(), idxDescriptor.getJcptName(), idxDescriptor.getIdxTableQName().toUpperCase());
        StringBuffer sbuf = new StringBuffer("DELETE " + idxDescriptor.getIdxTableQName() + " " + condition);
        PreparedStatement ps = null;
        ps = JavaStoredProcSession.instance().prepareStatement(sbuf.toString());
        try {
            ps.execute();
        }
        catch (SQLException sqlE) {
            JavaStoredProcSession.instance().invalidate(sbuf.toString());
            if (logger.isErrorEnabled()) {
                logger.error("Failing statement: " + sbuf.toString());
            }
            throw sqlE;
        }
        finally {
            JavaStoredProcSession.instance().close(null, ps);
        }
        JCartDml.storeUpdate(idxDescriptor, (byte)3, -1);
        return 0;
    }

    public static void storeUpdate(JCartIndexDescriptor idxDescriptor, byte updateType, int cdId) throws Exception {
        updateLogProcessor.addLog(JavaStoredProcSession.instance().getConnection(), idxDescriptor, updateType, cdId);
    }

    public static String checkSmiles(String smiles, String qTableName) throws Exception {
        if (smiles != null && smiles.length() > JCartDml.getSmilesColLength(qTableName)) {
            return null;
        }
        return smiles;
    }

    private static Dml getDml() throws Exception {
        return (Dml)RmiDirectory.instance().getServer("DmlServer");
    }

    public static void main(String[] args) throws ParseException {
        byte[][] aa = new byte[1][];
        System.err.println(aa[0] == null);
    }

    public static int isInsertable(String structure, String schemaName, String tableName, String columnName) throws Exception {
        String[] idxTblQName;
        if (logger.isDebugEnabled()) {
            logger.debug("structure=" + structure + ", schemaName=" + schemaName + "tableName=" + tableName);
        }
        DbSession dbSession = JavaStoredProcSession.getCurrent();
        String usedSchemaName = schemaName;
        if (usedSchemaName == null) {
            usedSchemaName = dbSession.getRealUser();
        }
        if ((idxTblQName = JcMetaDataFunctions.getJspInstance().getIdxSchemaAndName(usedSchemaName, tableName, columnName, dbSession.getJccOwner())) == null) {
            throw new IllegalArgumentException("No index defined on table.");
        }
        JCartIndexDescriptor iDesc = JCartIndexDescriptor.get(dbSession, idxTblQName[0], idxTblQName[1], null);
        int tableType = iDesc.getTableType();
        if (JCartDml.getDml().isInsertable(structure, tableType)) {
            return 1;
        }
        return 0;
    }
}

