/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge;

import chemaxon.jchem.cartridge.JCartDml;
import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.resultset.CdIdResultSet;
import chemaxon.jchem.cartridge.resultset.EarlyCdIdResultSet;
import chemaxon.jchem.cartridge.resultset.JCCartResultSet;
import chemaxon.jchem.cartridge.resultset.MultiResultSet;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.InsertReqData;
import chemaxon.jchem.cartridge.tunnel.InsertRespData;
import chemaxon.jchem.cartridge.tunnel.search.SearchInfo;
import chemaxon.jchem.cartridge.util.JCartLogger;

public class JCartSearch {
    private static final JCartLogger logger = JCartLogger.getLogger(JCartSearch.class);

    public static JCCartResultSet perfectSearchInTx(SearchInfo searchInfo, long termTime) throws Exception {
        InsertReqData requestData = new InsertReqData();
        JCartIndexDescriptor idxDescriptor = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), searchInfo.getIndexSchemaName(), searchInfo.getIndexName(), searchInfo.getIndexPartition(), searchInfo.getBaseSchemaName(), searchInfo.getBaseTableName(), searchInfo.getIndexedColumn());
        requestData.reset();
        requestData.structure = searchInfo.getQuery();
        requestData.haltOnBadFormat = true;
        JCartDml.fillInCommonRequestData(idxDescriptor, requestData);
        if (JFunctions.isEmptyMol(searchInfo.getQuery())) {
            return CdIdResultSet.createCdIdResultSet(searchInfo, new byte[0], Long.MAX_VALUE);
        }
        InsertRespData[][] holder = new InsertRespData[1][];
        JCartDml.getMolProps(idxDescriptor, requestData, holder);
        MultiResultSet multiSet = new MultiResultSet();
        InsertRespData[] resp = holder[0];
        for (int i = 0; i < resp.length; ++i) {
            InsertRespData responseData = resp[i];
            multiSet.add(new EarlyCdIdResultSet(searchInfo, requestData.structure, responseData.smilesOrSmarts, Integer.MAX_VALUE, responseData.genericTautomer, termTime, responseData.hashCode));
        }
        return multiSet;
    }
}

