/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.oresident.JccConfigConstants;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class JcMetaDataFunctions
implements JccConfigConstants {
    private static final JCartLogger logger = JCartLogger.getLogger(JcMetaDataFunctions.class);
    private static JcMetaDataFunctions instance;
    public static final String NAME_COLUMN = "prop_name";
    public static final String VALUE_COLUMN = "prop_value";
    public static final String VALUE_COLUMN_EXT = "prop_value_ext";
    private DbSession dbSession;
    private static boolean masterTableStructureChecked;
    public static final String JCPROPTABLE_PREFIX_IDX = "idx";
    public static final String MASTER_METADATATABLE = "JC_IDX_PROPERTY";
    public static final String DEFAULTPROPERTIES_TIMESTAMP_KEY = "defaultProperties.validityTimestamp";

    public JcMetaDataFunctions(DbSession dbSession) {
        this.dbSession = dbSession;
    }

    public static JcMetaDataFunctions getJspInstance() {
        if (instance == null) {
            instance = new JcMetaDataFunctions(JavaStoredProcSession.instance());
        }
        if (!(JcMetaDataFunctions.instance.dbSession instanceof JavaStoredProcSession)) {
            throw new IllegalStateException("dbSession is not JavaStoredProcedureSession");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHostAndInstanceName() throws Exception {
        String[] names = new String[2];
        String sql = "SELECT host_name, instance_name FROM v$instance";
        ResultSet rs = null;
        PreparedStatement pstmt = this.dbSession.prepareStatement(sql);
        try {
            rs = pstmt.executeQuery();
            if (!rs.next() && logger.isWarningEnabled()) {
                logger.warning("\"" + sql + "\" returned no rows.");
            }
            names[0] = rs.getString("host_name");
            names[1] = rs.getString("instance_name");
            if (rs.next() && logger.isWarningEnabled()) {
                logger.warning("Too many Oracle instances");
            }
            String[] stringArray = names;
            return stringArray;
        }
        catch (SQLException sqlException) {
            if (sqlException.getErrorCode() == 942 && logger.isWarningEnabled()) {
                logger.warning("Name of the connected Oracle instance could not be obtained.");
            }
        }
        finally {
            this.dbSession.close(rs, pstmt);
        }
        return null;
    }

    public int getDuplicateFiltering(JCartIndexDescriptor idxDescriptor) throws Exception {
        int duplicateFilteringFlags = 0;
        boolean duplicateFiltering = this.getJChemPropertyForIndex(idxDescriptor.getJcptName(), idxDescriptor.getIdxTableQName(), false, "duplicateFiltering").equalsIgnoreCase("true");
        if (duplicateFiltering) {
            duplicateFilteringFlags |= 1;
        }
        boolean tautomerDuplicateFiltering = this.getJChemPropertyForIndex(idxDescriptor.getJcptName(), idxDescriptor.getIdxTableQName(), false, "tautomerDuplicateFiltering").equalsIgnoreCase("true");
        if (duplicateFiltering && tautomerDuplicateFiltering) {
            duplicateFilteringFlags |= 4;
        }
        boolean exclusiveDuplicateFiltering = this.getJChemPropertyForIndex(idxDescriptor.getJcptName(), idxDescriptor.getIdxTableQName(), false, "exclusiveDuplicateFiltering").equalsIgnoreCase("true");
        if (duplicateFiltering && exclusiveDuplicateFiltering) {
            duplicateFilteringFlags |= 2;
        }
        return duplicateFilteringFlags;
    }

    public String getBaseTableQName(String idxSchema, String idxName) throws Exception {
        String[] bt = this.getBaseTableSchemaAndName(idxSchema, idxName);
        return bt[0] + "." + bt[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getBaseTableSchemaAndName(String idxSchema, String idxName) throws Exception {
        String tblSchema = null;
        String tblName = null;
        PreparedStatement pstmt = this.dbSession.prepareStatement("SELECT table_owner, table_name FROM all_indexes WHERE owner = ? and index_name = ?");
        try {
            pstmt.setString(1, idxSchema);
            pstmt.setString(2, idxName);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new Exception("Index not found: " + idxSchema + "." + idxName);
            }
            tblSchema = rs.getString("table_owner");
            tblName = rs.getString("table_name");
            if (rs.next()) {
                throw new Exception("Found too many index: " + idxSchema + "." + idxName);
            }
            String[] stringArray = new String[]{tblSchema, tblName};
            return stringArray;
        }
        finally {
            this.dbSession.close(null, pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIndexedColName(String idxSchema, String idxName) throws Exception {
        PreparedStatement pstmt = this.dbSession.prepareStatement("SELECT column_name FROM all_ind_columns WHERE index_owner = ? and index_name = ?");
        try {
            pstmt.setString(1, idxSchema);
            pstmt.setString(2, idxName);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new Exception("Index not found: " + idxSchema + "." + idxName);
            }
            String colName = rs.getString("column_name");
            if (rs.next()) {
                throw new Exception("Found too many index: " + idxSchema + "." + idxName);
            }
            String string = colName;
            return string;
        }
        finally {
            this.dbSession.close(null, pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getGlobalJchemProperty(String jc_name, String propName) throws Exception {
        PreparedStatement ps = null;
        ResultSet rset = null;
        String stmt = "SELECT prop_value FROM " + jc_name + " WHERE PROP_NAME = ?";
        ps = this.dbSession.prepareStatement(stmt);
        try {
            ps.setString(1, propName);
            rset = ps.executeQuery();
            if (!rset.next()) {
                String string = null;
                return string;
            }
            String string = rset.getString(1);
            return string;
        }
        catch (Exception ex) {
            String string = null;
            return string;
        }
        finally {
            this.dbSession.close(rset, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMasterTable() throws Exception {
        String stmt = "SELECT count(*) FROM user_tab_columns WHERE table_name = ?";
        ResultSet rset = null;
        PreparedStatement ps = this.dbSession.prepareStatement(stmt);
        int count = -1;
        try {
            ps.setString(1, MASTER_METADATATABLE);
            rset = ps.executeQuery();
            rset.next();
            count = rset.getInt(1);
        }
        finally {
            this.dbSession.close(rset, ps);
        }
        if (count != 0 && count != 3) {
            String errMsg = "The structure of the master metadata table 'JC_IDX_PROPERTY' is incompatible with this version of JChem Cartridge. Please, drop all your jc_idxtype indexes (if you have not done so yet) and drop the table 'JC_IDX_PROPERTY'";
            throw new Exception(errMsg);
        }
    }

    public String getPropertyTableName(String idxSchema, String idxName, String idxPartition) throws Exception {
        String string;
        String idxQName = this.getIdxQName(idxSchema, idxName, idxPartition);
        PreparedStatement ps = null;
        ResultSet rset = null;
        StringBuffer buffer = new StringBuffer("SELECT prop_value FROM ");
        buffer.append(this.getMasterIdxTableName(idxSchema)).append(" WHERE prop_name= ?");
        String sql = buffer.toString();
        String bind1 = null;
        ps = this.dbSession.prepareStatement(sql);
        try {
            buffer = new StringBuffer(idxQName.toUpperCase());
            buffer.append(".JChemProperties");
            bind1 = buffer.toString();
            ps.setString(1, bind1);
            if (logger.isDebugEnabled()) {
                logger.debug("Executing: " + sql + " [bind1=" + bind1 + "]...");
            }
            rset = ps.executeQuery();
            String propTableName = null;
            while (rset.next()) {
                propTableName = rset.getString(1);
            }
            if (propTableName != null && propTableName.indexOf(46) == -1 && !this.tableExists(propTableName) && idxSchema != null) {
                String ptName1 = idxSchema + "." + propTableName;
                if (this.tableExists(ptName1)) {
                    propTableName = ptName1;
                } else {
                    String ptName2 = this.getBaseTableSchemaAndName(idxSchema, idxName)[0] + "." + propTableName;
                    if (this.tableExists(ptName2)) {
                        propTableName = ptName2;
                    } else if (logger.isErrorEnabled()) {
                        logger.error("Potential internal error: " + propTableName + " is registered as JChemProperties table for " + idxSchema + "." + idxName + "." + idxPartition + ", but neither it nor " + ptName1 + " nor " + ptName2 + " exists");
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Returning " + propTableName + " for " + idxSchema + "." + idxName);
            }
            string = propTableName;
        }
        catch (SQLException sqlE) {
            try {
                if (logger.isErrorEnabled()) {
                    logger.error("Failed statement: " + sql + " [bind1=" + bind1 + "]");
                }
                throw sqlE;
            }
            catch (Throwable throwable) {
                this.dbSession.close(rset, ps);
                ps = null;
                throw throwable;
            }
        }
        this.dbSession.close(rset, ps);
        ps = null;
        return string;
    }

    public int getTableType(String jcptName, String idxTblQName, boolean isJChemTable) throws Exception {
        int dfltTableType = 2;
        String value = this.getJChemPropertyForIndex(jcptName, idxTblQName, isJChemTable, "tableType");
        if (value == null) {
            return dfltTableType;
        }
        return Integer.parseInt(value);
    }

    public int getIdxSubType(String jcptName, String idxTblQName, boolean isJChemTable) throws Exception {
        int dfltIdxSubtype = 0;
        String value = this.getJChemPropertyForIndex(jcptName, idxTblQName, isJChemTable, "idxSubType");
        if (value == null) {
            return dfltIdxSubtype;
        }
        return Integer.parseInt(value);
    }

    public String getJChemPropertyForIndex(String jcptName, String idxTblQName, boolean isJChemTable, String propertyName) throws Exception {
        return this.getJChemPropertyForIndex(jcptName, idxTblQName, isJChemTable, propertyName, false);
    }

    public String getJChemPropertyForIndex(String jcptName, String idxTblQName, boolean isJChemTable, String propertyName, boolean forUpdate) throws Exception {
        String propertyValue = null;
        ResultSet rset = null;
        idxTblQName = idxTblQName.toUpperCase();
        String jcidxPrefix = "";
        if (!isJChemTable) {
            jcidxPrefix = JCPROPTABLE_PREFIX_IDX;
        }
        StringBuffer buffer = new StringBuffer("SELECT prop_value FROM ");
        buffer.append(jcptName).append(" WHERE prop_name = ?");
        if (forUpdate) {
            buffer.append(" FOR UPDATE");
        }
        String sql = buffer.toString();
        PreparedStatement ps = this.dbSession.prepareStatement(sql);
        buffer = new StringBuffer(jcidxPrefix);
        buffer.append("table.").append(idxTblQName).append(".").append(propertyName);
        if (logger.isDebugEnabled()) {
            logger.debug("Executing: \"" + sql + "\" with ?1=" + buffer.toString());
        }
        ps.setString(1, buffer.toString());
        try {
            String propValue;
            rset = ps.executeQuery();
            if (rset.next()) {
                propValue = rset.getString(VALUE_COLUMN);
                this.dbSession.close(rset, ps);
                rset = null;
                ps = null;
                if (propValue != null) {
                    propertyValue = propValue.trim();
                } else {
                    buffer = new StringBuffer("SELECT prop_value_ext FROM ");
                    buffer.append(jcptName).append(" WHERE prop_name = ? ");
                    sql = buffer.toString();
                    ps = this.dbSession.prepareStatement(sql);
                    buffer = new StringBuffer(jcidxPrefix);
                    buffer.append("table.").append(idxTblQName).append(".").append(propertyName);
                    ps.setString(1, buffer.toString());
                    rset = ps.executeQuery();
                    rset.next();
                    byte[] data = JFunctions.readBytes(rset, VALUE_COLUMN_EXT);
                    if (data != null) {
                        propertyValue = new String(data, "ASCII");
                    }
                }
            } else {
                propertyValue = null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Returning: " + propertyValue);
            }
            propValue = propertyValue;
            return propValue;
        }
        catch (SQLException sqlE) {
            this.dbSession.invalidate(sql);
            if (logger.isErrorEnabled()) {
                logger.error("JFunctions.getJChemPropertyForIndex: failing statment: " + sql + " bind#1: '" + buffer.toString());
            }
            throw sqlE;
        }
        finally {
            this.dbSession.close(rset, ps);
        }
    }

    public boolean jChemPropertyForIndexExists(String jcptName, String idxTblQName, boolean isJChemTable, String propertyName) throws Exception {
        ResultSet rset = null;
        idxTblQName = idxTblQName.toUpperCase();
        String jcidxPrefix = "";
        if (!isJChemTable) {
            jcidxPrefix = JCPROPTABLE_PREFIX_IDX;
        }
        StringBuffer buffer = new StringBuffer("SELECT prop_value FROM ");
        buffer.append(jcptName).append(" WHERE prop_name = ?");
        String sql = buffer.toString();
        PreparedStatement ps = this.dbSession.prepareStatement(sql);
        buffer = new StringBuffer(jcidxPrefix);
        buffer.append("table.").append(idxTblQName).append(".").append(propertyName);
        ps.setString(1, buffer.toString());
        try {
            rset = ps.executeQuery();
            if (rset.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sqlE) {
            if (logger.isErrorEnabled()) {
                logger.error("JFunctions.getJChemPropertyForIndex: failing statment: " + sql);
            }
            throw sqlE;
        }
        finally {
            this.dbSession.close(rset, ps);
        }
    }

    public void setJChemPropertyForIndex(String jcptName, String idxTblQName, boolean isJChemTable, String propertyName, String propertyValue) throws Exception {
        boolean propertyExists;
        idxTblQName = idxTblQName.toUpperCase();
        String jcidxPrefix = JCPROPTABLE_PREFIX_IDX;
        if (isJChemTable) {
            jcidxPrefix = "";
        }
        if (propertyExists = this.jChemPropertyForIndexExists(jcptName, idxTblQName, isJChemTable, propertyName)) {
            this.updateJChemProperty(jcptName, idxTblQName, propertyName, propertyValue, jcidxPrefix);
        } else {
            this.insertJChemProperty(jcptName, idxTblQName, propertyName, propertyValue, jcidxPrefix);
        }
        this.updateJChemProperty(jcptName, idxTblQName, "validityTimestamp", new Timestamp(System.currentTimeMillis()).toString(), jcidxPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJChemProperty(String jcptName, String idxTblQName, String propertyName, String propertyValue, String jcidxPrefix) throws Exception {
        boolean extended = false;
        if (propertyValue.length() > 200) {
            extended = true;
        }
        StringBuffer buffer = new StringBuffer("UPDATE ");
        buffer.append(jcptName).append(" SET prop_value = ?, prop_value_ext = ? WHERE prop_name = ? ");
        String sql = buffer.toString();
        PreparedStatement ps = null;
        ps = this.dbSession.prepareStatement(sql);
        buffer = new StringBuffer(jcidxPrefix).append("table.").append(idxTblQName.toUpperCase()).append(".").append(propertyName);
        String pName = buffer.toString();
        try {
            if (extended) {
                ps.setString(1, null);
                byte[] bytes = propertyValue.getBytes("ASCII");
                if (bytes.length > 2000) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    ps.setBinaryStream(2, (InputStream)bais, bytes.length);
                } else {
                    ps.setBytes(2, bytes);
                }
            } else {
                ps.setString(1, propertyValue);
                ps.setBytes(2, null);
            }
            ps.setString(3, pName);
            ps.execute();
        }
        finally {
            this.dbSession.close(null, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertJChemProperty(String jcptName, String qualifTblName, String propertyName, String propertyValue, String jcidxPrefix) throws Exception {
        boolean extended = false;
        if (propertyValue.length() > 200) {
            extended = true;
        }
        PreparedStatement ps = null;
        ps = this.dbSession.prepareStatement("INSERT INTO " + jcptName + " VALUES(?, ?, ?)");
        String fullPrefix = "";
        if (jcidxPrefix != null) {
            fullPrefix = jcidxPrefix + "table." + qualifTblName.toUpperCase() + ".";
        }
        try {
            ps.setString(1, fullPrefix + propertyName);
            if (extended) {
                ps.setString(2, null);
                byte[] bytes = propertyValue.getBytes("ASCII");
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                ps.setBinaryStream(3, (InputStream)bais, bytes.length);
            } else {
                ps.setString(2, propertyValue);
                ps.setBytes(3, null);
            }
            ps.execute();
        }
        finally {
            this.dbSession.close(null, ps);
        }
    }

    public boolean getJChemPropertyAsBoolean(String jcpName, String idxTblQName, boolean isJChemTable, String propertyName, boolean defaultValue) throws Exception {
        String strValue = this.getJChemPropertyForIndex(jcpName, idxTblQName, isJChemTable, propertyName);
        if (strValue == null) {
            return defaultValue;
        }
        return strValue.equalsIgnoreCase("TRUE");
    }

    public String getProperty(String tblName, String propertyName) throws SQLException {
        return this.getProperty(tblName, propertyName, false);
    }

    public String getProperty(String tblName, String propertyName, boolean forUpdate) throws SQLException {
        String propertyValue = null;
        StringBuffer buffer = new StringBuffer("SELECT prop_value FROM ");
        buffer.append(tblName).append(" WHERE prop_name = ?");
        if (forUpdate) {
            buffer.append(" for update");
        }
        String sql = buffer.toString();
        ResultSet rset = null;
        PreparedStatement ps = this.dbSession.prepareStatement(sql);
        ps.setString(1, propertyName);
        try {
            String propValue;
            if (logger.isDebugEnabled()) {
                logger.debug("Executing: " + sql);
            }
            if ((rset = ps.executeQuery()).next()) {
                propValue = rset.getString(VALUE_COLUMN);
                if (propValue != null) {
                    propertyValue = propValue.trim();
                } else {
                    this.dbSession.close(rset, ps);
                    rset = null;
                    ps = null;
                    buffer = new StringBuffer("SELECT prop_value_ext FROM ");
                    buffer.append(tblName).append(" WHERE prop_name = ? ");
                    sql = buffer.toString();
                    ps = this.dbSession.prepareStatement(sql);
                    ps.setString(1, propertyName);
                    rset = ps.executeQuery();
                    rset.next();
                    byte[] data = (byte[])rset.getObject(VALUE_COLUMN_EXT);
                    if (data != null) {
                        try {
                            propertyValue = propValue = new String(data, "ASCII");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Returning '" + propertyValue + "' for tblName=" + tblName + ", propertyName=" + propertyName + ", forUpdate=" + forUpdate);
            }
            propValue = propertyValue;
            return propValue;
        }
        catch (SQLException sqlE) {
            if (logger.isErrorEnabled()) {
                logger.error("Failing statement: " + sql);
            }
            if (sqlE.getErrorCode() == 942) {
                this.dbSession.invalidate(sql);
            }
            throw sqlE;
        }
        finally {
            this.dbSession.close(rset, ps);
        }
    }

    public void setProperty(String tblName, String propertyName, String propertyValue) throws Exception {
        String old = this.getProperty(tblName, propertyName);
        if (old != null) {
            this.updateProperty(tblName, propertyName, propertyValue);
        } else {
            try {
                this.insertProperty(tblName, propertyName, propertyValue);
            }
            catch (SQLException sqlE) {
                if (sqlE.getErrorCode() == 1) {
                    this.updateProperty(tblName, propertyName, propertyValue);
                }
                throw sqlE;
            }
        }
    }

    private void updateProperty(String tblName, String propertyName, String propertyValue) throws Exception {
        boolean extended = false;
        if (propertyValue != null && propertyValue.length() > 4000) {
            extended = true;
        }
        PreparedStatement ps = null;
        String sql = "UPDATE " + tblName + " SET prop_value = ?, prop_value_ext = ? " + "WHERE prop_name = ? ";
        ps = this.dbSession.prepareStatement(sql);
        try {
            if (extended) {
                ps.setString(1, null);
                byte[] bytes = propertyValue.getBytes("ASCII");
                if (bytes != null && bytes.length > 2000) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    ps.setBinaryStream(2, (InputStream)bais, bytes.length);
                } else {
                    ps.setBytes(2, bytes);
                }
            } else {
                ps.setString(1, propertyValue);
                ps.setBytes(2, null);
            }
            ps.setString(3, propertyName);
            ps.execute();
        }
        catch (SQLException sqlE) {
            if (logger.isErrorEnabled()) {
                logger.error("Failing statement: " + sql);
            }
            this.dbSession.invalidate(sql);
            throw sqlE;
        }
        finally {
            this.dbSession.close(null, ps);
        }
    }

    private void insertProperty(String tblName, String propertyName, String propertyValue) throws Exception {
        boolean extended = false;
        if (propertyValue != null && propertyValue.length() > 4000) {
            extended = true;
        }
        PreparedStatement ps = null;
        ps = this.dbSession.prepareStatement("INSERT INTO " + tblName + " VALUES(?, ?, ?)");
        try {
            ps.setString(1, propertyName);
            if (extended) {
                ps.setString(2, null);
                byte[] bytes = propertyValue.getBytes("ASCII");
                if (bytes != null && bytes.length > 2000) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    ps.setBinaryStream(3, (InputStream)bais, bytes.length);
                } else {
                    ps.setBytes(3, bytes);
                }
            } else {
                ps.setString(2, propertyValue);
                ps.setBytes(3, null);
            }
            ps.execute();
        }
        catch (SQLException e) {
            if (logger.isErrorEnabled()) {
                logger.error("Problem with inserting: name=" + propertyName + ", value=" + propertyValue);
            }
            throw e;
        }
        finally {
            this.dbSession.close(null, ps);
        }
    }

    public void setMasterProperty(String idxSchema, String propertyName, String propertyValue) throws Exception {
        String pv;
        block8: {
            pv = null;
            try {
                pv = this.getProperty(this.getMasterIdxTableName(idxSchema), propertyName);
            }
            catch (SQLException e) {
                if (!this.createMasterTableMaybe(idxSchema, e)) break block8;
                pv = this.getProperty(this.getMasterIdxTableName(idxSchema), propertyName);
            }
        }
        if (pv == null) {
            try {
                this.insertMasterProperty(idxSchema, propertyName, propertyValue);
            }
            catch (SQLException sqlE) {
                if (sqlE.getErrorCode() == 1) {
                    this.updateMasterProperty(idxSchema, propertyName, propertyValue);
                }
                throw sqlE;
            }
        } else if (!pv.equals(propertyValue)) {
            this.updateMasterProperty(idxSchema, propertyName, propertyValue);
        }
    }

    private boolean createMasterTableMaybe(String idxSchema, SQLException e) throws Exception {
        if (e == null || e.getErrorCode() == 942) {
            String masterTable = this.getMasterIdxTableName(idxSchema);
            if (!this.tableExists(masterTable)) {
                this.execDDLStatement(this.createMasterTableSql(masterTable));
                if (logger.isDebugEnabled()) {
                    logger.debug(masterTable + " has been created.");
                }
                return true;
            }
            return false;
        }
        throw e;
    }

    private String createMasterTableSql(String masterTable) {
        return "CREATE TABLE " + masterTable + "(prop_name VARCHAR2(" + 4000 + ") unique, " + "prop_value VARCHAR2(" + 4000 + "), " + "prop_value_ext BLOB)";
    }

    private void insertMasterProperty(String idxSchema, String propertyName, String propertyValue) throws Exception {
        if (!masterTableStructureChecked) {
            this.checkMasterTableStructure(idxSchema);
        }
        this.insertProperty(this.getMasterIdxTableName(idxSchema), propertyName, propertyValue);
    }

    public String getMasterPropertyTimestamp() throws Exception {
        return this.getProperty(this.getMasterIdxTableName(null), DEFAULTPROPERTIES_TIMESTAMP_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkMasterTableStructure(String idxSchema) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            String sql = "SELECT data_length FROM all_tab_cols WHERE owner = ? AND table_name = ? AND column_name = 'PROP_NAME'";
            ps = this.dbSession.prepareStatement(sql);
            rs = null;
            try {
                ps.setString(1, idxSchema);
                ps.setString(2, MASTER_METADATATABLE);
                rs = ps.executeQuery();
                if (rs.next()) {
                    String mtName = idxSchema + "." + MASTER_METADATATABLE;
                    int dataLength = rs.getInt(1);
                    if (dataLength < 4000) {
                        String sqlAlter = "ALTER TABLE " + mtName + " MODIFY(prop_name VARCHAR2(4000))";
                        this.execDDLStatement(sqlAlter);
                        if (logger.isInfoEnabled()) {
                            logger.info("prop_name column in " + mtName + " has been increased.");
                        }
                    }
                    break block5;
                }
                this.createMasterTableMaybe(idxSchema, null);
            }
            catch (Throwable throwable) {
                this.dbSession.close(rs, ps);
                throw throwable;
            }
        }
        this.dbSession.close(rs, ps);
        masterTableStructureChecked = true;
    }

    private void updateMasterProperty(String idxSchema, String propertyName, String propertyValue) throws Exception {
        this.updateProperty(this.getMasterIdxTableName(idxSchema), propertyName, propertyValue);
    }

    public String getMasterProperty(String idxSchema, String propertyName) throws Exception {
        String masterIdxTblName = null;
        try {
            masterIdxTblName = this.getMasterIdxTableName(idxSchema);
            return this.getProperty(masterIdxTblName, propertyName);
        }
        catch (SQLException sqlE) {
            if (sqlE.getErrorCode() == 942) {
                if (idxSchema != null) {
                    idxSchema = idxSchema.toUpperCase();
                    String currUserSchema = this.dbSession.getRealUser().toUpperCase();
                    String cartOwnerSchema = this.dbSession.getJccOwner();
                    if (idxSchema.equals(cartOwnerSchema) && !idxSchema.equals(this.dbSession.getRealUser())) {
                        throw new Exception(masterIdxTblName + " is not visible in schema " + currUserSchema);
                    }
                }
                return null;
            }
            throw sqlE;
        }
    }

    public String getMasterIdxTableName(String idxSchema) throws SQLException {
        String schema = idxSchema;
        if (idxSchema == null) {
            schema = this.dbSession.getRealUser();
        }
        StringBuffer buffer = new StringBuffer(schema);
        buffer.append(".").append(MASTER_METADATATABLE);
        return buffer.toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIdxSchemaAndName(String tableSchema, String tableName, String tableCol, String itypOwner) throws Exception {
        String[] stringArray;
        tableSchema = tableSchema.toUpperCase();
        tableName = tableName.toUpperCase();
        tableCol = tableCol.toUpperCase();
        itypOwner = itypOwner.toUpperCase();
        String[] idxSchemaAndName = new String[2];
        tableCol = tableCol.replace('\"', ' ');
        tableCol = tableCol.trim();
        ResultSet rset = null;
        String sql = "select all_ind_columns.index_owner, all_ind_columns.index_name from all_ind_columns, all_indexes where all_ind_columns.table_owner = ? and all_ind_columns.table_name = ? and all_ind_columns.column_name = ? and all_indexes.owner = all_ind_columns.index_owner and all_indexes.index_name = all_ind_columns.index_name and all_indexes.ityp_owner = ? and all_indexes.ityp_name = 'JC_IDXTYPE'";
        PreparedStatement pstmt = this.dbSession.prepareStatement(sql);
        try {
            pstmt.setString(1, tableSchema);
            pstmt.setString(2, tableName);
            pstmt.setString(3, tableCol);
            pstmt.setString(4, itypOwner);
            rset = pstmt.executeQuery();
            if (!rset.next()) {
                throw new Exception("No index found for " + tableSchema + "." + tableName + "." + tableCol + " for indextype owner=" + itypOwner);
            }
            idxSchemaAndName[0] = rset.getString(1);
            idxSchemaAndName[1] = rset.getString(2);
            stringArray = idxSchemaAndName;
        }
        catch (Throwable throwable) {
            this.dbSession.close(rset, pstmt);
            throw throwable;
        }
        this.dbSession.close(rset, pstmt);
        return stringArray;
    }

    public int getTableVersion(String jpName, String tableName, boolean isJChemTable) throws Exception {
        String versionString = null;
        tableName = tableName.toUpperCase();
        versionString = this.getJChemPropertyForIndex(jpName, tableName, isJChemTable, "version");
        int version = 0;
        version = versionString == null ? -1 : Integer.parseInt(versionString);
        return version;
    }

    public String getDefaultProperty(String propertyName) throws Exception {
        String sconf = this.getMasterProperty(null, propertyName);
        if (sconf == null) {
            sconf = this.getMasterProperty(this.dbSession.getJccOwner(), propertyName);
        }
        return sconf;
    }

    public void setDefaultProperty(String propertyName, String propertyValue) throws Exception {
        this.setMasterProperty(null, propertyName, propertyValue);
        this.setDefaultPropertiesTimeStamp();
    }

    private void setDefaultPropertiesTimeStamp() throws Exception {
        String propertyName = DEFAULTPROPERTIES_TIMESTAMP_KEY;
        String propertyValue = new Timestamp(System.currentTimeMillis()).toString();
        this.setProperty(this.getMasterIdxTableName(null), propertyName, propertyValue);
    }

    public boolean tableExists(String qualifTblName) throws SQLException {
        String owner = null;
        String tableName = null;
        int dotPos = qualifTblName.indexOf(46);
        if (dotPos == -1) {
            owner = this.dbSession.getRealUser().toUpperCase();
            tableName = qualifTblName.toUpperCase();
        } else {
            owner = qualifTblName.substring(0, dotPos).toUpperCase();
            tableName = qualifTblName.substring(dotPos + 1).toUpperCase();
        }
        String stmt = "SELECT count(*) FROM all_tables WHERE owner=? AND table_name = ?";
        ResultSet rset = null;
        PreparedStatement ps = this.dbSession.prepareStatementNoCache(stmt);
        try {
            ps.setString(1, owner);
            ps.setString(2, tableName);
            rset = ps.executeQuery();
            if (!rset.next()) {
                boolean bl = false;
                return bl;
            }
            int c = rset.getInt(1);
            if (c > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sqlE) {
            if (logger.isErrorEnabled()) {
                logger.error("Failed statement: " + stmt);
            }
            throw sqlE;
        }
        finally {
            ps.close();
        }
    }

    public void initMetadataMaybe(String idxSchema) throws Exception {
        String stmt;
        String masterTable;
        if (idxSchema == null) {
            idxSchema = this.dbSession.getRealUser();
        }
        if (!this.tableExists(masterTable = this.getMasterIdxTableName(idxSchema))) {
            stmt = "CREATE TABLE " + masterTable + "(prop_name VARCHAR2(" + 4000 + ") unique, " + "prop_value VARCHAR2(" + 4000 + "), " + "prop_value_ext LONG RAW)";
            this.execDDLStatement(stmt);
        } else {
            this.checkMasterTableStructure(idxSchema);
        }
        if (!this.sequenceExists(idxSchema, "JCHEMIDX_SEQ")) {
            stmt = "CREATE SEQUENCE " + idxSchema + "." + "JCHEMIDX_SEQ" + " INCREMENT BY 1 START WITH 1";
            this.execDDLStatement(stmt);
        }
        if (!this.tableExists(idxSchema + ".jc_idx_udop")) {
            stmt = "CREATE TABLE " + idxSchema + ".jc_idx_udop" + "(op_name VARCHAR2(4000), class_name VARCHAR2(4000), " + "delim VARCHAR2(4000), param_list VARCHAR2(4000))";
            this.execDDLStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sequenceExists(String seqOwner, String seqName) throws SQLException {
        if (seqOwner == null) {
            seqOwner = this.dbSession.getRealUser();
        }
        String stmt = "SELECT last_number FROM all_sequences  WHERE sequence_owner = ? AND sequence_name = ?";
        ResultSet rset = null;
        PreparedStatement ps = this.dbSession.prepareStatementNoCache(stmt);
        try {
            ps.setString(1, seqOwner.toUpperCase());
            ps.setString(2, seqName.toUpperCase());
            rset = ps.executeQuery();
            if (rset.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ps.close();
        }
    }

    public void execDDLStatement(String stmt) throws Exception {
        PreparedStatement ps = this.dbSession.prepareStatementNoCache(stmt);
        try {
            ps.execute();
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("Failing statement: " + stmt);
            }
            throw e;
        }
        finally {
            ps.close();
            ps = null;
        }
    }

    public String getIdxTblQName(String idxSchema, String propertyName) throws Exception {
        String qualifTblName = this.getMasterProperty(idxSchema, propertyName);
        if (!this.tableExists(qualifTblName)) {
            return null;
        }
        return qualifTblName;
    }

    public String getIdxQName(String idxSchema, String idxName, String idxPartition) throws Exception {
        StringBuffer buffer = new StringBuffer(idxSchema);
        buffer.append(".").append(idxName);
        if (idxPartition != null) {
            buffer.append("_").append(idxPartition);
        }
        return buffer.toString().toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIdxTableQNameForJcTable(String idxSchema, String idxName, String idxPartition) throws Exception {
        PreparedStatement pstmt;
        ResultSet rs;
        block3: {
            String string;
            String sql = "select table_owner, table_name from all_indexes where owner = ? and index_name = ?";
            rs = null;
            pstmt = this.dbSession.prepareStatement(sql);
            try {
                pstmt.setString(1, idxSchema.toUpperCase());
                pstmt.setString(2, idxName.toUpperCase());
                rs = pstmt.executeQuery();
                if (!rs.next()) break block3;
                String tableOwner = rs.getString(1);
                String tableName = rs.getString(2);
                string = tableOwner + "." + tableName;
            }
            catch (Throwable throwable) {
                this.dbSession.close(rs, pstmt);
                throw throwable;
            }
            this.dbSession.close(rs, pstmt);
            return string;
        }
        String string = null;
        this.dbSession.close(rs, pstmt);
        return string;
    }

    public String getIdxTableQName(String idxSchema, String idxName, String idxPartition, boolean evenIfJChemTable) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("idxSchema=" + idxSchema + ", idxName=" + idxName + ", idxPartition=" + idxPartition + ", evenIfJChemTable=" + evenIfJChemTable);
        }
        String masterPropName = this.getIdxQName(idxSchema, idxName, idxPartition) + ".idxTable";
        if (logger.isDebugEnabled()) {
            logger.debug("masterPropName=" + masterPropName);
        }
        String idxTblQName = this.getMasterProperty(idxSchema, masterPropName);
        if (logger.isDebugEnabled()) {
            logger.debug("idxTblQName=" + idxTblQName);
        }
        if (idxTblQName == null && evenIfJChemTable) {
            idxTblQName = this.getIdxTableQNameForJcTable(idxSchema, idxName, idxPartition);
        }
        return idxTblQName;
    }

    public String getIdxTableQName(String idxSchema, String idxName, String idxPartition, int evenIfJChemTable) throws Exception {
        return this.getIdxTableQName(idxSchema, idxName, idxPartition, evenIfJChemTable != 0);
    }

    public String getIdxTableQName(String idxSchema, String idxName, String idxPartition) throws Exception {
        return this.getIdxTableQName(idxSchema, idxName, idxPartition, false);
    }

    public boolean isJChemTable(String jcptName, String qualifTblName) throws SQLException {
        boolean bl;
        ResultSet rset;
        PreparedStatement ps;
        block7: {
            ps = null;
            rset = null;
            ps = this.dbSession.prepareStatement("SELECT prop_value FROM " + jcptName + " WHERE prop_name = ? ");
            ps.setString(1, "table." + qualifTblName.toUpperCase() + ".fingerprint.numberOfBits");
            rset = ps.executeQuery();
            if (!rset.next()) break block7;
            boolean bl2 = true;
            this.dbSession.close(rset, ps);
            ps = null;
            return bl2;
        }
        try {
            this.dbSession.close(null, ps);
            if (!JcMetaDataFunctions.getJspInstance().tableExists(qualifTblName.toUpperCase())) {
                throw new SQLException("Table or view '" + qualifTblName + "' does not exists.");
            }
            bl = false;
        }
        catch (SQLException sqlException) {
            block8: {
                boolean bl3;
                try {
                    if (sqlException.getErrorCode() != 942) break block8;
                    bl3 = false;
                }
                catch (Throwable throwable) {
                    this.dbSession.close(rset, ps);
                    ps = null;
                    throw throwable;
                }
                this.dbSession.close(rset, ps);
                ps = null;
                return bl3;
            }
            throw sqlException;
        }
        this.dbSession.close(rset, ps);
        ps = null;
        return bl;
    }

    public static void setInstance(JcMetaDataFunctions jmdf) {
        instance = jmdf;
    }

    static {
        masterTableStructureChecked = false;
    }
}

