/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.costestim;

import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class JcOptCollectDeleteStats {
    private static final JCartLogger logger = JCartLogger.getLogger(JcOptCollectDeleteStats.class);

    private JcOptCollectDeleteStats() {
    }

    public static int collectIdxStats(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, String tblPartition) throws Exception {
        JcOptCollectDeleteStats.gatherTableStats(idxSchema, idxName, idxPartition);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gatherTableStats(String idxSchema, String idxName, String idxPartition) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("gatherTableStats: idxSchema=" + idxSchema + ", idxName=" + idxName + ", idxPartition=" + idxPartition);
        }
        String idxTblQName = JcMetaDataFunctions.getJspInstance().getIdxTableQName(idxSchema, idxName, idxPartition, false);
        if (logger.isDebugEnabled()) {
            logger.debug("gatherTableStats: idxTblQName=" + idxTblQName);
        }
        if (idxTblQName == null) {
            return;
        }
        int dotPos = idxTblQName.indexOf(46);
        String idxTblBaseName = idxTblQName.substring(dotPos + 1);
        if (logger.isDebugEnabled()) {
            logger.debug("gatherTableStats: idxSchema=" + idxSchema + "." + idxTblBaseName);
        }
        String sql = "BEGIN dbms_stats.gather_table_stats(?, ?); END;";
        JavaStoredProcSession s = JavaStoredProcSession.instance();
        PreparedStatement ps = s.prepareStatement(sql);
        try {
            ps.setString(1, idxSchema);
            ps.setString(2, idxTblBaseName);
            ps.execute();
        }
        finally {
            s.close(null, ps);
        }
    }

    private static String getIdxStatTblName(String idxSchema, String idxName, String idxPartition) {
        String qIdxStatTblName = idxSchema + "." + idxName;
        if (idxPartition != null) {
            qIdxStatTblName = qIdxStatTblName + "_" + idxPartition;
        }
        qIdxStatTblName = qIdxStatTblName + "_jcs";
        return qIdxStatTblName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void searchRecordStats(String qTblName, String colName, String tblPartition, String query, String qIdxStatTblName) throws Exception {
        String sql = "SELECT count(*) FROM " + qTblName + " where jc_contains(" + colName + ", ?) = 1";
        JavaStoredProcSession s = JavaStoredProcSession.instance();
        PreparedStatement ps = s.getConnection().prepareStatement(sql);
        try {
            ps.setString(1, query);
            long start = System.currentTimeMillis();
            ResultSet rs = ps.executeQuery();
            long end = System.currentTimeMillis();
            rs.next();
            int hitCount = rs.getInt(1);
            JcOptCollectDeleteStats.recordStats(hitCount, end - start, qIdxStatTblName);
        }
        finally {
            ps.close();
        }
    }

    private static void recordStats(int hitCount, long time, String qIdxStatTblName) throws Exception {
        JcOptCollectDeleteStats.checkCreateStatTable(qIdxStatTblName);
        JcOptCollectDeleteStats.insertOrUpdateHitStat(hitCount, time, qIdxStatTblName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkCreateStatTable(String qIdxStatTblName) throws Exception {
        JavaStoredProcSession dbSession = JavaStoredProcSession.instance();
        if (!JcMetaDataFunctions.getJspInstance().tableExists(qIdxStatTblName)) {
            String sql = "CREATE TABLE " + qIdxStatTblName + " (hitcount NUMERIC(18,0), time NUMERIC(18,0))";
            PreparedStatement ps = dbSession.prepareStatementNoCache(sql);
            try {
                ps.execute();
            }
            finally {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertOrUpdateHitStat(int hitCount, long time, String qIdxTblName) throws Exception {
        boolean hasStat = JcOptCollectDeleteStats.hasHitStat(hitCount, qIdxTblName);
        String sql = null;
        sql = hasStat ? "UPDATE " + qIdxTblName + " SET time = ? WHERE hitcount = ?" : "INSERT INTO " + qIdxTblName + " (time, hitcount) VALUES(?,?)";
        JavaStoredProcSession dbSession = JavaStoredProcSession.instance();
        PreparedStatement ps = dbSession.prepareStatement(sql);
        try {
            ps.setLong(1, time);
            ps.setInt(2, hitCount);
            ps.execute();
        }
        finally {
            dbSession.close(null, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasHitStat(int hitCount, String qIdxTblName) throws Exception {
        boolean bl;
        String sql = "SELECT count(*) FROM " + qIdxTblName + " WHERE hitcount = ?";
        JavaStoredProcSession dbSession = JavaStoredProcSession.instance();
        ResultSet rs = null;
        PreparedStatement ps = dbSession.prepareStatement(sql);
        try {
            ps.setInt(1, hitCount);
            rs = ps.executeQuery();
            rs.next();
            int count = rs.getInt(1);
            bl = count > 0;
        }
        catch (Throwable throwable) {
            dbSession.close(rs, ps);
            throw throwable;
        }
        dbSession.close(rs, ps);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTableStats(String idxSchema, String idxName, String idxPartition) throws Exception {
        String idxTblQName = JcMetaDataFunctions.getJspInstance().getIdxTableQName(idxSchema, idxName, idxPartition, true);
        int dotPos = idxTblQName.indexOf(46);
        String idxTblBaseName = idxTblQName.substring(dotPos + 1);
        String sql = "BEGIN dbms_stats.delete_table_stats(?, ?); END;";
        JavaStoredProcSession s = JavaStoredProcSession.instance();
        PreparedStatement ps = s.prepareStatement(sql);
        try {
            ps.setString(1, idxSchema);
            ps.setString(2, idxTblBaseName);
            ps.execute();
        }
        finally {
            s.close(null, ps);
        }
    }
}

