/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.costestim;

import chemaxon.jchem.cartridge.JCFunctionsBlob;
import chemaxon.jchem.cartridge.JCartDml;
import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.oresident.util.CxOptions;
import chemaxon.jchem.cartridge.rmi.Dml;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.InsertReqData;
import chemaxon.jchem.cartridge.tunnel.InsertRespData;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import oracle.sql.BLOB;

public class JcOptSelectivity {
    private static final JCartLogger logger = JCartLogger.getLogger(JcOptSelectivity.class);
    private static final double[][] tanimSel = new double[][]{{0.95, 5.0E-4}, {0.9, 7.0E-4}, {0.85, 0.0022}, {0.8, 0.0032}, {0.75, 0.0045}, {0.7, 0.012}, {0.65, 0.0194}, {0.6, 0.0369}, {0.55, 0.0677}, {0.5, 0.3316}, {0.45, 2.2933}, {0.4, 13.8753}, {0.35, 40.4911}, {0.3, 64.0135}, {0.25, 80.0304}, {0.2, 89.8136}, {0.15, 95.5826}, {0.0, 99.9999}};

    private JcOptSelectivity() {
    }

    private static String[] getIdxTableOwnerAndName(String idxSchema, String idxName, String idxPartition) throws Exception {
        String owner = null;
        String tableName = null;
        String idxTableQName = JcMetaDataFunctions.getJspInstance().getIdxTableQName(idxSchema, idxName, idxPartition, true);
        int dotPos = idxTableQName.indexOf(46);
        if (dotPos == -1) {
            owner = JavaStoredProcSession.instance().getRealUser();
            tableName = idxTableQName.toUpperCase();
        } else {
            owner = idxTableQName.substring(0, dotPos).toUpperCase();
            tableName = idxTableQName.substring(dotPos + 1).toUpperCase();
        }
        return new String[]{owner, tableName};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumRows(String idxSchema, String idxName, String idxPartition) throws Exception {
        int n;
        String[] on = JcOptSelectivity.getIdxTableOwnerAndName(idxSchema, idxName, idxPartition);
        String owner = on[0];
        String tableName = on[1];
        ResultSet rset = null;
        String sql = "select num_rows from all_tables where owner = ? and table_name = ?";
        PreparedStatement pstmt = JavaStoredProcSession.instance().prepareStatement(sql);
        try {
            pstmt.setString(1, owner);
            pstmt.setString(2, tableName);
            rset = pstmt.executeQuery();
            if (!rset.next()) {
                throw new Exception("No index table: " + owner + "." + tableName);
            }
            int numRows = rset.getBigDecimal(1).toBigInteger().intValue();
            if (logger.isDebugEnabled()) {
                logger.debug("getNumRows: numRows=" + numRows);
            }
            n = numRows;
        }
        catch (Throwable throwable) {
            JavaStoredProcSession.instance().close(rset, pstmt);
            throw throwable;
        }
        JavaStoredProcSession.instance().close(rset, pstmt);
        return n;
    }

    public static float getSelectivity(String opSchema, String opName, String tableSchema, String tableName, String tableCol, String tablePartLower, String tablePartUpper, String start, String stop, int opFlag, BLOB query, String options) throws Exception {
        return JcOptSelectivity.getSelectivity(opSchema, opName, tableSchema, tableName, tableCol, tablePartLower, tablePartUpper, start, stop, opFlag, JCFunctionsBlob.blobToString(query), options);
    }

    public static float getSelectivity(String opSchema, String opName, String tableSchema, String tableName, String tableCol, String tablePartLower, String tablePartUpper, String start, String stop, int opFlag, String query, String options) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("getSelectivity called: " + opSchema + ", " + opName + ", " + tableSchema + ", " + tableName + ", " + tableCol + ", " + tablePartLower + ", " + tablePartUpper + ", " + start + ", " + stop + ", " + opFlag + ", " + query + ", " + options);
        }
        try {
            return JcOptSelectivity.getSelectivity0(opSchema, opName, tableSchema, tableName, tableCol, tablePartLower, tablePartUpper, start, stop, opFlag, query, options);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new Exception(throwable.getMessage());
        }
    }

    public static float getSelectivity0(String opSchema, String opName, String tableSchema, String tableName, String tableCol, String tablePartLower, String tablePartUpper, String start, String stop, int opFlag, String query, String options) throws Exception {
        String[] idxSchemaAndName = JcMetaDataFunctions.getJspInstance().getIdxSchemaAndName(tableSchema, tableName, tableCol, opSchema);
        String idxSchema = idxSchemaAndName[0];
        String idxName = idxSchemaAndName[1];
        float sel = 50.0f;
        if (opName.indexOf("CONTAINS") != -1) {
            sel = JcOptSelectivity.getSubstrSearchSelectivity(idxSchema, idxName, tableSchema, tableName, tableCol, start, stop, opFlag, query, options);
        } else if (opName.indexOf("COMPARE") != -1) {
            sel = options == null ? JcOptSelectivity.getSubstrSearchSelectivity(idxSchema, idxName, tableSchema, tableName, tableCol, start, stop, opFlag, query, options) : JcOptSelectivity.getGenericSearchSelectivity(idxSchema, idxName, tableSchema, tableName, tableCol, start, stop, opFlag, query, options);
        } else if (opName.indexOf("EQUALS") != -1) {
            sel = JcOptSelectivity.getPerfectSearchSelectivity(idxSchema, idxName, query);
        } else if (opName.indexOf("MATCHCOUNT") != -1) {
            sel = JcOptSelectivity.getMatchCountSelectivity(idxSchema, idxName, tableSchema, tableName, tableCol, query, options);
        } else if (opName.indexOf("EVALUATE") != -1) {
            sel = JcOptSelectivity.getEvaluateSelectivity(idxSchema, idxName, tableSchema, tableName, tableCol, query, options);
        } else if (opName.indexOf("TANIMOTO") != -1) {
            sel = JcOptSelectivity.getTanimotoSelectivity(start, stop, opFlag);
        } else {
            if (logger.isInfoEnabled()) {
                logger.info("Operator " + opName + " not supported for cost extimations");
            }
            sel = -1.0f;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Returning: " + sel);
        }
        return sel;
    }

    static float getTanimotoSelectivity(String start, String stop, int opFlag) {
        double stp;
        if (stop == null) {
            return JcOptSelectivity.getTanSelByThreshold(Double.parseDouble(start));
        }
        if (start == null) {
            return 100.0f - JcOptSelectivity.getTanSelByThreshold(Double.parseDouble(stop));
        }
        double strt = Double.parseDouble(start);
        if (strt >= (stp = Double.parseDouble(stop))) {
            return 99.998f;
        }
        return 100.0f - JcOptSelectivity.getTanSelByThreshold(stp) - (100.0f - JcOptSelectivity.getTanSelByThreshold(strt));
    }

    private static float getTanSelByThreshold(double t) {
        int idxMinDelta = -1;
        double minDelta = 1000.0;
        for (int ix = 0; ix < tanimSel.length; ++ix) {
            double d = Math.abs(t - tanimSel[ix][0]);
            if (!(d < minDelta)) continue;
            minDelta = d;
            idxMinDelta = ix;
        }
        return (float)tanimSel[idxMinDelta][1];
    }

    private static float getGenericSearchSelectivity(String idxSchema, String idxName, String tableSchema, String tableName, String tableCol, String start, String stop, int opFlag, String query, String options) throws Exception {
        CxOptions jcOptions;
        String searchType;
        if (logger.isDebugEnabled()) {
            logger.debug("getGenericSearchSelectivity called");
        }
        if ((searchType = (jcOptions = new CxOptions(options)).getStringValue("t")) != null) {
            if (searchType.equalsIgnoreCase("s") || searchType.equalsIgnoreCase("na")) {
                return JcOptSelectivity.getSubstrSearchSelectivity(idxSchema, idxName, tableSchema, tableName, tableCol, start, stop, opFlag, query, jcOptions);
            }
            if (searchType.equalsIgnoreCase("t")) {
                return JcOptSelectivity.getSimilaritySearchSelectivity(idxSchema, idxName, tableSchema, tableName, tableCol, start, stop, opFlag, query, jcOptions);
            }
            if (searchType.equalsIgnoreCase("p") || searchType.equalsIgnoreCase("d")) {
                return JcOptSelectivity.getPerfectSearchSelectivity(idxSchema, idxName, query);
            }
            if (searchType.equalsIgnoreCase("e") || searchType.equalsIgnoreCase("ef") || searchType.equalsIgnoreCase("r") || searchType.equalsIgnoreCase("f") || searchType.equalsIgnoreCase("ff") || searchType.equalsIgnoreCase("u")) {
                return -1.0f;
            }
            throw new UnsupportedOperationException();
        }
        return JcOptSelectivity.getSubstrSearchSelectivity(idxSchema, idxName, tableSchema, tableName, tableCol, start, stop, opFlag, query, jcOptions);
    }

    private static float getSubstrSearchSelectivity(String idxSchema, String idxName, String tableSchema, String tableName, String tableCol, String start, String stop, int opFlag, String query, String options) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("getSubstrSearchSelectivity called");
        }
        CxOptions jcOptions = new CxOptions(options);
        return JcOptSelectivity.getSubstrSearchSelectivity(idxSchema, idxName, tableSchema, tableName, tableCol, start, stop, opFlag, query, jcOptions);
    }

    private static float getSubstrSearchSelectivity(String idxSchema, String idxName, String tableSchema, String tableName, String tableCol, String start, String stop, int opFlag, String query, CxOptions jcOptions) throws Exception {
        jcOptions.removeOption("ctFilter");
        return JcOptSelectivity.getSelectivity(idxSchema, idxName, tableSchema, tableName, tableCol, start, stop, opFlag, query, jcOptions, "na");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float getPerfectSearchSelectivity(String idxSchema, String idxName, String query) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("getPerfectSearchSelectivity called");
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT num_distinct ");
        sqlBuffer.append("FROM ALL_TAB_COL_STATISTICS ");
        sqlBuffer.append("WHERE ");
        sqlBuffer.append("owner = ? ");
        sqlBuffer.append("AND table_name = ? ");
        sqlBuffer.append("AND column_name = 'CD_HASH'");
        String[] on = JcOptSelectivity.getIdxTableOwnerAndName(idxSchema, idxName, null);
        String owner = on[0];
        String tableName = on[1];
        int numDistinct = 0;
        ResultSet rs = null;
        PreparedStatement pstmt = JavaStoredProcSession.instance().prepareStatement(sqlBuffer.toString());
        try {
            pstmt.setString(1, owner);
            pstmt.setString(2, tableName);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new Exception("No index table: " + owner + "." + tableName);
            }
            numDistinct = rs.getInt(1);
            if (logger.isDebugEnabled()) {
                logger.debug("getPerfectSearchSelectivity: numDistinct=" + numDistinct);
            }
        }
        catch (Throwable throwable) {
            JavaStoredProcSession.instance().close(rs, pstmt);
            throw throwable;
        }
        JavaStoredProcSession.instance().close(rs, pstmt);
        int numRows = JcOptSelectivity.getNumRows(idxSchema, idxName, null);
        if (numRows == 0 || numDistinct == 0) {
            return 0.0f;
        }
        float estimHitCount = numRows / numDistinct / 2;
        float estimSel = Math.max(1.0f, estimHitCount * 100.0f / (float)numRows);
        if (estimSel > 2.0f) {
            JCartIndexDescriptor idxDescriptor = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName);
            InsertReqData requestData = new InsertReqData();
            JCartDml.fillInCommonRequestData(idxDescriptor, requestData);
            requestData.structure = query;
            Dml dmlServer = (Dml)RmiDirectory.instance().getServer("DmlServer");
            InsertRespData respData = dmlServer.createInsertData(requestData);
            int hashCode = respData.hashCode;
            String sql = "select count(*) from " + owner + "." + tableName + " where cd_hash = ?";
            rs = null;
            pstmt = JavaStoredProcSession.instance().prepareStatement(sql);
            try {
                pstmt.setInt(1, hashCode);
                rs = pstmt.executeQuery();
                rs.next();
                estimSel = Math.max(1, rs.getInt(1) / 2);
            }
            finally {
                JavaStoredProcSession.instance().close(rs, pstmt);
            }
        }
        return estimSel;
    }

    private static float getSimilaritySearchSelectivity(String idxSchema, String idxName, String tableSchema, String tableName, String tableCol, String start, String stop, int opFlag, String query, CxOptions jcOptions) throws Exception {
        return JcOptSelectivity.getSelectivity(idxSchema, idxName, tableSchema, tableName, tableCol, start, stop, opFlag, query, jcOptions, "t");
    }

    private static float getSelectivity(String idxSchema, String idxName, String tableSchema, String tableName, String tableCol, String start, String stop, int opFlag, String query, CxOptions jcOptions, String searchType) throws Exception {
        String idxPartition = null;
        String jpName = JcMetaDataFunctions.getJspInstance().getPropertyTableName(idxSchema, idxName, idxPartition);
        String options = "t:" + searchType;
        if (jcOptions != null) {
            jcOptions.setOptionValue("t", searchType);
            options = jcOptions.toString();
        }
        int hitCount = JFunctions.getHitCount(idxSchema, idxName, idxPartition, tableSchema, tableName, tableCol, jpName, "JC_COMPARE", null, start, stop, opFlag, query, options, -1L);
        int numRows = JcOptSelectivity.getNumRows(idxSchema, idxName, idxPartition);
        return 100 * hitCount / numRows;
    }

    private static int getMatchCountSelectivity(String idxSchema, String idxName, String tableSchema, String tableName, String tableCol, String query, String options) throws Exception {
        return JcOptSelectivity.getPredictedSelectivityValue(idxSchema, idxName, "matchcount", 50);
    }

    private static int getEvaluateSelectivity(String idxSchema, String idxName, String tableSchema, String tableName, String tableCol, String query, String options) throws Exception {
        return JcOptSelectivity.getPredictedSelectivityValue(idxSchema, idxName, "evaluate", 50);
    }

    private static int getPredictedSelectivityValue(String idxSchema, String idxName, String optype, int dfltValue) {
        return dfltValue;
    }
}

