/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.costestim;

import chemaxon.jchem.cartridge.costestim.CostFactors;
import chemaxon.jchem.cartridge.costestim.SloppyOperatorName;
import java.util.StringTokenizer;

public class OperatorCostFactors {
    public static final String ELEMENT_SEPARATOR = ";";
    private SloppyOperatorName opName;
    private CostFactors indexCosts;
    private CostFactors funcCosts;

    public OperatorCostFactors(String opName, CostFactors indexCosts, CostFactors funcCosts) {
        this.opName = new SloppyOperatorName(opName);
        this.indexCosts = indexCosts;
        this.funcCosts = funcCosts;
    }

    public OperatorCostFactors(String opName, String costFactorsStr) {
        this.opName = new SloppyOperatorName(opName);
        StringTokenizer t = new StringTokenizer(costFactorsStr, ELEMENT_SEPARATOR);
        double cpuCost = Double.parseDouble(t.nextToken());
        double ioCost = Double.parseDouble(t.nextToken());
        double netCost = Double.parseDouble(t.nextToken());
        this.indexCosts = new CostFactors(cpuCost, ioCost, netCost);
        cpuCost = Double.parseDouble(t.nextToken());
        ioCost = Double.parseDouble(t.nextToken());
        netCost = Double.parseDouble(t.nextToken());
        this.funcCosts = new CostFactors(cpuCost, ioCost, netCost);
    }

    public CostFactors getFuncCosts() {
        return this.funcCosts;
    }

    public void setFuncCosts(CostFactors funcCosts) {
        this.funcCosts = funcCosts;
    }

    public CostFactors getIndexCosts() {
        return this.indexCosts;
    }

    public void setIndexCosts(CostFactors indexCosts) {
        this.indexCosts = indexCosts;
    }

    public SloppyOperatorName getOpName() {
        return this.opName;
    }

    public String toString() {
        return this.indexCosts.getCpuCost() + ELEMENT_SEPARATOR + this.indexCosts.getIoCost() + ELEMENT_SEPARATOR + this.indexCosts.getNetworkCost() + ELEMENT_SEPARATOR + this.funcCosts.getCpuCost() + ELEMENT_SEPARATOR + this.funcCosts.getIoCost() + ELEMENT_SEPARATOR + this.funcCosts.getNetworkCost();
    }
}

