/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.costestim;

public class SloppyOperatorName {
    public static final String[] supportedSloppies = new String[]{new String("CONTAINS"), new String("COMPARE"), new String("EQUALS"), new String("MATCHCOUNT"), new String("EVALUATE"), new String("TANIMOTO")};
    private String sloppyName;

    public SloppyOperatorName(String operatorName) {
        this.sloppyName = SloppyOperatorName.getMatchingSloppy(operatorName);
    }

    public int hashCode() {
        return this.sloppyName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            String otherName = (String)obj;
            return otherName.toUpperCase().indexOf(this.sloppyName) > -1;
        }
        if (obj instanceof SloppyOperatorName) {
            String otherName = ((SloppyOperatorName)obj).sloppyName;
            return otherName.indexOf(this.sloppyName) > -1 || this.sloppyName.indexOf(otherName) > -1;
        }
        return false;
    }

    public String getSloppyName() {
        return this.sloppyName;
    }

    public static String getMatchingSloppy(String opName) {
        for (int i = 0; i < supportedSloppies.length; ++i) {
            String sloppyName = supportedSloppies[i];
            if (opName.toUpperCase().indexOf(sloppyName) <= -1) continue;
            return sloppyName;
        }
        throw new IllegalArgumentException("Unsupported operator/function name: " + opName);
    }
}

