/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.costestim.calibra;

import chemaxon.jchem.cartridge.costestim.CostFactors;
import chemaxon.jchem.interop.InteropUtil;

public class CalibData {
    public String structTable = "plain_nci";
    public String pkCol = "id";
    public String structCol = "structure";
    public String[] queries = new String[]{"c1ccccc1", "Clc1ccccc1"};
    public String options = "t:s";
    public int[] lessThanIds = new int[]{10000, 2000, 1000, 500, 100};
    private int queryIndex;
    private int idIndex;
    public CostFactors idxCosts;
    public CostFactors funcCosts;

    public CalibData(String structTable, String pkCol, String structCol, String[] queries, String options, int[] lessThanIds, CostFactors idxCosts, CostFactors funcCosts) {
        this.structTable = structTable;
        this.pkCol = pkCol;
        this.structCol = structCol;
        this.queries = queries;
        this.options = options;
        this.lessThanIds = lessThanIds;
        this.idxCosts = idxCosts;
        this.funcCosts = funcCosts;
    }

    public CalibData(String structTable, String pkCol, String structCol, String queries, String options, String lessThanIds, CostFactors idxCosts, CostFactors funcCosts) {
        this.structTable = structTable;
        this.pkCol = pkCol;
        this.structCol = structCol;
        this.queries = InteropUtil.parseStringList(queries, ";");
        this.options = options;
        this.lessThanIds = InteropUtil.parseIntList(lessThanIds, ";");
        this.idxCosts = idxCosts;
        this.funcCosts = funcCosts;
    }

    public boolean incQueryIndex() {
        if (this.queryIndex == this.queries.length - 1) {
            return false;
        }
        ++this.queryIndex;
        return true;
    }

    public boolean incIdIndex() {
        if (this.idIndex == this.lessThanIds.length - 1) {
            return false;
        }
        ++this.idIndex;
        return true;
    }

    public String getQuery() {
        return this.queries[this.queryIndex];
    }

    public int getLessThanId() {
        return this.lessThanIds[this.idIndex];
    }

    public String toString() {
        return "CalibData[structTable=" + this.structTable + ",pkCol=" + this.pkCol + ",structCol=" + this.structCol + ",query=" + this.getQuery() + ",lessThanId=" + this.getLessThanId() + "]";
    }
}

