/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.costestim.calibra;

import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.costestim.CostFactors;
import chemaxon.jchem.cartridge.costestim.JcOptCosts;
import chemaxon.jchem.cartridge.costestim.calibra.CalibData;
import chemaxon.jchem.cartridge.costestim.calibra.FineTuner;
import chemaxon.jchem.cartridge.costestim.calibra.FuncCalibrator;
import chemaxon.jchem.cartridge.costestim.calibra.IdxCalibrator;
import chemaxon.jchem.cartridge.costestim.calibra.TuningData;
import chemaxon.jchem.cartridge.costestim.calibra.TuningDataTester;
import chemaxon.jchem.cartridge.costestim.calibra.TuningTarget;
import chemaxon.jchem.cartridge.dbsession.ClientSideSession;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public abstract class Calibrator
implements TuningDataTester {
    private static JCartLogger logger = JCartLogger.getLogger(Calibrator.class);
    public static final double DEFAULT_NETWORK_COST = 1000.0;
    protected DbSession dbSession;
    protected CalibData calibData;

    public Calibrator(DbSession dbSession, String structTable, String pkCol, String structCol, String queries, String options, String lessThanIds, CostFactors idxCosts, CostFactors funcCosts) throws Exception {
        this.dbSession = dbSession;
        this.calibData = new CalibData(structTable, pkCol, structCol, queries, options, lessThanIds, idxCosts, funcCosts);
    }

    public void calibrate() throws Exception {
        TuningData tuningResult = null;
        do {
            int at = this.getActualTime();
            TuningTarget tt = new TuningTarget(at, 1);
            TuningData startData = new TuningData(this.getCostFactor(), -1);
            FineTuner fineTuner = new FineTuner(tt, startData, this);
            tuningResult = fineTuner.tune();
            this.record(tuningResult);
        } while (this.calibData.incIdIndex() || this.calibData.incQueryIndex());
        this.setCostFactor(tuningResult.param);
    }

    protected abstract void setCostFactor(double var1);

    protected abstract double getCostFactor();

    protected abstract int getActualTime() throws Exception;

    protected abstract int getPlannedTime() throws Exception;

    private void setVolatileCostEstimation(double newCost) throws Exception {
        if (newCost > 1.0E21) {
            throw new Exception("new cost to high: " + newCost);
        }
        this.setCostFactor(newCost);
        this.setVolatileCostEstimation("COMPARE", this.calibData.idxCosts, this.calibData.funcCosts);
    }

    @Override
    public void test(TuningData tuningData) throws Exception {
        double newCost = tuningData.param;
        this.setVolatileCostEstimation(newCost);
        tuningData.result = this.getPlannedTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDomainIdxScanInPlan(boolean require) throws Exception {
        String sql = "select operation, access_predicates, filter_predicates from plan_table";
        ResultSet rset = null;
        PreparedStatement pstmt = this.getConnection().prepareStatement(sql);
        try {
            String accessPredicates = null;
            boolean found = false;
            rset = pstmt.executeQuery();
            while (rset.next()) {
                String operation = rset.getString("operation");
                accessPredicates = rset.getString("access_predicates");
                if (logger.isDebugEnabled()) {
                    String filterPredicates = rset.getString("filter_predicates");
                    logger.debug("Plan table check: operation=" + operation + ", access_predicates=" + accessPredicates + ", filter_predicates=" + filterPredicates);
                }
                if (!operation.startsWith("DOMAIN INDEX")) continue;
                found = true;
                break;
            }
            if (require != found) {
                throw new Exception("Incorrect domain index status: " + found + ": " + accessPredicates);
            }
        }
        finally {
            this.dbSession.close(rset, pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTimeFromPlanTable() throws Exception {
        String sql = "select time from plan_table where id = 0";
        ResultSet rset = null;
        PreparedStatement pstmt = this.getConnection().prepareStatement(sql);
        try {
            rset = pstmt.executeQuery();
            if (!rset.next()) {
                throw new Exception("No appropriate row in plan table");
            }
            int pt = rset.getInt(1);
            if (rset.next()) {
                throw new Exception("Too many rows in plan table with id = 0");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Planned time: " + pt + " sec(s)");
            }
            int n = pt;
            return n;
        }
        finally {
            this.dbSession.close(rset, pstmt);
        }
    }

    private void record(TuningData td) throws Exception {
        logger.info(this.calibData + ": " + td);
    }

    protected Connection getConnection() throws SQLException {
        return this.dbSession.getConnection();
    }

    void setVolatileCostEstimation(String opName, CostFactors idxCosts, CostFactors funcCosts) throws Exception {
        this.setVolatileCostEstimation(opName, idxCosts.getCpuCost(), idxCosts.getIoCost(), idxCosts.getNetworkCost(), funcCosts.getCpuCost(), funcCosts.getIoCost(), funcCosts.getNetworkCost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setVolatileCostEstimation(String opName, double idxCpuCost, double idxIoCost, double idxNetCost, double funcCpuCost, double funcIoCost, double funcNetCost) throws Exception {
        if (this.dbSession instanceof ClientSideSession) {
            String sql = "call jchem_opti_pkg.set_volatile_cost_factors(?, ?, ?, ?, ?, ?, ?)";
            if (logger.isDebugEnabled()) {
                logger.debug("setting volatile cost estimations: sql=" + sql);
            }
            PreparedStatement pstmt = this.dbSession.prepareStatement(sql);
            try {
                int paramIdx = 1;
                pstmt.setString(paramIdx++, opName);
                pstmt.setDouble(paramIdx++, idxCpuCost);
                pstmt.setDouble(paramIdx++, idxIoCost);
                pstmt.setDouble(paramIdx++, idxNetCost);
                pstmt.setDouble(paramIdx++, funcCpuCost);
                pstmt.setDouble(paramIdx++, funcIoCost);
                pstmt.setDouble(paramIdx++, funcNetCost);
                pstmt.execute();
            }
            finally {
                this.dbSession.close(null, pstmt);
            }
        } else {
            JcOptCosts.setVolatileCostEstimation(opName, idxCpuCost, idxIoCost, idxNetCost, funcCpuCost, funcIoCost, funcNetCost);
        }
    }

    public static void calibrateAndStore(DbSession dbSession, JcMetaDataFunctions metaData, String structTable, String pkCol, String structCol, String queries, String options, String lessThanIds, CostFactors idxCosts, CostFactors funcCosts) throws Exception {
        Calibrator c = new IdxCalibrator(dbSession, structTable, pkCol, structCol, queries, options, lessThanIds, idxCosts);
        c.calibrate();
        c = new FuncCalibrator(dbSession, structTable, pkCol, structCol, queries, options, lessThanIds, funcCosts);
        c.calibrate();
        metaData.setMasterProperty(null, "cost.factors.COMPARE.default", idxCosts.getCpuCost() + ";" + idxCosts.getIoCost() + ";" + idxCosts.getNetworkCost() + ";" + funcCosts.getCpuCost() + ";" + funcCosts.getIoCost() + ";" + funcCosts.getNetworkCost());
    }

    private static Connection createTestConnection(String host, int port, String dbName, String userName, String password) throws Exception {
        String url = "jdbc:oracle:thin:@" + host + ":" + port + ":" + dbName;
        Class.forName("oracle.jdbc.OracleDriver");
        System.err.println("Connecting to " + url + "...");
        Connection conn = DriverManager.getConnection(url, userName, password);
        conn.setAutoCommit(false);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLogLevelOnConnection(DbSession dbSession, String logger, int level) throws Exception {
        PreparedStatement pstmt = dbSession.prepareStatement("call jcart_logger.set_log_level(?, ?)");
        try {
            pstmt.setString(1, logger);
            pstmt.setInt(2, level);
            pstmt.execute();
        }
        finally {
            dbSession.close(null, pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCursorSharingOnConnection(DbSession dbSession, String csMode) throws Exception {
        PreparedStatement pstmt = dbSession.prepareStatement("alter session set cursor_sharing = " + csMode);
        try {
            pstmt.execute();
        }
        finally {
            dbSession.close(null, pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String[] propNames = new String[]{"db.host", "db.port", "db.name", "db.user", "db.password", "struct.table", "pk.col", "struct.col", "search.queries", "search.options", "less.than.ids", "idx.cpu.cost", "idx.io.cost", "idx.net.cost", "func.cpu.cost", "func.io.cost", "func.net.cost", "mode"};
        try {
            Calibrator c;
            if (args.length == 1) {
                Properties props = new Properties();
                FileInputStream inStream = new FileInputStream(args[0]);
                try {
                    props.load(inStream);
                }
                finally {
                    ((InputStream)inStream).close();
                }
                args = new String[propNames.length];
                for (int i = 0; i < propNames.length; ++i) {
                    args[i] = props.getProperty(propNames[i]);
                }
            }
            int argIdx = 0;
            String host = args[argIdx++];
            int port = Integer.parseInt(args[argIdx++]);
            String dbName = args[argIdx++];
            String userName = args[argIdx++];
            String password = args[argIdx++];
            String structTable = args[argIdx++];
            String pkCol = args[argIdx++];
            String structCol = args[argIdx++];
            String queries = args[argIdx++];
            String options = args[argIdx++];
            String lessThanIds = args[argIdx++];
            double idxCpuCost = Double.parseDouble(args[argIdx++]);
            double idxIoCost = Double.parseDouble(args[argIdx++]);
            double idxNetCost = Double.parseDouble(args[argIdx++]);
            double funcCpuCost = Double.parseDouble(args[argIdx++]);
            double funcIoCost = Double.parseDouble(args[argIdx++]);
            double funcNetCost = Double.parseDouble(args[argIdx++]);
            String mode = args[argIdx++];
            boolean doIndex = false;
            boolean doFunc = false;
            if (mode.equals("both")) {
                doIndex = true;
                doFunc = true;
            } else if (mode.equals("idx")) {
                doIndex = true;
            } else if (mode.equals("func")) {
                doFunc = true;
            } else {
                throw new IllegalArgumentException("Unexpected mode: " + mode);
            }
            JCartLogger.setLevel("chemaxon.jchem.cartridge.costestim", 3);
            ClientSideSession css = new ClientSideSession(Calibrator.createTestConnection(host, port, dbName, userName, password));
            Calibrator.setLogLevelOnConnection(css, "chemaxon", 3);
            Calibrator.setCursorSharingOnConnection(css, "similar");
            CostFactors idxCosts = new CostFactors(idxCpuCost, idxIoCost, idxNetCost);
            CostFactors funcCosts = new CostFactors(funcCpuCost, funcIoCost, funcNetCost);
            if (doIndex) {
                c = new IdxCalibrator(css, structTable, pkCol, structCol, queries, options, lessThanIds, idxCosts);
                c.calibrate();
            }
            if (doFunc) {
                c = new FuncCalibrator(css, structTable, pkCol, structCol, queries, options, lessThanIds, funcCosts);
                c.calibrate();
            }
            String cmdString = "update jc_idx_property set prop_value = '" + idxCosts.getCpuCost() + ";" + idxCosts.getIoCost() + ";" + idxCosts.getNetworkCost() + ";" + funcCosts.getCpuCost() + ";" + funcCosts.getIoCost() + ";" + funcCosts.getNetworkCost() + "' where prop_name = 'cost.factors.COMPARE.default'";
            System.out.println(cmdString);
        }
        catch (Throwable tbl) {
            tbl.printStackTrace();
        }
    }
}

