/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.costestim.calibra;

import chemaxon.jchem.cartridge.costestim.CostFactors;
import chemaxon.jchem.cartridge.costestim.calibra.Calibrator;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class FuncCalibrator
extends Calibrator {
    private static JCartLogger logger = JCartLogger.getLogger(FuncCalibrator.class);

    public FuncCalibrator(DbSession dbSession, String structTable, String pkCol, String structCol, String queries, String options, String lessThanIds, CostFactors funcCosts) throws Exception {
        super(dbSession, structTable, pkCol, structCol, queries, options, lessThanIds, new CostFactors(100000.0, 10000.0, 10000.0), funcCosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getPlannedTime() throws Exception {
        String sql = "delete from plan_table";
        PreparedStatement pstmt = this.getConnection().prepareStatement(sql);
        try {
            pstmt.execute();
        }
        finally {
            this.dbSession.close(null, pstmt);
        }
        sql = "explain plan for " + this.getSelect();
        if (logger.isDebugEnabled()) {
            logger.debug("getPlannedTime: sql=" + sql);
        }
        pstmt = this.getConnection().prepareStatement(sql);
        try {
            int paramIdx = 1;
            pstmt.setInt(paramIdx++, this.calibData.getLessThanId());
            pstmt.setString(paramIdx++, this.calibData.getQuery());
            pstmt.setString(paramIdx++, this.calibData.options);
            pstmt.execute();
        }
        finally {
            this.dbSession.close(null, pstmt);
        }
        this.checkDomainIdxScanInPlan(false);
        return this.getTimeFromPlanTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getActualTime() throws Exception {
        String sql = this.getSelect();
        if (logger.isDebugEnabled()) {
            logger.debug("getActualTime: sql=" + sql);
        }
        ResultSet rset = null;
        PreparedStatement pstmt = this.getConnection().prepareStatement(sql);
        try {
            int paramIdx = 1;
            pstmt.setInt(paramIdx++, this.calibData.getLessThanId());
            pstmt.setString(paramIdx++, this.calibData.getQuery());
            pstmt.setString(paramIdx++, this.calibData.options);
            long start = System.currentTimeMillis();
            rset = pstmt.executeQuery();
            if (!rset.next()) {
                throw new Exception("No row result set");
            }
            int pt = rset.getInt(1);
            if (rset.next()) {
                throw new Exception("Too many rows in result set");
            }
            long end = System.currentTimeMillis();
            int actualTime = (int)((end - start) / 1000L);
            if (logger.isDebugEnabled()) {
                logger.debug("actual time: " + actualTime + " sec(s)");
            }
            int n = actualTime;
            return n;
        }
        finally {
            this.dbSession.close(null, pstmt);
        }
    }

    private String getSelect() {
        return "select count(*) from (select " + this.calibData.structCol + " from " + this.calibData.structTable + " where " + this.calibData.pkCol + " < ?) a where jc_compare(" + this.calibData.structCol + ", ?, ?) = 1";
    }

    private String getBasicSelect() {
        return "select count(" + this.calibData.structCol + ") from " + this.calibData.structTable + " where " + this.calibData.pkCol + " < ?";
    }

    @Override
    protected double getCostFactor() {
        return this.calibData.funcCosts.getCpuCost();
    }

    @Override
    protected void setCostFactor(double param) {
        this.calibData.funcCosts.setCpuCost(param);
    }
}

