/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.costestim.calibra;

import chemaxon.jchem.cartridge.costestim.CostFactors;
import chemaxon.jchem.cartridge.costestim.calibra.Calibrator;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class IdxCalibrator
extends Calibrator {
    private static JCartLogger logger = JCartLogger.getLogger(IdxCalibrator.class);

    public IdxCalibrator(DbSession dbSession, String structTable, String pkCol, String structCol, String queries, String options, String lessThanIds, CostFactors idxCosts) throws Exception {
        super(dbSession, structTable, pkCol, structCol, queries, options, lessThanIds, idxCosts, new CostFactors(1.0E12, 0.0, 10000.0));
        this.setVolatileCostEstimation("COMPARE", idxCosts, this.calibData.funcCosts);
        this.getActualTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getPlannedTime() throws Exception {
        String sql = "delete from plan_table";
        PreparedStatement pstmt = this.getConnection().prepareStatement(sql);
        try {
            pstmt.execute();
        }
        finally {
            this.dbSession.close(null, pstmt);
        }
        String query = this.calibData.getQuery();
        String options = this.calibData.options;
        sql = "explain plan for select count(*) from " + this.calibData.structTable + " where jc_compare(" + this.calibData.structCol + ", '" + query + "', '" + options + "') = 1";
        if (logger.isDebugEnabled()) {
            logger.debug("getPlannedTime: sql=" + sql + " (query=" + query + ", options=" + options);
        }
        Statement stmt = this.getConnection().createStatement();
        try {
            stmt.execute(sql);
        }
        finally {
            stmt.close();
        }
        return this.getTimeFromPlanTable();
    }

    @Override
    protected int getActualTime() throws Exception {
        this.executeActualQuery();
        long start = System.currentTimeMillis();
        this.executeActualQuery();
        long end = System.currentTimeMillis();
        int actualTime = (int)((end - start) / 1000L);
        if (logger.isDebugEnabled()) {
            logger.debug("actual time: " + actualTime + " sec(s)");
        }
        return actualTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeActualQuery() throws Exception {
        String sql = "select count(*) from " + this.calibData.structTable + " where jc_compare(" + this.calibData.structCol + ", ?, ?) = 1";
        if (logger.isDebugEnabled()) {
            logger.debug("getActualTime: sql=" + sql);
        }
        ResultSet rset = null;
        PreparedStatement pstmt = this.getConnection().prepareStatement(sql);
        try {
            pstmt.setString(1, this.calibData.getQuery());
            pstmt.setString(2, this.calibData.options);
            rset = pstmt.executeQuery();
            if (!rset.next()) {
                throw new Exception("No row result set");
            }
            int pt = rset.getInt(1);
            if (rset.next()) {
                throw new Exception("Too many rows in result set");
            }
        }
        finally {
            this.dbSession.close(null, pstmt);
        }
    }

    @Override
    protected double getCostFactor() {
        return this.calibData.idxCosts.getIoCost();
    }

    @Override
    protected void setCostFactor(double param) {
        this.calibData.idxCosts.setIoCost(param);
    }

    protected void calcPlannerAdjustment() throws Exception {
    }
}

