/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.ctcol;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.EvalChemTermInfo;
import chemaxon.jchem.cartridge.util.JCartLogger;
import chemaxon.jchem.db.CTColumnPropUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import oracle.sql.ARRAY;

public class ChemTermColSupport {
    private static final JCartLogger logger = JCartLogger.getLogger(ChemTermColSupport.class);
    private DbSession dbSession;

    private static ChemTermColSupport createInstance() {
        return new ChemTermColSupport(JavaStoredProcSession.instance());
    }

    public ChemTermColSupport(DbSession dbSession) {
        this.dbSession = dbSession;
    }

    public static ARRAY getAutoCalcCtsARR(String idxSchema, String idxName, String idxPartition) throws Exception {
        ChemTermColSupport i = ChemTermColSupport.createInstance();
        return JFunctions.convertToARRAY(i.getAutoCalcCts(idxSchema, idxName, idxPartition), "CHAR_ARRAY");
    }

    public static ARRAY getAutoCalcCtsByColARR(String tableSchema, String tableName, String colName) throws Exception {
        ChemTermColSupport i = ChemTermColSupport.createInstance();
        String installSchema = i.dbSession.getJccOwner();
        String[] idxSchemaAndName = JcMetaDataFunctions.getJspInstance().getIdxSchemaAndName(tableSchema, tableName, colName, installSchema);
        return JFunctions.convertToARRAY(i.getAutoCalcCts(idxSchemaAndName[0], idxSchemaAndName[1], null), "CHAR_ARRAY");
    }

    public String[] getAutoCalcCts(String idxSchema, String idxName, String idxPartition) throws Exception {
        JCartIndexDescriptor idesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition);
        return this.getAutoCalcCts(idesc.getJcptName(), idesc.getIdxTableQName(), !idesc.isJChemTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAutoCalcCts(String jcptName, String idxTableQName, boolean isJChemTable) throws Exception {
        String ctcolpfx = CTColumnPropUtil.getChemTermColumnPropNamePfx(idxTableQName, isJChemTable);
        String sql = "SELECT prop_name, prop_value, prop_value_ext FROM " + jcptName + " WHERE prop_name LIKE ?";
        ArrayList<String> alist = new ArrayList<String>();
        ResultSet rs = null;
        PreparedStatement pstmt = this.dbSession.prepareStatement(sql);
        try {
            pstmt.setString(1, ctcolpfx + "%");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String e = rs.getString(2);
                if (e == null) {
                    byte[] barray = JFunctions.readBytes(rs, 2);
                    if (barray == null && logger.isWarningEnabled()) {
                        logger.warning("Both prop_value and prop_value_ext are null");
                    }
                    e = new String(barray, "US-ASCII");
                }
                alist.add(e);
            }
        }
        catch (Throwable throwable) {
            this.dbSession.close(rs, pstmt);
            throw throwable;
        }
        this.dbSession.close(rs, pstmt);
        String[] autoCalcCts = new String[alist.size()];
        alist.toArray(autoCalcCts);
        return autoCalcCts;
    }

    public String getChemTermColumn(EvalChemTermInfo evalInfo) throws Exception {
        return this.getChemTermColumn(evalInfo.getJcpropTableName(), evalInfo.getIndexTableQName(), evalInfo.isJchemTable(), evalInfo.getEvalOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChemTermColumn(String jcptName, String tableName, boolean jchemTable, String expression) throws Exception {
        String string;
        tableName = tableName.toUpperCase();
        String ctcolpfx = CTColumnPropUtil.getChemTermColumnPropNamePfx(tableName, !jchemTable);
        String sql = "SELECT prop_name, prop_value, prop_value_ext FROM " + jcptName + " WHERE prop_name LIKE ?";
        ResultSet rs = null;
        PreparedStatement pstmt = this.dbSession.prepareStatement(sql);
        try {
            pstmt.setString(1, ctcolpfx + "%");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String ctColPropName = rs.getString(1);
                String e = rs.getString(2);
                if (e == null) {
                    byte[] barray = JFunctions.readBytes(rs, 2);
                    if (barray == null && logger.isWarningEnabled()) {
                        logger.warning("Both prop_value and prop_value_ext are null");
                    }
                    e = new String(barray, "US-ASCII");
                }
                if (!e.equals(expression)) break block6;
                int lastDotPos = ctColPropName.lastIndexOf(46);
                string = ctColPropName.substring(lastDotPos + 1);
            }
        }
        catch (Throwable throwable) {
            this.dbSession.close(rs, pstmt);
            throw throwable;
        }
        {
            block6: {
                this.dbSession.close(rs, pstmt);
                return string;
            }
            continue;
        }
        this.dbSession.close(rs, pstmt);
        return null;
    }
}

