/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.dml;

import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.dml.CacheRegistrationCache;
import chemaxon.jchem.cartridge.dml.CacheRegistrationSnapshot;
import chemaxon.jchem.cartridge.dml.UpdateLogBuffer;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.util.JCartLogger;
import chemaxon.jchem.db.UpdateLogCache;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class UpdateLogProcessor {
    private static final HashMap cacheRegistrationCachesByJcpt = new HashMap();
    private static final HashMap updateLogBuffersByLogTableName = new HashMap();
    private static final JCartLogger logger = JCartLogger.getLogger(UpdateLogProcessor.class);
    public static final int BUFFER_SIZE = 10000;

    public void addLog(Connection connection, JCartIndexDescriptor idxDescriptor, byte updateType, int cdId) throws Exception {
        CacheRegistrationCache cacheRegistrationCache = this.getCacheRegistrationCache(idxDescriptor);
        CacheRegistrationSnapshot cacheRegSnapshot = cacheRegistrationCache.getCacheRegistrationSnapshot();
        ArrayList newlyRegisteredCaches = cacheRegSnapshot.getNewlyRegisteredCaches();
        if (newlyRegisteredCaches.size() > 0) {
            this.dumpBuffer(connection, newlyRegisteredCaches);
        }
        String[] allCaches = cacheRegSnapshot.onLineCaches();
        for (int ix = 0; ix < allCaches.length; ++ix) {
            String cacheId = allCaches[ix];
            this.writeBufferNewLogs(connection, idxDescriptor, cacheId, updateType, cdId);
        }
    }

    private CacheRegistrationCache getCacheRegistrationCache(JCartIndexDescriptor idxDescriptor) throws Exception {
        String jcptName = idxDescriptor.getJcptName();
        CacheRegistrationCache cacheRegistrationCache = (CacheRegistrationCache)cacheRegistrationCachesByJcpt.get(jcptName);
        if (cacheRegistrationCache == null) {
            cacheRegistrationCache = new CacheRegistrationCache(JavaStoredProcSession.instance(), jcptName);
            cacheRegistrationCachesByJcpt.put(jcptName, cacheRegistrationCache);
        }
        return cacheRegistrationCache;
    }

    private UpdateLogBuffer getUpdateLogBuffer(JCartIndexDescriptor idxDescriptor) throws Exception {
        String updateLogTableName = idxDescriptor.getUpdateLogTableName();
        UpdateLogBuffer buffer = (UpdateLogBuffer)updateLogBuffersByLogTableName.get(updateLogTableName);
        if (buffer == null) {
            buffer = new UpdateLogBuffer(idxDescriptor.getUpdateLogSeqName());
            updateLogBuffersByLogTableName.put(updateLogTableName, buffer);
        }
        return buffer;
    }

    private void writeBufferNewLogs(Connection connection, JCartIndexDescriptor idxDesc, String cacheId, byte updateType, int cdId) throws Exception {
        this.writeLog(idxDesc, cacheId, UpdateLogCache.createLogInfo(updateType, cdId, true));
        this.getUpdateLogBuffer(idxDesc).storeUpdate(updateType, cdId);
    }

    private void dumpBuffer(Connection connection, ArrayList newlyRegisteredCaches) throws SQLException {
        for (String logTableName : updateLogBuffersByLogTableName.keySet()) {
            UpdateLogBuffer buffer = (UpdateLogBuffer)updateLogBuffersByLogTableName.get(logTableName);
            String updateLogSeqName = buffer.getUpdateLogSeqName();
            this.dumpBufferForLogTable(connection, buffer, logTableName, updateLogSeqName, newlyRegisteredCaches);
        }
    }

    private void dumpBufferForLogTable(Connection connection, UpdateLogBuffer buffer, String logTableName, String updateLogSeqName, ArrayList newlyRegisteredCaches) throws SQLException {
        if (logger.isInfoEnabled()) {
            logger.info("Dumping buffered update logs to log table '" + logTableName + "' for " + newlyRegisteredCaches.size() + " structure caches having recently come on line...");
        }
        PreparedStatement pstmt = UpdateLogProcessor.prepareWriteLog(logTableName, updateLogSeqName);
        try {
            buffer.logsForNewCaches(newlyRegisteredCaches, pstmt);
        }
        catch (SQLException sqlE) {
            JavaStoredProcSession.instance().invalidate(UpdateLogProcessor.createInsertSql(logTableName, updateLogSeqName));
            throw sqlE;
        }
        finally {
            JavaStoredProcSession.instance().close(null, pstmt);
        }
    }

    private static String createInsertSql(String updateLogTableName, String updateLogSeqName) {
        return "INSERT INTO " + updateLogTableName + " (" + "update_id" + "," + "update_info" + "," + "cache_id" + ") values(" + updateLogSeqName + ".NEXTVAL, ?, ?)";
    }

    private static PreparedStatement prepareWriteLog(String logTableName, String updateLogSeqName) throws SQLException {
        String sql = UpdateLogProcessor.createInsertSql(logTableName, updateLogSeqName);
        return JavaStoredProcSession.instance().prepareStatement(sql);
    }

    private void writeLog(JCartIndexDescriptor idxDesc, String cacheId, String updateInfo) throws SQLException {
        String logTableName = idxDesc.getUpdateLogTableName();
        String updateLogSeqName = idxDesc.getUpdateLogSeqName();
        PreparedStatement pstmt = UpdateLogProcessor.prepareWriteLog(logTableName, updateLogSeqName);
        try {
            this.writeLog(pstmt, updateInfo, cacheId);
        }
        catch (SQLException sqlE) {
            JavaStoredProcSession.instance().invalidate(UpdateLogProcessor.createInsertSql(logTableName, updateLogSeqName));
            throw sqlE;
        }
        finally {
            JavaStoredProcSession.instance().close(null, pstmt);
        }
    }

    private void writeLog(PreparedStatement pstmt, String updateInfo, String cacheId) throws SQLException {
        pstmt.setString(1, updateInfo);
        pstmt.setString(2, cacheId);
        pstmt.execute();
    }
}

