/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.importer;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.jchem.cartridge.importer.JccImporterOracleSupport;
import chemaxon.jchem.db.SettingsHandler;
import chemaxon.marvin.io.MPropHandler;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordReader;
import chemaxon.struc.MPropertyContainer;
import chemaxon.util.ConnectionHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class JccImporter {
    private static final Logger logger = Logger.getLogger(JccImporter.class.getName());
    public static final int UPDATE = 0;
    public static final int INSERT = 1;
    public static final int INSERT_WITH_ID = 2;
    int mode;
    Connection con;
    String tableName;
    String idColName;
    String idSeqName;
    PreparedStatement pstmt = null;
    long totalMemoryAt1000 = 0L;
    private ArrayList<Field> activeFieldList = new ArrayList();
    private ArrayList<BLOB> tmpBlobs = new ArrayList();
    private ArrayList<CLOB> tmpClobs = new ArrayList();
    Field[] fields = null;
    private int lastPstmtMode = 0;
    private PreparedStatement getSeqPstmt;

    public JccImporter(Connection conn, int mode, String tableName, String idColName, String idSeqName) throws SQLException {
        this.mode = mode;
        this.con = conn;
        this.tableName = tableName;
        this.idColName = idColName;
        this.idSeqName = idSeqName;
        this.getFieldsFromDB();
    }

    private void getFieldsFromDB() throws SQLException {
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM " + this.tableName + " WHERE 1 = 2");
        ResultSetMetaData rmd = rs.getMetaData();
        int cols = rmd.getColumnCount();
        this.fields = new Field[cols];
        for (int i = 0; i < cols; ++i) {
            Field field = new Field();
            field.name = rmd.getColumnName(i + 1).toUpperCase();
            field.type = rmd.getColumnType(i + 1);
            this.fields[i] = field;
        }
        rs.close();
        stmt.close();
    }

    private PreparedStatement getPstmtForInsert() throws SQLException {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("INSERT INTO ");
        sb.append(this.tableName);
        sb.append(" (\n" + this.idColName);
        String values = this.idSeqName + ".nextval";
        for (int x = 0; x < this.activeFieldList.size(); ++x) {
            Field field = this.activeFieldList.get(x);
            if (values.length() > 0) {
                sb.append(",\n");
                values = values + ",";
            }
            sb.append(field.name);
            values = values + "?";
        }
        sb.append(") ");
        sb = sb.append("VALUES (" + values + ")");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("INSERT SQL: " + sb.toString());
        }
        return this.con.prepareStatement(sb.toString());
    }

    private void closeAndPrepareIfNeeded() throws SQLException {
        boolean pstmtNeeded = false;
        if (this.pstmt == null || this.lastPstmtMode != this.mode) {
            pstmtNeeded = true;
        }
        this.lastPstmtMode = this.mode;
        if (this.pstmt != null && pstmtNeeded) {
            this.pstmt.close();
        }
        if (pstmtNeeded) {
            this.pstmt = this.getPstmtForInsert();
        }
    }

    private Field getField(String name) throws SQLException {
        name = name.toUpperCase();
        for (int x = 0; x < this.fields.length; ++x) {
            Field field = this.fields[x];
            if (!field.name.equals(name)) continue;
            return field;
        }
        throw new SQLException("ERROR: field \"" + name + "\" is not " + "present in table \"" + this.tableName + "\".");
    }

    private void setValuesForPstmt() throws SQLException, IOException {
        int pos = 0;
        for (int x = 0; x < this.activeFieldList.size(); ++x) {
            Field field = this.activeFieldList.get(x);
            ++pos;
            Object value = field.value;
            int type = field.type;
            if (value == null) {
                this.pstmt.setNull(pos, type);
                continue;
            }
            if (type == 2004) {
                byte[] bytes = value instanceof String ? ((String)value).getBytes() : (byte[])value;
                if (bytes.length > 2000) {
                    BLOB blob = JccImporterOracleSupport.getTmpBLOB(this.con, bytes);
                    this.tmpBlobs.add(blob);
                    this.pstmt.setBlob(pos, (Blob)blob);
                    continue;
                }
                this.pstmt.setBytes(pos, bytes);
                continue;
            }
            if (type == 2005) {
                String stringValue = (String)value;
                if (stringValue.length() > 32766) {
                    CLOB clob = JccImporterOracleSupport.getTmpCLOB(this.con, stringValue);
                    this.tmpClobs.add(clob);
                    this.pstmt.setClob(pos, (Clob)clob);
                    continue;
                }
                this.pstmt.setString(pos, stringValue);
                continue;
            }
            if (type == -4 || type == -2) {
                byte[] data = null;
                data = value instanceof String ? ((String)value).getBytes() : (byte[])value;
                this.pstmt.setBinaryStream(pos, (InputStream)new ByteArrayInputStream(data), data.length);
                continue;
            }
            this.pstmt.setObject(pos, value);
        }
    }

    public void setColValue(String colName, Object value) throws SQLException {
        Field f = this.getField(colName);
        f.value = value;
        this.activeFieldList.add(f);
    }

    public void execute() throws SQLException, IOException {
        this.closeAndPrepareIfNeeded();
        this.setValuesForPstmt();
        this.pstmt.executeUpdate();
        this.cleanUpTmpLobs();
        this.activeFieldList.clear();
    }

    private void cleanUpTmpLobs() throws SQLException {
        for (CLOB c : this.tmpClobs) {
            c.freeTemporary();
        }
        this.tmpClobs.clear();
        for (BLOB b : this.tmpBlobs) {
            b.freeTemporary();
        }
        this.tmpBlobs.clear();
    }

    public void close() throws SQLException {
        if (this.pstmt != null) {
            this.pstmt.close();
        }
        if (this.getSeqPstmt != null) {
            this.getSeqPstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long mainUc(String[] args) throws Throwable {
        String driverClassName = "oracle.jdbc.OracleDriver";
        String url = null;
        String login = null;
        String password = null;
        String tableName = null;
        String idColName = null;
        String idSeqName = null;
        String structColName = null;
        String fileName = null;
        String fieldToColMapString = null;
        boolean sqlTrace = false;
        long requestedRecordCount = Long.MAX_VALUE;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("--driver")) {
                driverClassName = args[++i];
                continue;
            }
            if (arg.equals("--url")) {
                url = args[++i];
                continue;
            }
            if (arg.equals("--login") || arg.equals("-l")) {
                login = args[++i];
                continue;
            }
            if (arg.equals("--password") || arg.equals("-p")) {
                password = args[++i];
                continue;
            }
            if (arg.equals("--inputfile")) {
                fileName = args[++i];
                continue;
            }
            if (arg.equals("--field-col-map")) {
                fieldToColMapString = args[++i];
                continue;
            }
            if (arg.equals("--table")) {
                tableName = args[++i];
                continue;
            }
            if (arg.equals("--pk-col")) {
                idColName = args[++i];
                continue;
            }
            if (arg.equals("--pk-seq")) {
                idSeqName = args[++i];
                continue;
            }
            if (arg.equals("--struct-col")) {
                structColName = args[++i];
                continue;
            }
            if (arg.equals("--record-count")) {
                requestedRecordCount = Long.parseLong(args[++i]);
                continue;
            }
            if (arg.equals("--sql-trace")) {
                sqlTrace = true;
                continue;
            }
            throw new IllegalArgumentException(args[i]);
        }
        if (structColName == null) {
            structColName = "structure";
        }
        HashMap<String, String> fieldToColMap = new HashMap<String, String>();
        if (fieldToColMapString != null) {
            StringTokenizer stzer = new StringTokenizer(fieldToColMapString, ";");
            while (stzer.hasMoreTokens()) {
                String mapItem = stzer.nextToken();
                int esIdx = mapItem.indexOf(61);
                String f = mapItem.substring(0, esIdx);
                String c = mapItem.substring(esIdx + 1);
                fieldToColMap.put(f, c);
            }
        }
        Throwable error = null;
        long recordCount = 0L;
        Connection conn = JccImporter.getConnection(driverClassName, url, login, password);
        try {
            if (sqlTrace) {
                Statement stmt = conn.createStatement();
                try {
                    stmt.execute("alter session set events '10046 trace name context forever, level 12' zzyzz");
                }
                finally {
                    stmt.close();
                }
            }
            String[] idColSeq = JccImporter.checkCreateTable(conn, tableName, idColName, idSeqName, structColName);
            idColName = idColSeq[0];
            idSeqName = idColSeq[1];
            long start = System.currentTimeMillis();
            JccImporter jcimp = new JccImporter(conn, 1, tableName, idColName, idSeqName);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileName));
            MRecordReader recordReader = MFileFormatUtil.createRecordReader(is, null);
            long tt1 = 0L;
            long tt2 = 0L;
            long t1 = System.nanoTime();
            MRecord rec = recordReader.nextRecord();
            while (rec != null && recordCount < requestedRecordCount) {
                String[] keys;
                String header = recordReader.getHeaderAsString();
                String footer = recordReader.getFooterAsString();
                StringBuffer source = new StringBuffer();
                if (header != null) {
                    source.append(header);
                }
                source.append(rec.getString());
                if (footer != null) {
                    source.append(footer);
                }
                jcimp.setColValue(structColName, source.toString());
                MPropertyContainer propContainer = rec.getPropertyContainer();
                for (String key : keys = propContainer.getKeys()) {
                    String colName = (String)fieldToColMap.get(key);
                    if (colName == null) continue;
                    String value = MPropHandler.convertToString(propContainer, key);
                    jcimp.setColValue(colName, value);
                }
                long t2 = System.nanoTime();
                jcimp.execute();
                long t3 = System.nanoTime();
                tt1 += t2 - t1;
                tt2 += t3 - t2;
                if (++recordCount % 1000L == 0L) {
                    System.err.println(recordCount + "[" + tt1 / 1000000000L + ", " + tt2 / 1000000000L + "], ");
                    tt1 = 0L;
                    tt2 = 0L;
                }
                if (recordCount % 10000L == 0L) {
                    conn.commit();
                }
                t1 = System.nanoTime();
                rec = recordReader.nextRecord();
            }
            conn.commit();
            long stop = System.currentTimeMillis();
            System.out.println("Took " + (stop - start) / 1000L + " seconds to import " + fileName + " into " + login + "." + tableName);
        }
        catch (Throwable throwable) {
            error = throwable;
            return (long)error;
        }
        finally {
            try {
                conn.close();
            }
            finally {
                if (error != null) {
                    throw error;
                }
            }
        }
        return recordCount;
    }

    private static String[] checkCreateTable(Connection conn, String tableName, String idColName, String idSeqName, String structColName) throws SQLException {
        String sql = "select count(*) from " + tableName + " where 1 = 2";
        Statement stmt = conn.createStatement();
        try {
            stmt.execute(sql);
            if (idColName == null) {
                idColName = "id";
                if (idSeqName == null) {
                    idSeqName = tableName + "_pksq";
                }
            }
            String[] stringArray = new String[]{idColName, idSeqName};
            return stringArray;
        }
        catch (SQLException sqlException) {
            if (sqlException.getErrorCode() == 942) {
                idSeqName = JccImporter.createSequence(conn, tableName, idSeqName);
                idColName = JccImporter.createTable(conn, tableName, idColName, structColName);
                String[] stringArray = new String[]{idColName, idSeqName};
                return stringArray;
            }
            throw sqlException;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createSequence(Connection conn, String tableName, String idSeqName) throws SQLException {
        if (idSeqName == null) {
            idSeqName = tableName + "_pksq";
        }
        String sql = "create sequence " + idSeqName;
        Statement stmt = conn.createStatement();
        try {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Creating sequence: " + sql);
            }
            stmt.execute(sql);
        }
        finally {
            stmt.close();
        }
        return idSeqName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createTable(Connection conn, String tableName, String idColName, String structColName) throws SQLException {
        if (idColName == null) {
            idColName = "id";
        }
        String sql = "create table " + tableName + " (" + idColName + " number primary key, " + structColName + " clob) lob(" + structColName + ") store as (cache)";
        Statement stmt = conn.createStatement();
        try {
            stmt.execute(sql);
        }
        finally {
            stmt.close();
        }
        return idColName;
    }

    private static Connection getConnection(String driverClassName, String url, String login, String password) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        SettingsHandler sh = new SettingsHandler();
        Properties settings = sh.getSettings();
        if (url != null) {
            settings.put("connection.jdbcUrl", url);
        }
        if (driverClassName != null) {
            settings.put("connection.jdbcDriver", driverClassName);
        }
        if (login != null) {
            settings.put("connection.login", login);
        }
        if (password != null) {
            settings.put("connection.password", password);
        }
        ConnectionHandler conh = new ConnectionHandler();
        conh.loadValuesFromProperties(settings);
        conh.connectToDatabase();
        Connection conn = conh.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    public static void main(String[] args) {
        try {
            System.out.println(JccImporter.mainUc(args));
        }
        catch (Throwable tbl) {
            tbl.printStackTrace();
            System.exit(1);
        }
    }

    public static class Field {
        String name;
        int type;
        Object value;
    }
}

