/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.importer;

import chemaxon.jchem.cartridge.importer.JccImporter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class JccImporterOracleSupport {
    public static CLOB getTmpCLOB(Connection con, String clobData) throws SQLException, IOException {
        CLOB tempClob = null;
        tempClob = CLOB.createTemporary((Connection)con, (boolean)true, (int)10);
        tempClob.open(1);
        Writer tempClobWriter = tempClob.setCharacterStream(1L);
        tempClobWriter.write(clobData);
        tempClobWriter.flush();
        tempClobWriter.close();
        tempClob.close();
        return tempClob;
    }

    public static BLOB getTmpBLOB(Connection con, byte[] blobData) throws SQLException, IOException {
        BLOB tempBlob = null;
        tempBlob = BLOB.createTemporary((Connection)con, (boolean)true, (int)10);
        tempBlob.open(1);
        OutputStream out = tempBlob.setBinaryStream(1L);
        out.write(blobData);
        out.flush();
        out.close();
        tempBlob.close();
        return tempBlob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PreparedStatement updateBigLOBs(Connection con, PreparedStatement pstmt, ArrayList bigLOBs, String tableName, String idColName, Object id) throws SQLException, IOException {
        block18: {
            Connection retrievedConnection = null;
            do {
                if (retrievedConnection == null) continue;
                con = retrievedConnection;
            } while ((retrievedConnection = con.getMetaData().getConnection()) != con);
            boolean prevAutoCommit = con.getAutoCommit();
            con.setAutoCommit(false);
            if (pstmt == null) {
                pstmt = JccImporterOracleSupport.createPreparedStatement(con, bigLOBs, tableName, idColName);
            }
            pstmt.setObject(1, id);
            ResultSet rs = pstmt.executeQuery();
            try {
                if (rs.next()) {
                    for (int x = 0; x < bigLOBs.size(); ++x) {
                        JccImporter.Field field = (JccImporter.Field)bigLOBs.get(x);
                        OutputStream outstream = null;
                        if (field.type == 2005) {
                            CLOB clob = ((OracleResultSet)rs).getCLOB(x + 1);
                            clob.open(1);
                            try {
                                Writer writer = clob.getCharacterOutputStream();
                                String str = null;
                                if (field.value instanceof byte[]) {
                                    str = new String((byte[])field.value);
                                    writer.write(str, 0, str.length());
                                } else if (field.value instanceof String) {
                                    str = (String)field.value;
                                    writer.write(str, 0, str.length());
                                } else if (field.value instanceof Clob) {
                                    Clob clobVal = (Clob)field.value;
                                    Reader reader = clobVal.getCharacterStream();
                                    int read = 0;
                                    char[] buffer = new char[4096];
                                    while ((read = reader.read(buffer)) != -1) {
                                        writer.write(buffer, 0, read);
                                    }
                                }
                                writer.flush();
                                writer.close();
                                continue;
                            }
                            finally {
                                clob.close();
                            }
                        }
                        BLOB blob = ((OracleResultSet)rs).getBLOB(x + 1);
                        outstream = blob.getBinaryOutputStream();
                        byte[] bytes = null;
                        bytes = field.value instanceof String ? ((String)field.value).getBytes() : (byte[])field.value;
                        outstream.write(bytes);
                        outstream.flush();
                        outstream.close();
                    }
                    break block18;
                }
                throw new SQLException("ERROR: JChem could not set LOB values in table " + tableName + " cd_id=" + id);
            }
            finally {
                rs.close();
                if (prevAutoCommit) {
                    con.setAutoCommit(true);
                }
            }
        }
        return pstmt;
    }

    private static PreparedStatement createPreparedStatement(Connection con, ArrayList bigLOBs, String tableName, String idColName) throws SQLException {
        String sql = "select ";
        int count = 0;
        for (int x = 0; x < bigLOBs.size(); ++x) {
            JccImporter.Field field = (JccImporter.Field)bigLOBs.get(x);
            if (count++ != 0) {
                sql = sql + ",";
            }
            sql = sql + field.name;
        }
        sql = sql + " from " + tableName + " where " + idColName + "= ? for update";
        return con.prepareStatement(sql);
    }
}

