/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install;

import chemaxon.jchem.cartridge.dbsession.ClientSideSession;
import chemaxon.jchem.cartridge.install.IdxUpgradeInfo;
import chemaxon.jchem.cartridge.install.schema.Schema;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IndexRebuilder {
    private static final Logger logger = Logger.getLogger(IndexRebuilder.class.getName());
    public static final int IDXREBUILD_NONE = 0;
    public static final int IDXREBUILD_ASK = 1;
    public static final int IDXREBUILD_ALL = 2;
    private Schema schema;
    private Iterator<String[]> idxIterator;

    public IndexRebuilder(Schema schema) throws Exception {
        this.schema = schema;
        this.idxIterator = schema.getJcIndexes(null).iterator();
    }

    public IdxUpgradeInfo next() throws Exception {
        while (this.idxIterator.hasNext()) {
            String idxPartName;
            String[] nextIdx = this.idxIterator.next();
            String idxSchema = nextIdx[0];
            String idxName = nextIdx[1];
            String string = idxPartName = nextIdx.length == 3 ? nextIdx[2] : null;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("idxSchema=" + idxSchema + ", idxName=" + idxName + ", idxPartName=" + idxPartName);
            }
            ClientSideSession dbSession = new ClientSideSession(this.schema.getConnection(), this.schema.getJccOwnerName());
            try {
                JCartIndexDescriptor idxDesc = JCartIndexDescriptor.get(dbSession, idxSchema, idxName, idxPartName);
                if (idxDesc.getIdxSubType() == 1) {
                    if (!logger.isLoggable(Level.INFO)) continue;
                    logger.info(idxDesc.getIndexSchemaName() + "." + idxDesc.getIndexName() + " is of fingerprint subtype.");
                    continue;
                }
                if (idxDesc.getIdxCompatibility() < 0) {
                    return new IdxUpgradeInfo(idxDesc, true);
                }
                if (idxDesc.getIdxCompatibility() == 0) {
                    return new IdxUpgradeInfo(idxDesc, false);
                }
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.info("Version of index data " + idxDesc.getIndexSchemaName() + "." + idxDesc.getIndexName() + " is newer than the current index version.");
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) continue;
                logger.log(Level.SEVERE, "Error while processing index: " + idxSchema + "." + idxName + (idxPartName == null ? "" : idxPartName), e);
            }
        }
        return null;
    }

    public void rebuildIndex(String idxName, String partitionName, boolean skipAutoCalcCt) throws SQLException {
        this.schema.reconnect();
        String partitionClause = partitionName == null ? "" : " partition " + partitionName;
        String sql = "alter index " + idxName + " rebuild " + partitionClause + " parameters('upgradeOnly=y" + (skipAutoCalcCt ? ",skipAutoCalcCt=y" : "") + "')";
        if (logger.isLoggable(Level.INFO)) {
            logger.info(sql + "...");
        }
        this.schema.executeSql(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAutoCalcCts(JCartIndexDescriptor idxDesc) throws SQLException {
        ArrayList<String> l = new ArrayList<String>();
        String sql = "select * from TABLE(" + idxDesc.getDbSession().getJccOwner() + ".jchem_core_pkg.jctf_autocalccts('" + idxDesc.getIndexSchemaName() + "', '" + idxDesc.getIndexName() + "', " + (idxDesc.getIndexPartitionName() == null ? "null" : "'" + idxDesc.getIndexPartitionName() + "'") + "))";
        Statement stmt = this.schema.getConnection().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                l.add(rs.getString(1));
            }
        }
        finally {
            stmt.close();
        }
        return l;
    }
}

