/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install;

import chemaxon.jchem.cartridge.install.ConnectUtil;
import chemaxon.jchem.cartridge.install.InstallUtil;
import chemaxon.jchem.cartridge.install.Installer;
import chemaxon.jchem.cartridge.install.JccConfigUtilCmdLine;
import chemaxon.jchem.cartridge.install.ManualUpgradeNeededException;
import chemaxon.jchem.cartridge.install.ServerCtrl;
import chemaxon.jchem.cartridge.install.WindowsServiceInstaller;
import chemaxon.jchem.cartridge.install.params.ConfigurationParameter;
import chemaxon.jchem.cartridge.install.params.InstallParameters;
import chemaxon.util.RuntimeUtils;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstallCmdLine {
    private static final Logger logger = Logger.getLogger(InstallCmdLine.class.getName());
    public static final boolean PROMPT_FOR_WSERVICE_PARAMS = true;
    public static final boolean PROMPT_FOR_JDBC_DRIVER_PATH = false;
    protected String unattendedParamFile;
    protected ArrayList<String> tasksLeftForUser = new ArrayList();
    protected String oracleHome;
    protected boolean skipPrivilegeChecks;
    protected boolean jcServerOnly;
    protected boolean serviceOnly;
    protected JccConfigUtilCmdLine cmdLine = new JccConfigUtilCmdLine();
    private ServerCtrl serverCtrl;
    private boolean userCancelled;

    public InstallCmdLine(String[] args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--oracle-home")) {
                this.oracleHome = args[++i];
                continue;
            }
            if (args[i].equals("--unattended-params")) {
                this.unattendedParamFile = args[++i];
                continue;
            }
            if (args[i].equals("--jcserver-only")) {
                this.jcServerOnly = true;
                continue;
            }
            if (args[i].equals("--service-only")) {
                this.serviceOnly = true;
                continue;
            }
            if (args[i].equals("--skip-privilege-checks")) {
                this.skipPrivilegeChecks = true;
                continue;
            }
            throw new IllegalArgumentException("Invalid argument: " + args[i]);
        }
        if (this.jcServerOnly && this.unattendedParamFile != null) {
            throw new IllegalArgumentException("JChem Server-only installation is not supported in the unattended mode.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() throws Exception {
        InstallParameters ip = new InstallParameters();
        ip.skipPrivilegeChecks = this.skipPrivilegeChecks;
        this.serverCtrl = new ServerCtrl(ip);
        try {
            if (this.unattendedParamFile == null) {
                this.getParamsInteractively(ip);
                if (this.confirmUserInput("Install")) {
                    this.install(ip);
                    this.installJChemServerAsAService(ip);
                } else {
                    this.userCancelled = true;
                }
            } else {
                ip.loadUiFromFiles(this.unattendedParamFile);
                this.checkParams(ip);
                ip.store(ServerCtrl.getConfigFilePath());
                this.serverCtrl.startCheckPort();
                this.install(ip);
            }
            ip.store(ServerCtrl.getConfigFilePath());
        }
        finally {
            this.stopJChemServer();
        }
    }

    protected void initOracleHome(InstallParameters ip) throws IOException, InterruptedException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        ip.oracleHome.setUserInput(this.oracleHome);
        ip.checkOracleHome();
        ConnectUtil.initInstance(ip.oracleHome.getUserInput());
        ConnectUtil.initInstance(this.oracleHome);
    }

    private void checkParams(InstallParameters ip) throws Exception {
        File jdbc;
        if (this.oracleHome == null || this.oracleHome.trim().length() == 0) {
            this.oracleHome = ip.oracleHome.getUserInput();
        } else {
            ip.oracleHome.setUserInput(this.oracleHome);
        }
        ip.checkOracleHome();
        if (ip.jdbcDriver.hasUserInput() && !(jdbc = new File(ip.jdbcDriver.getUserInput())).isFile()) {
            throw new IllegalArgumentException("The file " + jdbc.getCanonicalPath() + " doesn't exist.");
        }
        if (ip.dbaLogin.hasUserInput()) {
            ip.checkLogin(ip.dbaLogin, ip.dbaPassword);
        } else {
            if (!ip.jccOwnerLogin.hasUserInput()) {
                throw new IllegalArgumentException("You need to specify 'jcart.owner.login', if you don't specify DBA");
            }
            ip.checkTnsName(ip.jccOwnerLogin, ip.jccOwnerPassword);
            ip.checkLogin(ip.jccOwnerLogin, ip.jccOwnerPassword);
            if (ip.basicJccRole.hasUserInput() && !ip.doesBasicJccRoleExist()) {
                throw new IllegalArgumentException("Basic JCC role is set to " + ip.basicJccRole.getUserInput() + ", but the role doesn't exist " + "and we have no DBA login to set it up!");
            }
        }
    }

    private void install(InstallParameters ip) throws Exception {
        if (this.jcServerOnly) {
            return;
        }
        Installer installer = new Installer(ip);
        installer.install();
    }

    protected void getParamsInteractively(InstallParameters ip) throws Exception {
        this.getOracleParamsInteractively(ip);
        this.getCheckJChemServerParamsInteractively(ip);
        this.checkStartNewJChemServer(ip, false);
        if (!this.jcServerOnly) {
            this.getCheckDbaLoginInteractively(ip);
            this.getCheckJCartOwnerLoginInteractively(ip);
            this.checkTnsNameInteractively(ip);
            this.getBasicJccRoleNameInteractively(ip);
        }
    }

    protected void getOracleParamsInteractively(InstallParameters ip) throws IOException, InterruptedException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        if (!this.jcServerOnly) {
            this.initOracleHome(ip);
        }
        this.cmdLine.promptForInput(ip.oracleHost);
        while (true) {
            try {
                this.cmdLine.promptForInput(ip.oracleListenerPort);
                Integer.parseInt(ip.oracleListenerPort.getUserInput());
            }
            catch (NumberFormatException nfe) {
                InstallCmdLine.warn(ip.oracleListenerPort.getUserInput() + " is not a number");
                continue;
            }
            break;
        }
        this.cmdLine.promptForInput(ip.oracleInstanceName);
        if (ip.useSqlPlus() && !this.jcServerOnly) {
            ip.tnsName.setDefaultValue(ip.oracleInstanceName.getUserInput());
            if (ip.sqlPlusMajorVersion < 10) {
                this.cmdLine.promptForInput(ip.tnsName);
            } else {
                ip.tnsName.setUserInput(ip.tnsName.getDefaultValue());
            }
        }
    }

    protected void getCheckJChemServerParamsInteractively(InstallParameters ip) throws Exception {
        this.cmdLine.promptForInput(ip.jchemServerHost);
        this.cmdLine.promptForInput(ip.jchemServerPort);
        if (ip.isJCServerLocal()) {
            this.cmdLine.promptForInput(ip.jchemServerMaxmem);
        }
        this.getStructureCacheId(ip);
        ip.store(ServerCtrl.getConfigFilePath());
    }

    protected void getStructureCacheId(InstallParameters ip) throws Exception {
        this.cmdLine.promptForInput(ip.structureCacheId);
    }

    protected void getCheckDbaLoginInteractively(InstallParameters ip) throws IOException, SQLException {
        this.cmdLine.promptForInput(ip.dbaLogin);
        while (ip.dbaLogin.hasUserInput()) {
            JccConfigUtilCmdLine.promptForPassword(ip.dbaPassword);
            try {
                ip.checkDbaLogin();
                break;
            }
            catch (IllegalArgumentException iae) {
                InstallCmdLine.warn("Error: " + iae.getMessage());
                this.cmdLine.promptForInput(ip.dbaLogin);
            }
        }
    }

    protected void getCheckJCartOwnerLoginInteractively(InstallParameters ip) throws SQLException, IOException {
        while (true) {
            try {
                this.cmdLine.promptCheckInput(ip.jccOwnerLogin);
                JccConfigUtilCmdLine.promptForPassword(ip.jccOwnerPassword);
                ip.checkJCartOwnerLogin();
                return;
            }
            catch (IllegalArgumentException iae) {
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINEST, " - ", iae);
                if (!this.handleJCartOwnerLoginCheckFailure(ip, iae)) continue;
                return;
            }
            break;
        }
    }

    protected boolean handleJCartOwnerLoginCheckFailure(InstallParameters ip, IllegalArgumentException iae) throws SQLException {
        boolean loginFault;
        Throwable cause = iae.getCause();
        boolean bl = loginFault = cause instanceof SQLException && ((SQLException)cause).getErrorCode() == 1017;
        if (loginFault && ip.dbaLogin.hasUserInput()) {
            if (InstallUtil.userExists(ip, ip.jccOwnerLogin)) {
                InstallCmdLine.err("Wrong password");
                return false;
            }
            InstallCmdLine.warn("Schema " + ip.jccOwnerLogin.getUserInput() + " doesn't exists. It will be created");
            return true;
        }
        InstallCmdLine.err(iae.getMessage());
        return false;
    }

    protected void checkTnsNameInteractively(InstallParameters ip) throws IOException {
        if (!ip.useSqlPlus()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("SQL*Plus is not used, skip checking TNS name");
            }
            return;
        }
        ConfigurationParameter login = ip.dbaLogin;
        ConfigurationParameter password = ip.dbaPassword;
        if (!login.hasUserInput()) {
            login = ip.jccOwnerLogin;
            password = ip.jccOwnerPassword;
        }
        while (true) {
            try {
                this.cmdLine.promptForInput(ip.tnsName);
                ip.checkTnsName(login, password);
            }
            catch (IllegalArgumentException iae) {
                InstallCmdLine.warn("The TNS name " + ip.tnsName.getUserInput() + " doesn't work with sqlplus. " + "Please, specify another one.");
                continue;
            }
            break;
        }
    }

    protected void getBasicJccRoleNameInteractively(InstallParameters ip) throws SQLException, IOException {
        ConfigurationParameter param = ConfigurationParameter.createYesNo("Do you want to use a role for basic JChem Cartridge user privileges? (This role will be granted to " + ip.jccOwnerLogin.getUserInput() + " WITH ADMIN OPTION. " + "DataVault users, please, answer with with \"n\")", true);
        this.cmdLine.promptForInput(param);
        if (!param.getUserInput().equals("y")) {
            return;
        }
        while (true) {
            this.cmdLine.promptForInput(ip.basicJccRole);
            if (ip.doesBasicJccRoleExist()) break;
            if (ip.hasDbaWithCreateRolePrivs()) {
                InstallCmdLine.warn("Role " + ip.basicJccRole.getUserInput() + " doesn't exist, it will be created");
                break;
            }
            InstallCmdLine.warn("Role " + ip.basicJccRole.getUserInput() + " doesn't exist and you didn't specify " + "a DBA login that could be used to create it. " + "Please, specify an existing role " + "to be used for JChem Cartridge users.");
        }
    }

    public void checkStartNewJChemServer(InstallParameters ip, boolean stickWithCurrentLocator) throws Exception {
        this.checkStartNewJChemServer(ip, stickWithCurrentLocator, true);
    }

    public void checkStartNewJChemServer(InstallParameters ip, boolean stickWithCurrentLocator, boolean interactive) throws Exception {
        String msgTryingToStartServer = "Trying to start JChem Server...";
        String msgNotLocalServer = "JChem Server is configured to run on " + ip.jchemServerHost.getUserInput() + ". Please, start JChem Server on " + ip.jchemServerHost.getUserInput() + ". Press <Enter>, when started.";
        String verCode = InstallUtil.checkJChemServer(ip.getRmiLocator());
        int attCount = 0;
        while (true) {
            if (attCount++ > 120) {
                throw new RuntimeException("Has been attempting too many times to locate server.");
            }
            if (verCode == InstallUtil.RUNNING_JCSRV_NONE) {
                this.createFreshServerCtrl(ip);
                if (ip.isJCServerLocal()) {
                    InstallCmdLine.msg(msgTryingToStartServer);
                    this.serverCtrl.start();
                    if (this.serverCtrl.isRunning()) {
                        return;
                    }
                    throw new RuntimeException("An error occurred, while starting JChem Server. Please, consult the JChem Server logs for more information.");
                }
                InstallCmdLine.msg(msgNotLocalServer);
                JccConfigUtilCmdLine.readStdIn();
            } else {
                if (verCode == "") {
                    return;
                }
                if (verCode == InstallUtil.RUNNING_JCSRV_UNKNOWN_SERVICE) {
                    String msgUnknownService = "An unknown service is running at " + ip.getRmiLocator() + ".";
                    if (stickWithCurrentLocator) {
                        throw new IllegalArgumentException(msgUnknownService + " Please, specify another " + "hostname:port combination.");
                    }
                    InstallCmdLine.msg(msgUnknownService);
                    if (ip.isJCServerLocal()) {
                        InstallCmdLine.msg(msgTryingToStartServer);
                        this.createFreshServerCtrl(ip);
                        int port = this.serverCtrl.startCheckPort();
                        if (this.serverCtrl.isRunning()) {
                            InstallCmdLine.msg("JChem Server has been started at port " + ip.jchemServerPort.getUserInput() + ".");
                        }
                    } else {
                        InstallCmdLine.msg(msgNotLocalServer);
                    }
                } else {
                    String errorMessage = "Incompatible JChem Server version is running at " + ip.getRmiLocator() + ": " + verCode;
                    if (interactive) {
                        InstallCmdLine.warn(errorMessage);
                        InstallCmdLine.warn("Please, stop the incompatible JChem Server version and press <Enter>, when stopped.");
                        JccConfigUtilCmdLine.readStdIn();
                    } else {
                        throw new IllegalArgumentException(errorMessage);
                    }
                }
            }
            verCode = InstallUtil.checkJChemServer(ip.getRmiLocator());
        }
    }

    private void createFreshServerCtrl(InstallParameters ip) throws IOException, InterruptedException {
        this.stopJChemServer();
        this.serverCtrl = new ServerCtrl(ip);
    }

    protected void stopJChemServer() throws IOException, InterruptedException {
        if (this.serverCtrl != null) {
            this.serverCtrl.stop();
        }
    }

    private void installJChemServerAsAService(InstallParameters ip) throws IOException, InterruptedException {
        if (!ip.isJCServerLocal()) {
            return;
        }
        String q = "Do you want to install JChemServer as an operating system service?";
        if (RuntimeUtils.isWindows() && this.cmdLine.promptForYesNo(q, true)) {
            while (true) {
                this.cmdLine.promptForInput(ip.serviceName);
                try {
                    ip.checkServiceName();
                }
                catch (IllegalArgumentException iae) {
                    ip.serviceName.setUserInput(null);
                    InstallCmdLine.msg(iae.getMessage());
                    continue;
                }
                break;
            }
            this.cmdLine.promptForInput(ip.serviceDisplayName);
            WindowsServiceInstaller wsi = new WindowsServiceInstaller(ip);
            wsi.installService();
            InstallCmdLine.msg("Service successfully created. Check the settings in the \"Services\" Microsoft Management Console");
        }
    }

    protected boolean confirmUserInput(String message) throws IOException {
        System.out.println("\n\nYou have entered the following parameters:");
        System.out.println("==========================================\n");
        for (ConfigurationParameter pp : this.cmdLine.getAllUserInputs()) {
            if (pp.isPassword()) continue;
            System.out.println(pp.getPromptMessage() + ": " + pp.getUserInput());
        }
        String q = "Proceed with the " + message + "?";
        return this.cmdLine.promptForYesNo(q, false);
    }

    protected void printTasksLeftForUser() {
        InstallCmdLine.warn("You have to manually perform the following tasks:");
        for (int i = 0; i < this.tasksLeftForUser.size(); ++i) {
            String task = this.tasksLeftForUser.get(i);
            System.out.println("\n" + (i + 1) + ". " + task);
        }
    }

    public static void warn(String w) {
        System.out.println("\n====> " + w);
    }

    public static void err(String w) {
        System.out.println("\n====> ERROR: " + w);
    }

    public static void msg(String w) {
        System.out.println("\n====> " + w);
    }

    public static void main(String[] args) {
        try {
            InstallCmdLine i = new InstallCmdLine(args);
            i.install();
            String statusMessage = i.userCancelled ? "USER CANCELLED THE INSTALLATION." : "INSTALL SUCCESSFULLY COMPLETED.";
            if (i.tasksLeftForUser.size() == 0) {
                System.out.println("\n\n================================\n" + statusMessage + "\n================================\n\n");
            } else {
                System.out.println("\n\nInstall completed with tasks left to be manually performed:");
                i.printTasksLeftForUser();
            }
        }
        catch (ManualUpgradeNeededException manu) {
            InstallCmdLine.err(manu.getMessage());
            System.exit(1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(2);
        }
    }
}

