/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install;

import chemaxon.jchem.cartridge.install.params.ConfigurationParameter;
import chemaxon.jchem.cartridge.install.params.InstallParameters;
import chemaxon.jchem.cartridge.install.schema.Schema;
import chemaxon.jchem.cartridge.rmi.VersionMismatchException;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.rmi.client.RmiServerDesc;
import chemaxon.util.RuntimeUtils;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.rmi.ConnectIOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstallUtil {
    private static final Logger logger = Logger.getLogger(InstallUtil.class.getName());
    public static final String RUNNING_JCSRV_NONE = null;
    public static final String RUNNING_JCSRV_CURRENT = "";
    public static final String RUNNING_JCSRV_UNKNOWN_SERVICE = new String("Unknown service");
    static final String JCART_SQL_FILE_NAME = "jchem_cart.sql";

    public static void loadPlSql(String oracleHome, String tnsName, String username, String password, String file) throws IOException, InterruptedException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Loading PL/SQL script " + file + " into " + username + "'s schema...");
        }
        String[] arguments = new String[]{oracleHome + File.separator + "bin" + File.separator + "sqlplus", "-L", username + "/" + password + "@" + tnsName, "@" + file};
        RuntimeUtils.exec(arguments, password);
    }

    public static void dropUser(Schema dbaSchema, Schema targetSchema) throws SQLException {
        targetSchema.disconnect();
        String sql = "drop user " + targetSchema.getUsername() + " cascade";
        dbaSchema.executeSql(sql);
    }

    public static String checkJChemServer(String rmiSrvUrl) throws Exception {
        String retVal = null;
        try {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Checking JChem Server at " + rmiSrvUrl + "...");
            }
            new RmiDirectory(new RmiServerDesc(rmiSrvUrl)).locateBypassCache();
            retVal = RUNNING_JCSRV_CURRENT;
        }
        catch (VersionMismatchException vme) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Exception while locating Directory", vme);
            }
            retVal = vme.getMessage();
        }
        catch (ConnectException ce) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Exception while locating Directory", ce);
            }
            retVal = RUNNING_JCSRV_NONE;
        }
        catch (java.rmi.ConnectException ce) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Exception while locating Directory", ce);
            }
            if (ce.getCause() instanceof ConnectException) {
                retVal = RUNNING_JCSRV_NONE;
            }
            return InstallUtil.checkPreRmiRegistryDirectory(new RmiServerDesc(rmiSrvUrl));
        }
        catch (ConnectIOException cioe) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Exception while locating Directory", cioe);
            }
            return InstallUtil.checkPreRmiRegistryDirectory(new RmiServerDesc(rmiSrvUrl));
        }
        catch (EOFException eofe) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Exception while locating Directory", eofe);
            }
            retVal = RUNNING_JCSRV_UNKNOWN_SERVICE;
        }
        catch (Exception exception) {
            String emsg = exception.getMessage();
            emsg = InstallUtil.hackVersionMismatchMessage(emsg);
            if (emsg.indexOf("JChem version mismatch") != -1) {
                retVal = emsg;
            }
            throw exception;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("returning: " + retVal);
        }
        return retVal;
    }

    private static String checkPreRmiRegistryDirectory(RmiServerDesc rmiServerDesc) throws Exception {
        String retVal = null;
        try {
            RmiDirectory.locateViaSocket(rmiServerDesc, 10000);
            throw new RuntimeException("Pre-RmiRegistry Directory found with same version!");
        }
        catch (VersionMismatchException vme) {
            retVal = vme.getMessage();
        }
        catch (ConnectException ce) {
            retVal = RUNNING_JCSRV_NONE;
        }
        catch (SocketTimeoutException ste) {
            retVal = RUNNING_JCSRV_UNKNOWN_SERVICE;
        }
        catch (StreamCorruptedException sce) {
            retVal = RUNNING_JCSRV_UNKNOWN_SERVICE;
        }
        catch (EOFException eofe) {
            retVal = RUNNING_JCSRV_UNKNOWN_SERVICE;
        }
        catch (Exception exception) {
            String emsg = exception.getMessage();
            emsg = InstallUtil.hackVersionMismatchMessage(emsg);
            if (emsg.indexOf("JChem version mismatch") != -1) {
                retVal = emsg;
            }
            throw exception;
        }
        return retVal;
    }

    private static String hackVersionMismatchMessage(String emsg) {
        return emsg.replaceFirst("in Oracle", "required").replace("RMI", "JChem");
    }

    static void loadJarFileIntoOracle(String oracleHome, String jarfile, Schema schema, boolean useLoadjava) throws IOException, InterruptedException, SQLException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Loading jar file " + jarfile + " into " + schema.getUsername() + "'s schema...");
        }
        if (useLoadjava) {
            String[] arguments = new String[]{oracleHome + File.separator + "bin" + File.separator + "loadjava", "-thin", "-user", schema.getUsername() + "/" + schema.getPassword() + "@" + schema.getHostname() + ":" + schema.getPort() + ":" + schema.getDbinstance(), jarfile};
            RuntimeUtils.exec(arguments);
        } else {
            schema.loadJar(jarfile);
        }
    }

    public static List<String> getJavaPermGrantStmts(String targetUser, String jchemServerHost, String jchemServerPort, int[] databaseVersion) {
        boolean oraver_10gR1 = false;
        if (databaseVersion != null) {
            oraver_10gR1 = databaseVersion[0] == 10 && databaseVersion[1] == 1;
        }
        ArrayList<String> l = new ArrayList<String>();
        targetUser = InstallUtil.trimSYSLogin(targetUser).toUpperCase();
        String socketPerm = "call dbms_java.grant_permission('" + targetUser + "', 'SYS:java.net.SocketPermission', '" + jchemServerHost + ":" + jchemServerPort + "', 'resolve,connect')";
        l.add(socketPerm);
        if (oraver_10gR1) {
            String p1 = "call dbms_java.grant_permission('" + targetUser + "', 'SYS:java.lang.RuntimePermission', " + "'shutdownHooks', '')";
            String p2 = "call dbms_java.grant_permission('" + targetUser + "', 'SYS:java.util.logging.LoggingPermission', " + "'control', '')";
            l.add(p1);
            l.add(p2);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocalAddress(String address) throws IOException {
        boolean[] barr;
        block17: {
            Thread timer;
            block16: {
                barr = new boolean[]{false};
                final ServerSocket ss = new ServerSocket(0);
                timer = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException e) {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, "-", e);
                                }
                            }
                        }
                        finally {
                            block11: {
                                try {
                                    ss.close();
                                }
                                catch (IOException e) {
                                    if (!logger.isLoggable(Level.FINE)) break block11;
                                    logger.log(Level.FINE, "-", e);
                                }
                            }
                        }
                    }
                };
                final CountDownLatch startSignal = new CountDownLatch(1);
                int port = ss.getLocalPort();
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        block6: {
                            try {
                                startSignal.countDown();
                                Socket s = ss.accept();
                                barr[0] = true;
                                s.close();
                            }
                            catch (UnknownHostException e) {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, "-", e);
                                }
                            }
                            catch (IOException e) {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, "-", e);
                                }
                            }
                            catch (Throwable throwable) {
                                if (!logger.isLoggable(Level.SEVERE)) break block6;
                                logger.log(Level.SEVERE, "Error while probing JChem Server host", throwable);
                            }
                        }
                    }
                };
                t.start();
                timer.start();
                try {
                    startSignal.await();
                    Socket s = new Socket(address, port);
                    try {
                        InputStream is = s.getInputStream();
                        int count = is.read();
                        if (count != -1 && logger.isLoggable(Level.WARNING)) {
                            logger.warning("Reading from test socket returned " + count + ", whereas -1 was expected.");
                        }
                    }
                    finally {
                        s.close();
                    }
                }
                catch (NoRouteToHostException nrthe) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "exception", nrthe);
                    }
                    System.err.println("NoRouteToHostException while probing JChem Server host. Assuming firewall.");
                }
                catch (ConnectException ce) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "exception", ce);
                    }
                }
                catch (Throwable throwable) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "error", throwable);
                    }
                    System.err.println(throwable);
                }
                timer.interrupt();
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    if (!logger.isLoggable(Level.FINE)) break block16;
                    logger.log(Level.FINE, "-", e);
                }
            }
            try {
                timer.join();
            }
            catch (InterruptedException e) {
                if (!logger.isLoggable(Level.FINE)) break block17;
                logger.log(Level.FINE, "-", e);
            }
        }
        return barr[0];
    }

    public static Schema createSchema(InstallParameters ip, ConfigurationParameter login, ConfigurationParameter password, boolean isDBA) {
        return new Schema(ip.oracleHost.getUserInput(), Integer.parseInt(ip.oracleListenerPort.getUserInput()), ip.oracleInstanceName.getUserInput(), login.getUserInput(), password.getUserInput(), ip.jccOwnerLogin.getUserInput(), isDBA);
    }

    public static void checkPrivileges(Schema s, String[] privileges) throws SQLException {
        HashSet<String> notFound = new HashSet<String>();
        Set<String> userPrivileges = InstallUtil.getPrivilegesByView(s, "user_sys_privs");
        userPrivileges.addAll(InstallUtil.getPrivilegesByView(s, "role_sys_privs"));
        for (int i = 0; i < privileges.length; ++i) {
            String priv = privileges[i].toUpperCase();
            if (userPrivileges.contains(priv)) continue;
            notFound.add(priv);
        }
        if (notFound.size() > 0) {
            throw new IllegalArgumentException(s.getUsername().toUpperCase() + " doesn't have the following required privilege(s): " + notFound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getPrivilegesByView(Schema s, String privilegView) throws SQLException {
        HashSet<String> privset = new HashSet<String>();
        String sql = "select privilege from " + privilegView;
        Connection conn = s.getConnection();
        PreparedStatement pstmt = conn.prepareStatement(sql);
        try {
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                privset.add(rs.getString(1));
            }
            HashSet<String> hashSet = privset;
            return hashSet;
        }
        finally {
            pstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkJavaPrivilege(Schema s, String typeName, String name, String action) throws SQLException {
        String sql = "select count(*) from user_java_policy where kind = 'GRANT' and type_name = '" + typeName + "' and name like '" + name + "%' and action = '" + action + "' and enabled = 'ENABLED'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("sql=" + sql);
        }
        Statement stmt = s.getConnection().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            rs.next();
            if (rs.getInt(1) < 1) {
                throw new IllegalArgumentException(s.getUsername() + " doesn't have " + typeName + " for " + name + " to " + action);
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean userExists(InstallParameters ip, ConfigurationParameter login) throws SQLException {
        boolean userExists = false;
        Schema dbaSchema = InstallUtil.createSchema(ip, ip.dbaLogin, ip.dbaPassword, true);
        dbaSchema.connect();
        try {
            Statement stmt = dbaSchema.getConnection().createStatement();
            String sql = "select count(*) from dba_users where username = '" + login.getUserInput().toUpperCase() + "'";
            ResultSet rs = stmt.executeQuery(sql);
            rs.next();
            userExists = rs.getInt(1) > 0;
        }
        finally {
            dbaSchema.disconnect();
        }
        return userExists;
    }

    public static String trimSYSLogin(String username) {
        if (username == null) {
            throw new IllegalArgumentException("username must not be null");
        }
        if (username.toUpperCase().trim().equals("SYS AS SYSDBA")) {
            return "SYS";
        }
        return username;
    }

    public static void main(String[] args) {
        try {
            String string = InstallUtil.checkJChemServer("localhost:25");
            System.out.println("'" + string + "'");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

