/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install;

import chemaxon.jchem.cartridge.install.ChUrl;
import chemaxon.jchem.cartridge.install.InstallUtil;
import chemaxon.jchem.cartridge.install.params.InstallParameters;
import chemaxon.jchem.cartridge.install.schema.PlSqlLoader;
import chemaxon.jchem.cartridge.install.schema.Schema;
import chemaxon.jchem.cartridge.servlets.indexing.CacheIdManagement;
import chemaxon.jchem.version.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Installer {
    public static final Logger logger = Logger.getLogger(Installer.class.getName());
    public static final String HACKED_JCHEM_CART_SQL_FILE = "jchem_cart.sql_i";
    public static final String[] OTHER_PLSQL_SCRIPTS = new String[]{"jchem_util.sql", "jchem_opti.sql", "idx_analyse.sql", "privman.sql"};
    protected ArrayList<String> tasksLeftForUser = new ArrayList();
    protected InstallParameters ip;
    protected Schema dbaSchema;
    public Schema jcartOwnerSchema;

    public Installer(InstallParameters ip) {
        this.ip = ip;
        if (ip.dbaLogin.hasUserInput() && !ip.dbaLogin.getUserInput().equals("!")) {
            this.dbaSchema = InstallUtil.createSchema(ip, ip.dbaLogin, ip.dbaPassword, true);
        }
        this.jcartOwnerSchema = InstallUtil.createSchema(ip, ip.jccOwnerLogin, ip.jccOwnerPassword, false);
    }

    public void install() throws Exception {
        if (this.hasDba()) {
            this.dbaSchema.connect();
        }
        try {
            this.jcartOwnerSchema.connect();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1017 && this.hasDba()) {
                logger.log(Level.FINE, "First attempt to connect to " + this.jcartOwnerSchema.getUsername() + " failed.", e);
                this.setupConnectJCartOwnerSchema();
            }
            throw e;
        }
        if (this.dbaSchema != null && this.ip.basicJccRole.getUserInput() != null) {
            this.dbaSchema.executeSqls(this.ip.stmtsToSetupBasicJccRoleAsDba());
        }
        this.patientlyCheckJChemServer();
        this.loadJCartJar();
        this.loadCorePlSql(this.jcartOwnerSchema);
        this.loadOtherPlSql(this.jcartOwnerSchema);
        this.jcartOwnerSchema.buildFromDatabase();
        this.jcartOwnerSchema.verifyBasedOn(this.jcartOwnerSchema);
        this.jcartOwnerSchema.executeSql("call jc_set_default_property('dummy', 'dummy')");
        this.registerRmiLocator();
        this.registerCacheId();
        this.test();
        this.createPublicSynonyms();
        this.grantBasicJccPrivilegesByJCartOwner(this.ip.basicJccRole.getUserInput());
    }

    private void patientlyCheckJChemServer() throws Exception {
        int maxTryCount = 3;
        long sleepTime = 1000L;
        Exception checkFailed = null;
        for (int count = 0; count < 3; ++count) {
            try {
                InstallUtil.checkJChemServer(this.ip.jchemServerHost.getUserInput() + ":" + this.ip.jchemServerPort.getUserInput());
                checkFailed = null;
                break;
            }
            catch (NoSuchObjectException nsoe) {
                checkFailed = nsoe;
            }
            catch (NotBoundException nbe) {
                checkFailed = nbe;
            }
            Thread.sleep(1000L);
        }
        if (checkFailed != null) {
            throw checkFailed;
        }
    }

    protected void loadCorePlSql(Schema schema) throws Exception {
        File cartHomeDir = new File(this.ip.jchemHome, "cartridge");
        File hackedJChemCartFile = new File(cartHomeDir, HACKED_JCHEM_CART_SQL_FILE);
        ChUrl.prepareSqlScript(this.jcartOwnerSchema.getUsername().toUpperCase(), new File(cartHomeDir, "jchem_cart.sql"), hackedJChemCartFile);
        this.loadPlSql(schema, hackedJChemCartFile.getCanonicalPath());
    }

    protected void loadOtherPlSql(Schema schema) throws IOException, InterruptedException, Exception {
        File cartHomeDir = new File(this.ip.jchemHome, "cartridge");
        for (String scriptName : OTHER_PLSQL_SCRIPTS) {
            String scriptPath = cartHomeDir.getCanonicalPath() + File.separator + scriptName;
            this.loadPlSql(schema, scriptPath);
        }
    }

    private void loadPlSql(Schema schema, String plSqlFile) throws IOException, InterruptedException, Exception {
        schema.connect();
        if (this.ip.useSqlPlus()) {
            this.loadPlSqlWithSqlPlus(schema, plSqlFile);
        } else {
            this.loadPlSqlWithInternalLoader(schema, plSqlFile);
        }
    }

    private void loadPlSqlWithInternalLoader(Schema schema, String plSqlFile) throws Exception {
        PlSqlLoader loader = new PlSqlLoader(schema.getConnection());
        loader.load(plSqlFile);
    }

    private void loadPlSqlWithSqlPlus(Schema schema, String plSqlFile) throws IOException, InterruptedException, SQLException {
        InstallUtil.loadPlSql(this.ip.oracleHome.getUserInput(), this.ip.tnsName.getUserInput(), schema.getUsername(), schema.getPassword(), plSqlFile);
        try {
            PlSqlLoader.checkErrors(schema.getConnection(), schema.getUsername(), "%", null);
        }
        catch (SQLException sqlException) {
            throw new SQLException(plSqlFile + ": " + sqlException.getMessage());
        }
    }

    private void loadJCartJar() throws IOException, InterruptedException, SQLException {
        this.loadJCartIntoOracle(this.jcartOwnerSchema);
    }

    protected void loadJCartIntoOracle(Schema jcartOwnerSchema) throws IOException, InterruptedException, SQLException {
        String jarfile = this.ip.jchemHome + File.separator + "cartridge" + File.separator + "jcart.jar";
        InstallUtil.loadJarFileIntoOracle(this.ip.oracleHome.getUserInput(), jarfile, jcartOwnerSchema, this.ip.useLoadjava());
    }

    private void registerRmiLocator() throws SQLException {
        String rmiLocator = this.ip.jchemServerHost.getUserInput() + ":" + this.ip.jchemServerPort.getUserInput();
        String sql = "call jchem_core_pkg.set_master_property(null, 'rmi.server.1', '" + rmiLocator + "')";
        this.jcartOwnerSchema.executeSql(sql);
    }

    protected void registerCacheId() throws Exception {
        CacheIdManagement cim = new CacheIdManagement();
        cim.registerCacheIdForJcc(this.jcartOwnerSchema.getConnection(), this.ip.jccOwnerLogin.getUserInput(), this.ip.structureCacheId.getUserInput(), null);
    }

    private boolean hasDba() {
        return this.dbaSchema != null;
    }

    private void setupConnectJCartOwnerSchema() throws SQLException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Setting up schema " + this.jcartOwnerSchema.getUsername());
        }
        this.dbaSchema.executeSqls(this.getStmtsToSetupJCartOwnerSchema());
        this.jcartOwnerSchema.connect();
    }

    private List<String> getStmtsToSetupJCartOwnerSchema() throws SQLException {
        return this.getStmtsToSetupJCartOwnerSchema(this.jcartOwnerSchema, true);
    }

    protected List<String> getStmtsToSetupJCartOwnerSchema(Schema jcartOwnerSchema, boolean withJavaPermissions) {
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add("create user " + jcartOwnerSchema.getUsername() + " identified by " + jcartOwnerSchema.getPassword());
        String[] privs = InstallParameters.JCHEM_OWNER_PRIVILEGES;
        for (int ix = 0; ix < privs.length; ++ix) {
            String priv = privs[ix];
            sqlList.add("grant " + priv + " to " + InstallUtil.trimSYSLogin(jcartOwnerSchema.getUsername()));
        }
        if (withJavaPermissions) {
            for (String sql : InstallUtil.getJavaPermGrantStmts(jcartOwnerSchema.getUsername(), this.ip.jchemServerHost.getUserInput(), this.ip.jchemServerPort.getUserInput(), this.ip.databaseVersion)) {
                sqlList.add(sql);
            }
        }
        return sqlList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test() throws SQLException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Testing with user " + this.jcartOwnerSchema.getUsername() + "...");
        }
        ArrayList<String> l = new ArrayList<String>();
        this.jcartOwnerSchema.executeSql("call jchem_core_pkg.use_password('" + this.jcartOwnerSchema.getPassword() + "')");
        String sql = "select jchem_core_pkg.getenvironment from dual";
        Statement stmt = this.jcartOwnerSchema.getConnection().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                l.add(rs.getString(1));
            }
        }
        finally {
            stmt.close();
        }
        String pname = "JChem version: ";
        String e = (String)l.get(0);
        StringTokenizer tokzer = new StringTokenizer(e, "\n");
        while (tokzer.hasMoreTokens()) {
            String tok = tokzer.nextToken();
            if (!tok.startsWith(pname)) continue;
            String pvalue = tok.substring(pname.length()).trim();
            if (!pvalue.equals(VersionInfo.JCHEM_VERSION)) {
                throw new RuntimeException("Version mismatch: " + sql + " returned '" + pvalue + "'; expected '" + VersionInfo.JCHEM_VERSION + "'");
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Test OK!");
            }
            return;
        }
        throw new RuntimeException(sql + " returned no JChem version info");
    }

    protected void createPublicSynonyms() throws SQLException {
        String dropSql = "call " + this.jcartOwnerSchema.getUsername() + "." + "privman_pkg.drop_public_syns_for_jcobjs('" + this.jcartOwnerSchema.getUsername() + "')";
        String createSql = "call " + this.jcartOwnerSchema.getUsername() + "." + "privman_pkg.public_syns_for_jcobjs('" + this.jcartOwnerSchema.getUsername() + "')";
        if (this.dbaSchema == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("No DBA login available, skipping synonym creation");
            }
            String msg = "You must manually create public synonyms for the JChem Cartridge objects. You have to first drop the existing public synonyms:\n\n\t" + dropSql + "\n\n; then create new ones:\n\n\t" + createSql;
            this.tasksLeftForUser.add(msg);
        } else {
            this.dbaSchema.executeSql(dropSql);
            this.dbaSchema.executeSql(createSql);
        }
    }

    public void installJChemServerAsService() {
    }

    public void grantBasicJccPrivilegesByJCartOwner(String target) throws Exception {
        if (target == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Skipping granting basic privileges to 'null'");
            }
            return;
        }
        this.jcartOwnerSchema.executeSqls(this.ip.stmtsToConfigureBasicJccRoleAsJccOwner(target));
    }
}

