/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SqlLoader {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public void load(Connection conn, String text) throws IOException, SQLException {
        SqlLoader.checkErrors(conn);
        List<String> sqlList = this.parseText(text);
        for (String sql : sqlList) {
            this.loadSql(conn, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSql(Connection conn, String sql) throws SQLException {
        Statement stmt = conn.createStatement();
        try {
            stmt.execute(sql);
        }
        finally {
            stmt.close();
        }
        SqlLoader.checkErrors(conn);
    }

    private List<String> parseText(String text) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        BufferedReader br = new BufferedReader(new StringReader(text));
        String line = br.readLine();
        while (line != null) {
            if (line.startsWith("/")) {
                l.add(buffer.toString());
                buffer = new StringBuilder();
            } else {
                if (buffer.length() > 0) {
                    buffer.append(LINE_SEPARATOR);
                }
                buffer.append(line);
            }
            line = br.readLine();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkErrors(Connection conn) throws SQLException {
        StringBuilder buffer = new StringBuilder();
        String errorCheckSql = "select text, line, position from user_errors order by sequence";
        PreparedStatement pstmt = conn.prepareStatement(errorCheckSql);
        try {
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String text = rs.getString("text");
                String line = rs.getString("line");
                String position = rs.getString("position");
                if (buffer.length() > 0) {
                    buffer.append(LINE_SEPARATOR);
                }
                buffer.append("[").append(line).append(",").append(position).append("]: ").append(text);
            }
        }
        finally {
            pstmt.close();
        }
        if (buffer.length() > 0) {
            throw new SQLException(buffer.toString());
        }
    }
}

