/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install;

import chemaxon.jchem.cartridge.install.IdxUpgradeInfo;
import chemaxon.jchem.cartridge.install.IndexRebuilder;
import chemaxon.jchem.cartridge.install.InstallCmdLine;
import chemaxon.jchem.cartridge.install.InstallUtil;
import chemaxon.jchem.cartridge.install.JccConfigUtilCmdLine;
import chemaxon.jchem.cartridge.install.ManualUpgradeNeededException;
import chemaxon.jchem.cartridge.install.ServerCtrl;
import chemaxon.jchem.cartridge.install.Upgrader;
import chemaxon.jchem.cartridge.install.WindowsServiceInstaller;
import chemaxon.jchem.cartridge.install.params.ConfigurationParameter;
import chemaxon.jchem.cartridge.install.params.InstallParameters;
import chemaxon.jchem.cartridge.install.params.UpgradeParameters;
import chemaxon.jchem.cartridge.install.schema.Schema;
import chemaxon.jchem.cartridge.rmi.impl.AdminImpl;
import chemaxon.jchem.cartridge.servlets.indexing.CacheIdManagement;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.db.Updater;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.RuntimeUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpgradeCmdLine
extends InstallCmdLine {
    private static final Logger logger = Logger.getLogger(UpgradeCmdLine.class.getName());

    public UpgradeCmdLine(String[] args) throws IOException {
        super(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upgrade() throws Exception {
        UpgradeParameters up = new UpgradeParameters();
        try {
            up.skipPrivilegeChecks = this.skipPrivilegeChecks;
            if (this.unattendedParamFile == null) {
                boolean bl = this.interactiveUpgrade(up);
                return bl;
            }
            boolean bl = this.nonInteractiveUpgrade(up);
            return bl;
        }
        finally {
            this.stopJChemServer();
        }
    }

    private boolean nonInteractiveUpgrade(UpgradeParameters up) throws Exception {
        up.loadUiFromFiles(this.unattendedParamFile);
        this.initOracleHome(up);
        if (this.jcServerOnly) {
            throw new IllegalArgumentException("--jcserver-only switch is not supported in unattended mode.");
        }
        up.store(ServerCtrl.getConfigFilePath());
        this.checkStartNewJChemServer(up, true, false);
        this.upgrade(up);
        return true;
    }

    private boolean interactiveUpgrade(UpgradeParameters up) throws Exception {
        this.getPathToOldJccHome(up);
        if (up.isOldJChem50OrLater()) {
            this.readParamsFromOldJCart(up);
            up.oldStructureCacheId.setUserInput(up.structureCacheId.getUserInput());
            this.checkLicenseDir(up);
        }
        this.getParamsInteractively(up);
        if (this.confirmUserInput("Upgrade")) {
            if (!this.jcServerOnly) {
                this.upgrade(up);
            }
            this.upgradeJChemServerService(up);
            up.store(ServerCtrl.getConfigFilePath());
            return true;
        }
        return false;
    }

    private void upgradeJChemServerService(UpgradeParameters up) throws IOException, InterruptedException {
        ConfigurationParameter pp = ConfigurationParameter.createYesNo("Do you want to upgrade JChemServer as an operating system service?", true);
        if (RuntimeUtils.isWindows()) {
            WindowsServiceInstaller wsi = new WindowsServiceInstaller(up);
            if (this.cmdLine.promptForYesNo(pp)) {
                block4: {
                    ConfigurationParameter diffName;
                    do {
                        this.cmdLine.promptForInput(up.serviceName);
                        up.checkServiceName();
                        if (wsi.probeService()) break block4;
                        UpgradeCmdLine.err("The Windows Service " + up.serviceName.getUserInput() + " doesn't appear to exist.");
                    } while (this.cmdLine.promptForYesNo(diffName = ConfigurationParameter.createYesNo("Do you want to specify a different service name? (Answer 'n', if you want to install a new service as " + up.serviceName.getUserInput() + ".", false)));
                    this.createNewJChemServiceMaybe(up, wsi);
                    return;
                }
                wsi.upgradeService();
            } else {
                this.createNewJChemServiceMaybe(up, wsi);
            }
        }
    }

    private void createNewJChemServiceMaybe(UpgradeParameters up, WindowsServiceInstaller wsi) throws IOException, InterruptedException {
        ConfigurationParameter newService = ConfigurationParameter.createYesNo("Do you want to install a new Windows Service for JChem Server as " + up.serviceName.getUserInput() + "?", false);
        if (!this.cmdLine.promptForYesNo(newService)) {
            UpgradeCmdLine.msg("No Windows Service will be installed.");
            return;
        }
        wsi.installService();
    }

    private void getPathToOldJccHome(UpgradeParameters up) throws IOException {
        String description;
        ConfigurationParameter pp;
        do {
            String cwd = System.getProperty("user.dir");
            File cwDir = new File(cwd);
            String cwdName = cwDir.getName();
            this.cmdLine.promptForInput(up.pathToOldJChem);
            up.checkOldJChemHome();
            if (cwdName.equals("cartridge")) {
                up.oldJccDir.setUserInput("cartridge");
                up.constructPathToOldJcc();
                continue;
            }
            up.oldJccDir.setDefaultValue(cwdName);
            this.cmdLine.promptForInput(up.oldJccDir);
            up.constructPathToOldJcc();
            if (up.isOldJChem50OrLater()) continue;
            throw new IllegalArgumentException("The directory " + up.pathToOldJcc.getUserInput() + " must contains a jcart.properties file.");
        } while (!up.isOldJChem50OrLater() && !this.cmdLine.promptForYesNo(pp = ConfigurationParameter.createYesNo(description = "The directory " + up.pathToOldJcc.getUserInput() + " appears to hold " + "a JChem Cartridge version prior to 5.0. " + "Is this correct?", true)));
    }

    private void readParamsFromOldJCart(UpgradeParameters up) throws IOException, InterruptedException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        String pathToOldJChem = up.pathToOldJChem.getUserInput();
        String pathToOldJcc = up.pathToOldJcc.getUserInput();
        File jcartPropsFile = InstallParameters.jccPropFileInJccHome(new File(up.pathToOldJcc.getUserInput()));
        up.loadUiFromFiles(jcartPropsFile.getCanonicalPath());
        up.pathToOldJChem.setUserInput(pathToOldJChem);
        up.pathToOldJcc.setUserInput(pathToOldJcc);
    }

    private void checkLicenseDir(UpgradeParameters up) throws IOException {
        File pathToOldLicenseDir;
        String licDirProp = up.getConfigFromFiles().getProperty("license.dir");
        if (licDirProp == null) {
            licDirProp = "licenses";
        }
        if (licDirProp.trim().endsWith("/")) {
            int lastSlashPos = licDirProp.lastIndexOf(47);
            licDirProp = licDirProp.substring(0, lastSlashPos);
        }
        if (licDirProp.trim().endsWith("\\")) {
            int lastBackSlashPos = licDirProp.lastIndexOf(92);
            licDirProp = licDirProp.substring(0, lastBackSlashPos);
        }
        if ((pathToOldLicenseDir = new File(licDirProp)).getAbsolutePath().equals(licDirProp) || pathToOldLicenseDir.getCanonicalPath().equals(licDirProp)) {
            UpgradeCmdLine.warn(licDirProp + " for licenses appears to be an absolute path." + " Nothing to do there.");
            return;
        }
        File oldAbs = new File(up.pathToOldJcc.getUserInput(), licDirProp);
        if (!oldAbs.exists()) {
            UpgradeCmdLine.warn("The directory " + oldAbs.getCanonicalPath() + ", where the old JChem Cartridge version expected " + "the licenses files, doesn't exist.");
            return;
        }
        File newAbs = new File(licDirProp);
        String msg = "The license files in " + oldAbs.getCanonicalPath() + " will now be moved to " + newAbs.getCanonicalPath() + ".";
        if (!newAbs.isDirectory()) {
            msg = msg + " The directory " + newAbs.getCanonicalPath() + " will be created.";
        }
        if (this.cmdLine.promptForYesNo(msg, true)) {
            this.copyLicenses(oldAbs, newAbs);
        } else {
            this.addLicenseDirToManualTasks("", oldAbs);
        }
    }

    private void addLicenseDirToManualTasks(String xmsg, File oldAbs) throws IOException {
        this.tasksLeftForUser.add("Store license files currently in " + oldAbs.getCanonicalPath() + " in an appropriate place " + "and set the license.dir property in jcart.properties " + "accordingly");
    }

    private void copyLicenses(File oldAbs, File newAbs) throws IOException {
        if (!newAbs.isDirectory() && !newAbs.mkdirs()) {
            this.addLicenseDirToManualTasks("Directory " + newAbs.getCanonicalPath() + " could not be created. ", oldAbs);
            return;
        }
        File[] oldFiles = oldAbs.listFiles();
        for (int i = 0; i < oldFiles.length; ++i) {
            File oldFile = oldFiles[i];
            if (oldFile.isDirectory()) {
                UpgradeCmdLine.warn(oldFile.getCanonicalPath() + " is a directory; will not be copied. " + "It's contents and subdirectories " + "will not be copied either.");
                continue;
            }
            String fname = oldFile.getName();
            File newFile = new File(newAbs, fname);
            this.copyFile(oldFile, newFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File oldFile, File newFile) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(oldFile));
        try {
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(newFile));
            try {
                byte[] buffer = new byte[4096];
                int count = bin.read(buffer);
                while (count != -1) {
                    bout.write(buffer, 0, count);
                    count = bin.read(buffer);
                }
            }
            finally {
                bout.close();
            }
        }
        finally {
            bin.close();
        }
    }

    private void upgrade(UpgradeParameters up) throws Exception {
        int oraclePort = Integer.parseInt(up.oracleListenerPort.getUserInput());
        String dbaLogin = up.dbaLogin.getUserInput();
        if (dbaLogin.equals("!")) {
            dbaLogin = null;
        }
        Upgrader ute = new Upgrader(up);
        ute.upgrade();
        if (ute.upgradePlanOnly()) {
            return;
        }
        this.tasksLeftForUser.addAll(ute.getTasksLeftForUser());
        this.rebuildIndices(up, ute);
    }

    @Override
    protected void getParamsInteractively(InstallParameters up) throws Exception {
        this.getOracleParamsInteractively(up);
        if (!this.jcServerOnly) {
            this.getCheckDbaLoginInteractively(up);
        }
        this.getCheckJCartOwnerLoginInteractively(up);
        up.adjustRmiUrlFromDb();
        ((UpgradeParameters)up).oldStructureCacheId.setUserInput(up.structureCacheId.getUserInput());
        this.getCheckJChemServerParamsInteractively(up);
        this.checkStartNewJChemServer(up, false);
        if (this.jcServerOnly) {
            return;
        }
        this.checkTnsNameInteractively(up);
        this.getBasicJccRoleNameInteractively(up);
        this.getUpgradeParamsInteractively((UpgradeParameters)up);
    }

    @Override
    protected void getStructureCacheId(InstallParameters ip) throws Exception {
        UpgradeParameters up = (UpgradeParameters)ip;
        String oldCacheId = up.oldStructureCacheId.getUserInput();
        if (oldCacheId == null) {
            this.cmdLine.promptForInput(up.structureCacheId);
        } else {
            CacheIdManagement cim = new CacheIdManagement();
            ArrayList<String> cacheIds = cim.getAllJccCacheIds(ip.createConnection(ip.jccOwnerLogin, ip.jccOwnerPassword), ip.jccOwnerLogin.getUserInput());
            if (!cacheIds.contains(oldCacheId)) {
                String message = "The structure cache id of the installation being upgraded is set to " + oldCacheId + ", but it is not registered in the database.";
                String prompt = message + " Is this the correct id? " + "(If it is, it will be registered.) ";
                if (this.cmdLine.promptForYesNo(prompt, false)) {
                    up.oldStructureCacheId.setUserInput(null);
                } else {
                    throw new IllegalStateException(message);
                }
            }
        }
    }

    @Override
    protected boolean handleJCartOwnerLoginCheckFailure(InstallParameters ip, IllegalArgumentException iae) {
        UpgradeCmdLine.err(iae.getMessage());
        return false;
    }

    private void getUpgradeParamsInteractively(UpgradeParameters up) throws SQLException, IOException {
        block10: {
            this.cmdLine.promptCheckInput(up.stagingSchema);
            JccConfigUtilCmdLine.promptForPassword(up.stagingSchemaPassword);
            if (!up.dbaLogin.hasUserInput()) {
                while (true) {
                    try {
                        up.checkLogin(up.stagingSchema, up.stagingSchemaPassword);
                        up.checkStagingSchema();
                        break block10;
                    }
                    catch (IllegalArgumentException iae) {
                        UpgradeCmdLine.warn("Error: " + iae.getMessage());
                        this.cmdLine.promptCheckInput(up.stagingSchema);
                        JccConfigUtilCmdLine.promptForPassword(up.stagingSchemaPassword);
                        continue;
                    }
                    break;
                }
            }
            while (true) {
                try {
                    try {
                        up.checkLogin(up.stagingSchema, up.stagingSchemaPassword);
                    }
                    catch (IllegalArgumentException iae) {
                        break;
                    }
                    up.checkStagingSchema();
                }
                catch (IllegalArgumentException iae) {
                    UpgradeCmdLine.warn("Error: " + iae.getMessage());
                    this.cmdLine.promptCheckInput(up.stagingSchema);
                    JccConfigUtilCmdLine.promptForPassword(up.stagingSchemaPassword);
                    continue;
                }
                break;
            }
        }
        if (up.dbaLogin.hasUserInput()) {
            this.cmdLine.promptForInput(up.rebuildIndexes);
        }
    }

    private void rebuildIndices(UpgradeParameters up, Upgrader ute) throws Exception {
        int idxRebuild = this.getIndexRebuildMode(up);
        if (idxRebuild == 0) {
            String msg = "You must manually rebuild jc_idxtype indices created on regular structure tables with the previous cartridge version. Use the 'upgradeOnly=y' parameter:\n\n\tALTER INDEX <index-name> REBUILD PARAMETERS('upgradeOnly=y')";
            this.tasksLeftForUser.add(msg);
            msg = "You must manually upgrade JChem structure tables using jcman or Instant JChem";
            this.tasksLeftForUser.add(msg);
            return;
        }
        Schema dbaSchema = ute.getDbaSchema();
        dbaSchema.setJccOwnerName(ute.jcartOwnerSchema.getUsername());
        dbaSchema.executeSqls(InstallUtil.getJavaPermGrantStmts(dbaSchema.getUsername().toUpperCase(), up.jchemServerHost.getUserInput(), up.jchemServerPort.getUserInput(), up.databaseVersion));
        ute.grantBasicJccPrivilegesByJCartOwner(dbaSchema.getUsername());
        dbaSchema.reconnect();
        ArrayList<IdxUpgradeInfo> jchemTables = new ArrayList<IdxUpgradeInfo>();
        UpgradeCmdLine.msg("Rebuilding indexes on regular structure tables...");
        IndexRebuilder idxRebuilder = new IndexRebuilder(dbaSchema);
        HashSet<String> schemasWithRenewedPrivileges = new HashSet<String>();
        IdxUpgradeInfo idxUpgradeInfo = null;
        while ((idxUpgradeInfo = idxRebuilder.next()) != null) {
            JCartIndexDescriptor idxDesc = idxUpgradeInfo.getIdxDescriptor();
            if (idxDesc.isJChemTable()) {
                jchemTables.add(idxUpgradeInfo);
                continue;
            }
            String idxName = idxDesc.getIndexSchemaName() + "." + idxDesc.getIndexName();
            if (idxRebuild == 1 && !this.confirmIdxRebuild(idxName, idxUpgradeInfo.isIndexDataRecalcRequired())) continue;
            String partitionName = idxDesc.getIndexPartitionName();
            String schemaName = idxDesc.getIndexSchemaName();
            if (!schemasWithRenewedPrivileges.contains(schemaName)) {
                ute.grantBasicJccPrivilegesByJCartOwner(schemaName);
                schemasWithRenewedPrivileges.add(schemaName);
            }
            try {
                idxRebuilder.rebuildIndex(idxName, partitionName, this.skipAutoCalcCt(up, idxRebuilder, idxDesc));
            }
            catch (SQLException sqlException) {
                String partitionNamePart = idxDesc.getIndexPartitionName() == null ? "" : "." + idxDesc.getIndexPartitionName();
                String msg = "Upgrading the index " + idxDesc.getIndexSchemaName() + "." + idxDesc.getIndexName() + partitionNamePart + " failed with the following exception: " + sqlException.getMessage();
                UpgradeCmdLine.msg(msg);
                this.tasksLeftForUser.add(msg);
            }
        }
        this.upgradeJcbTables(up, jchemTables);
    }

    private int getIndexRebuildMode(UpgradeParameters up) {
        String irs = up.rebuildIndexes.getUserInput();
        if (irs == null) {
            return 0;
        }
        if (irs.equals("all")) {
            return 2;
        }
        if (irs.equals("ask")) {
            return 1;
        }
        return 0;
    }

    private boolean confirmIdxRebuild(String idxName, boolean idxDataRecalcRequired) throws IOException {
        String p = "Proceed with rebuilding " + idxName.toUpperCase();
        if (idxDataRecalcRequired) {
            p = p + " (Index data recalculation is required)";
        }
        p = p + "?";
        return this.cmdLine.promptForYesNo(p, true);
    }

    private boolean skipAutoCalcCt(UpgradeParameters up, IndexRebuilder idxRebuilder, JCartIndexDescriptor idxDesc) throws Exception {
        if (this.unattendedParamFile != null) {
            return false;
        }
        if (up.skipRebuildAutoCalcCt.hasUserInput()) {
            String uInput = up.skipRebuildAutoCalcCt.getUserInput();
            return uInput.equals("y") || uInput.equals("true");
        }
        List<String> autoCalcCts = idxRebuilder.getAutoCalcCts(idxDesc);
        if (autoCalcCts == null || autoCalcCts.size() == 0) {
            return false;
        }
        String m = "The following Chemical Terms are automatically calucated as part of this index :";
        StringBuffer b = new StringBuffer();
        for (String ct : autoCalcCts) {
            if (b.length() > 0) {
                b.append(",");
            }
            b.append(ct);
        }
        b.append(".");
        return !this.cmdLine.promptForYesNo(m + b.toString(), false);
    }

    private void upgradeJcbTables(UpgradeParameters up, ArrayList<IdxUpgradeInfo> jchemTables) throws Exception {
        UpgradeCmdLine.msg("Upgrading JChem structure tables...");
        AdminImpl.loadLicenses();
        for (IdxUpgradeInfo idxUpgradeInfo : jchemTables) {
            if (this.getIndexRebuildMode(up) == 1 && !this.confirmRegeneration(idxUpgradeInfo.getIdxDescriptor(), idxUpgradeInfo.isIndexDataRecalcRequired())) continue;
            this.upgradeJcbTable(up, idxUpgradeInfo.getIdxDescriptor());
        }
    }

    private boolean confirmRegeneration(JCartIndexDescriptor idxDescriptor, boolean idxDataRecalcRequired) throws IOException {
        String p = "Proceed with recalculating " + idxDescriptor.getIdxTableQName().toUpperCase();
        if (idxDataRecalcRequired) {
            p = p + " (Data recalculation is required)";
        }
        p = p + "?";
        return this.cmdLine.promptForYesNo(p, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeJcbTable(UpgradeParameters up, JCartIndexDescriptor idxDescriptor) throws Exception {
        ConnectionHandler ch = new ConnectionHandler();
        ch.setDriver("oracle.jdbc.OracleDriver");
        ch.setUrl("jdbc:oracle:thin:@" + up.oracleHost.getUserInput() + ":" + up.oracleListenerPort.getUserInput() + ":" + up.oracleInstanceName.getUserInput());
        ch.setLoginName(up.dbaLogin.getUserInput());
        ch.setPassword(up.dbaPassword.getUserInput());
        ch.setPropertyTable(idxDescriptor.getJcptName());
        ch.connectToDatabase();
        try {
            CacheIdManagement cim = new CacheIdManagement();
            cim.registerCacheIdsForJcb(ch, up.jccOwnerLogin.getUserInput(), idxDescriptor.getJcptName());
            ch.getConnection().commit();
            UpgradeCmdLine.msg("Upgrading " + idxDescriptor.getIdxTableQName() + "...");
            ArrayList<String> tablesToConsider = new ArrayList<String>();
            tablesToConsider.add(idxDescriptor.getIdxTableQName());
            Updater u = new Updater(ch, tablesToConsider);
            Updater.UpdateInfo ui = u.getNextUpdateInfo();
            while (ui != null) {
                u.performCurrentUpdate();
                ui = u.getNextUpdateInfo();
            }
        }
        finally {
            ch.close();
        }
    }

    public static void main(String[] args) {
        try {
            UpgradeCmdLine u = new UpgradeCmdLine(args);
            if (u.upgrade()) {
                if (u.tasksLeftForUser.size() == 0) {
                    System.out.println("\n\n==============================\nUPGRADE SUCCESSFULLY COMPLETED.\n==============================\n\n");
                } else {
                    System.out.println("\n\nUpgrade completed with tasks left to be manually performed:");
                    u.printTasksLeftForUser();
                }
            } else {
                System.out.println("\n\nUpgrade skipped.");
            }
        }
        catch (ManualUpgradeNeededException manu) {
            UpgradeCmdLine.err(manu.getMessage());
            System.exit(1);
        }
        catch (Throwable throwable) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "error", throwable);
            }
            throwable.printStackTrace();
            System.exit(2);
        }
    }
}

