/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install;

import chemaxon.jchem.cartridge.install.InstallUtil;
import chemaxon.jchem.cartridge.install.Installer;
import chemaxon.jchem.cartridge.install.SqlLoader;
import chemaxon.jchem.cartridge.install.params.UpgradeParameters;
import chemaxon.jchem.cartridge.install.schema.Schema;
import chemaxon.jchem.cartridge.install.schema.UpgradePlan;
import chemaxon.jchem.cartridge.servlets.indexing.CacheIdManagement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Upgrader
extends Installer {
    private static final Logger logger = Logger.getLogger(Upgrader.class.getName());
    private Schema stagingSchema;

    public Upgrader(UpgradeParameters up) {
        super(up);
        this.stagingSchema = new Schema(up.oracleHost.getUserInput(), Integer.parseInt(up.oracleListenerPort.getUserInput()), up.oracleInstanceName.getUserInput(), up.stagingSchema.getUserInput(), up.stagingSchemaPassword.getUserInput(), this.jcartOwnerSchema.getUsername(), false);
    }

    public void upgrade() throws Exception {
        this.upgrade(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgrade(boolean codeOnly) throws Exception {
        this.setupStagingSchema();
        try {
            this.upgradeSchemaObjects();
            this.loadJCartIntoOracle(this.jcartOwnerSchema);
            if (!codeOnly) {
                this.setNewRmiUrl();
            }
            this.upgradeCacheId();
            this.execFinalAnonymousBlock();
            this.execNotInFinalAnonymousBlock();
        }
        finally {
            this.dropEmptyStagingSchema();
        }
    }

    private void setupStagingSchema() throws SQLException {
        if (this.dbaSchema == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("No DBA login available, skipping staging schema setup");
            }
            return;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Setting up staging schema...");
        }
        this.dbaSchema.executeSqls(this.getStmtsToSetupJCartOwnerSchema(this.stagingSchema, false));
    }

    private void upgradeSchemaObjects() throws Exception {
        this.populateNewVersionStage();
        this.stagingSchema.buildFromDatabase();
        this.stagingSchema.verifyBasedOn(this.stagingSchema);
        this.jcartOwnerSchema.buildFromDatabase();
        UpgradePlan upgradePlan = this.jcartOwnerSchema.createUpgradePlan(this.stagingSchema);
        this.dumpUpgradePlan(upgradePlan.toString());
        if (this.upgradePlanOnly()) {
            return;
        }
        upgradePlan.execute();
        this.jcartOwnerSchema.verifyBasedOn(this.stagingSchema);
    }

    private void dropEmptyStagingSchema() throws SQLException, IOException {
        if (this.dbaSchema == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("No DBA login available, emptying staging schema...");
            }
            this.emptyStagingSchema();
        } else {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Dropping staging schema...");
            }
            InstallUtil.dropUser(this.dbaSchema, this.stagingSchema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emptyStagingSchema() throws IOException, SQLException {
        SqlLoader sqlLoader = new SqlLoader();
        this.stagingSchema.connect();
        Connection conn = this.stagingSchema.getConnection();
        sqlLoader.load(conn, this.getEmptyingScript());
        Statement stmt = conn.createStatement();
        try {
            String sql = "select count(*) from user_objects";
            ResultSet rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                throw new RuntimeException("No results for " + sql);
            }
            int objectCount = rs.getInt(1);
            if (objectCount != 0 && logger.isLoggable(Level.WARNING)) {
                logger.warning("Staging schema could not be emptied, " + objectCount + " object(s) left.");
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEmptyingScript() throws IOException {
        InputStream instream = this.getClass().getClassLoader().getResourceAsStream("chemaxon/jchem/cartridge/install/empty-staging-schema.sql");
        try {
            StringBuilder sb = new StringBuilder();
            InputStreamReader r = new InputStreamReader(instream);
            try {
                char[] buff = new char[4096];
                int count = r.read(buff);
                while (count != -1) {
                    sb.append(new String(buff, 0, count));
                    count = r.read(buff);
                }
            }
            finally {
                ((Reader)r).close();
            }
            String string = sb.toString();
            return string;
        }
        finally {
            instream.close();
        }
    }

    private void populateNewVersionStage() throws Exception {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Populating the staging schema with the objects of the new JChem Cartridge version...");
        }
        this.loadJCartIntoOracle(this.stagingSchema);
        this.jcartOwnerSchema.executeSql("grant select on jchem_sessionid_sq to " + this.stagingSchema.getUsername());
        this.loadCorePlSql(this.stagingSchema);
        this.loadOtherPlSql(this.stagingSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpUpgradePlan(String string) throws IOException {
        File f = new File("upgrade-plan.txt");
        FileWriter fw = new FileWriter(f);
        try {
            fw.write(new Date().toString());
            fw.write(System.getProperty("line.separator"));
            fw.write(string);
        }
        finally {
            ((Writer)fw).close();
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Upgrade plan has been stored in " + f.getCanonicalPath());
        }
    }

    public boolean upgradePlanOnly() {
        String ui = ((UpgradeParameters)this.ip).upgradePlanOnly.getUserInput();
        if (ui == null) {
            return false;
        }
        return ui.equalsIgnoreCase("y") || ui.equalsIgnoreCase("yes") || ui.equalsIgnoreCase("true");
    }

    private void setNewRmiUrl() throws SQLException {
        String newRmiUrl = this.ip.jchemServerHost.getUserInput() + ":" + this.ip.jchemServerPort.getUserInput();
        if (newRmiUrl != null) {
            String sql = "call jchem_core_pkg.set_master_property(null, 'rmi.server.1', '" + newRmiUrl + "')";
            this.jcartOwnerSchema.executeSql(sql);
        }
    }

    protected void upgradeCacheId() throws Exception {
        UpgradeParameters up = (UpgradeParameters)this.ip;
        String oldId = up.oldStructureCacheId.getUserInput();
        String newId = up.structureCacheId.getUserInput();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("oldId=" + oldId + ", newId=" + newId);
        }
        if (oldId == null || !newId.equals(oldId)) {
            CacheIdManagement cim = new CacheIdManagement();
            cim.registerCacheIdForJcc(this.jcartOwnerSchema.getConnection(), up.jccOwnerLogin.getUserInput(), newId, oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execFinalAnonymousBlock() throws IOException, SQLException {
        File cartHomeDir = new File(this.ip.jchemHome, "cartridge");
        String filePath = new File(cartHomeDir, "jchem_cart.sql_i").getCanonicalPath();
        ArrayList<String> lines = new ArrayList<String>();
        boolean foundDeclare = false;
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        try {
            String l = reader.readLine();
            int lineNo = 1;
            while (l != null) {
                if (l.startsWith("declare")) {
                    foundDeclare = true;
                    lines.clear();
                }
                if (foundDeclare) {
                    lines.add(l);
                }
                l = reader.readLine();
                ++lineNo;
            }
        }
        finally {
            reader.close();
        }
        if (!foundDeclare) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("No anonymous block found in jchem_cart.sql_i");
            }
        } else {
            String l;
            StringBuffer sb = new StringBuffer();
            for (int ix = 0; ix < lines.size() && !(l = (String)lines.get(ix)).startsWith("/"); ++ix) {
                sb.append(l).append("\n");
            }
            this.jcartOwnerSchema.executeSql(sb.toString());
        }
    }

    private void execNotInFinalAnonymousBlock() throws SQLException {
        this.jcartOwnerSchema.executeSql("call jc_set_default_property('dummy', 'dummy')");
    }

    public Schema getDbaSchema() {
        return this.dbaSchema;
    }

    public ArrayList<String> getTasksLeftForUser() {
        return this.tasksLeftForUser;
    }
}

