/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install.params;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationParameter {
    private static final Logger logger = Logger.getLogger(ConfigurationParameter.class.getName());
    private String name;
    private String promptMessage;
    private String description;
    private List<String> allowedValues;
    private String defaultValue;
    private boolean password;
    private boolean valueToBeSaved;
    private String userInput;
    private static Map<String, ConfigurationParameter> allConfigurationParameters = new HashMap<String, ConfigurationParameter>();

    public ConfigurationParameter() {
    }

    public ConfigurationParameter(String name) {
        this.name = name;
    }

    public void copyTo(Object obj) {
        ConfigurationParameter other = (ConfigurationParameter)obj;
        if (other.name == null) {
            other.name = this.name;
        } else if (!other.name.equals(this.name)) {
            throw new IllegalArgumentException("Other has name: " + other.name + " which is different from mine: " + this.name);
        }
        other.promptMessage = this.promptMessage;
        other.description = this.description;
        other.allowedValues = this.allowedValues;
        other.defaultValue = this.defaultValue;
        other.password = this.password;
        other.valueToBeSaved = this.valueToBeSaved;
        other.userInput = this.userInput;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this + " copied");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPromptMessage() {
        return this.promptMessage;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defValue) {
        this.defaultValue = defValue;
    }

    public boolean isPassword() {
        return this.password;
    }

    public boolean isValueToBeSaved() {
        return this.valueToBeSaved;
    }

    public String getUserInput() {
        return this.userInput;
    }

    public void setUserInput(String userInput) {
        this.userInput = userInput;
    }

    public static ConfigurationParameter getProperties(String name) {
        return allConfigurationParameters.get(name);
    }

    public static Map<String, ConfigurationParameter> loadFrom(InputStream instream) throws IOException {
        HashMap<String, ConfigurationParameter> paramMap = new HashMap<String, ConfigurationParameter>();
        BufferedReader br = new BufferedReader(new InputStreamReader(instream));
        String line = br.readLine();
        while (line != null) {
            try {
                ConfigurationParameter p = ConfigurationParameter.createConfigurationParameter(line);
                if (p != null) {
                    paramMap.put(p.getName(), p);
                }
            }
            catch (NoSuchElementException nsee) {
                nsee.printStackTrace();
                throw new IllegalArgumentException("Problem during processing '" + line + "'");
            }
            line = br.readLine();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Returning " + paramMap + "...");
        }
        return paramMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ConfigurationParameter> loadFromResource(String resourceFileName) throws IOException {
        InputStream instream = ConfigurationParameter.class.getClassLoader().getResourceAsStream("chemaxon/jchem/cartridge/install/" + resourceFileName);
        try {
            Map<String, ConfigurationParameter> map = ConfigurationParameter.loadFrom(instream);
            return map;
        }
        finally {
            instream.close();
        }
    }

    private static ConfigurationParameter createConfigurationParameter(String line) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Processing line: " + line + "...");
        }
        if ((line = line.trim()).length() == 0 || line.startsWith("#")) {
            return null;
        }
        ConfigurationParameter p = new ConfigurationParameter();
        StringTokenizer st = new StringTokenizer(line, "|");
        p.name = st.nextToken().trim();
        p.description = st.nextToken().trim();
        p.promptMessage = st.nextToken().trim();
        p.allowedValues = ConfigurationParameter.extractAllowedValues(st.nextToken().trim());
        p.defaultValue = st.nextToken().trim();
        p.valueToBeSaved = st.nextToken().trim().equals("y");
        boolean bl = p.password = p.name.indexOf("password") != -1;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Returning " + p + "...");
        }
        return p;
    }

    public static ConfigurationParameter create(String name, String description, String prompt, List<String> allowedValues, String defaultValue) {
        return ConfigurationParameter.create(name, false, description, prompt, allowedValues, defaultValue);
    }

    public static ConfigurationParameter create(String name, boolean password, String description, String prompt, List<String> allowedValues, String defaultValue) {
        ConfigurationParameter pp = new ConfigurationParameter();
        pp.name = name;
        pp.password = password;
        pp.description = description;
        pp.promptMessage = prompt;
        pp.allowedValues = allowedValues;
        pp.defaultValue = defaultValue;
        return pp;
    }

    public static ConfigurationParameter createYesNo(String description, boolean def) {
        ArrayList<String> allowedValues = new ArrayList<String>();
        allowedValues.add("y");
        allowedValues.add("n");
        return ConfigurationParameter.create("created.in.place", description, description, allowedValues, def ? "y" : "n");
    }

    private static List<String> extractAllowedValues(String nextToken) {
        if ((nextToken = nextToken.trim()).length() == 0) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(nextToken, ",");
        while (st.hasMoreTokens()) {
            String v = st.nextToken().trim();
            l.add(v);
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.finest("value added: '" + v + "'");
        }
        return l;
    }

    public boolean hasUserInput() {
        String ui = this.getUserInput();
        return ui != null && ui.trim().length() > 0 && !ui.equals("!");
    }

    public boolean hasDefaultValue() {
        String v = this.getDefaultValue();
        return v != null && v.trim().length() > 0;
    }

    public void useDefault() {
        this.userInput = this.defaultValue;
    }

    public String toString() {
        return "ConfigurationParameter [name=" + this.name + ", promptMessage=" + this.promptMessage + ", description=" + this.description + ", allowedValues=" + this.allowedValues + ", defaultValue=" + this.defaultValue + ", password=" + this.password + ", valueToBeSaved=" + this.valueToBeSaved + ", userInput=" + this.userInput + "]";
    }
}

