/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install.schema;

import chemaxon.jchem.cartridge.install.schema.PlSqlProgram;
import chemaxon.jchem.cartridge.install.schema.Schema;
import chemaxon.jchem.cartridge.install.schema.SchemaObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class PlSqlObjectType
extends PlSqlProgram {
    private static final Logger logger = Logger.getLogger(PlSqlObjectType.class.getName());
    private Map<String, Attribute> attributes = this.getAttributes();
    private List<String> functionDeclarations = this.getMethodDeclarations();

    public PlSqlObjectType(Schema schema, String name) throws SQLException {
        super(schema, "TYPE", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Attribute> getAttributes() throws SQLException {
        HashMap<String, Attribute> def = new HashMap<String, Attribute>();
        String sql = "select attr_name, attr_type_owner, attr_type_name, length, precision, scale from all_type_attrs where owner = upper(?) and type_name = upper(?) order by attr_no";
        PreparedStatement pstmt = this.schema.conn.prepareStatement(sql);
        try {
            int paramIdx = 1;
            pstmt.setString(paramIdx++, this.schema.username);
            pstmt.setString(paramIdx++, this.id.getName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Attribute attribute = new Attribute();
                attribute.name = rs.getString("attr_name");
                String attribTypeOwner = rs.getString("attr_type_owner");
                if (attribTypeOwner != null && attribTypeOwner.equals("SYS")) {
                    attribute.typeOwner = attribTypeOwner;
                }
                attribute.type = rs.getString("attr_type_name");
                int length = rs.getInt("length");
                if (rs.wasNull()) {
                    length = -1;
                }
                if (length > -1) {
                    attribute.length = length;
                }
                int precision = rs.getInt("precision");
                if (rs.wasNull()) {
                    precision = -1;
                }
                if (precision > -1) {
                    int scale = rs.getInt("scale");
                    if (rs.wasNull()) {
                        scale = -1;
                    }
                    if (scale > -1) {
                        attribute.scale = scale;
                    }
                }
                def.put(attribute.name, attribute);
            }
        }
        finally {
            pstmt.close();
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getMethodDeclarations() throws SQLException {
        ArrayList<String> def = new ArrayList<String>();
        String paramSql = "select distinct param_name, param_no, param_mode, param_type_owner, param_type_name from all_method_params  where owner = upper(?) and type_name = upper(?) and method_name = upper(?) and method_no = ? order by param_no";
        PreparedStatement paramPstmt = this.schema.conn.prepareStatement(paramSql);
        try {
            String methodSql = "select method_name, method_no from all_type_methods where owner = upper(?) and type_name = upper(?) order by method_name, method_no";
            PreparedStatement methodPstmt = this.schema.conn.prepareStatement(methodSql);
            try {
                int paramIdx = 1;
                methodPstmt.setString(paramIdx++, this.schema.username);
                methodPstmt.setString(paramIdx++, this.id.getName());
                ResultSet rs = methodPstmt.executeQuery();
                while (rs.next()) {
                    String methodName = rs.getString(1);
                    int methodNo = rs.getInt(2);
                    String methodParams = this.getMethodParams(paramPstmt, methodName, methodNo);
                    def.add("FUNCTION " + methodName + "(" + methodParams + ") RETURN NUMBER");
                }
            }
            finally {
                methodPstmt.close();
            }
        }
        finally {
            paramPstmt.close();
        }
        return def;
    }

    private String getMethodParams(PreparedStatement paramPstmt, String methodName, int methodNo) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        int paramIdx = 1;
        paramPstmt.setString(paramIdx++, this.schema.username);
        paramPstmt.setString(paramIdx++, this.id.getName());
        paramPstmt.setString(paramIdx++, methodName);
        paramPstmt.setInt(paramIdx++, methodNo);
        ResultSet rs = paramPstmt.executeQuery();
        while (rs.next()) {
            String paramTypeOwner;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(rs.getString("param_name")).append(" ");
            String paramMod = rs.getString("param_mode");
            if (paramMod != null) {
                buffer.append(paramMod).append(" ");
            }
            if ((paramTypeOwner = rs.getString("param_type_owner")) != null && paramTypeOwner.equals("SYS")) {
                buffer.append(paramTypeOwner).append(".");
            }
            buffer.append(rs.getString("param_type_name"));
        }
        return buffer.toString();
    }

    @Override
    public void prepareUpgradePlan(SchemaObject newVersion) throws SQLException {
        PlSqlObjectType newObjectType = (PlSqlObjectType)newVersion;
        this.upgradeAttributes(this.attributes, newObjectType.attributes);
        this.upgradeFunctions(this.functionDeclarations, newObjectType.functionDeclarations);
    }

    private void upgradeAttributes(Map<String, Attribute> currentDeclarations, Map<String, Attribute> newDeclarations) {
        ArrayList<Attribute> toAdd = new ArrayList<Attribute>();
        ArrayList<Attribute> toModifyAttrType = new ArrayList<Attribute>();
        ArrayList<Attribute> toDrop = new ArrayList<Attribute>();
        Iterator<String> iterOnCurrent = currentDeclarations.keySet().iterator();
        while (iterOnCurrent.hasNext()) {
            String name = iterOnCurrent.next();
            Attribute from = currentDeclarations.get(name);
            Attribute to = newDeclarations.get(name);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.id + "Comparing from=" + from.toString() + ", to=" + to.toString());
            }
            if (to == null) {
                toDrop.add(from);
                iterOnCurrent.remove();
                continue;
            }
            if (to.equals(from)) {
                newDeclarations.remove(name);
                iterOnCurrent.remove();
                continue;
            }
            if (to.type.equals(from.type)) {
                throw new IllegalArgumentException(this.id + ": length modification is not yet supported: from=" + from.toString() + ", to=" + to.toString());
            }
            toModifyAttrType.add(to);
            newDeclarations.remove(name);
            iterOnCurrent.remove();
        }
        for (String name : newDeclarations.keySet()) {
            toAdd.add(newDeclarations.get(name));
        }
        if (toAdd.size() == 0 && toDrop.size() == 0 && toModifyAttrType.size() == 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Old and new " + this.id + " definitions are identical");
            }
            return;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info(this.id + ": " + currentDeclarations.size() + " methods in the old JChem Cartridge version, " + newDeclarations.size() + " methods in the new JChem Cartridge version ; " + toAdd.size() + " method(s) to add, " + toModifyAttrType.size() + " to modify, " + toDrop.size() + " method(s) to drop");
        }
        this.createAddDropAttributesUpgradeStep(toAdd, toDrop);
        this.createAddDropAttributesUpgradeStep(null, toModifyAttrType);
        this.createAddDropAttributesUpgradeStep(toModifyAttrType, null);
    }

    private void createAddDropAttributesUpgradeStep(List<Attribute> toAdd, List<Attribute> toDrop) {
        Attribute attribute;
        boolean start = true;
        StringBuffer buffer = new StringBuffer("alter type ");
        buffer.append(this.schema.username).append(".").append(this.id.getName()).append(" ");
        Iterator<Attribute> iter = null;
        if (toDrop != null) {
            iter = toDrop.iterator();
            while (iter.hasNext()) {
                if (start) {
                    start = false;
                } else {
                    buffer.append(", ");
                }
                attribute = iter.next();
                buffer.append("drop attribute ").append(attribute.name);
            }
        }
        if (toAdd != null) {
            iter = toAdd.iterator();
            while (iter.hasNext()) {
                if (start) {
                    start = false;
                } else {
                    buffer.append(", ");
                }
                attribute = iter.next();
                buffer.append("add attribute ").append(attribute.toDefinition());
            }
        }
        if (!start) {
            buffer.append(" cascade");
            this.createUpgradeStep(this.schema, buffer.toString());
        }
    }

    private void upgradeFunctions(List<String> currentDeclarations, List<String> newDeclarations) throws SQLException {
        ArrayList<String> toAdd = new ArrayList<String>();
        ArrayList<String> toDrop = new ArrayList<String>();
        for (String def : currentDeclarations) {
            if (newDeclarations.contains(def)) continue;
            toDrop.add(def);
        }
        for (String def : newDeclarations) {
            if (currentDeclarations.contains(def)) continue;
            toAdd.add(def);
        }
        if (toAdd.size() == 0 && toDrop.size() == 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Old and new " + this.id + " definitions are identical");
            }
            return;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info(this.id + ": " + currentDeclarations.size() + " methods in the old JChem Cartridge version, " + newDeclarations.size() + " methods in the new JChem Cartridge version ; " + toAdd.size() + " method(s) to add, " + toDrop.size() + " method(s) to drop");
        }
        this.addDropTypeComponents(toAdd, toDrop);
    }

    private void addDropTypeComponents(List<String> toAdd, List<String> toDrop) throws SQLException {
        String typeComponentDef;
        boolean start = true;
        StringBuffer buffer = new StringBuffer("alter type ");
        buffer.append(this.schema.username).append(".").append(this.id.getName()).append(" ");
        Iterator<String> iter = toDrop.iterator();
        while (iter.hasNext()) {
            if (start) {
                start = false;
            } else {
                buffer.append(", ");
            }
            typeComponentDef = iter.next();
            buffer.append("drop ");
            buffer.append(this.membershipModifier(typeComponentDef));
            buffer.append(" ").append(typeComponentDef);
        }
        iter = toAdd.iterator();
        while (iter.hasNext()) {
            if (start) {
                start = false;
            } else {
                buffer.append(", ");
            }
            typeComponentDef = iter.next();
            buffer.append("add ");
            buffer.append(this.membershipModifier(typeComponentDef));
            buffer.append(" ").append(typeComponentDef);
        }
        buffer.append(" cascade");
        this.createUpgradeStep(this.schema, buffer.toString());
    }

    private String membershipModifier(String methodDef) {
        String[] memberFunctions = new String[]{"ODCIINDEXFETCH", "ODCIINDEXCLOSE", "ODCISTATS"};
        for (int i = 0; i < memberFunctions.length; ++i) {
            String f = memberFunctions[i];
            if (methodDef.indexOf(f) <= -1) continue;
            return "member";
        }
        return "static";
    }

    private static class Attribute {
        public String name;
        public String typeOwner;
        public String type;
        public Integer length;
        public Integer precision;
        public Integer scale;

        private Attribute() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.length == null ? 0 : this.length.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.precision == null ? 0 : this.precision.hashCode());
            result = 31 * result + (this.scale == null ? 0 : this.scale.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Attribute other = (Attribute)obj;
            if (this.length == null ? other.length != null : !this.length.equals(other.length)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.precision == null ? other.precision != null : !this.precision.equals(other.precision)) {
                return false;
            }
            if (this.scale == null ? other.scale != null : !this.scale.equals(other.scale)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toDefinition() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.name).append(" ");
            if (this.typeOwner != null) {
                buffer.append(this.typeOwner).append(".");
            }
            buffer.append(this.type);
            if (this.length != null) {
                buffer.append("(").append(this.length).append(")");
            }
            if (this.precision != null) {
                buffer.append("(").append(this.length);
                if (this.scale != null) {
                    buffer.append(",").append(this.scale);
                }
                buffer.append(")");
            }
            return buffer.toString();
        }

        public String toString() {
            return "Attribute [name=" + this.name + ", typeOwner=" + this.typeOwner + ", type=" + this.type + ", length=" + this.length + ", precision=" + this.precision + ", scale=" + this.scale + "]";
        }
    }
}

