/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install.schema;

import chemaxon.jchem.cartridge.install.ManualUpgradeNeededException;
import chemaxon.jchem.cartridge.install.schema.PlSqlOperatorBinding;
import chemaxon.jchem.cartridge.install.schema.Schema;
import chemaxon.jchem.cartridge.install.schema.SchemaObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

class PlSqlOperator
extends SchemaObject {
    private static final Logger logger = Logger.getLogger(PlSqlOperator.class.getName());
    private final Schema schema;
    private ArrayList<PlSqlOperatorBinding> bindings;

    public PlSqlOperator(Schema schema, String name) throws SQLException {
        super(schema, "OPERATOR", name);
        this.schema = schema;
        this.bindings = this.collectOpBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<PlSqlOperatorBinding> collectOpBindings() throws SQLException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Collecting bindings for " + this.id.getName());
        }
        ArrayList<PlSqlOperatorBinding> l = new ArrayList<PlSqlOperatorBinding>();
        String sql = "select binding#, argument_type from all_oparguments where owner = upper(?) and operator_name = upper(?) order by binding#, position";
        PreparedStatement pstmt = this.schema.conn.prepareStatement(sql);
        try {
            int paramIdx = 1;
            pstmt.setString(paramIdx++, this.schema.username);
            pstmt.setString(paramIdx++, this.id.getName());
            ResultSet rs = pstmt.executeQuery();
            PlSqlOperatorBinding currentBinding = null;
            while (rs.next()) {
                int bindingNo = rs.getInt("binding#");
                String argType = rs.getString("argument_type");
                if (currentBinding == null || currentBinding.bindingNo != bindingNo) {
                    if (currentBinding != null) {
                        l.add(currentBinding);
                    }
                    currentBinding = new PlSqlOperatorBinding(this.schema, bindingNo, this.id.getName());
                }
                currentBinding.argumentTypes.add(argType);
            }
            if (currentBinding != null) {
                l.add(currentBinding);
            }
        }
        finally {
            pstmt.close();
        }
        this.schema.allOperatorBindings.put(this.id.getName(), l);
        return l;
    }

    @Override
    public void prepareCreatePlan(Schema targetSchema) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("create or replace operator ");
        buffer.append(targetSchema.username).append(".").append(this.id.getName());
        buffer.append(" binding\n");
        int l = buffer.length();
        Iterator<PlSqlOperatorBinding> iterator = this.bindings.iterator();
        while (iterator.hasNext()) {
            if (buffer.length() > l) {
                buffer.append(",");
            }
            PlSqlOperatorBinding b = iterator.next();
            buffer.append(b);
        }
        this.createUpgradeStep(targetSchema, buffer.toString());
        targetSchema.add(this);
    }

    @Override
    public void prepareUpgradePlan(SchemaObject newVersion) throws SQLException {
        PlSqlOperator newOpVersion = (PlSqlOperator)newVersion;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Upgrading operator " + this.id.getName() + ". Number of current bindings: " + this.bindings.size() + ", number of new bindings: " + newOpVersion.bindings.size());
        }
        for (PlSqlOperatorBinding currentBinding : this.bindings) {
            if (newOpVersion.bindings.remove(currentBinding)) continue;
            this.dropBinding(currentBinding);
        }
        for (PlSqlOperatorBinding newBinding : newOpVersion.bindings) {
            String stmt = "alter operator " + this.schema.username + "." + this.id.getName() + " " + newBinding.toAddString();
            if (this.schema.dbMajorVersion < 10) {
                throw new ManualUpgradeNeededException(this.schema.dbMajorVersion, this.schema.dbMinorVersion, stmt);
            }
            this.createUpgradeStep(this.schema, stmt);
        }
    }

    private void dropBinding(PlSqlOperatorBinding currentBinding) throws SQLException {
        String stmt = "alter operator " + this.schema.username + "." + this.id.getName() + " " + currentBinding.toDropString();
        if (this.schema.dbMajorVersion < 10) {
            throw new ManualUpgradeNeededException(this.schema.dbMajorVersion, this.schema.dbMinorVersion, stmt);
        }
        this.createUpgradeStep(this.schema, stmt);
    }

    @Override
    public void prepareDropPlan() throws SQLException {
        this.createUpgradeStep(this.schema, "drop operator " + this.schema.username + "." + this.id.getName() + " force");
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PlSqlOperator)) {
            return false;
        }
        PlSqlOperator other = (PlSqlOperator)obj;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Comparing " + this + " with " + other);
        }
        return other.id.getName().equals(this.id.getName());
    }

    @Override
    public String toString() {
        return "PlSqlOperator[" + this.id.getName() + ", " + this.bindings;
    }
}

