/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install.schema;

import chemaxon.jchem.cartridge.importer.JccImporterOracleSupport;
import chemaxon.jchem.cartridge.install.ConnectUtil;
import chemaxon.jchem.cartridge.install.JccInstallConfig;
import chemaxon.jchem.cartridge.install.schema.IndexType;
import chemaxon.jchem.cartridge.install.schema.PlSqlLoader;
import chemaxon.jchem.cartridge.install.schema.PlSqlObjectType;
import chemaxon.jchem.cartridge.install.schema.PlSqlOperator;
import chemaxon.jchem.cartridge.install.schema.PlSqlOperatorBinding;
import chemaxon.jchem.cartridge.install.schema.PlSqlProgram;
import chemaxon.jchem.cartridge.install.schema.PlSqlProgramBody;
import chemaxon.jchem.cartridge.install.schema.SchemaObject;
import chemaxon.jchem.cartridge.install.schema.SchemaObjectDependencies;
import chemaxon.jchem.cartridge.install.schema.Sequence;
import chemaxon.jchem.cartridge.install.schema.UpgradePlan;
import chemaxon.jchem.cartridge.install.schema.UpgradeStep;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.sql.BLOB;

public class Schema {
    static final Logger logger = Logger.getLogger(Schema.class.getName());
    int dbMajorVersion;
    int dbMinorVersion;
    private boolean isDba;
    String username;
    private String password;
    private String hostname;
    private int port;
    private String dbinstance;
    private String cartOwnerName;
    private List<Sequence> sequences = new ArrayList<Sequence>();
    private List<PlSqlProgram> plSqlPrograms = new ArrayList<PlSqlProgram>();
    private List<PlSqlOperator> operators = new ArrayList<PlSqlOperator>();
    private List<IndexType> indexTypes = new ArrayList<IndexType>();
    private List<SchemaObject> newDbObjects = new ArrayList<SchemaObject>();
    Map<String, List<PlSqlOperatorBinding>> allOperatorBindings = new HashMap<String, List<PlSqlOperatorBinding>>();
    Connection conn;

    public Schema(String hostName, int port, String instanceName, String username, String password, String cartOwnerName, boolean isDba) {
        if (username == null) {
            throw new IllegalArgumentException("userame must not be null");
        }
        this.hostname = hostName;
        this.port = port;
        this.dbinstance = instanceName;
        this.username = username;
        this.password = password;
        this.cartOwnerName = cartOwnerName;
        this.isDba = isDba;
    }

    public void connect() throws SQLException {
        if (this.conn == null) {
            this.conn = ConnectUtil.getConnection(this.hostname, this.port, this.dbinstance, this.username, this.password);
            DatabaseMetaData dbMetaData = this.conn.getMetaData();
            this.dbMajorVersion = dbMetaData.getDatabaseMajorVersion();
            this.dbMinorVersion = dbMetaData.getDatabaseMinorVersion();
        }
    }

    public void disconnect() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    public void buildFromDatabase() throws SQLException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Building schema model for " + this.username.toUpperCase() + "...");
        }
        this.connect();
        this.collectSequences();
        this.collectPlSqlPrograms();
        this.collectOperators();
        this.collectIndexTypes();
        this.collectPlSqlProgramDependencies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectSequences() throws SQLException {
        String sql = "select sequence_name from all_sequences where sequence_owner = upper(?)";
        PreparedStatement pstmt = this.conn.prepareStatement(sql);
        try {
            pstmt.setString(1, this.username);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String sequenceName = rs.getString("sequence_name");
                this.sequences.add(new Sequence(this, sequenceName));
            }
        }
        finally {
            pstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectPlSqlPrograms() throws SQLException {
        String sql = "select distinct type, name from all_source where owner = upper(?)";
        String sqlParam1 = this.username;
        PreparedStatement pstmt = this.conn.prepareStatement(sql);
        try {
            pstmt.setString(1, sqlParam1);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                PlSqlProgram p = null;
                String type = rs.getString(1);
                String name = rs.getString(2);
                p = type.endsWith("BODY") ? new PlSqlProgramBody(this, type, name) : (type.equals("TYPE") ? new PlSqlObjectType(this, name) : new PlSqlProgram(this, type, name));
                this.plSqlPrograms.add(p);
            }
        }
        finally {
            pstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectOperators() throws SQLException {
        String sql = "select distinct operator_name from all_operators where owner = upper(?)";
        String sqlParam1 = this.username;
        PreparedStatement pstmt = this.conn.prepareStatement(sql);
        try {
            pstmt.setString(1, sqlParam1);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.operators.add(new PlSqlOperator(this, rs.getString(1)));
            }
        }
        finally {
            pstmt.close();
        }
    }

    private <E> E getDbObject(List<? extends E> list, E peer) {
        for (E e : list) {
            if (!e.equals(peer)) continue;
            return e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectIndexTypes() throws SQLException {
        String sql = "select indextype_name, implementation_name, partitioning from all_indextypes where owner = upper(?)";
        PreparedStatement pstmt = this.conn.prepareStatement(sql);
        try {
            pstmt.setString(1, this.username);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Executing " + sql + " using " + this.username + " for owner...");
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String indexTypeName = rs.getString("indextype_name");
                String implementationName = rs.getString("implementation_name");
                String partitioning = rs.getString("partitioning");
                this.indexTypes.add(new IndexType(this, indexTypeName, implementationName, partitioning));
            }
        }
        finally {
            pstmt.close();
        }
    }

    public void add(SchemaObject dbObject) {
        this.newDbObjects.add(dbObject);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(dbObject + " added to " + this.getUsername());
        }
    }

    private void collectPlSqlProgramDependencies() {
    }

    public UpgradePlan createUpgradePlan(Schema newVersion) throws Exception {
        UpgradePlan plan = new UpgradePlan();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Preparing upgrade of JChem Cartridge in " + this.username.toUpperCase() + " based on " + newVersion.username.toUpperCase() + "...");
        }
        this.prepareUpgrade(newVersion.sequences, this.sequences);
        this.prepareUpgrade(newVersion.plSqlPrograms, this.plSqlPrograms);
        this.prepareUpgrade(newVersion.operators, this.operators);
        this.prepareUpgrade(newVersion.indexTypes, this.indexTypes);
        plan.addSteps(this.getUpgradeSteps(newVersion));
        return plan;
    }

    private <E> void prepareUpgrade(List<? extends SchemaObject> newVersions, List<? extends SchemaObject> currentVersions) throws SQLException {
        for (SchemaObject schemaObject : newVersions) {
            SchemaObject cvObject = this.getDbObject(currentVersions, schemaObject);
            if (cvObject == null) {
                schemaObject.prepareCreatePlan(this);
                continue;
            }
            cvObject.prepareUpgradePlan(schemaObject);
        }
        for (SchemaObject schemaObject : currentVersions) {
            SchemaObject no = this.getDbObject(newVersions, schemaObject);
            if (no != null) continue;
            schemaObject.prepareDropPlan();
        }
    }

    private List<UpgradeStep> getUpgradeSteps(Schema newVersion) throws Exception {
        ArrayList<UpgradeStep> steps = new ArrayList<UpgradeStep>();
        SchemaObjectDependencies deps = new SchemaObjectDependencies();
        deps.build(newVersion);
        ArrayList<SchemaObject> allObjects = new ArrayList<SchemaObject>();
        allObjects.addAll(this.newDbObjects);
        allObjects.addAll(this.sequences);
        allObjects.addAll(this.plSqlPrograms);
        allObjects.addAll(this.operators);
        allObjects.addAll(this.indexTypes);
        steps.addAll(deps.getUpgradeSteps(allObjects));
        return steps;
    }

    public void verifyBasedOn(Schema newVersion) throws Exception {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Verifying schema objects...");
        }
        this.compilePlSqlPrograms(newVersion);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Schema objects verified.");
        }
    }

    private void compilePlSqlPrograms(Schema newVersion) throws Exception {
        for (PlSqlProgram p : newVersion.plSqlPrograms) {
            if (p instanceof PlSqlProgramBody) continue;
            this.compile(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(PlSqlProgram p) throws Exception {
        String sql = "alter " + p.id.getType() + " " + p.id.getName() + " compile";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(sql);
        }
        Statement stmt = this.conn.createStatement();
        try {
            stmt.execute(sql);
            PlSqlLoader.checkErrors(this.conn, this.getUsername().toUpperCase(), p.id.getName(), null);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String[]> getJcIndexes(ArrayList<String[]> badIndexes) throws Exception {
        ArrayList<String[]> jcIndexes = new ArrayList<String[]>();
        String viewName = "all_indexes";
        if (this.isDba) {
            viewName = "dba_indexes";
        }
        String sql = "select owner, index_name, partitioned from " + viewName + " where ityp_owner = '" + this.cartOwnerName.toUpperCase() + "' and ityp_name = 'JC_IDXTYPE'";
        Statement stmt = this.conn.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String idxOwner = rs.getString("owner");
                String idxName = rs.getString("index_name");
                String partioned = rs.getString("partitioned");
                try {
                    if (partioned.equals("YES")) {
                        String sqlPartitions = "select partition_name from all_ind_partitions where index_owner = '" + idxOwner + "' and index_name = '" + idxName + "'";
                        Statement stmtPartitions = this.conn.createStatement();
                        try {
                            ResultSet rsPartitions = stmtPartitions.executeQuery(sqlPartitions);
                            while (rsPartitions.next()) {
                                String partName = rsPartitions.getString(1);
                                jcIndexes.add(new String[]{idxOwner, idxName, partName});
                            }
                            continue;
                        }
                        finally {
                            stmtPartitions.close();
                            continue;
                        }
                    }
                    jcIndexes.add(new String[]{idxOwner, idxName});
                }
                catch (Throwable throwable) {
                    if (badIndexes == null) continue;
                    badIndexes.add(new String[]{idxOwner + "." + idxName, throwable.getMessage()});
                }
            }
            if (logger.isLoggable(Level.FINE) && badIndexes != null) {
                logger.fine("Found " + badIndexes.size() + " indexes in total.");
            }
            ArrayList<String[]> arrayList = jcIndexes;
            return arrayList;
        }
        finally {
            stmt.close();
        }
    }

    public SchemaObject findDbObjectByName(String identifier) {
        for (SchemaObject entity : this.newDbObjects) {
            if (!entity.id.getName().equalsIgnoreCase(identifier)) continue;
            return entity;
        }
        return null;
    }

    public PlSqlProgram findDbObjectByComponentName(String componentName) throws SQLException {
        for (PlSqlProgram p : this.plSqlPrograms) {
            if (!this.specifiesComponent(p, componentName)) continue;
            return p;
        }
        return null;
    }

    private boolean specifiesComponent(PlSqlProgram p, String component) throws SQLException {
        boolean retval;
        if (p instanceof PlSqlProgramBody) {
            return false;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Checking entity " + p.id + " for component " + component + "...");
        }
        boolean bl = retval = p.getSource().toLowerCase().indexOf(component.toLowerCase()) != -1;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Component " + component + (retval ? "" : " NOT") + " found in entity " + p.id);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadJar(String jarfile) throws SQLException, IOException {
        String tableName = this.createJarTable();
        try {
            this.loadClasses(jarfile, tableName);
            this.createJava(tableName);
        }
        finally {
            this.dropTable(tableName);
        }
    }

    private String createJarTable() throws SQLException {
        String tableName = "cls";
        this.executeSql("create table cls (id number primary key, cl blob not null) lob(cl) store as (cache)");
        this.executeSql("create sequence cls_pksq");
        return "cls";
    }

    private void dropTable(String tableName) throws SQLException {
        this.executeSql("drop table " + tableName);
        this.executeSql("drop sequence " + tableName + "_pksq");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClasses(String jarfile, String tableName) throws IOException, SQLException {
        String sql = "insert into " + tableName + " values(" + tableName + "_pksq.nextval, ?)";
        PreparedStatement pstmt = this.getConnection().prepareStatement(sql);
        try {
            JarFile jf = new JarFile(jarfile);
            try {
                Enumeration<JarEntry> entries = jf.entries();
                int count = 0;
                while (entries.hasMoreElements()) {
                    JarEntry e = entries.nextElement();
                    if (!e.getName().endsWith(".class")) continue;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Processing " + e.getName());
                    }
                    byte[] classAsBytes = this.toBytes(jf.getInputStream(e));
                    BLOB tmpBlob = this.setBlobValue(pstmt, classAsBytes);
                    try {
                        pstmt.execute();
                    }
                    finally {
                        if (tmpBlob != null) {
                            tmpBlob.freeTemporary();
                        }
                    }
                    if (count++ % 1000 != 0) continue;
                    this.getConnection().commit();
                }
                this.getConnection().commit();
            }
            finally {
                jf.close();
            }
        }
        finally {
            pstmt.close();
        }
    }

    private BLOB setBlobValue(PreparedStatement pstmt, byte[] bytes) throws SQLException, IOException {
        BLOB blob = null;
        if (bytes.length > 2000) {
            blob = JccImporterOracleSupport.getTmpBLOB(this.getConnection(), bytes);
            if (blob == null) {
                throw new NullPointerException();
            }
            pstmt.setBlob(1, (Blob)blob);
        } else {
            pstmt.setBytes(1, bytes);
        }
        return blob;
    }

    private byte[] toBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int readCount = inputStream.read(buffer);
        while (readCount != -1) {
            baos.write(buffer, 0, readCount);
            readCount = inputStream.read(buffer);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJava(String tableName) throws SQLException {
        String sql = "select id from " + tableName;
        PreparedStatement pstmt = this.getConnection().prepareStatement(sql);
        try {
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int id = rs.getInt(1);
                String sql1 = "create or replace java class using blob select cl from " + tableName + " where id = " + id;
                this.executeSql(sql1);
            }
        }
        finally {
            pstmt.close();
        }
    }

    public void executeSqls(List<String> sqls) throws SQLException {
        for (String sql : sqls) {
            this.executeSql(sql);
        }
    }

    public void executeSql(String sql) throws SQLException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getUsername() + ": " + sql);
        }
        this.connect();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("After connect: " + this.conn.getMetaData().getUserName());
        }
        if (sql.equalsIgnoreCase("create or replace null")) {
            throw new IllegalArgumentException(sql);
        }
        if (JccInstallConfig.dryrun) {
            if (!logger.isLoggable(Level.FINE)) {
                System.out.println(sql);
            }
            return;
        }
        Statement stmt = this.conn.createStatement();
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("About to execute `" + sql + "`...");
            }
            stmt.execute(sql);
        }
        catch (SQLException sqlException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Sql failed: " + sql, sqlException);
            }
            throw sqlException;
        }
        finally {
            stmt.close();
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getDbinstance() {
        return this.dbinstance;
    }

    public Connection getConnection() throws SQLException {
        this.connect();
        return this.conn;
    }

    public void setPasswordForJcc() throws SQLException {
        String cartOwnerRef;
        if (this.cartOwnerName == null) {
            cartOwnerRef = "";
        } else {
            cartOwnerRef = this.cartOwnerName + ".";
            this.executeSql("call " + cartOwnerRef + "jchem_core_pkg.set_jccowner_schema('" + this.cartOwnerName + "')");
        }
        this.executeSql("call " + cartOwnerRef + "jchem_core_pkg.use_password('" + this.getPassword() + "')");
    }

    public void reconnect() throws SQLException {
        this.disconnect();
        this.connect();
        this.setPasswordForJcc();
    }

    public void setJccOwnerName(String cartOwnerName) {
        this.cartOwnerName = cartOwnerName;
    }

    public String getJccOwnerName() {
        return this.cartOwnerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            String sql = "create or replace procedure zazi as begin ; end;";
            Class.forName("oracle.jdbc.OracleDriver");
            Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521:mydb", "pkovacsuser_trunk", "ciril");
            try {
                Statement stmt = conn.createStatement();
                try {
                    stmt.execute(sql);
                    System.out.println(sql + " executed");
                    sql = "alter procedure zazi compile";
                    stmt.execute(sql);
                    System.out.println(sql + " executed");
                    PlSqlLoader.checkErrors(conn, "PKOVACSUSER_TRUNK", "ZAZI", null);
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }
}

