/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install.schema;

import chemaxon.jchem.cartridge.install.schema.Schema;
import chemaxon.jchem.cartridge.install.schema.SchemaObjectId;
import chemaxon.jchem.cartridge.install.schema.UpgradeStep;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

abstract class SchemaObject {
    private static final Logger logger = Logger.getLogger(SchemaObject.class.getName());
    protected List<UpgradeStep> upgradeSteps = new ArrayList<UpgradeStep>();
    protected SchemaObjectId id;
    final Schema schema;

    public SchemaObject(Schema schema, String type, String name) throws SQLException {
        this.schema = schema;
        this.id = new SchemaObjectId(type, name);
    }

    public String insertSchemaQualif(String text) {
        StringBuffer buffer = new StringBuffer();
        return buffer.toString();
    }

    public abstract void prepareCreatePlan(Schema var1) throws SQLException;

    public abstract void prepareUpgradePlan(SchemaObject var1) throws SQLException;

    public void prepareDropPlan() throws SQLException {
        this.createUpgradeStep("drop " + this.id.getType() + " " + this.id.getName());
    }

    public void executeUpgradeSteps() throws SQLException {
        for (UpgradeStep step : this.upgradeSteps) {
            step.perform();
        }
    }

    public List<UpgradeStep> getUpgradeSteps() throws Exception {
        return this.upgradeSteps;
    }

    protected void createUpgradeStep(String sql) {
        this.createUpgradeStep(this.schema, sql);
    }

    protected void createUpgradeStep(Schema targetSchema, String sql) {
        this.upgradeSteps.add(new UpgradeStep(targetSchema, this.id, sql));
    }

    public String toString() {
        return this.id.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SchemaObject)) {
            return false;
        }
        SchemaObject other = (SchemaObject)o;
        return this.id.equals(other.id);
    }

    public static void main(String[] args) {
        String s1 = "TRUE";
        String s2 = "true";
        System.out.println(s1.toLowerCase() == s2);
        System.out.println(s1.toLowerCase().equals(s2));
    }
}

