/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.install.schema;

import chemaxon.jchem.cartridge.install.schema.Schema;
import chemaxon.jchem.cartridge.install.schema.SchemaObject;
import chemaxon.jchem.cartridge.install.schema.SchemaObjectId;
import chemaxon.jchem.cartridge.install.schema.UpgradeStep;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SchemaObjectDependencies {
    private static final Logger logger = Logger.getLogger(SchemaObjectDependencies.class.getName());
    private List<Node> flat = new ArrayList<Node>();
    private List<Node> topDependents = new ArrayList<Node>();

    public void build(Schema schema) throws SQLException {
        List<DependencyPair> pairList = this.buildPairList(schema);
        this.build(pairList);
        if (logger.isLoggable(Level.FINEST)) {
            this.logTop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DependencyPair> buildPairList(Schema schema) throws SQLException {
        ArrayList<DependencyPair> list = new ArrayList<DependencyPair>();
        String sql = "select type, name, referenced_type, referenced_name from all_dependencies where referenced_owner = owner and owner = '" + schema.getUsername().toUpperCase() + "' " + "and referenced_type <> 'NON-EXISTENT' ";
        Statement stmt = schema.getConnection().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                DependencyPair pair = new DependencyPair();
                pair.pendent = new SchemaObjectId(rs.getString("type"), rs.getString("name"));
                pair.pendee = new SchemaObjectId(rs.getString("referenced_type"), rs.getString("referenced_name"));
                list.add(pair);
            }
            ArrayList<DependencyPair> arrayList = list;
            return arrayList;
        }
        finally {
            stmt.close();
        }
    }

    private void build(List<DependencyPair> pairs) {
        for (DependencyPair pair : pairs) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("pair=" + pair);
            }
            Node pendent = this.find(pair.pendent, this.flat);
            Node pendee = this.find(pair.pendee, this.flat);
            if (pendent == null) {
                pendee = this.checkCreatePendee(pendee, pair.pendee);
                pendent = new Node(pair.pendent, pendee);
                this.flat.add(pendent);
                this.topDependents.add(pendent);
            } else {
                pendee = this.checkCreatePendee(pendee, pair.pendee);
                pendent.dependees.add(pendee);
            }
            if (!logger.isLoggable(Level.FINEST)) continue;
            this.logTop();
        }
    }

    private Node checkCreatePendee(Node pendeeNode, SchemaObjectId pendee) {
        if (logger.isLoggable(Level.FINEST) && pendee.getName().equals("JCC_IDX_STATS")) {
            logger.finest("pendee=" + pendee);
        }
        if (pendeeNode == null) {
            pendeeNode = new Node(pendee, null);
            this.flat.add(pendeeNode);
        } else {
            boolean found = this.topDependents.remove(pendeeNode);
            if (logger.isLoggable(Level.FINEST) && pendee.getName().equals("JCC_IDX_STATS")) {
                logger.finest((found ? "" : "NOT ") + "found in topDendependts");
            }
        }
        return pendeeNode;
    }

    private Node find(SchemaObjectId id, List<Node> list) {
        for (Node n : list) {
            if (!n.o.equals(id)) continue;
            return n;
        }
        return null;
    }

    public List<UpgradeStep> getUpgradeSteps(List<? extends SchemaObject> objList) throws Exception {
        ArrayList<UpgradeStep> seq = new ArrayList<UpgradeStep>();
        ArrayList<? extends SchemaObject> cpy = new ArrayList<SchemaObject>();
        cpy.addAll(objList);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Object list copy: " + cpy);
        }
        this.recurse(this.topDependents, seq, cpy);
        for (SchemaObject schemaObject : cpy) {
            seq.addAll(schemaObject.getUpgradeSteps());
        }
        return seq;
    }

    private void recurse(List<Node> list, List<UpgradeStep> seq, List<? extends SchemaObject> objList) throws Exception {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("list=" + list);
        }
        for (Node n : list) {
            this.recurse(n.dependees, seq, objList);
            if (n.planned) continue;
            List<UpgradeStep> steps = this.findSteps(n.o, objList);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Object list copy: " + objList);
            }
            seq.addAll(steps);
            n.planned = true;
        }
        list.clear();
    }

    private List<UpgradeStep> findSteps(SchemaObjectId o, List<? extends SchemaObject> objList) throws Exception {
        Iterator<? extends SchemaObject> iter = objList.iterator();
        while (iter.hasNext()) {
            SchemaObject ol = iter.next();
            if (!ol.id.equals(o)) continue;
            iter.remove();
            return ol.getUpgradeSteps();
        }
        throw new RuntimeException(o + " could not be found in " + objList);
    }

    private void logTop() {
        StringBuilder b = new StringBuilder();
        for (Node n : this.topDependents) {
            if (b.length() > 0) {
                b.append(",");
            }
            b.append(n.o);
        }
        logger.finest("top=" + b.toString());
    }

    private static class Node {
        private SchemaObjectId o;
        private List<Node> dependees = new ArrayList<Node>();
        public boolean planned;

        public Node(SchemaObjectId o, Node dependee) {
            if (o == null) {
                throw new IllegalArgumentException("Schema object id must not be null");
            }
            this.o = o;
            if (dependee != null) {
                this.dependees.add(dependee);
            }
        }

        public String toString() {
            return "PlSqlProgramDependencies.Node[o=" + this.o + "dependees=" + this.dependees + "]";
        }

        public int hashCode() {
            return this.o.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return this.o.equals(other.o);
        }
    }

    private static class DependencyPair {
        private SchemaObjectId pendent;
        private SchemaObjectId pendee;

        private DependencyPair() {
        }

        public String toString() {
            return "DependencyPair[dpendent=" + this.pendent + ",dpendee=" + this.pendee + "]";
        }
    }
}

