/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.jcservcli;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NisStructureSearch;
import chemaxon.jchem.cartridge.oresident.util.CxOptions;
import chemaxon.jchem.cartridge.rmi.MolSearch;
import chemaxon.jchem.cartridge.rmi.TableScan;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.search.MolSearchParams;
import chemaxon.jchem.cartridge.util.JCartLogger;
import chemaxon.util.IntArray;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LocalPerfectSearchResult
implements TableScan {
    private static final JCartLogger logger = JCartLogger.getLogger(LocalPerfectSearchResult.class);
    private JCartIndexDescriptor idxDescriptor;
    private boolean queryAsCdSmiles;
    private String generTautomer;
    private String options;
    private int maxHitCount;
    private PreparedStatement psTargetsByCdHash;
    private String query;
    private ResultSet rsTargetsByCdHash = null;
    private PreparedStatement psTargetsByCdId;
    private int chunkSize = 100;
    private int totalHitCount;
    private MolSearch molSearch;
    private int cdHashCode;
    private boolean done;
    private int hashCodeMatchCount;
    private int uniqueSmilesMatchCount;
    private int abasMatchCount;

    public LocalPerfectSearchResult(JCartIndexDescriptor idxDescriptor, String queryStructure, String querySmiles, int maxHitCount, String generTautomer, String options, int cdHashCode) throws Exception {
        this.idxDescriptor = idxDescriptor;
        this.cdHashCode = cdHashCode;
        this.generTautomer = generTautomer;
        this.options = options;
        this.maxHitCount = maxHitCount;
        if (queryStructure == null) {
            throw new IllegalArgumentException("queryStructure should not be null");
        }
        this.queryAsCdSmiles = true;
        this.query = querySmiles;
        if (querySmiles == null) {
            this.query = queryStructure;
            this.queryAsCdSmiles = false;
        }
        if (options != null) {
            CxOptions jcOptions = new CxOptions(options);
            this.chunkSize = jcOptions.getIntValue("earlyResults", 100);
            maxHitCount = jcOptions.getIntValue("maxHitCount", Integer.MAX_VALUE);
        }
        if (this.chunkSize == 0) {
            this.chunkSize = Integer.MAX_VALUE;
        }
        this.molSearch = (MolSearch)RmiDirectory.instance().getServer("MolSearchServer");
    }

    private PreparedStatement createPsTargetsByCdHash() throws SQLException {
        StringBuffer stmt = new StringBuffer("");
        stmt.append("select cd_id, cd_smiles from ");
        stmt.append(this.idxDescriptor.getIdxTableQName());
        stmt.append(" where cd_hash = ?");
        PreparedStatement psTargetsByCdHash = JavaStoredProcSession.instance().prepareStatement(stmt.toString());
        psTargetsByCdHash.setInt(1, this.cdHashCode);
        return psTargetsByCdHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int isMatch() throws Exception {
        MolSearchParams molSearchInfo;
        boolean isMatching;
        ++this.hashCodeMatchCount;
        int id = this.rsTargetsByCdHash.getInt(1);
        String smiles = this.rsTargetsByCdHash.getString(2);
        if (this.queryAsCdSmiles && this.query.equals(smiles)) {
            ++this.uniqueSmilesMatchCount;
            return id;
        }
        String target = smiles;
        boolean targetStdrNeeded = false;
        if (smiles == null) {
            targetStdrNeeded = true;
            if (this.psTargetsByCdId == null) {
                this.psTargetsByCdId = JavaStoredProcSession.instance().prepareStatement(LocalPerfectSearchResult.createSqlForGettingTargetByCdId(this.idxDescriptor));
            }
            this.psTargetsByCdId.setInt(1, id);
            ResultSet rsTargets = this.psTargetsByCdId.executeQuery();
            try {
                if (!rsTargets.next()) {
                    throw new RuntimeException("No such cd_id found by " + LocalPerfectSearchResult.createSqlForGettingTargetByCdId(this.idxDescriptor) + ": " + id);
                }
                byte[] targetCdStructure = JFunctions.readBytes(rsTargets, 1);
                target = new String(targetCdStructure, "US-ASCII");
            }
            finally {
                JavaStoredProcSession.instance().close(rsTargets, null);
            }
        }
        if (this.generTautomer != null) {
            this.query = this.generTautomer;
        }
        if (this.options == null) {
            this.options = "t:p";
        }
        if (isMatching = this.molSearch.search(molSearchInfo = NisStructureSearch.createMolSearchInfo(-1, this.options, !this.queryAsCdSmiles, this.idxDescriptor.isAbsoluteStereo(null), this.idxDescriptor.getTableType(), JFunctions.encodeDbString(this.query), JFunctions.encodeDbString(target), targetStdrNeeded, this.idxDescriptor, null))) {
            ++this.abasMatchCount;
            return id;
        }
        return -1;
    }

    public static String createSqlForGettingTargetByCdId(JCartIndexDescriptor idxDescriptor) {
        StringBuffer stmt = new StringBuffer("");
        if (idxDescriptor.isJChemTable()) {
            stmt.append("select cd_structure from ");
            stmt.append(idxDescriptor.getIdxTableQName());
            stmt.append(" where cd_id = ?");
        } else {
            String baseTableQName = idxDescriptor.getBaseTableSchema() + "." + idxDescriptor.getBaseTableName();
            stmt.append("select ").append(idxDescriptor.getColName());
            stmt.append(" from ");
            stmt.append(baseTableQName).append(" bt, ");
            stmt.append(idxDescriptor.getIdxTableQName()).append(" it ");
            stmt.append(" where bt.rowid = it.rid and it.cd_id = ?");
        }
        return stmt.toString();
    }

    @Override
    public int[] getNextHits() throws RemoteException {
        try {
            return this.getNextHitsUc();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while getting the next hits: " + exception.getMessage(), exception);
        }
    }

    private int[] getNextHitsUc() throws Exception {
        if (this.done) {
            return null;
        }
        if (this.psTargetsByCdHash == null) {
            this.psTargetsByCdHash = this.createPsTargetsByCdHash();
            this.rsTargetsByCdHash = this.psTargetsByCdHash.executeQuery();
        }
        IntArray ia = new IntArray();
        while (!this.done && this.totalHitCount < this.maxHitCount && ia.size() < this.chunkSize && this.rsTargetsByCdHash.next()) {
            int id = this.isMatch();
            if (id <= 0) continue;
            ia.add(id);
            ++this.totalHitCount;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("done=" + this.done + ", totalHitCount=" + this.totalHitCount + ", maxHitCount=" + this.maxHitCount);
        }
        if (ia.size() < this.chunkSize) {
            this.done = true;
            if (ia.size() == 0) {
                return null;
            }
        }
        return ia.toArray();
    }

    @Override
    public void dispose() throws RemoteException {
        try {
            JavaStoredProcSession.instance().close(this.rsTargetsByCdHash, this.psTargetsByCdHash);
            JavaStoredProcSession.instance().close(null, this.psTargetsByCdId);
            if (logger.isDebugEnabled()) {
                logger.debug("hashCodeMatchCount=" + this.hashCodeMatchCount + ", uniqueSmilesMatchCount=" + this.uniqueSmilesMatchCount + ", abasMatchCount=" + this.abasMatchCount);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }

    @Override
    public String getDescription() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long getMemoryUsage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long getSearchId() throws RemoteException {
        throw new UnsupportedOperationException();
    }
}

