/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.jcservcli;

import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.jcservcli.ServiceEndPoint;
import java.util.ArrayList;

public class ServiceEndPointLocator {
    public static final String MASTER_PROPERTY_KEY = "jchem.service.endPoint.url";
    private static ServiceEndPointLocator instance;
    private DbSession dbSession;
    private String jcartOwnerSchema;
    private ArrayList srvEndPointCache = new ArrayList();
    private long endPointsRefreshIval = 600000L;
    private long lastCall = 0L;

    public ServiceEndPointLocator(DbSession dbSession) throws Exception {
        this.dbSession = dbSession;
        this.jcartOwnerSchema = dbSession.getJccOwner();
    }

    private void readServiceEndPoints() throws Exception {
        for (int ix = 1; ix < Integer.MAX_VALUE; ++ix) {
            String endPoint = this.readServiceEndPoint(ix);
            if (endPoint == null) {
                return;
            }
            this.srvEndPointCache.add(new ServiceEndPoint(endPoint));
        }
    }

    private String readServiceEndPoint(int ix) throws Exception {
        return new JcMetaDataFunctions(this.dbSession).getMasterProperty(this.jcartOwnerSchema, "jchem.service.endPoint.url." + ix);
    }

    public ServiceEndPoint getEndPoint() throws Exception {
        long now = System.currentTimeMillis();
        if (now - this.lastCall >= this.endPointsRefreshIval) {
            this.readServiceEndPoints();
        }
        this.lastCall = now;
        ServiceEndPoint endPoint = null;
        for (int ix = 0; ix < this.srvEndPointCache.size(); ++ix) {
            endPoint = (ServiceEndPoint)this.srvEndPointCache.get(ix);
            if (!endPoint.isStatus()) continue;
            return endPoint;
        }
        return null;
    }

    public ServiceEndPoint fallback() {
        return (ServiceEndPoint)this.srvEndPointCache.get(0);
    }

    public static ServiceEndPointLocator getInstance(DbSession dbSession) {
        if (instance == null) {
            try {
                instance = new ServiceEndPointLocator(dbSession);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        return instance;
    }
}

