/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.oresident;

import chemaxon.jchem.cartridge.dbsession.DbSessionBase;
import chemaxon.jchem.cartridge.rmi.DuplicateStructureException;
import chemaxon.jchem.cartridge.rmi.IllegalOptionException;
import chemaxon.jchem.cartridge.rmi.JccSecurityException;
import chemaxon.jchem.cartridge.rmi.KilledTaskException;
import chemaxon.jchem.cartridge.rmi.StructureFormatException;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class JavaStoredProcExceptionHandler {
    private static final JCartLogger logger = JCartLogger.getLogger(JavaStoredProcExceptionHandler.class);
    private static final boolean doSessionTrace = logger.isDebugEnabled();
    private static final boolean backwardCompatible = false;
    private static Boolean priorJdk14;
    public static final Class[] handledExceptions;

    public static String handleTopLevelError(Throwable error) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("handleTopLevelError: handling " + JCartLogger.stackTrace(error));
        }
        if (doSessionTrace) {
            logger.error(JCartLogger.stackTrace(error));
        }
        Throwable toHandle = null;
        int errNo = 0;
        for (int i = 0; i < handledExceptions.length && toHandle == null; ++i) {
            Class eClass = handledExceptions[i];
            toHandle = JavaStoredProcExceptionHandler.getFirstCauseOfType(error, eClass);
            ++errNo;
        }
        if (toHandle == null) {
            JavaStoredProcExceptionHandler.throwException(error);
            return error.getMessage();
        }
        String errorMessage = errNo + 100 + "~" + toHandle.getMessage();
        JavaStoredProcExceptionHandler.setLastError(errorMessage);
        if (logger.isDebugEnabled()) {
            logger.debug("Returning error message: " + errorMessage);
        }
        return errorMessage;
    }

    private static void throwException(Throwable error) throws Exception {
        if (error instanceof Exception) {
            throw (Exception)error;
        }
        try {
            Constructor constr = RuntimeException.class.getConstructor(Throwable.class);
            throw (RuntimeException)constr.newInstance(error);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(error.getMessage());
        }
    }

    public static Throwable getFirstCauseOfType(Throwable exception, Class cause) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("exception=" + exception.getClass().getName() + "[\"" + exception.getMessage() + "\"], cause=" + cause.getName());
        }
        if (JavaStoredProcExceptionHandler.isJdkOlderThan14()) {
            return JavaStoredProcExceptionHandler.getFirstCauseOfTypePriorJdk14(exception, cause);
        }
        Throwable next = exception;
        while (next != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Checking " + next.getClass().getName() + "[\"" + next.getMessage() + "\"]...");
            }
            if (next.getClass().equals(cause)) {
                return next;
            }
            next = JavaStoredProcExceptionHandler.getNextCause(next);
        }
        return null;
    }

    private static Throwable getFirstCauseOfTypePriorJdk14(Throwable exception, Class cause) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (exception.getClass().equals(cause)) {
            return exception;
        }
        String message = exception.getMessage();
        String causeName = cause.getName();
        int causeNameStartPos = message.indexOf(causeName);
        if (logger.isDebugEnabled()) {
            logger.debug("causeNameStartPos=" + causeNameStartPos);
        }
        if (causeNameStartPos == -1) {
            return null;
        }
        int causeMessageStartPos = causeNameStartPos + causeName.length() + 2;
        String causeMessage = message.substring(causeMessageStartPos);
        try {
            Constructor c = cause.getConstructor(String.class);
            return (Throwable)c.newInstance(causeMessage);
        }
        catch (NoSuchMethodException nsme) {
            return (Throwable)cause.newInstance();
        }
    }

    private static Throwable getNextCause(Throwable throwable) throws Exception {
        try {
            Method getCauseMethod = Throwable.class.getMethod("getCause", null);
            return (Throwable)getCauseMethod.invoke((Object)throwable, (Object[])null);
        }
        catch (Exception e) {
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new Exception(throwable.getMessage());
        }
    }

    private static boolean isJdkOlderThan14() {
        if (priorJdk14 == null) {
            try {
                Method getCauseMethod = Throwable.class.getMethod("getCause", null);
                priorJdk14 = new Boolean(false);
            }
            catch (NoSuchMethodException nsme) {
                priorJdk14 = new Boolean(true);
            }
        }
        return priorJdk14;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLastError(String message) throws SQLException {
        String sql = "declare begin " + DbSessionBase.getCurrent().getJccOwner() + ".jchem_core_pkg.lastError := ?; end;";
        PreparedStatement pstmt = DbSessionBase.getCurrent().prepareStatement(sql);
        try {
            pstmt.setString(1, message);
            pstmt.execute();
        }
        finally {
            DbSessionBase.getCurrent().close(null, pstmt);
        }
    }

    static {
        handledExceptions = new Class[]{StructureFormatException.class, IllegalOptionException.class, DuplicateStructureException.class, JccSecurityException.class, IllegalArgumentException.class, JccSecurityException.class, KilledTaskException.class};
    }
}

