/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.oresident;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.oresident.JavaStoredProcExceptionHandler;
import chemaxon.jchem.cartridge.oresident.util.CxOptions;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.io.Serializable;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.sql.ARRAY;
import oracle.sql.STRUCT;

public class ScanContext
implements Serializable {
    private static final JCartLogger logger = JCartLogger.getLogger(ScanContext.class);
    public static final String SCAN_CONTEXT_TYPE_NAME = "SCAN_CONTEXT";
    private static final String SCAN_CONTEXT_ARRAY_TYPE_NAME = "SCAN_CONTEXT_ARRAY";
    public static final int MAX_SCANCTX_COUNT = 200;
    public static final int MAX_ARGUMENT_COUNT = 6;
    private static List scanContextList = new LinkedList();
    private static Map scannoToScanContext = new HashMap();
    private static Set openScanContexts = new HashSet();
    private JCartIndexDescriptor indexDescriptor;
    private long scanId;
    private String usrOpId;
    private java.util.Date startDate;
    private String operatorName;
    private String[] arguments = new String[6];
    private String note;
    private SoftData softData;
    private PreparedStatement pstmtRetrieveRowid;

    public ScanContext(JCartIndexDescriptor idxDesc, long scanId, String usrOpId, java.util.Date startDate, String operatorName, String[] arguments, String note, SoftData softData) throws SQLException {
        this.indexDescriptor = idxDesc;
        this.scanId = scanId;
        this.usrOpId = usrOpId;
        this.startDate = startDate;
        this.operatorName = operatorName;
        this.note = note;
        this.arguments = this.checkArguments(arguments);
        this.softData = softData;
    }

    private String[] checkArguments(String[] arguments) {
        int excessArgs = arguments.length - 6;
        if (excessArgs > 0) {
            this.note = excessArgs + " argument(s) not recorded.";
        }
        String[] result = new String[Math.min(arguments.length, 6)];
        for (int ix = 0; ix < result.length; ++ix) {
            result[ix] = arguments[ix];
        }
        return result;
    }

    public JCartIndexDescriptor getIndexDescriptor() {
        return this.indexDescriptor;
    }

    public long getScanId() {
        return this.scanId;
    }

    public String getUsrOpId() {
        return this.usrOpId;
    }

    public Date getStartDate() {
        return new Date(this.startDate.getTime());
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public SoftData getSoftData() {
        return this.softData;
    }

    public String getNote() {
        return this.note;
    }

    public int hashCode() {
        return (int)(this.scanId ^ this.scanId >>> 32);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ScanContext)) {
            return false;
        }
        ScanContext other = (ScanContext)obj;
        return other.scanId == this.scanId;
    }

    public String toString() {
        return "ScanContext [indexDescriptor=" + this.indexDescriptor + ", scanId=" + this.scanId + ", usrOpId=" + this.usrOpId + ", startDate=" + this.startDate + ", operatorName=" + this.operatorName + ", arguments=..., note=" + this.note + ", pstmtRetrieveRowid=" + this.pstmtRetrieveRowid + "]";
    }

    public static ScanContext getScanContext(long scanno) {
        return (ScanContext)scannoToScanContext.get(new Long(scanno));
    }

    private Object[] toPlSqlAttributes() throws Exception {
        return new Object[]{new Long(this.getScanId()), this.indexDescriptor.getBaseTableSchema(), this.indexDescriptor.getBaseTableName(), this.indexDescriptor.getColName(), this.indexDescriptor.getIndexSchemaName(), this.indexDescriptor.getIndexName(), this.getUsrOpId(), this.getStartDate(), this.getOperatorName(), JFunctions.convertToARRAY(this.arguments, "SCAN_ARGUMENTS"), this.note};
    }

    public static STRUCT getScanContextPlSql(long scanno) throws Exception {
        ScanContext scanContext = ScanContext.getScanContext(scanno);
        if (scanContext == null) {
            return null;
        }
        Object[] attribs = scanContext.toPlSqlAttributes();
        return JFunctions.createSqlStruct(SCAN_CONTEXT_TYPE_NAME, attribs);
    }

    public static ScanContext getCreateScanContext(JCartIndexDescriptor idxDesc, long scanId, String usrOpId, java.util.Date startDate, String operatorName, String query, String options, String note, boolean withSoftData) throws SQLException {
        ScanContext sctx = ScanContext.getScanContext(scanId);
        if (sctx == null) {
            SoftData softData = null;
            if (withSoftData) {
                softData = new SoftData(options);
            }
            ScanContext scanContext = new ScanContext(idxDesc, scanId, usrOpId, startDate, operatorName, new String[]{query, options}, note, softData);
            if (scannoToScanContext.size() >= 200) {
                ScanContext oldest = (ScanContext)scanContextList.remove(0);
                scannoToScanContext.remove(new Long(oldest.getScanId()));
            }
            scannoToScanContext.put(new Long(scanContext.getScanId()), scanContext);
            scanContextList.add(scanContext);
            sctx = scanContext;
        }
        return sctx;
    }

    private void prepareForRetrievingRowids() throws SQLException {
        if (!openScanContexts.contains(this)) {
            String idxTableQName = this.indexDescriptor.getIdxTableQName();
            String rowidColumn = this.indexDescriptor.isJChemTable() ? "rowid" : "rid";
            String sql = "select " + rowidColumn + " from " + idxTableQName + " where cd_id = ?";
            this.pstmtRetrieveRowid = this.indexDescriptor.getDbSession().prepareStatement(sql);
            openScanContexts.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrieveRowid(int cdId) throws SQLException {
        this.prepareForRetrievingRowids();
        this.pstmtRetrieveRowid.setInt(1, cdId);
        ResultSet rs = this.pstmtRetrieveRowid.executeQuery();
        try {
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            rs.close();
        }
    }

    public void stopRetrievingRowids() throws SQLException {
        this.indexDescriptor.getDbSession().close(null, this.pstmtRetrieveRowid);
        this.pstmtRetrieveRowid = null;
    }

    public static void closeOpenScanContexts() {
        Iterator iter = openScanContexts.iterator();
        while (iter.hasNext()) {
            ScanContext scanContext = (ScanContext)iter.next();
            iter.remove();
            try {
                scanContext.stopRetrievingRowids();
            }
            catch (Throwable throwable) {
                logger.error(throwable);
            }
        }
    }

    public static ARRAY getScanContexts() throws Exception {
        try {
            ArrayList<STRUCT> list = new ArrayList<STRUCT>();
            Iterator iter = scanContextList.iterator();
            while (iter.hasNext()) {
                list.add(JFunctions.createSqlStruct(SCAN_CONTEXT_TYPE_NAME, ((ScanContext)iter.next()).toPlSqlAttributes()));
            }
            Object[] structArray = list.toArray(new STRUCT[list.size()]);
            return JFunctions.convertToARRAY(structArray, SCAN_CONTEXT_ARRAY_TYPE_NAME);
        }
        catch (Exception e) {
            JavaStoredProcExceptionHandler.handleTopLevelError(e);
            return null;
        }
    }

    public static void releaseSoftData(long scanId) {
        ScanContext sc = (ScanContext)scannoToScanContext.get(new Long(scanId));
        if (sc == null) {
            return;
        }
        sc.softData = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Soft data released from " + sc);
        }
    }

    public static void clear() {
        scanContextList.clear();
        scannoToScanContext.clear();
        ScanContext.closeOpenScanContexts();
    }

    public static class SoftData {
        private CxOptions cxOptions;
        private List filterQueryResults;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SoftData(String options) throws SQLException {
            this.cxOptions = new CxOptions(options);
            String filterQuery = this.cxOptions.getStringValue("filterQuery");
            if (filterQuery != null) {
                this.filterQueryResults = new ArrayList();
                JavaStoredProcSession dbSession = JavaStoredProcSession.instance();
                PreparedStatement pstmt = dbSession.prepareStatement(filterQuery);
                ResultSet rs = null;
                try {
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.filterQueryResults.add(rs.getString(1));
                    }
                }
                finally {
                    dbSession.close(rs, pstmt);
                }
                this.cxOptions.removeOption("filterQuery");
            }
        }

        public CxOptions getCxOptions() {
            return this.cxOptions;
        }

        public List getFilterQueryResults() {
            return this.filterQueryResults;
        }
    }
}

