/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.oresident.dml;

import chemaxon.jchem.cartridge.ColumnDescriptor;
import chemaxon.jchem.cartridge.JCFunctionsBlob;
import chemaxon.jchem.cartridge.JCFunctionsClob;
import chemaxon.jchem.cartridge.JCartDml;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.oresident.JccConfigConstants;
import chemaxon.jchem.cartridge.oresident.dml.IndexTableDml;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.InsertRespData;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class IndexTableDmlBase
implements IndexTableDml {
    private static final JCartLogger logger = JCartLogger.getLogger(IndexTableDmlBase.class.getName());
    protected DbSession dbSession;
    protected JCartIndexDescriptor idxDescriptor;
    private int cdStructColType;
    private int cdId;

    public IndexTableDmlBase(DbSession dbSession, JCartIndexDescriptor idxDescriptor) {
        this.dbSession = dbSession;
        this.idxDescriptor = idxDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insert(InsertRespData responseData, String rowid) throws Exception {
        this.cdId = JCartDml.getNextFreeCdId(this.idxDescriptor);
        String sql = this.getInsertSql(responseData);
        PreparedStatement pstmt = this.dbSession.prepareStatement(sql);
        try {
            int colIdx = this.setParameters(responseData, pstmt);
            this.setInsertParameters(rowid, this.cdId, pstmt, colIdx);
            pstmt.execute();
        }
        finally {
            this.dbSession.close(null, pstmt);
        }
        this.loadCdStructureLob(responseData, this.cdId);
        JCartDml.insertMds(this.idxDescriptor, this.cdId);
        JCartDml.updateMds(this.idxDescriptor, null, this.cdId);
        return this.cdId;
    }

    protected String getInsertSql(InsertRespData responseData) throws Exception {
        List colList = this.getInsertSqlColumnList(responseData);
        List valueList = this.getSqlValueList(responseData, colList);
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("INSERT INTO ").append(this.idxDescriptor.getIdxTableQName()).append(" (").append(IndexTableDmlBase.toCsv(colList)).append(") VALUES(").append(IndexTableDmlBase.toCsv(valueList)).append(")");
        String sql = sqlBuffer.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("INSERT SQL is " + sql);
        }
        return sql;
    }

    private List getInsertSqlColumnList(InsertRespData responseData) {
        List colList = this.getSqlColumnList(responseData);
        colList.add("cd_id");
        if (!this.idxDescriptor.isJChemTable()) {
            colList.add("rid");
        }
        return colList;
    }

    protected List getSqlColumnList(InsertRespData responseData) {
        ArrayList<String> colList = new ArrayList<String>();
        ColumnDescriptor[] colDefs = this.getMiscColDefs();
        for (int ix = 0; ix < colDefs.length; ++ix) {
            colList.add(colDefs[ix].colName);
        }
        for (int i = 0; i < responseData.fps.length; ++i) {
            colList.add("cd_fp" + (i + 1));
        }
        this.addToInsertSqlColumnList(responseData.ctColNamesAndValues, colList);
        if (this.idxDescriptor.isJChemTable()) {
            colList.add("cd_structure");
            this.addToInsertSqlColumnList(responseData.xColNamesAndValues, colList);
        }
        return colList;
    }

    protected List getSqlValueList(InsertRespData responseData, List sqlColumnList) throws Exception {
        ArrayList<String> valueList = new ArrayList<String>();
        ColumnDescriptor[] colDefs = this.getMiscColDefs();
        for (int i = 0; i < sqlColumnList.size(); ++i) {
            if (i < colDefs.length && colDefs[i].colType == 2004) {
                valueList.add("empty_blob()");
                continue;
            }
            if (((String)sqlColumnList.get(i)).equalsIgnoreCase("cd_timestamp")) {
                valueList.add("SYSDATE");
                continue;
            }
            if (((String)sqlColumnList.get(i)).equalsIgnoreCase("cd_structure")) {
                this.addSqlValueForCdStructure(responseData, valueList);
                continue;
            }
            valueList.add("?");
        }
        return valueList;
    }

    private void addSqlValueForCdStructure(InsertRespData responseData, List valueList) throws Exception {
        this.cdStructColType = JCartDml.getCdStructColType(this.idxDescriptor);
        if (this.cdStructColType == 2005 && responseData.structure != null) {
            valueList.add("empty_clob()");
        } else if (this.cdStructColType == 2004 && responseData.structure != null) {
            valueList.add("empty_blob()");
        } else {
            valueList.add("?");
        }
    }

    private void setInsertParameters(String rowid, int cdId, PreparedStatement pstmt, int colIdx) throws SQLException {
        pstmt.setInt(colIdx++, cdId);
        if (!this.idxDescriptor.isJChemTable()) {
            pstmt.setString(colIdx++, rowid);
        }
    }

    protected abstract ColumnDescriptor[] getMiscColDefs();

    protected int setParameters(InsertRespData responseData, PreparedStatement ps) throws Exception {
        int colIdx = 1;
        ps.setString(colIdx, responseData.smilesOrSmarts);
        ps.setString(++colIdx, responseData.formula);
        ps.setString(++colIdx, null);
        ++colIdx;
        if (responseData.mass == null) {
            ps.setNull(colIdx, 6);
        } else {
            ps.setFloat(colIdx, responseData.mass.floatValue());
        }
        ps.setInt(++colIdx, responseData.hashCode);
        String flags = responseData.flags;
        ps.setString(++colIdx, flags);
        ps.setInt(++colIdx, 0);
        ++colIdx;
        for (int ix = 0; ix < responseData.fps.length; ++ix) {
            ps.setInt(colIdx, responseData.fps[ix]);
            ++colIdx;
        }
        colIdx = JCartDml.setColValuesOnPstmt(this.idxDescriptor, responseData.ctColNamesAndValues, ps, colIdx);
        colIdx = JCartDml.setColValuesOnPstmt(this.idxDescriptor, responseData.xColNamesAndValues, ps, colIdx);
        colIdx = this.setSqlValueForCdStructure(responseData, ps, colIdx);
        return colIdx;
    }

    private int setSqlValueForCdStructure(InsertRespData responseData, PreparedStatement pstmt, int colIdx) throws SQLException, UnsupportedEncodingException {
        if (this.idxDescriptor.isJChemTable()) {
            if (responseData.structure == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("setSqlValueForCdStructure: setting empty structure for " + colIdx + " column");
                }
                pstmt.setBytes(colIdx++, JccConfigConstants.EMPTY_STRUCTURE_AS_BYTES);
            } else if (this.cdStructColType == 12 || this.cdStructColType == 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("setSqlValueForCdStructure: setting string for " + colIdx + " column");
                }
                pstmt.setString(colIdx++, responseData.structure);
            }
        }
        return colIdx;
    }

    public static String toCsv(List stringList) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = stringList.iterator();
        while (iter.hasNext()) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(iter.next());
        }
        return buffer.toString();
    }

    protected void addToInsertSqlColumnList(String[][] ctColNamesAndValues, List colList) {
        if (ctColNamesAndValues != null) {
            for (int ix = 0; ix < ctColNamesAndValues.length; ++ix) {
                colList.add(ctColNamesAndValues[ix][0]);
            }
        }
    }

    private void loadCdStructureLob(InsertRespData responseData, int cdId) throws Exception {
        if (this.idxDescriptor.isJChemTable() && responseData.structure != null) {
            switch (this.cdStructColType) {
                case 2005: {
                    JCFunctionsClob.insert(this.idxDescriptor.getIdxTableQName(), "cd_structure", responseData.structure, cdId);
                    break;
                }
                case 2004: {
                    JCFunctionsBlob.loadBlobContent(this.idxDescriptor.getIdxTableQName(), "cd_structure", responseData.structure.getBytes("ASCII"), cdId);
                }
            }
        }
    }

    @Override
    public void update(InsertRespData responseData, String rowid) throws Exception {
        this.update(responseData, rowid, JCartDml.getCdIdFromRowid(this.idxDescriptor, rowid));
    }

    @Override
    public void update(InsertRespData responseData, int cdId) throws Exception {
        this.update(responseData, null, cdId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(InsertRespData responseData, String rowid, int cdId) throws Exception {
        String sql = this.getUpdateSql(responseData, rowid, cdId);
        PreparedStatement pstmt = this.dbSession.prepareStatement(sql);
        try {
            int colIdx = this.setParameters(responseData, pstmt);
            this.setUpdateParameters(responseData, rowid, cdId, pstmt, colIdx);
            pstmt.execute();
        }
        finally {
            this.dbSession.close(null, pstmt);
        }
        this.loadCdStructureLob(responseData, cdId);
        JCartDml.updateMds(this.idxDescriptor, null, cdId);
    }

    private String getUpdateSql(InsertRespData responseData, String rowid, int cdId) throws Exception {
        List colList = this.getSqlColumnList(responseData);
        List valueList = this.getSqlValueList(responseData, colList);
        StringBuffer sqlBuffer = new StringBuffer("UPDATE " + this.idxDescriptor.getIdxTableQName() + " SET ");
        for (int ix = 0; ix < colList.size(); ++ix) {
            if (ix > 0) {
                sqlBuffer.append(", ");
            }
            sqlBuffer.append(colList.get(ix)).append(" = ").append(valueList.get(ix));
        }
        sqlBuffer.append(" WHERE ");
        if (this.idxDescriptor.isJChemTable()) {
            sqlBuffer.append("cd_id = ?");
        } else {
            sqlBuffer.append("rid = ?");
        }
        String sql = sqlBuffer.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("UPDATE SQL is " + sql);
        }
        return sql;
    }

    private int setUpdateParameters(InsertRespData responseData, String rowid, int cdId, PreparedStatement pstmt, int colIdx) throws SQLException {
        if (this.idxDescriptor.isJChemTable()) {
            pstmt.setInt(colIdx++, cdId);
        } else {
            pstmt.setString(colIdx++, rowid);
        }
        return colIdx;
    }
}

