/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.oresident.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CxOptions {
    private String delimiter;
    private char divider;
    private Map optMap = new HashMap();
    private ArrayList repeatableOptions = new ArrayList();

    public CxOptions(String optionString) {
        this(null, optionString, " ", ':');
    }

    public CxOptions(String[] p_allowedOptions, String optionString) {
        this(p_allowedOptions, optionString, " ", ':');
    }

    public CxOptions(String[] p_allowedOptions, String optionString, String separator, char divider) {
        this(p_allowedOptions, null, optionString, separator, divider);
    }

    public CxOptions(String[] p_allowedOptions, String[] repeatableOptions, String optionString, String separator, char divider) {
        String token;
        if (repeatableOptions != null) {
            for (int i = 0; i < repeatableOptions.length; ++i) {
                String rableOpt = repeatableOptions[i];
                this.addRepeatableOption(rableOpt);
            }
        }
        this.delimiter = separator;
        this.divider = divider;
        String[] l_allowedOptions = null;
        if (p_allowedOptions != null) {
            l_allowedOptions = new String[p_allowedOptions.length];
            for (int ix = 0; ix < l_allowedOptions.length; ++ix) {
                l_allowedOptions[ix] = p_allowedOptions[ix].toLowerCase();
            }
        }
        if (optionString == null) {
            optionString = "";
        }
        if (optionString.trim().length() == 0) {
            return;
        }
        if (optionString.startsWith("sep=")) {
            int firstSpacePos = optionString.indexOf(" ");
            if (firstSpacePos == -1) {
                throw new IllegalArgumentException("The separator string option must be ended with a space (which is not part of the separator string).");
            }
            this.delimiter = optionString.substring("sep=".length(), firstSpacePos);
            if (this.delimiter.length() == 0) {
                this.delimiter = " ";
            }
            optionString = optionString.substring(firstSpacePos + 1);
        }
        int lastIdx = 0 - this.delimiter.length();
        int nextIdx = optionString.indexOf(this.delimiter);
        while (nextIdx != -1) {
            token = optionString.substring(lastIdx + this.delimiter.length(), nextIdx);
            if (token.length() > 0) {
                this.processOption(l_allowedOptions, token, divider);
            }
            lastIdx = nextIdx;
            nextIdx = optionString.indexOf(this.delimiter, lastIdx + 1);
        }
        token = optionString.substring(lastIdx + this.delimiter.length());
        if (token.length() > 0) {
            this.processOption(l_allowedOptions, token, divider);
        }
    }

    private void processOption(String[] allowedOptions, String option, char divider) {
        if (allowedOptions == null) {
            this.processOption(option, divider);
        } else {
            this.processOptionCheckAllowed(allowedOptions, option, divider);
        }
    }

    private void processOptionCheckAllowed(String[] allowedOptions, String option, char divider) {
        for (int ix = 0; ix < allowedOptions.length; ++ix) {
            String extOpt = allowedOptions[ix] + divider;
            if (!option.toLowerCase().startsWith(extOpt)) continue;
            String optValue = option.substring(extOpt.length());
            this.setOption(allowedOptions[ix], optValue);
            return;
        }
        int idx = option.indexOf(divider);
        if (idx > -1) {
            option = option.substring(0, idx);
        }
        if (option.trim().length() == 0) {
            return;
        }
        throw new IllegalArgumentException("Illegal option: " + option);
    }

    private void processOption(String option, char divider) {
        int nameEnd = option.indexOf(divider);
        if (nameEnd == -1) {
            throw new IllegalArgumentException("Option without value: >" + option + "<");
        }
        int valueStart = nameEnd + 1;
        String name = option.substring(0, nameEnd);
        String value = option.substring(valueStart);
        this.setOption(name.toLowerCase(), value);
    }

    private void setOption(String optionName, String optionValue) {
        if (this.repeatableOptions.contains(optionName = optionName.toLowerCase())) {
            ArrayList<String> valueList = (ArrayList<String>)this.optMap.get(optionName);
            if (valueList == null) {
                valueList = new ArrayList<String>();
                this.optMap.put(optionName, valueList);
            }
            valueList.add(optionValue);
            return;
        }
        this.optMap.put(optionName, optionValue);
    }

    public boolean getBoolValue(String option, boolean def) {
        String value = this.getStringValue(option);
        if (value == null) {
            return def;
        }
        return CxOptions.getBooleanValue(option, value, def);
    }

    public static boolean getBooleanValue(String name, String value, boolean def) {
        if (value == null) {
            return def;
        }
        if (value.equalsIgnoreCase("y")) {
            return true;
        }
        if (value.equalsIgnoreCase("n")) {
            return false;
        }
        CxOptions.throwBadOptionValueException(value.toCharArray(), name);
        return false;
    }

    public char[] getValue(String option) {
        String value = (String)this.optMap.get(option.toLowerCase());
        if (value == null) {
            return null;
        }
        return value.toCharArray();
    }

    public String getStringValue(String option) {
        return (String)this.optMap.get(option.toLowerCase());
    }

    public String getStringValue(String option, String dfltValue) {
        String val = (String)this.optMap.get(option.toLowerCase());
        if (val == null) {
            return dfltValue;
        }
        return val;
    }

    public int getIntValue(String option, int dfltValue) {
        int v = dfltValue;
        String s = this.getStringValue(option);
        if (s != null) {
            v = Integer.parseInt(s);
        }
        return v;
    }

    public void setOptionValue(String optName, String value) {
        if (this.repeatableOptions.contains(optName)) {
            throw new IllegalArgumentException(optName + " is repeatable");
        }
        this.optMap.put(optName.toLowerCase(), value);
    }

    public void removeOption(String optName) {
        this.optMap.remove(optName.toLowerCase());
    }

    public Iterator optionNames() {
        return this.optMap.keySet().iterator();
    }

    public boolean containsOptionName(String name) {
        return this.optMap.keySet().contains(name.toLowerCase());
    }

    public void addRepeatableOption(String optionName) {
        this.repeatableOptions.add(optionName.toLowerCase());
    }

    public ArrayList getValueList(String optionName) {
        if (!this.repeatableOptions.contains(optionName = optionName.toLowerCase())) {
            throw new IllegalArgumentException(optionName + " is not a repeatable option");
        }
        return (ArrayList)this.optMap.get(optionName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.delimiter != null) {
            sb.append("sep=").append(this.delimiter).append(" ");
        }
        for (String name : this.optMap.keySet()) {
            String value = (String)this.optMap.get(name);
            sb.append(name).append(this.divider).append(value).append(this.delimiter);
        }
        return sb.toString();
    }

    public static void throwBadOptionValueException(char[] carr, String optionName) {
        throw new IllegalArgumentException("Value '" + new String(carr) + "' for option '" + optionName + "'");
    }

    public static void main(String[] args) {
        String[] allowedOptions = new String[]{"JCHEMPROPERTIESTABLE", "TABLESPACE", "STORAGE", "DEBUGLEVEL", "ABSOLUTESTEREO", "FP_SIZE", "FP_BIT", "PAT_LENGTH", "STD_CONFIG", "REGENERATETABLE", "BUILDTYPE", "PASSWORD", "STRUCTURALFP_CONFIG", "HALTONBADFORMAT", "TABLETYPE", "AUTOCALCCT", "REFRESHPERIOD"};
        String[] repeatableOptions = new String[]{"AUTOCALCCT"};
        String param = "sep=! autoCalcCt=numeric(30,15);logp()!autoCalcCt=numeric(10,0);rotatableBondCount()!autoCalcCt=numeric(30,15);pKa(\"acidic\",\"2\")!JCHEMPROPERTIESTABLE=JCHEMPROPERTIES!tableType=anyStructures";
        CxOptions jcOptions = new CxOptions(allowedOptions, repeatableOptions, param, ",", '=');
        String[] ctArray = null;
        ArrayList ctlist = jcOptions.getValueList("AUTOCALCCT");
        if (ctlist != null) {
            ctArray = new String[ctlist.size()];
            ctlist.toArray(ctArray);
        }
        CxOptions o = new CxOptions(null);
        o.setOption("t", "na");
        System.err.println(o.toString());
    }

    public static void log(char[] carr) {
        if (carr == null) {
            System.out.println("null");
            return;
        }
        System.out.println(new String(carr));
    }

    public static void log(boolean b) {
        System.out.println(b);
    }
}

