/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.oresident.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class StringUtil {
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String[] split(String text, String pattern) {
        if (text == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(text, pattern);
        int s = tok.countTokens();
        String[] ret = new String[s];
        for (int i = 0; i < s; ++i) {
            ret[i] = tok.nextToken().trim();
        }
        return ret;
    }

    public static String convertToMultiLine(String text, String separators, int lineLength) {
        return StringUtil.convertToMultiLine(text, separators, "\n", lineLength);
    }

    public static String convertToMultiLine(String text, String separators, String newLine, int lineLength) {
        StringTokenizer st = new StringTokenizer(text, separators, true);
        StringBuffer buf = new StringBuffer();
        StringBuffer line = new StringBuffer();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() > 1 && line.length() > 0 && line.length() + token.length() > lineLength) {
                buf.append(line.toString());
                buf.append(newLine);
                line = new StringBuffer();
            }
            line.append(token);
        }
        buf.append(line.toString());
        return new String(buf);
    }

    public static String replaceFirst(String text, String substring, String replacement) {
        if (text.equals(substring)) {
            return replacement;
        }
        int fromindex = text.indexOf(substring);
        if (fromindex < 0) {
            return text;
        }
        StringBuffer sb = new StringBuffer(text);
        sb.replace(fromindex, fromindex + substring.length(), replacement);
        return sb.toString();
    }

    public static String replaceAll(String text, String substring, String replacement) {
        if (text.equals(substring)) {
            return replacement;
        }
        if (text.indexOf(substring) == -1) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        int fromindex = 0;
        int toindex = text.indexOf(substring, 0);
        int len = substring.length();
        while (toindex > -1) {
            sb.append(text.substring(fromindex, toindex));
            sb.append(replacement);
            fromindex = toindex + len;
            toindex = text.indexOf(substring, fromindex);
        }
        sb.append(text.substring(fromindex));
        return sb.toString();
    }

    public static int[] parseInts(String intsString) throws NumberFormatException {
        int len = intsString.length();
        int[] ints = new int[len];
        int ind = 0;
        int from = StringUtil.getNextDigit(intsString, 0, len);
        int to = 0;
        while (from != len) {
            to = StringUtil.getNextSeparator(intsString, from, len);
            ints[ind++] = Integer.parseInt(intsString.substring(from, to));
            from = StringUtil.getNextDigit(intsString, to, len);
        }
        int[] rints = new int[ind];
        System.arraycopy(ints, 0, rints, 0, ind);
        return rints;
    }

    private static int getNextSeparator(String str, int from, int limit) {
        for (int i = from; i < limit; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return i;
        }
        return limit;
    }

    private static int getNextDigit(String str, int from, int limit) {
        for (int i = from; i < limit; ++i) {
            if (!Character.isDigit(str.charAt(i))) continue;
            return i;
        }
        return limit;
    }

    public static String replaceString(String input, String query, String replacement) {
        int pos;
        StringBuffer sb = new StringBuffer();
        int from = 0;
        while ((pos = input.indexOf(query, from)) >= 0) {
            if (pos > from) {
                sb.append(input.substring(from, pos));
            }
            sb.append(replacement);
            from = pos + query.length();
        }
        if (input.length() > from) {
            sb.append(input.substring(from, input.length()));
        }
        return sb.toString();
    }

    public static String convertToUNIXStyle(String input) {
        String value = input;
        value = StringUtil.replaceString(value, "\r\n", "\n");
        value = StringUtil.replaceString(value, "\r", "\n");
        return value;
    }

    public static int skipDelimiters(String string, String delimiters, int pos, int count) {
        boolean inDelimBlock = delimiters.indexOf(string.charAt(0)) != -1;
        int skipped = 0;
        while (pos < string.length()) {
            char ch = string.charAt(pos);
            if (delimiters.indexOf(ch) != -1) {
                inDelimBlock = true;
            } else if (inDelimBlock) {
                inDelimBlock = false;
                if (++skipped >= count) {
                    return pos;
                }
            }
            ++pos;
        }
        return -1;
    }

    public static String encrypt(String string) {
        StringBuffer result = new StringBuffer("$CxCr$");
        byte[] key = new byte[20];
        for (int x = 0; x < key.length; ++x) {
            key[x] = (byte)(32.0 + Math.random() * 95.0);
        }
        byte[] original = null;
        try {
            original = string.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        int size = original.length;
        byte[] encrypted = new byte[size];
        for (int x = 0; x < size; ++x) {
            int nn = original[x] + key[x % key.length] - 32;
            encrypted[x] = (byte)(32 + nn % 96);
        }
        try {
            result.append(new String(key, "ASCII"));
            result.append(new String(encrypted, "ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        result.append("$CxCr$");
        return result.toString();
    }

    public static String getMD5String(String input) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        byte[] inb = new byte[]{};
        try {
            inb = input.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        byte[] outb = md.digest(inb);
        return StringUtil.bytesToHexString(outb);
    }

    public static final ArrayList tokenize(String string, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        int length = string.length();
        int delimLength = delimiter.length();
        while (true) {
            int idx;
            if ((idx = string.indexOf(delimiter, pos)) == -1) {
                if (pos >= length - 1) break;
                result.add(string.substring(pos, length));
                break;
            }
            result.add(string.substring(pos, idx));
            pos = idx + delimLength;
        }
        return result;
    }

    public static final String bytesToHexString(byte[] arr) {
        int len = arr.length;
        StringBuffer sb = new StringBuffer(len * 2);
        for (int i = 0; i < len; ++i) {
            int hi = arr[i] >>> 4 & 0xF;
            sb.append(hex[hi]);
            int low = arr[i] & 0xF;
            sb.append(hex[low]);
        }
        return sb.toString();
    }

    public static final String arrayToString(int[] arr, String sep) {
        return StringUtil.arrayToString(arr, 0, sep);
    }

    public static final String arrayToString(int[] arr, int inc, String sep) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                b.append(sep);
            }
            b.append(arr[i] + inc);
        }
        return new String(b);
    }

    public static final boolean isBlank(String text) {
        if (!StringUtil.isNullOrEmpty(text)) {
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isWhitespace(text.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean isNullOrEmpty(String text) {
        return text == null || text.length() == 0;
    }
}

