/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.resultset;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.resultset.ResultSetBase;
import chemaxon.jchem.cartridge.tunnel.TableOpInfo;
import chemaxon.jchem.cartridge.tunnel.TableScanInfo;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleConnection;

public class CdIdResultSet
extends ResultSetBase {
    private static JCartLogger logger = JCartLogger.getLogger(CdIdResultSet.class);
    private int[] cdIdArray;
    private int cdIdArrayLength;
    private long termTime;
    Statement previousStatement;

    public CdIdResultSet(String idxTblQName, boolean isJChemTable, byte[] data, long termTime) throws Exception {
        super(idxTblQName, isJChemTable, data);
        this.termTime = termTime;
    }

    public CdIdResultSet(String idxTblQName, boolean isJChemTable, int[] hits, long termTime) throws Exception {
        super(idxTblQName, isJChemTable, hits);
        this.termTime = termTime;
    }

    public static CdIdResultSet createCdIdResultSet(TableScanInfo searchInfo, byte[] result, long termTime) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("createCdIdResultSet: result size=" + result.length);
        }
        String baseTableQName = searchInfo.getBaseSchemaName() + "." + searchInfo.getBaseTableName();
        boolean isJChemTable = baseTableQName.equalsIgnoreCase(searchInfo.getIndexTableQName());
        return new CdIdResultSet(searchInfo.getIndexTableQName(), isJChemTable, result, termTime);
    }

    public static CdIdResultSet createCdIdResultSet(TableOpInfo tableOpInfo, int[] hits, long termTime) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("createCdIdResultSet: hit count=" + hits.length);
        }
        String baseTableQName = tableOpInfo.getBaseSchemaName() + "." + tableOpInfo.getBaseTableName();
        boolean isJChemTable = baseTableQName.equalsIgnoreCase(tableOpInfo.getIndexTableQName());
        return new CdIdResultSet(tableOpInfo.getIndexTableQName(), isJChemTable, hits, termTime);
    }

    protected void createIdArray_(byte[] data) throws SQLException {
        this.cdIdArrayLength = 0;
        if (this.cdIdArray == null) {
            this.cdIdArray = new int[0x100000];
        }
        int counter = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 44) continue;
            ++counter;
        }
        int resultCount = counter;
        if (this.cdIdArray == null || this.cdIdArray.length < resultCount) {
            JFunctions.trace(this.getClass().getName() + ": Allocate new buffer of " + this.cdIdArray.length + " bytes");
            this.cdIdArray = new int[resultCount];
            System.gc();
        }
        this.cdIdArrayLength = resultCount;
        int a = 0;
        counter = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == 44) {
                this.cdIdArray[counter++] = a;
                a = 0;
                continue;
            }
            a = a * 10 + (data[i] - 48);
        }
    }

    @Override
    protected void createIdArray(byte[] data) {
        if (logger.isDebugEnabled()) {
            logger.debug("createIdArray: data.length=" + data.length);
        }
        this.cdIdArray = new int[data.length / 4];
        this.cdIdArrayLength = this.cdIdArray.length;
        for (int position = 0; position < this.cdIdArrayLength; ++position) {
            this.cdIdArray[position] = JFunctions.getFingerprintInInt(data, position);
        }
    }

    @Override
    protected void createIdArray(int[] hits) {
        this.cdIdArray = hits;
        this.cdIdArrayLength = this.cdIdArray.length;
    }

    @Override
    public ResultSet prepareExec(int nextCount) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("prepareExec: BEGIN");
        }
        OracleConnection oconn = (OracleConnection)JavaStoredProcSession.instance().getConnection();
        if (logger.isDebugEnabled()) {
            logger.debug("prepareExec: setting create statement as ref cursor ON...");
        }
        oconn.setCreateStatementAsRefCursor(true);
        ResultSet rs = null;
        rs = this.resultSetFromStatement((Connection)oconn, nextCount);
        if (logger.isDebugEnabled()) {
            logger.debug("prepareExec: setting create statement as ref cursor ON...");
        }
        oconn.setCreateStatementAsRefCursor(false);
        if (this.idArrayIdx + nextCount == this.cdIdArrayLength) {
            this.cdIdArray = null;
            System.gc();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("prepareExec: END");
        }
        return rs;
    }

    protected ResultSet resultSetFromStatement(Connection conn, int nextCount) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("resultSetFromStatement: about to createStatement...");
        }
        String sql = this.createStatementString(nextCount);
        Statement statement = conn.createStatement();
        if (logger.isDebugEnabled()) {
            logger.debug("resultSetFromStatement: exec' query");
        }
        ResultSet rs = statement.executeQuery(sql);
        if (logger.isDebugEnabled()) {
            logger.debug("resultSetFromStatement: query exec'd");
        }
        return rs;
    }

    public String createStatementString(int count) {
        if (logger.isDebugEnabled()) {
            logger.debug("createStatementString count=" + count);
        }
        String idxTblBaseName = JFunctions.oracleObjectBaseName(this.idxTblQName);
        String ridColName = "rid";
        String hint = "/*+INDEX (" + this.idxTblQName + " " + idxTblBaseName + "_jcp) */";
        if (this.isJChemTable) {
            ridColName = "rowid";
            hint = "";
        }
        StringBuffer sb = new StringBuffer("select " + hint + ridColName + " from " + this.idxTblQName + " where cd_id in (" + this.cdIdArray[this.idArrayIdx + 0]);
        for (int ix = 0; ix < count - 1; ++ix) {
            if ((ix + 1) % 1000 == 0) {
                sb.append(") OR cd_id in (" + this.cdIdArray[this.idArrayIdx + ix + 1]);
                continue;
            }
            sb.append(", " + this.cdIdArray[this.idArrayIdx + ix + 1]);
        }
        sb.append(")");
        if (logger.isDebugEnabled()) {
            logger.debug("createStatementString END");
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int getNrRemainingRowids() {
        nr = 0;
        v0 = termTimePassed = System.currentTimeMillis() > this.termTime;
        if (CdIdResultSet.logger.isDebugEnabled()) {
            CdIdResultSet.logger.debug("cdIdArray=" + this.cdIdArray + ", termTimePassed=" + termTimePassed);
        }
        if (this.cdIdArray == null || termTimePassed) {
            try {
                if (this.previousStatement == null) ** GOTO lbl17
                this.previousStatement.close();
                this.previousStatement = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        } else {
            if (CdIdResultSet.logger.isDebugEnabled()) {
                CdIdResultSet.logger.debug("getNrRemainingRowids: cdIdArrayLength=" + this.cdIdArrayLength + ", idArrayIdx=" + this.idArrayIdx);
            }
            nr = this.cdIdArrayLength - this.idArrayIdx;
        }
lbl17:
        // 3 sources

        if (CdIdResultSet.logger.isDebugEnabled()) {
            CdIdResultSet.logger.debug("getNrRemainingRowids: returning " + nr);
        }
        return nr;
    }

    @Override
    public void cleanup() throws Exception {
        this.cdIdArray = null;
    }
}

