/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.client;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.rmi.Directory;
import chemaxon.jchem.cartridge.rmi.client.RmiServerDesc;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RmiDirectory {
    private static final JCartLogger logger = JCartLogger.getLogger(RmiDirectory.class);
    public static RmiDirectory instance;
    private DbSession dbSession;
    private RmiServerDesc rmiServerDesc;
    private Directory directory;
    private boolean local;
    private Map cache = new HashMap();
    private List tunnlets = new LinkedList();
    private int tunnelSocketTimeout = -1;

    public RmiDirectory(RmiServerDesc p_rmiServerDesc) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.rmiServerDesc = p_rmiServerDesc;
    }

    private RmiDirectory(DbSession dbSession) {
        if (dbSession == null) {
            throw new IllegalArgumentException("dbSession must not be null");
        }
        this.dbSession = dbSession;
    }

    public Directory locate() throws Exception {
        if (this.directory != null) {
            return this.directory;
        }
        this.directory = this.locateInJvm();
        if (this.directory == null) {
            try {
                return this.locateBypassCache();
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(JCartLogger.stackTrace(e));
                }
                throw new Exception("Problem connecting to JChemServer: rmi://" + this.rmiServerDesc.host + ":" + this.rmiServerDesc.port + ": " + e.getMessage());
            }
        }
        return this.directory;
    }

    public Directory locateBypassCache() throws Exception {
        RmiServerDesc rmiServerDesc = this.getRmiServerDesc();
        Registry registry = LocateRegistry.getRegistry(rmiServerDesc.host, rmiServerDesc.port);
        if (logger.isDebugEnabled()) {
            logger.debug("RmiDirectory.locateBypassCache(): we have reference to registry");
        }
        Directory tmpRef = (Directory)registry.lookup("jcc/Directory");
        if (logger.isDebugEnabled()) {
            logger.debug("RmiDirectory.locateBypassCache(): we have reference to the Directory");
        }
        tmpRef.checkVersion(JFunctions.getJChemVersion(this.dbSession));
        if (logger.isDebugEnabled()) {
            logger.debug("RmiDirectory.locateBypassCache(): JChem version checked");
        }
        return tmpRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Directory locateViaSocket(RmiServerDesc p_rmiServerDesc, int readTimeOut) throws Exception {
        Directory tmpRef = null;
        Socket s = new Socket(p_rmiServerDesc.host, p_rmiServerDesc.port);
        s.setSoTimeout(readTimeOut);
        try {
            ObjectInputStream ois = new ObjectInputStream(s.getInputStream());
            tmpRef = (Directory)ois.readObject();
        }
        finally {
            s.close();
        }
        tmpRef.checkVersion(JFunctions.getJChemVersion(null));
        if (logger.isDebugEnabled()) {
            logger.debug("locate(): version checked");
        }
        return tmpRef;
    }

    public static synchronized RmiDirectory instance() {
        if (instance == null) {
            instance = new RmiDirectory(JavaStoredProcSession.instance());
        }
        return instance;
    }

    public static synchronized RmiDirectory instance(DbSession dbSession) {
        if (dbSession instanceof JavaStoredProcSession) {
            return RmiDirectory.instance();
        }
        return new RmiDirectory(dbSession);
    }

    public Remote getServer(String name) throws Exception {
        Remote r = (Remote)this.cache.get(name);
        if (r == null) {
            Directory d = this.locate();
            r = this.local ? (Remote)d.getLocal(name) : d.get(name);
            this.cache.put(name, r);
        }
        return r;
    }

    private Directory locateInJvm() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        try {
            if (this.dbSession instanceof JavaStoredProcSession) {
                return null;
            }
            Class<?> clazz = Class.forName("chemaxon.jchem.cartridge.rmi.impl.DirectoryImpl");
            Method m = clazz.getMethod("getInstance", null);
            Directory dir = (Directory)m.invoke(null, (Object[])null);
            if (dir != null) {
                this.local = true;
            }
            return dir;
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    private void clearRemoteRefCache0() {
        if (logger.isDebugEnabled()) {
            logger.debug("clearing directory cache...");
        }
        this.directory = null;
        this.local = false;
        this.cache.clear();
        this.rmiServerDesc = null;
        if (logger.isDebugEnabled()) {
            logger.debug("directory cache cleared, directory=" + this.directory);
        }
    }

    private void clearRemoteRefCache0(String name) {
        this.cache.remove(name);
    }

    public RmiServerDesc getRmiServerDesc() throws Exception {
        if (this.rmiServerDesc == null) {
            String connectString = new JcMetaDataFunctions(this.dbSession).getMasterProperty(this.dbSession.getJccOwner(), "rmi.server.1");
            if (connectString == null) {
                return null;
            }
            this.rmiServerDesc = new RmiServerDesc(connectString);
        }
        return this.rmiServerDesc;
    }

    public static void clearRemoteRefCache() {
        RmiDirectory.instance().clearRemoteRefCache0();
    }

    public static void clearRemoteRef(String name) {
        RmiDirectory.instance().clearRemoteRefCache0(name);
    }
}

