/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.jchem.cartridge.rmi.ClassWithRemote;
import chemaxon.jchem.cartridge.rmi.Directory;
import chemaxon.jchem.cartridge.rmi.VersionMismatchException;
import chemaxon.jchem.cartridge.rmi.impl.AdminImpl;
import chemaxon.jchem.cartridge.rmi.impl.DmlImpl;
import chemaxon.jchem.cartridge.rmi.impl.EvalTableScannerImpl;
import chemaxon.jchem.cartridge.rmi.impl.EvaluatorImpl;
import chemaxon.jchem.cartridge.rmi.impl.FormulaSearchImpl;
import chemaxon.jchem.cartridge.rmi.impl.IndexImpl;
import chemaxon.jchem.cartridge.rmi.impl.JCartProfilerImpl;
import chemaxon.jchem.cartridge.rmi.impl.JcReactImpl;
import chemaxon.jchem.cartridge.rmi.impl.JchemSearchImpl;
import chemaxon.jchem.cartridge.rmi.impl.MiscellaniousImpl;
import chemaxon.jchem.cartridge.rmi.impl.MolSearchImpl;
import chemaxon.jchem.cartridge.rmi.impl.RemoteTask;
import chemaxon.jchem.cartridge.rmi.impl.RmiExceptionHandler;
import chemaxon.jchem.cartridge.rmi.impl.RmiTunnelImpl;
import chemaxon.jchem.cartridge.rmi.impl.UserDefFuncImpl;
import chemaxon.jchem.cartridge.rmi.impl.errcache.ErrorCacheImpl;
import chemaxon.jchem.cartridge.tunnel.UserInfo;
import chemaxon.jchem.cartridge.util.Environment;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class DirectoryImpl
implements Directory {
    private static Logger logger = Logger.getLogger(DirectoryImpl.class.getName());
    private static DirectoryImpl instance;
    private static ConcurrentHashMap<String, ClassWithRemote> map;

    protected DirectoryImpl() throws IOException {
        map.put("AdminServer", new ClassWithRemote(AdminImpl.class));
        map.put("IndexServer", new ClassWithRemote(IndexImpl.class));
        map.put("DmlServer", new ClassWithRemote(DmlImpl.class));
        map.put("MolSearchServer", new ClassWithRemote(MolSearchImpl.class));
        map.put("EvaluatorServer", new ClassWithRemote(EvaluatorImpl.class));
        map.put("MiscellaniousServer", new ClassWithRemote(MiscellaniousImpl.class));
        map.put("JchemSearchServer", new ClassWithRemote(JchemSearchImpl.class));
        map.put("EvalTableScanner", new ClassWithRemote(EvalTableScannerImpl.class));
        map.put("Reactor", new ClassWithRemote(JcReactImpl.class));
        map.put("Tunnel", new ClassWithRemote(RmiTunnelImpl.class));
        map.put("FormulaSearch", new ClassWithRemote(FormulaSearchImpl.class));
        map.put("Profiler", new ClassWithRemote(JCartProfilerImpl.class));
        map.put("UserDefFuncServer", new ClassWithRemote(UserDefFuncImpl.class));
        ClassWithRemote ecwr = new ClassWithRemote(ErrorCacheImpl.class);
        map.put("ErrorCache", ecwr);
        this.open("ErrorCache", ecwr, ErrorCacheImpl.instance());
    }

    @Override
    public String[] getLocale() {
        return new String[]{Locale.getDefault().getLanguage(), Locale.getDefault().getCountry()};
    }

    @Override
    public Remote get(String name) throws RemoteException {
        try {
            ClassWithRemote cwr = map.get(name);
            Remote remote = null;
            if (cwr != null) {
                remote = map.get(name).getRemoteObj();
            }
            if (remote == null) {
                Class directoryEntry = cwr.getClassObj();
                if (directoryEntry == null) {
                    throw new RemoteException("No entry found in directory: " + name);
                }
                if (directoryEntry instanceof Class) {
                    Class clazz = directoryEntry;
                    remote = (Remote)clazz.newInstance();
                } else {
                    remote = (Remote)((Object)directoryEntry);
                }
                this.open(name, cwr, remote);
            }
            return remote;
        }
        catch (Throwable tbl) {
            RmiExceptionHandler.handleError(logger, tbl);
            return null;
        }
    }

    private void open(String name, ClassWithRemote cwr, Remote remote) throws IOException {
        RemoteTask.export(remote);
        cwr.setRemoteObj(remote);
    }

    @Override
    public Object getLocal(String name) {
        try {
            Object obj = null;
            Class clazz = null;
            ClassWithRemote cwr = map.get(name);
            if (cwr != null) {
                clazz = cwr.getClassObj();
            }
            if (clazz == null) {
                throw new RemoteException("No server found: " + name);
            }
            obj = clazz.newInstance();
            return obj;
        }
        catch (Throwable tbl) {
            throw new RuntimeException(tbl);
        }
    }

    @Override
    public void checkVersion(String jchemVersionInOracle) throws RemoteException {
        String currentJChemVersion = Environment.getInstance().getJchemVersion();
        if (!jchemVersionInOracle.equals(currentJChemVersion)) {
            throw new VersionMismatchException("JChem version mismatch: " + jchemVersionInOracle + " in Oracle, " + currentJChemVersion + " in RMI Server");
        }
    }

    @Override
    public String getEnvironment(UserInfo userInfo) throws RemoteException {
        try {
            return Environment.getInstance().getDescription(userInfo);
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }

    public static synchronized DirectoryImpl createInstance() throws IOException {
        if (instance == null) {
            instance = new DirectoryImpl();
            try {
                RemoteTask.export(instance);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return instance;
        }
        throw new IllegalStateException("Instance already created");
    }

    public static synchronized DirectoryImpl getInstance() throws RemoteException {
        return instance;
    }

    public ClassWithRemote changeClass(String name, Class newClass) throws RemoteException {
        return map.put(name, new ClassWithRemote(newClass));
    }

    public ClassWithRemote changeClass(String name, ClassWithRemote cwr) throws RemoteException {
        return map.put(name, cwr);
    }

    static {
        map = new ConcurrentHashMap();
    }
}

