/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.jchem.cartridge.ctcol.ChemTermColSupport;
import chemaxon.jchem.cartridge.dbsession.ClientSideSession;
import chemaxon.jchem.cartridge.rmi.EvalTableScanner;
import chemaxon.jchem.cartridge.rmi.TableScan;
import chemaxon.jchem.cartridge.rmi.impl.RmiExceptionHandler;
import chemaxon.jchem.cartridge.rmi.impl.scanresult.AutoCalcCtColScan;
import chemaxon.jchem.cartridge.rmi.impl.scanresult.EvalHitFinder;
import chemaxon.jchem.cartridge.rmi.impl.scanresult.EvaluatorScan;
import chemaxon.jchem.cartridge.rmi.impl.scanresult.TableScanBaseImpl;
import chemaxon.jchem.cartridge.rmi.impl.scanresult.UserDefFuncHitFinder;
import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.tunnel.EvalChemTermInfo;
import chemaxon.jchem.cartridge.tunnel.TableScanInfo;
import chemaxon.jchem.cartridge.tunnel.UserDefFuncInfo;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.util.hitfinder.HitFinder;
import chemaxon.util.hitfinder.HitFinderFactory;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.util.logging.Logger;

public class EvalTableScannerImpl
implements EvalTableScanner {
    static Logger logger = Logger.getLogger(EvalTableScanner.class.getName());

    @Override
    public TableScan scan(TableScanInfo scanInfo, int resultChunkSize) throws RemoteException {
        try {
            TableScanBaseImpl r = null;
            if (scanInfo instanceof EvalChemTermInfo) {
                final EvalChemTermInfo evalInfo = (EvalChemTermInfo)scanInfo;
                String ctColName = this.getAutoCalcCtColName(evalInfo);
                r = ctColName == null ? new EvaluatorScan(evalInfo, new HitFinderFactory<String>(){

                    @Override
                    public HitFinder<String> createHitFinder() throws ParseException {
                        return new EvalHitFinder(evalInfo);
                    }
                }, resultChunkSize) : new AutoCalcCtColScan(resultChunkSize, evalInfo, ctColName);
            } else if (scanInfo instanceof UserDefFuncInfo) {
                final UserDefFuncInfo userDefFuncInfo = (UserDefFuncInfo)scanInfo;
                r = new EvaluatorScan(userDefFuncInfo, new HitFinderFactory<String>(){

                    @Override
                    public HitFinder<String> createHitFinder() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
                        return new UserDefFuncHitFinder(userDefFuncInfo);
                    }
                }, resultChunkSize);
            }
            return r;
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAutoCalcCtColName(EvalChemTermInfo evalInfo) throws Exception {
        Connection conn = EvalTableScannerImpl.getCm().getConnection(evalInfo.getSessionInfo());
        try {
            String string = new ChemTermColSupport(new ClientSideSession(conn)).getChemTermColumn(evalInfo);
            return string;
        }
        finally {
            conn.close();
        }
    }

    public static JCartConnectionManager getCm() throws Exception {
        return JCartConnectionManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHitCount(EvalChemTermInfo evalChemTermInfo) throws RemoteException {
        int hitCount = 0;
        TableScan t = this.scan(evalChemTermInfo, Integer.MAX_VALUE);
        try {
            hitCount = t.getNextHits().length;
        }
        finally {
            try {
                t.dispose();
            }
            catch (Exception e) {
                RmiExceptionHandler.handleError(logger, (Throwable)e);
            }
        }
        return hitCount;
    }
}

