/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.jchem.cartridge.rmi.Index;
import chemaxon.jchem.cartridge.rmi.impl.RmiExceptionHandler;
import chemaxon.jchem.cartridge.server.task.Task;
import chemaxon.jchem.cartridge.servlets.indexing.operations.JCartIndexAlter;
import chemaxon.jchem.cartridge.servlets.indexing.operations.JCartIndexBaseAsync;
import chemaxon.jchem.cartridge.servlets.indexing.operations.JCartIndexCreate;
import chemaxon.jchem.cartridge.servlets.indexing.operations.JCartIndexRebuild;
import chemaxon.jchem.cartridge.servlets.indexing.operations.JCartIndexTruncate;
import chemaxon.jchem.cartridge.servlets.indexing.operations.MdDescManager;
import chemaxon.jchem.cartridge.tunnel.FetchIndexStats;
import chemaxon.jchem.cartridge.tunnel.index.AlterIndexInfo;
import chemaxon.jchem.cartridge.tunnel.index.CreateMolDescInfo;
import chemaxon.jchem.cartridge.tunnel.index.IndexCreateInfo;
import chemaxon.jchem.cartridge.tunnel.index.IndexRebuildInfo;
import chemaxon.jchem.cartridge.tunnel.index.IndexingInfo;
import chemaxon.jchem.cartridge.tunnel.index.MdManagementInfo;
import java.rmi.RemoteException;
import java.util.logging.Logger;

public class IndexImpl
implements Index {
    private static final Logger logger = Logger.getLogger(IndexImpl.class.getName());

    @Override
    public void truncateIndex(IndexingInfo ii) throws RemoteException {
        try {
            JCartIndexTruncate truncate = new JCartIndexTruncate(ii);
            truncate.all();
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
        }
    }

    @Override
    public void truncateUpdateLogTable(IndexingInfo ii) throws RemoteException {
        try {
            JCartIndexTruncate truncate = new JCartIndexTruncate(ii);
            truncate.updateLogTable();
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
        }
    }

    @Override
    public void createMdWithDefaultSettings(CreateMolDescInfo molDescInfo) throws RemoteException {
        try {
            MdDescManager.addDefaultMd(molDescInfo);
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
        }
    }

    @Override
    public Long createIndex(IndexCreateInfo indexCreateInfo) throws RemoteException {
        try {
            JCartIndexCreate indexer = new JCartIndexCreate(indexCreateInfo);
            indexer.executeAsynch();
            return indexer.getId();
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }

    @Override
    public Long rebuildIndex(IndexRebuildInfo indexRebuildInfo) throws RemoteException {
        try {
            JCartIndexRebuild indexer = new JCartIndexRebuild(indexRebuildInfo);
            indexer.executeAsynch();
            return indexer.getId();
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }

    @Override
    public void alterIndex(AlterIndexInfo alterIndexInfo) throws RemoteException {
        try {
            JCartIndexAlter indexer = new JCartIndexAlter(alterIndexInfo);
            indexer.execute();
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
        }
    }

    @Override
    public String fetchIndexStats(FetchIndexStats fetchIndexStats) throws RemoteException {
        try {
            return JCartIndexCreate.getIndexStatistics(fetchIndexStats);
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }

    @Override
    public void createMolDesc(CreateMolDescInfo createMolDescInfo) throws RemoteException {
        try {
            MdDescManager.addMd(createMolDescInfo);
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
        }
    }

    @Override
    public void deleteMolDesc(MdManagementInfo mdManagementInfo) throws RemoteException {
        try {
            MdDescManager.delMdDesc(mdManagementInfo);
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
        }
    }

    @Override
    public void deleteAllMolDesc(MdManagementInfo mdManagementInfo) throws RemoteException {
        try {
            MdDescManager.delAllMdDesc(mdManagementInfo);
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
        }
    }

    @Override
    public void addMolDescConf(MdManagementInfo mdManagementInfo) throws RemoteException {
        try {
            MdDescManager.addMdConf(mdManagementInfo);
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
        }
    }

    @Override
    public void delMolDescConf(MdManagementInfo mdManagementInfo) throws RemoteException {
        try {
            MdDescManager.delMdConf(mdManagementInfo);
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
        }
    }

    @Override
    public int getLongopStatusTotalWork(long taskId) throws RemoteException {
        try {
            Task task = Task.get(taskId);
            if (task == null) {
                return 0;
            }
            if (task instanceof JCartIndexBaseAsync) {
                return ((JCartIndexBaseAsync)task).getTotalWork();
            }
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
        }
        return 0;
    }

    @Override
    public int getLongopStatusSofar(long taskId) throws RemoteException {
        try {
            Task task = Task.get(taskId);
            if (task == null) {
                return 0;
            }
            if (task instanceof JCartIndexBaseAsync) {
                return ((JCartIndexBaseAsync)task).getSofar();
            }
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
        }
        return 0;
    }

    @Override
    public String getLongopStatusOpName(long taskId) throws RemoteException {
        try {
            Task task = Task.get(taskId);
            if (task == null) {
                return null;
            }
            if (task instanceof JCartIndexBaseAsync) {
                return ((JCartIndexBaseAsync)task).getOpName();
            }
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
        }
        return null;
    }

    @Override
    public boolean waitForRefresh(long taskId) throws RemoteException {
        try {
            Task task = Task.get(taskId);
            if (task == null) {
                return true;
            }
            if (task instanceof JCartIndexBaseAsync) {
                return ((JCartIndexBaseAsync)task).waitForRefresh();
            }
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
        }
        return true;
    }

    @Override
    public void disposeLongop(long taskId) throws RemoteException {
        try {
            Task.dispose(taskId);
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
        }
    }
}

