/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.jchem.cartridge.profiling.HostEnv;
import chemaxon.jchem.cartridge.profiling.InsertProfile;
import chemaxon.jchem.cartridge.profiling.JcsrvHost;
import chemaxon.jchem.cartridge.profiling.OraSearchProfile;
import chemaxon.jchem.cartridge.profiling.SearchProfile;
import chemaxon.jchem.cartridge.rmi.JCartProfiler;
import chemaxon.jchem.cartridge.rmi.impl.RmiExceptionHandler;
import chemaxon.jchem.cartridge.tunnel.search.SearchInfo;
import chemaxon.jchem.cartridge.util.JccConfig;
import chemaxon.jchem.version.VersionInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCartProfilerImpl
implements JCartProfiler {
    private static Log log = LogFactory.getLog(JCartProfilerImpl.class);
    private static long searchProfileIdCounter;
    private static Map<Long, SearchProfile> searchProfiles;

    public static boolean isProfiling(SearchInfo searchInfo) {
        return searchInfo.getProfileId() != null;
    }

    @Override
    public HostEnv createHostEnv() throws RemoteException {
        try {
            HostEnv hostEnv = new HostEnv();
            hostEnv.hostName = JCartProfilerImpl.getHostName();
            hostEnv.osName = System.getProperty("os.name");
            hostEnv.osVersion = System.getProperty("os.version");
            hostEnv.nrOfCpus = Runtime.getRuntime().availableProcessors();
            hostEnv.cpuVendor = System.getProperty("sun.cpu.isalist");
            hostEnv.cpuSpeed = 0;
            return hostEnv;
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(log, throwable);
            return null;
        }
    }

    @Override
    public JcsrvHost createJcsrvHost() throws RemoteException {
        try {
            JcsrvHost jcsrvHost = new JcsrvHost(this.createHostEnv());
            jcsrvHost.jcsrvContainer = "RMI-Server";
            jcsrvHost.jvmVersion = System.getProperty("java.vm.version");
            jcsrvHost.jchemVersion = VersionInfo.JCHEM_VERSION;
            jcsrvHost.nrOfThreadsPerOp = JccConfig.getInstance().getJcSearchThreadsPerCall();
            return jcsrvHost;
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(log, throwable);
            return null;
        }
    }

    @Override
    public long startSearchProfiling() throws RemoteException {
        SearchProfile sp = new SearchProfile();
        sp.profileId = searchProfileIdCounter++;
        searchProfiles.put(new Long(sp.profileId), sp);
        return sp.profileId;
    }

    @Override
    public synchronized void stopSearchProfiling(Long sessionId, OraSearchProfile oraResidentProfile) throws RemoteException {
        try {
            JCartProfilerImpl.searchProfiles.get((Object)new Long((long)sessionId.longValue())).oraSearchProfile = oraResidentProfile;
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(log, throwable);
        }
    }

    @Override
    public SearchProfile getSearchProfile(Long sessionId) throws RemoteException {
        return searchProfiles.get(sessionId);
    }

    private void completeSearchProfiles(ArrayList rawPointSetList, ArrayList searchProfileList) throws Exception {
        if (rawPointSetList.size() != searchProfileList.size()) {
            throw new Exception("rawPointSetList.size() = " + rawPointSetList.size() + ", searchProfileList.size() = " + searchProfileList.size());
        }
    }

    private static void completeInsertProfiles(ArrayList rawPointSetList, ArrayList insertProfileList) throws Exception {
        if (rawPointSetList.size() != insertProfileList.size()) {
            throw new Exception("rawPointSetList.size() = " + rawPointSetList.size() + ", insertProfileList.size() = " + insertProfileList.size());
        }
        for (int ix = 0; ix < rawPointSetList.size(); ++ix) {
            String rawPointSet = (String)rawPointSetList.get(ix);
            InsertProfile ip = (InsertProfile)insertProfileList.get(ix);
            JCartProfilerImpl.processInsertProfile(rawPointSet, ip);
        }
    }

    private static void processInsertProfile(String rawPointSet, InsertProfile ip) throws Exception {
        StringTokenizer stRest = new StringTokenizer(rawPointSet, ";");
        ip.plsqlEntered = Long.parseLong(stRest.nextToken());
        ip.jspEntered = Long.parseLong(stRest.nextToken());
        ip.leaveJspForServlet = Long.parseLong(stRest.nextToken());
        ip.backFromServlet = Long.parseLong(stRest.nextToken());
        ip.insertPsReady = Long.parseLong(stRest.nextToken());
        ip.startUpdateTracking = Long.parseLong(stRest.nextToken());
        ip.leaveJspForPlsql = Long.parseLong(stRest.nextToken());
        ip.backInPlsql = Long.parseLong(stRest.nextToken());
        if (stRest.hasMoreTokens()) {
            throw new Exception("Too many profile elements in set");
        }
    }

    private static byte[] objToBytes(Object obj) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream(bout);
            objOut.writeObject(obj);
            objOut.close();
            return bout.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String getHostName() throws Exception {
        return InetAddress.getLocalHost().getHostName();
    }

    public static SearchProfile getSearchProfileLocal(long profileId) {
        return searchProfiles.get(new Long(profileId));
    }

    static {
        searchProfiles = new ConcurrentHashMap<Long, SearchProfile>();
    }
}

