/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.formats.MolFormatException;
import chemaxon.jchem.cartridge.rmi.JchemSearch;
import chemaxon.jchem.cartridge.rmi.TableScan;
import chemaxon.jchem.cartridge.rmi.impl.RmiExceptionHandler;
import chemaxon.jchem.cartridge.rmi.impl.scanresult.SearchExInfo;
import chemaxon.jchem.cartridge.rmi.impl.scanresult.SearchScan;
import chemaxon.jchem.cartridge.server.task.Task;
import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.servlets.search.QueryHandler;
import chemaxon.jchem.cartridge.servlets.search.QueryHandlerFactory;
import chemaxon.jchem.cartridge.tunnel.search.SearchExecInfo;
import chemaxon.jchem.cartridge.tunnel.search.SearchInfo;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.JChemSearch;
import chemaxon.jchem.db.PropertyNotSetException;
import chemaxon.jchem.interop.InteropMiscellanious;
import chemaxon.jchem.interop.InteropUtil;
import chemaxon.jchem.interop.JChemSearchOptionsAdapter;
import chemaxon.sss.SearchConstants;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.HitColoringAndAlignmentOptions;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JchemSearchImpl
implements JchemSearch,
SearchConstants {
    private static Logger logger = Logger.getLogger(JchemSearchImpl.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHitCount(SearchInfo searchInfo) throws RemoteException {
        int hitCount = 0;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BEGIN: searchInfo=" + searchInfo);
        }
        searchInfo.setEarlyResults(false);
        TableScan r = this.search(searchInfo);
        try {
            int[] hits = r.getNextHits();
            if (hits != null) {
                hitCount = hits.length;
            }
        }
        finally {
            try {
                r.dispose();
            }
            catch (Exception e) {
                RmiExceptionHandler.handleError(logger, (Throwable)e);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("About to return " + hitCount + " hit(s)");
        }
        return hitCount;
    }

    @Override
    public TableScan search(SearchInfo searchInfo) throws RemoteException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BEGIN: searchInfo=" + searchInfo);
        }
        try {
            QueryHandler queryHandler = new QueryHandlerFactory(searchInfo).create();
            SearchScan jcresult = new SearchScan(queryHandler, searchInfo);
            queryHandler.start();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("About to return " + jcresult);
            }
            Task task = jcresult;
            Task t = Task.get(task.getId());
            return jcresult;
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }

    public int[] test(String param, int size) throws RemoteException {
        int[] ia = new int[1024 * size];
        return ia;
    }

    @Override
    public Long searchReturnSearchId(SearchInfo searchInfo) throws RemoteException {
        long id = -1L;
        try {
            QueryHandler queryHandler = new QueryHandlerFactory(searchInfo).create();
            queryHandler.start();
            SearchScan scanTask = new SearchScan(queryHandler, searchInfo);
            long searchId = scanTask.getId();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("returning search id: " + searchId);
            }
            return new Long(searchId);
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return id;
        }
    }

    @Override
    public int[] getNextHits(Long searchId) throws RemoteException {
        try {
            TableScan jcresult = (TableScan)((Object)Task.get(searchId));
            return jcresult.getNextHits();
        }
        catch (Exception e) {
            RmiExceptionHandler.handleError(logger, (Throwable)e);
            return null;
        }
    }

    @Override
    public void disposeSearch(Long searchId) throws RemoteException {
        try {
            Task.dispose(searchId);
        }
        catch (Exception e) {
            RmiExceptionHandler.handleError(logger, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] hitColorAndAlign(SearchInfo sinfo, String rowids, String hitColorAndAlignOptionList) throws RemoteException {
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("sinfo=" + sinfo + ", hitColorAndAlignOptionList=" + hitColorAndAlignOptionList);
            }
            HitColoringAndAlignmentOptions hcaaOptions = new HitColoringAndAlignmentOptions();
            HitColoringAndAlignmentOptions.setOptions(hcaaOptions, hitColorAndAlignOptionList);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("hcaaOptions.coloring=" + hcaaOptions.coloring + ", hcaaOptions.hitColor=" + hcaaOptions.hitColor);
            }
            Molecule[] mols = null;
            ConnectionHandler ch = JCartConnectionManager.getInstance().createConnectionHandler(sinfo.getSessionInfo(), sinfo.getJcpropTableName(), true);
            try {
                ConnectionHandler cmittableCh = new ConnectionHandler(ch.getConnection(), ch.getPropertyTable(), true);
                JChemSearch jcSearch = this.initJChemSearchForHitVisualization(sinfo, cmittableCh);
                int[] idList = null;
                idList = sinfo.isJchemTable() ? InteropUtil.parseIntList(rowids, ", ") : this.getCdIdFromRowids(ch.getConnection(), jcSearch.getStructureTable(), rowids);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Coloring starting...");
                }
                mols = jcSearch.getHitsAsMolecules(idList, hcaaOptions, null, new ArrayList());
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Coloring stopped...");
                }
            }
            finally {
                ch.close();
            }
            String[] mrvs = InteropMiscellanious.exportMoleculesToArray(mols, "mrv");
            return mrvs;
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JChemSearch initJChemSearchForHitVisualization(SearchInfo sinfo, ConnectionHandler ch) throws SQLException, MolFormatException, DatabaseSearchException, IOException, PropertyNotSetException {
        String indexTable;
        JChemSearchOptionsAdapter searchOptions = new JChemSearchOptionsAdapter(sinfo.getOptions());
        String indexedTable = sinfo.getBaseSchemaName() + "." + sinfo.getBaseTableName();
        if (sinfo.getBaseSchemaName() == null) {
            indexedTable = sinfo.getBaseTableName();
        }
        boolean isJChemTable = (indexTable = sinfo.getIndexTableQName()) == null || indexTable.equals(indexedTable);
        String structureTable = indexedTable;
        if (!isJChemTable) {
            structureTable = indexTable;
        }
        JChemSearch jcSearch = null;
        jcSearch = isJChemTable ? new JChemSearch() : new JChemSearch(indexedTable, sinfo.getIndexedColumn());
        jcSearch.setStructureTable(structureTable);
        jcSearch.setSearchOptions(searchOptions);
        jcSearch.setConnectionHandler(ch);
        jcSearch.setQueryStructure(sinfo.getQuery());
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Dummy query starting...");
        }
        jcSearch.setFilterIDList(new int[]{-1});
        try {
            jcSearch.run();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Dummy query stopped.");
            }
        }
        finally {
            ch.getConnection().commit();
        }
        return jcSearch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getCdIdFromRowids(Connection conn, String tableName, String rowids) throws SQLException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select cd_id from ").append(tableName).append(" where rid in (");
        int idCount = 0;
        StringTokenizer st = new StringTokenizer(rowids, ", ");
        while (st.hasMoreTokens()) {
            if (idCount > 0) {
                sqlBuffer.append(",");
            }
            sqlBuffer.append("'").append(st.nextToken()).append("'");
            ++idCount;
        }
        sqlBuffer.append(")");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("sql: " + sqlBuffer.toString());
        }
        int[] cdIdArray = new int[idCount];
        ResultSet rs = null;
        Statement stmt = conn.createStatement();
        try {
            rs = stmt.executeQuery(sqlBuffer.toString());
            idCount = 0;
            while (rs.next()) {
                cdIdArray[idCount] = rs.getInt(1);
                ++idCount;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        return cdIdArray;
    }

    @Override
    public SearchExecInfo getSearchExecInfo(Long searchId) throws RemoteException {
        try {
            SearchExInfo sinfo = SearchExInfo.remove(searchId);
            if (sinfo == null) {
                return null;
            }
            return new SearchExecInfo(sinfo.getScreenedCountUnique(), sinfo.getScreenedCountTotal());
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }
}

