/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.SimilarityCalculator;
import chemaxon.descriptors.SimilarityCalculatorFactory;
import chemaxon.descriptors.SimilarityException;
import chemaxon.formats.MolFormatException;
import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.extfp.ExtFpRowDataGenerator;
import chemaxon.jchem.cartridge.oresident.JccConfigConstants;
import chemaxon.jchem.cartridge.rmi.Miscellanious;
import chemaxon.jchem.cartridge.rmi.StructureFormatException;
import chemaxon.jchem.cartridge.rmi.impl.RmiExceptionHandler;
import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.servlets.JcUtil;
import chemaxon.jchem.cartridge.tunnel.MdMetaData;
import chemaxon.jchem.cartridge.tunnel.TableOpInfo;
import chemaxon.jchem.cartridge.tunnel.search.ScreenParams;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.MDTableHandler;
import chemaxon.jchem.db.RegenerationChecker;
import chemaxon.jchem.interop.InteropMiscellanious;
import chemaxon.jchem.interop.Pools;
import chemaxon.reaction.Standardizer;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.MolHandler;
import chemaxon.util.RuntimeUtils;
import chemaxon.util.cache.CachedPools;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MiscellaniousImpl
implements Miscellanious {
    private static Logger logger = Logger.getLogger(MiscellaniousImpl.class.getName());
    public static final SimilarityCalculatorCache simCalcCache = new SimilarityCalculatorCache();

    @Override
    public String standardize(String target, String stdrConfig, String outFormat) throws RemoteException {
        try {
            return InteropMiscellanious.standardize(target, stdrConfig, outFormat);
        }
        catch (Throwable tbl) {
            RmiExceptionHandler.handleError(logger, tbl);
            return null;
        }
    }

    @Override
    public double getChemFpDissimilarity(int tableType, int[] fp_t, byte[] target, boolean targetStdrNeeded, byte[] query, int[] fp_props, String stdrConfig, String dissimMetric) throws RemoteException {
        try {
            if (logger.isLoggable(Level.FINER)) {
                int i;
                StringBuffer sb = new StringBuffer("tableType=").append(tableType);
                if (fp_t != null) {
                    sb.append(", fp_t={");
                    for (i = 0; i < fp_t.length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(fp_t[i]);
                    }
                    sb.append("}");
                }
                sb.append(", target=").append(JFunctions.decodeDbString(target));
                sb.append(", targetStdrNeeded=").append(targetStdrNeeded);
                sb.append(", query=").append(JFunctions.decodeDbString(query));
                if (fp_props != null) {
                    sb.append(", fp_props={");
                    for (i = 0; i < fp_props.length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(fp_props[i]);
                    }
                    sb.append("}");
                }
                sb.append(", stdrConfig=").append(stdrConfig);
                sb.append(", dissimMetric=").append(dissimMetric);
                logger.finer(sb.toString());
            }
            double sim = MiscellaniousImpl.getChemFpDissimilarity(tableType, fp_t, JFunctions.decodeDbString(target), targetStdrNeeded, JFunctions.decodeDbString(query), fp_props, stdrConfig, dissimMetric);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Returning " + sim);
            }
            return sim;
        }
        catch (Throwable tbl) {
            RmiExceptionHandler.handleError(logger, tbl);
            return 0.0;
        }
    }

    @Override
    public double getMdDissimilarity(byte[] target, byte[] query, String stdrConfig, ScreenParams screenParams) throws RemoteException {
        try {
            return MiscellaniousImpl.getMdDissimilarity(target == null ? null : new String(target), new String(query), stdrConfig, screenParams);
        }
        catch (Throwable tbl) {
            RmiExceptionHandler.handleError(logger, tbl);
            return 0.0;
        }
    }

    @Override
    public byte[] molconvertb(byte[] target, String inputFormat, String options) throws RemoteException {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("target=" + new String(target) + ", inputFormat=" + inputFormat + ", options=" + options);
            }
            byte[] result = InteropMiscellanious.molconvert(target, inputFormat, options);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("returning " + result.length + " byte(s)");
            }
            return result;
        }
        catch (MolFormatException mfe) {
            throw new StructureFormatException(mfe);
        }
        catch (Throwable tbl) {
            RmiExceptionHandler.handleError(logger, tbl);
            return null;
        }
    }

    @Override
    public Object getMolProperty(String target, String stdrConfig, String propertyName) throws RemoteException {
        try {
            MolHandler mh = new MolHandler(target);
            InteropMiscellanious.standardize(mh.getMolecule(), stdrConfig, false);
            if (propertyName.startsWith("cd_molweight")) {
                return new Double(mh.calcMolWeightInDouble());
            }
            if (propertyName.startsWith("cd_formula")) {
                return mh.calcMolFormula();
            }
            return mh.getMolecule().getProperty(propertyName);
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MdMetaData[] getMdMetaData(TableOpInfo tableOpInfo, boolean isJChemTable) throws RemoteException {
        MdMetaData[] mdMetaDataArray;
        String idxTableQName = tableOpInfo.getIndexTableQName();
        ConnectionHandler ch = this.getConnectionHandler(tableOpInfo);
        try {
            MDTableHandler mdTableHandler = new MDTableHandler(ch, idxTableQName, !isJChemTable);
            String[] mdNames = mdTableHandler.getMolecularDescriptors();
            MdMetaData[] mdMetaDataArray2 = new MdMetaData[mdNames.length];
            for (int i = 0; i < mdNames.length; ++i) {
                MdMetaData mdMetaData = new MdMetaData();
                mdMetaData.name = mdNames[i];
                this.fillMdMetaData(idxTableQName, mdTableHandler, mdMetaData);
                mdMetaDataArray2[i] = mdMetaData;
            }
            mdMetaDataArray = mdMetaDataArray2;
        }
        catch (Throwable throwable) {
            try {
                ch.getConnection().rollback();
                ch.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                RmiExceptionHandler.handleError(logger, throwable2);
                return null;
            }
        }
        ch.getConnection().rollback();
        ch.close();
        return mdMetaDataArray;
    }

    private void fillMdMetaData(String idxTableQName, MDTableHandler mdTableHandler, MdMetaData mdMetaData) throws SQLException {
        String mdName = mdMetaData.name;
        mdMetaData.type = mdTableHandler.getMDType(mdName);
        mdMetaData.settings = mdTableHandler.getMDSettings(mdName);
        mdMetaData.tableName = MDTableHandler.getMDTableName(idxTableQName, mdName);
        String[] configNames = mdTableHandler.getMDConfigs(mdName);
        mdMetaData.configs = new String[configNames.length][2];
        for (int i = 0; i < configNames.length; ++i) {
            String configName;
            mdMetaData.configs[i][0] = configName = configNames[i];
            mdMetaData.configs[i][1] = mdTableHandler.getMDConfig(mdName, configName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int idxCompatibility(TableOpInfo tableOpInfo, boolean isJChemTable) throws RemoteException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("tableOpInfo=" + tableOpInfo);
        }
        try {
            ConnectionHandler ch = this.getConnectionHandler(tableOpInfo);
            try {
                DatabaseProperties dp = new DatabaseProperties(ch, !isJChemTable);
                int i = RegenerationChecker.isRegenerationNeeded(tableOpInfo.getIndexTableQName().toUpperCase(), dp);
                if (i == 0) {
                    int n = 0;
                    return n;
                }
                if (i == 1) {
                    int n = -1;
                    return n;
                }
                if (i != 2) throw new IllegalArgumentException("Unknown index compatibility value: " + i);
                int n = 1;
                return n;
            }
            finally {
                ch.getConnection().rollback();
                ch.close();
            }
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return -1;
        }
    }

    private ConnectionHandler getConnectionHandler(TableOpInfo tableOpInfo) throws Exception {
        return JCartConnectionManager.getInstance().createConnectionHandler(tableOpInfo.getSessionInfo(), tableOpInfo.getJcpropTableName(), true);
    }

    @Override
    public String exec(String options, String[] params) throws RemoteException {
        try {
            ArrayList<String> l = new ArrayList<String>();
            for (String p : params) {
                if (p == null) break;
                l.add(p);
            }
            params = new String[l.size()];
            l.toArray(params);
            return RuntimeUtils.exec(params);
        }
        catch (RuntimeException e) {
            RmiExceptionHandler.handleError(logger, (Throwable)e);
        }
        catch (IOException e) {
            RmiExceptionHandler.handleError(logger, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            RmiExceptionHandler.handleError(logger, (Throwable)e);
        }
        return null;
    }

    public static double getDefaultDissimilarity(String metric, String target, boolean targetStdrNeeded, int[] targetFp, String query, boolean queryStdrNeeded, int[] fpProps, String stdrConfig, boolean stdrOptionals) throws Exception {
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("metric=" + metric + ", target=" + target + ", targetStdrNeeded=" + targetStdrNeeded + ", targetFp=" + targetFp + ", query=" + query + ", queryStdrNeeded=" + queryStdrNeeded + ", fpProps=" + fpProps + ", stdrConfig=" + stdrConfig + ", stdrOptionals=" + stdrOptionals);
            }
            if (metric == null) {
                metric = "tanimoto";
            }
            if (targetFp == null) {
                targetFp = InteropMiscellanious.getFp(target, targetStdrNeeded, stdrConfig, stdrOptionals, fpProps);
            }
            SimilarityCalculatorCacheKey key = new SimilarityCalculatorCacheKey(metric, query, queryStdrNeeded, stdrConfig, stdrOptionals, fpProps);
            SimilarityCalculator sc = (SimilarityCalculator)simCalcCache.getCreatePoolItem(key);
            double dissim = sc.getDissimilarity(targetFp);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("returning " + dissim + "...");
            }
            return dissim;
        }
        catch (MolFormatException molformExc) {
            String faultyPart = "query";
            if (targetFp == null) {
                faultyPart = "target";
            }
            throw new StructureFormatException("Invalid " + faultyPart + " format", molformExc);
        }
    }

    public static double getMdDissimilarity(String target, String query, String stdrConfig, ScreenParams screenParams) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("target=" + target + ", query=" + query + ", stdrConfig=" + stdrConfig + ", screenParams=" + screenParams);
        }
        MolecularDescriptor targetMd = null;
        MolecularDescriptor queryMd = null;
        try {
            MdMetaData mdMeta = screenParams.getMdScreenInfo().getMdmeta();
            targetMd = InteropMiscellanious.createMd(mdMeta.type, mdMeta.settings, screenParams.getMdScreenInfo().getScreenConfiguration());
            queryMd = targetMd.clone();
            InteropMiscellanious.setMdContent(target, screenParams.getTargetFp(), stdrConfig, targetMd);
            InteropMiscellanious.setMdContent(query, null, stdrConfig, queryMd);
            double sim = queryMd.getDissimilarity(targetMd, 0);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("returning " + sim + "...");
            }
            return sim;
        }
        catch (MolFormatException mfe) {
            String faultyPart = "query";
            if (targetMd == null) {
                faultyPart = "target";
            }
            throw new StructureFormatException("Invalid " + faultyPart + " format", mfe);
        }
    }

    public static double getFpOnlyDissimilarity(String target, String query, String metric) throws ParseException, SimilarityException {
        ExtFpRowDataGenerator fpg = new ExtFpRowDataGenerator();
        int[] qFp = fpg.getRowData((String)query).fingerprint;
        int[] tFp = fpg.getRowData((String)target).fingerprint;
        SimilarityCalculator<int[]> simCalc = SimilarityCalculatorFactory.create(metric);
        simCalc.setQueryFingerprint(qFp);
        return simCalc.getDissimilarity(tFp);
    }

    public static double getChemFpDissimilarity(int tableType, int[] fp_t, String target, boolean targetStdrNeeded, String query, int[] fp_props, String stdrConfig, String dissimMetric) throws Exception {
        double dissimilarity = -1.0;
        InteropMiscellanious.checkFpProps(fp_props, tableType);
        dissimilarity = tableType == 1 ? InteropMiscellanious.getReactionDissimilarity(fp_t, target, query, fp_props, stdrConfig, true, dissimMetric) : (tableType == 10000 ? MiscellaniousImpl.getFpOnlyDissimilarity(target, query, dissimMetric) : MiscellaniousImpl.getDefaultDissimilarity(dissimMetric, target, targetStdrNeeded, fp_t, query, true, fp_props, stdrConfig, true));
        return dissimilarity;
    }

    public static void main(String[] args) throws RemoteException {
        MiscellaniousImpl m = new MiscellaniousImpl();
        System.out.println(m.getChemFpDissimilarity(1, null, "Brc1ccccc1>>Br[Mg]c1ccccc1".getBytes(), true, "BrC1CCCC1>>Br[Mg]C1CCCC1".getBytes(), new int[]{512, 2, 6}, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String standardize(String structure, String stdrConfig, String cleaningTemplate, String outFormat) throws RemoteException {
        String string;
        Standardizer standardizer = Pools.getCreateStandardizer(stdrConfig);
        try {
            MolHandler mh = new MolHandler(structure);
            if (cleaningTemplate != null && cleaningTemplate.length() > 0 && !cleaningTemplate.equals("null")) {
                standardizer.setCleanTemplates(JcUtil.importMolecules(cleaningTemplate, false));
            }
            string = InteropMiscellanious.standardize(standardizer, mh.getMolecule(), outFormat);
            standardizer.setCleanTemplates(null);
        }
        catch (Throwable throwable) {
            try {
                standardizer.setCleanTemplates(null);
                Pools.recycleStandardizer(stdrConfig, standardizer);
                throw throwable;
            }
            catch (Throwable throwable2) {
                RmiExceptionHandler.handleError(logger, throwable2);
                return null;
            }
        }
        Pools.recycleStandardizer(stdrConfig, standardizer);
        return string;
    }

    public static class SimilarityCalculatorCacheKey {
        private String metric;
        private String query;
        private String stdrConfig = JccConfigConstants.UNINITIALIZED_STRING;
        private boolean stdrOptionals;
        private int[] fpProps;
        private String asString;
        private int[] queryFp;

        public SimilarityCalculatorCacheKey(String metric, String query, boolean stdrConfigNeeded, String stdrConfig, boolean stdrOptionals, int[] fpProps) {
            this.metric = metric;
            this.query = query;
            if (stdrConfigNeeded) {
                this.stdrConfig = stdrConfig;
            }
            this.stdrOptionals = stdrOptionals;
            this.fpProps = fpProps;
            this.asString = metric + query + stdrConfig + stdrOptionals;
            for (int i = 0; i < fpProps.length; ++i) {
                int fpprop = fpProps[i];
                this.asString = this.asString + fpprop;
            }
        }

        public String getMetric() {
            return this.metric;
        }

        public int[] getQueryFp() throws Exception {
            if (this.queryFp == null) {
                this.queryFp = InteropMiscellanious.getFp(this.query, this.stdrConfig != JccConfigConstants.UNINITIALIZED_STRING, this.stdrConfig, this.stdrOptionals, this.fpProps);
            }
            return this.queryFp;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SimilarityCalculatorCacheKey)) {
                return false;
            }
            SimilarityCalculatorCacheKey other = (SimilarityCalculatorCacheKey)obj;
            return this.asString.equals(other.asString);
        }

        public int hashCode() {
            return this.asString.hashCode();
        }
    }

    public static class SimilarityCalculatorCache
    extends CachedPools {
        @Override
        public Object createPoolItem(Object key) throws Exception {
            SimilarityCalculatorCacheKey sccKey = (SimilarityCalculatorCacheKey)key;
            SimilarityCalculator<int[]> sc = SimilarityCalculatorFactory.create(sccKey.getMetric());
            sc.setQueryFingerprint(sccKey.getQueryFp());
            return sc;
        }
    }
}

