/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.jchem.cartridge.rmi.ReactProducts;
import chemaxon.jchem.cartridge.rmi.impl.RemoteTask;
import chemaxon.jchem.cartridge.rmi.impl.RmiExceptionHandler;
import chemaxon.jchem.cartridge.servlets.react.JCartReactor;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReactProductsImpl
extends RemoteTask
implements ReactProducts {
    private static Logger logger = Logger.getLogger(ReactProductsImpl.class.getName());
    private LinkedBlockingQueue<String> productQueue;
    private JCartReactor jCartReactor;
    private int resultChunkSize;
    private Throwable error;

    public ReactProductsImpl(SessionInfo userInfo, String userAssignedOpId, String taskDescription, LinkedBlockingQueue<String> productQueue, JCartReactor jCartReactor, int resultChunkSize) throws IOException {
        super(userInfo, userAssignedOpId, taskDescription);
        this.productQueue = productQueue;
        this.jCartReactor = jCartReactor;
        this.resultChunkSize = resultChunkSize;
    }

    @Override
    public String[] getNextProducts() throws RemoteException {
        try {
            if (this.hasPreviousMarkerOrError()) {
                return null;
            }
            ArrayList<String> newProducts = new ArrayList<String>();
            String product = this.getNextProductFromQueue();
            StringBuffer debugBuffer = null;
            if (logger.isLoggable(Level.FINE)) {
                debugBuffer = new StringBuffer();
            }
            while (product != null) {
                if (debugBuffer != null) {
                    if (debugBuffer.length() > 0) {
                        debugBuffer.append(";");
                    }
                    debugBuffer.append(product);
                }
                newProducts.add(product);
                if (newProducts.size() == this.resultChunkSize) {
                    String[] prodArray = new String[newProducts.size()];
                    newProducts.toArray(prodArray);
                    if (debugBuffer != null) {
                        logger.fine("Returning " + debugBuffer.toString());
                    }
                    return prodArray;
                }
                product = this.getNextProductFromQueue();
            }
            return this.returnLeftOver(newProducts);
        }
        catch (Throwable throwable) {
            RmiExceptionHandler.handleError(logger, throwable);
            return null;
        }
    }

    private boolean hasPreviousMarkerOrError() throws Throwable {
        if (this.error != null) {
            throw this.error;
        }
        return this.productQueue == null;
    }

    private String getNextProductFromQueue() throws Throwable {
        String obj = this.productQueue.take();
        if (obj == JCartReactor.POISON) {
            this.productQueue = null;
            return null;
        }
        if (obj instanceof Throwable) {
            this.error = (Throwable)((Object)obj);
            throw this.error;
        }
        return obj;
    }

    private String[] returnLeftOver(ArrayList<String> newProducts) {
        if (newProducts.size() > 0) {
            String[] prodArray = new String[newProducts.size()];
            newProducts.toArray(prodArray);
            if (logger.isLoggable(Level.FINE)) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < prodArray.length; ++i) {
                    String prod = prodArray[i];
                    if (sb.length() > 0) {
                        sb.append(";");
                    }
                    sb.append(prod);
                }
                logger.fine("Returning " + sb.toString());
            }
            return prodArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() throws RemoteException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("dispose called");
        }
        try {
            super.dispose();
        }
        catch (Throwable tbl) {
            RmiExceptionHandler.handleError(logger, tbl);
        }
        finally {
            try {
                this.jCartReactor.stop();
            }
            catch (Throwable throwable) {
                RmiExceptionHandler.handleError(logger, throwable);
            }
        }
    }

    @Override
    public Long getMemoryUsage() throws Exception {
        return null;
    }
}

