/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.jchem.cartridge.server.task.Task;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import chemaxon.jchem.cartridge.util.JccConfig;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;

public abstract class RemoteTask
extends Task
implements Remote {
    protected RemoteTask(SessionInfo sessionInfo, String userAssignedOpId, String description, int timeOutInSeconds) throws IOException {
        super(sessionInfo, userAssignedOpId, description, timeOutInSeconds);
        RemoteTask.export(this);
    }

    protected RemoteTask(SessionInfo sessionInfo, String userAssignedOpId, String description) throws IOException {
        this(sessionInfo, userAssignedOpId, description, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dispose() throws Exception {
        try {
            super.dispose();
        }
        finally {
            UnicastRemoteObject.unexportObject(this, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Remote export(Remote remote) throws IOException {
        JccConfig jccConfig = JccConfig.getInstance();
        int port = jccConfig.getInt("jchem.server.port", 1099);
        if (remote instanceof RemoteTask) {
            Remote remote2 = remote;
            synchronized (remote2) {
                return UnicastRemoteObject.exportObject(remote, port);
            }
        }
        return UnicastRemoteObject.exportObject(remote, port);
    }
}

