/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl;

import chemaxon.formats.MolFormatException;
import chemaxon.jchem.cartridge.oresident.JavaStoredProcExceptionHandler;
import chemaxon.jchem.cartridge.rmi.StructureFormatException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;

public class RmiExceptionHandler {
    private static final Logger logger = Logger.getLogger(RmiExceptionHandler.class.getName());

    private RmiExceptionHandler() {
    }

    public static Object handleError(Logger theirLoggers, Throwable throwable) throws RemoteException {
        if (theirLoggers.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, throwable.getMessage(), throwable);
        }
        for (int i = 0; i < JavaStoredProcExceptionHandler.handledExceptions.length; ++i) {
            Class eClass = JavaStoredProcExceptionHandler.handledExceptions[i];
            RmiExceptionHandler.handleException(eClass, throwable);
        }
        if (throwable instanceof RemoteException) {
            throw (RemoteException)throwable;
        }
        throw new RemoteException(throwable.getMessage());
    }

    private static void handleException(Class classToHandle, Throwable throwable) throws RemoteException {
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            if (cause.getClass().equals(classToHandle)) {
                if (cause instanceof RemoteException) {
                    throw (RemoteException)cause;
                }
                throw new RemoteException(throwable.getMessage());
            }
            RmiExceptionHandler.checkToConvert(cause);
        }
    }

    private static void checkToConvert(Throwable cause) throws RemoteException {
        if (cause instanceof MolFormatException) {
            MolFormatException mfe = (MolFormatException)cause;
            throw new StructureFormatException(mfe);
        }
    }

    public static Object handleError(Log log, Throwable throwable) throws RemoteException {
        return RmiExceptionHandler.handleError(log, null, throwable);
    }

    public static Object handleError(Log log, String msg, Throwable throwable) throws RemoteException {
        if (log.isErrorEnabled()) {
            if (msg == null) {
                msg = "Error in RMI call";
            }
            log.error((Object)msg, throwable);
        }
        if (throwable instanceof RemoteException) {
            throw (RemoteException)throwable;
        }
        throw new RemoteException(throwable.getMessage());
    }

    public static boolean isLocalClient(String[] clientHost) throws ServerNotActiveException, UnknownHostException, SocketException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("BEGIN");
        }
        clientHost[0] = UnicastRemoteObject.getClientHost();
        InetAddress clientInetAddress = InetAddress.getByName(clientHost[0]);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("checking " + clientInetAddress + "...");
        }
        Enumeration<NetworkInterface> niEnum = NetworkInterface.getNetworkInterfaces();
        while (niEnum.hasMoreElements()) {
            NetworkInterface netif = niEnum.nextElement();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("...against " + netif + "...");
            }
            Enumeration<InetAddress> iaEnum = netif.getInetAddresses();
            while (iaEnum.hasMoreElements()) {
                InetAddress localInetAddress = iaEnum.nextElement();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("...having " + localInetAddress + "...");
                }
                if (!clientInetAddress.equals(localInetAddress)) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(clientInetAddress + " equals " + localInetAddress);
                }
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) throws UnknownHostException, SocketException, NoSuchAlgorithmException, RemoteException, LogConfigurationException {
        RmiExceptionHandler.handleError(LogFactory.getLog((String)"valami"), (Throwable)new Exception("zazi"));
    }
}

