/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl.errcache;

import chemaxon.jchem.cartridge.rmi.ErrorCache;
import chemaxon.jchem.cartridge.rmi.impl.errcache.SessionErrors;
import chemaxon.jchem.cartridge.tunnel.search.ErrorRecord;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ErrorCacheImpl
implements ErrorCache,
Runnable {
    private static final Logger logger = Logger.getLogger(ErrorCacheImpl.class.getName());
    private volatile long errorCleanUpInterval;
    private Map<String, SessionErrors> bySessionIdErrMap = new HashMap<String, SessionErrors>();
    private CountDownLatch openLatch;
    private volatile Status status = Status.STOPPED;

    private ErrorCacheImpl() {
    }

    public synchronized void open() {
        if (this.status != Status.STOPPED) {
            throw new IllegalArgumentException("I am not stopped");
        }
        this.status = Status.STARTING;
        this.errorCleanUpInterval = 600000L;
        try {
            this.startCleanUpThread();
        }
        catch (InterruptedException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
            return;
        }
        this.status = Status.RUNNING;
    }

    public synchronized void close() throws InterruptedException {
        if (this.status != Status.RUNNING) {
            throw new IllegalStateException("I am not running");
        }
        this.status = Status.STOPPING;
        this.notify();
        this.wait();
        this.bySessionIdErrMap.clear();
        this.status = Status.STOPPED;
    }

    @Override
    public void run() {
        this.openLatch.countDown();
        this.cycleThroughCleanUp();
    }

    private synchronized void cycleThroughCleanUp() {
        while (this.status != Status.STOPPING) {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Sleeping " + this.errorCleanUpInterval + "...");
                }
                this.wait(this.errorCleanUpInterval);
                if (this.status == Status.STOPPING) continue;
                this.cleanUp();
            }
            catch (Throwable throwable) {
                if (!logger.isLoggable(Level.SEVERE)) continue;
                logger.log(Level.SEVERE, throwable.getMessage(), throwable);
            }
        }
        this.notify();
    }

    private void cleanUp() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Starting clean up");
        }
        Iterator<String> sidIterator = this.bySessionIdErrMap.keySet().iterator();
        while (sidIterator.hasNext()) {
            String sessionId = sidIterator.next();
            SessionErrors sessionErrors = this.bySessionIdErrMap.get(sessionId);
            if (sessionErrors == null) continue;
            sessionErrors.removeOldErrors();
            if (!sessionErrors.isEmptyLongEnough()) continue;
            sidIterator.remove();
        }
    }

    @Override
    public synchronized void addErrorRecord(String sessionId, ErrorRecord errorRecordecord) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("sessionId=" + sessionId + ", errorRecord=" + errorRecordecord);
        }
        SessionErrors sessionErrors = this.getSessionErrors(sessionId);
        sessionErrors.addRecord(errorRecordecord);
    }

    public static ErrorCacheImpl instance() {
        return SingletonHolder.instance;
    }

    public long getCleanUpInterval() {
        return this.errorCleanUpInterval;
    }

    @Override
    public synchronized void setCleanUpInterval(long cleanUpInterval) {
        this.errorCleanUpInterval = cleanUpInterval;
        this.notify();
    }

    private void startCleanUpThread() throws InterruptedException {
        this.openLatch = new CountDownLatch(1);
        Executors.newFixedThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        }).submit(this);
        this.openLatch.await();
    }

    private SessionErrors getSessionErrors(String sessionId) {
        SessionErrors sessionErrors = this.bySessionIdErrMap.get(sessionId);
        if (sessionErrors == null) {
            sessionErrors = new SessionErrors();
            this.bySessionIdErrMap.put(sessionId, sessionErrors);
        }
        return sessionErrors;
    }

    synchronized int getSessionErrorsCount() {
        return this.bySessionIdErrMap.size();
    }

    @Override
    public synchronized ErrorRecord[] getErrors(String sessionId, Long scanId, int count) {
        SessionErrors sessionErrors = this.bySessionIdErrMap.get(sessionId);
        if (sessionErrors == null) {
            return new ErrorRecord[0];
        }
        ErrorRecord[] errRecords = sessionErrors.getErrorRecords(scanId, count);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Returning " + errRecords + " record(s)...");
        }
        return errRecords;
    }

    @Override
    public synchronized int getErrorCount(String sessionId) {
        SessionErrors sessionErrors;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("sessionId=" + sessionId);
        }
        if ((sessionErrors = this.bySessionIdErrMap.get(sessionId)) == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No errors found for sessionId=" + sessionId);
            }
            return 0;
        }
        return sessionErrors.getErrorCount();
    }

    @Override
    public synchronized void clearCache(String sessionId) {
        this.getSessionErrors(sessionId).clearErrors();
    }

    @Override
    public synchronized void setErrorRecordExpirationTime(String sessionId, long expirationTime) {
        this.getSessionErrors(sessionId).setErrorRecordExpirationTime(expirationTime);
    }

    @Override
    public synchronized void setEmptySessionErrorsExpirationTime(String sessionId, long emptySessionErrorsExpirationTime) {
        this.getSessionErrors(sessionId).setEmptySessionErrorsExpirationTime(emptySessionErrorsExpirationTime);
    }

    @Override
    public synchronized void setRemoveRecordsOnAccess(String sessionId, boolean removeRecordsOnAccess) {
        this.getSessionErrors(sessionId).setRemoveRecordsOnAccess(removeRecordsOnAccess);
    }

    private static class SingletonHolder {
        public static final ErrorCacheImpl instance = new ErrorCacheImpl();

        private SingletonHolder() {
        }
    }

    private static enum Status {
        STOPPED,
        STARTING,
        RUNNING,
        STOPPING;

    }
}

