/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.rmi.impl.scanresult;

import chemaxon.jchem.cartridge.tunnel.EvalChemTermInfo;
import chemaxon.jchem.cartridge.util.CardinalPredicat;
import chemaxon.jep.ChemJEP;
import chemaxon.jep.Evaluator;
import chemaxon.jep.context.MolContext;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.util.MolHandler;
import chemaxon.util.hitfinder.HitFinder;

public class EvalHitFinder
implements HitFinder<String> {
    private EvalChemTermInfo evalInfo;
    private CardinalPredicat cardinalPredicat;
    private ChemJEP jep;
    private MolContext context;

    public EvalHitFinder(EvalChemTermInfo evalInfo) throws ParseException {
        this.evalInfo = evalInfo;
        this.cardinalPredicat = new CardinalPredicat(evalInfo.getPredicateInfo());
        String chemterms = evalInfo.getEvalOptions();
        Evaluator evaluator = new Evaluator();
        this.jep = evaluator.compile(chemterms, MolContext.class);
        this.context = new MolContext();
    }

    @Override
    public boolean yieldsHit(String struct) throws Exception {
        Object result;
        if (struct == null) {
            throw new IllegalArgumentException("struct should not be null");
        }
        if (struct.trim().length() == 0) {
            return false;
        }
        try {
            MolHandler mh = new MolHandler(struct);
            this.context.setMolecule(mh.getMolecule());
            result = this.jep.evaluate(this.context);
        }
        catch (Exception e) {
            throw new Exception("Problem evaluating " + this.evalInfo.getEvalOptions() + " for " + struct);
        }
        if (result instanceof Boolean) {
            Boolean b = (Boolean)result;
            Object object = result = b != false ? new Integer(1) : new Integer(0);
        }
        if (!(result instanceof Double || result instanceof Float || result instanceof Integer || result instanceof Long)) {
            throw new Exception("Expression " + this.evalInfo.getOptions() + " yields " + result.getClass().getName() + ". Expressions must yield one single number!");
        }
        String strValue = String.valueOf(result);
        double dbl = Double.parseDouble(strValue);
        return this.cardinalPredicat.isMatching(dbl);
    }
}

